<?php
declare(strict_types=1);
require_once __DIR__ . '/../core.php';
header('Content-Type: application/json; charset=UTF-8');

$lat = isset($_GET['lat']) ? (float)$_GET['lat'] : 0.0;
$lng = isset($_GET['lng']) ? (float)$_GET['lng'] : 0.0;
$limit = isset($_GET['limit']) ? max(1, (int)$_GET['limit']) : 10;

if (!$lat && !$lng) { echo json_encode([]); exit; }

$sql = "
SELECT
  l.location_id   AS id,
  l.location_title AS title,
  l.location_slug  AS slug,
  l.location_lat   AS lat,
  l.location_lng   AS lng,
  (6371 * ACOS(
     COS(RADIANS(:lat)) * COS(RADIANS(CAST(l.location_lat AS DECIMAL(9,6)))) *
     COS(RADIANS(CAST(l.location_lng AS DECIMAL(9,6))) - RADIANS(:lng)) +
     SIN(RADIANS(:lat)) * SIN(RADIANS(CAST(l.location_lat AS DECIMAL(9,6))))
  )) AS distance_km
FROM locations l
WHERE l.location_lat IS NOT NULL
  AND l.location_lng IS NOT NULL
ORDER BY distance_km ASC
LIMIT {$limit}
";
try {
  $st = $connect->prepare($sql);
  $st->execute([':lat'=>$lat, ':lng'=>$lng]);
  $rows = $st->fetchAll(PDO::FETCH_ASSOC);
  $out = [];
  foreach ($rows as $r) {
    if (!empty($r['slug'])) {
      $out[] = [
        'id' => (int)$r['id'],
        'title' => (string)$r['title'],
        'slug' => (string)$r['slug'],
        'distance_km' => round((float)$r['distance_km'], 1)
      ];
    }
  }
  echo json_encode($out, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
} catch (Throwable $e) {
  echo json_encode([]);
}
