<?php
declare(strict_types=1);
require_once __DIR__ . '/../core.php';
header('Content-Type: application/json; charset=utf-8');

$mmdbPaths = [
  __DIR__ . '/../storage/GeoLite2-City.mmdb',
  __DIR__ . '/../GeoLite2-City.mmdb',
  '/usr/share/GeoIP/GeoLite2-City.mmdb'
];

$lat = 0.0; $lng = 0.0;
try {
  if (file_exists(__DIR__ . '/../vendor/autoload.php')) {
    require_once __DIR__ . '/../vendor/autoload.php';
  }
  if (class_exists(\GeoIp2\Database\Reader::class)) {
    foreach ($mmdbPaths as $p) {
      if (is_file($p)) { $reader = new \GeoIp2\Database\Reader($p); break; }
    }
    if (isset($reader)) {
      $ip = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'] ?? '';
      if ($ip) {
        if (strpos($ip, ',') !== false) { $ip = trim(explode(',', $ip)[0]); }
        $rec = $reader->city($ip);
        $lat = (float)$rec->location->latitude;
        $lng = (float)$rec->location->longitude;
      }
    }
  }
} catch (\Throwable $e) {
  // silencioso
}

if (!$lat && !$lng) { echo json_encode([]); exit; }

// reusa o haversine
$sql = "
SELECT location_title AS title, location_slug AS slug,
(6371 * acos(
  cos(radians(:lat))*cos(radians(location_lat))*cos(radians(location_lng)-radians(:lng)) +
  sin(radians(:lat))*sin(radians(location_lat))
)) AS distance_km
FROM locations
WHERE location_lat IS NOT NULL AND location_lng IS NOT NULL
ORDER BY distance_km ASC
LIMIT 1";
$st = $connect->prepare($sql);
$st->execute([':lat'=>$lat, ':lng'=>$lng]);
$row = $st->fetch(PDO::FETCH_ASSOC);
echo $row ? json_encode(['slug'=>$row['slug'], 'title'=>$row['title'], 'distance_km'=>(float)$row['distance_km']]) : json_encode([]);
