<?php
declare(strict_types=1);
require_once __DIR__ . '/../core.php';
header('Content-Type: application/json; charset=utf-8');

/*
  Endpoint robusto:
  - Valida lat/lng de entrada
  - Ignora locations com lat/lng nulos/zero
  - Usa CAST para evitar problemas de tipos
  - Retorna o mais próximo mesmo que slug esteja vazio (cliente trata)
*/

$lat = isset($_GET['lat']) ? (float)$_GET['lat'] : 0.0;
$lng = isset($_GET['lng']) ? (float)$_GET['lng'] : 0.0;

if (!$lat && !$lng) { echo json_encode([]); exit; }

// Haversine em km (com CAST/COALESCE)
$sql = "
SELECT
  l.location_id,
  l.location_title AS title,
  l.location_slug  AS slug,
  l.location_lat   AS lat,
  l.location_lng   AS lng,
  (6371 *
   ACOS(
     COS(RADIANS(:lat)) * COS(RADIANS(CAST(l.location_lat AS DECIMAL(9,6)))) *
     COS(RADIANS(CAST(l.location_lng AS DECIMAL(9,6))) - RADIANS(:lng)) +
     SIN(RADIANS(:lat)) * SIN(RADIANS(CAST(l.location_lat AS DECIMAL(9,6))))
   )
  ) AS distance_km
FROM locations l
WHERE
  l.location_lat IS NOT NULL AND l.location_lng IS NOT NULL
  AND CAST(l.location_lat AS DECIMAL(9,6)) <> 0
  AND CAST(l.location_lng AS DECIMAL(9,6)) <> 0
ORDER BY distance_km ASC
LIMIT 1";

try {
  $st = $connect->prepare($sql);
  $st->execute([':lat'=>$lat, ':lng'=>$lng]);
  $row = $st->fetch(PDO::FETCH_ASSOC);
  if (!$row) { echo json_encode([]); exit; }

  // Normaliza slug/strings
  $slug = isset($row['slug']) && $row['slug'] !== '' ? $row['slug'] : null;
  $title = (string)($row['title'] ?? '');
  $dist = isset($row['distance_km']) ? (float)$row['distance_km'] : null;

  echo json_encode([
    'slug' => $slug,
    'title' => $title,
    'distance_km' => $dist
  ], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
} catch (\Throwable $e) {
  // retorno neutro em caso de erro SQL
  echo json_encode([]);
}
