'use strict';
function goBack() {
  window.history.back();
}

/* PRELOADER */
$(window).on('load', function() {
  $('#preloader').fadeOut('slow');
});

/* NICE-SELECT */
$(document).ready(function() {
  $('.nc-select').niceSelect();
});

/* FORMS */
function onRecaptchaSuccess(){
  $('#submit-form').submit();
}

/* SUBMIT NO EMPTY FIELD */
$(document).ready(function($){
  $("#searchForm").submit(function() {
    $(this).find(":input").filter(function(){ return !this.value; }).attr("disabled", "disabled");
    return true;
  });
  $("#searchForm").find(":input").prop("disabled", false);
});

$(document).ready(function(){
  $('.submit-form').on('click', function(){
    $("#searchForm").submit();
  });
});

/* CHOOSE PLAN */
$(document).ready(function(){
  $('.choosePlan').on('click', function(){
    let frequency = $(".tas_pricing_filter li[class*='uk-active']").data('plan'); 
    var planId = $(this).data('plan');
    window.open(SITEURL + "/pay/" + planId + "/?freq=" + frequency);
  });
});

/* ----- FIXED: number_format / nr declarations ----- */
if (typeof window.number_format !== 'function') {
  window.number_format = function(number, decimals, dec_point, thousands_point) {
    dec_point = (typeof dec_point !== 'undefined') ? dec_point : '.';
    thousands_point = (typeof thousands_point !== 'undefined') ? thousands_point : ',';

    if (number == null || !isFinite(number)) {
      return '';
    }
    if (typeof decimals === 'undefined' || decimals === null) {
      var len = number.toString().split('.').length;
      decimals = len > 1 ? len : 0;
    }
    number = parseFloat(number).toFixed(decimals);
    number = number.replace('.', dec_point);
    var splitNum = number.split(dec_point);
    splitNum[0] = splitNum[0].replace(/\B(?=(\d{3})+(?!\d))/g, thousands_point);
    number = splitNum.join(dec_point);
    return number;
  };
}

if (typeof window.nr !== 'function') {
  window.nr = function(number, decimals) {
    if (typeof decimals === 'undefined') decimals = 0;
    return window.number_format(number, decimals);
  };
}

/* PRICING HELPERS */
var compute_addons_total = function() {
  var addons = [];
  var total = 0;

  // periodicidade -> meses para cálculo (exclusividade)
  var months = 1;
  var freqVal = $("input[type='radio'][name='frequency']:checked").data('frequency');
  if (freqVal === 'halfyear') months = 6;
  if (freqVal === 'annual') months = 12;

  if ($('#addon_home7').length && $('#addon_home7').is(':checked')) {
    addons.push({title: 'Destaque na Home (7 dias)', amount: 99});
    total += 99;
  }
  if ($('#addon_cat7').length && $('#addon_cat7').is(':checked')) {
    addons.push({title: 'Topo da Categoria (7 dias)', amount: 79});
    total += 79;
  }

  if ($('#addon_creative').length) {
    var creative = parseFloat($('#addon_creative').val() || 0);
    if (creative > 0) {
      addons.push({title: 'Pacote Criativo + Oferta Matadora', amount: creative});
      total += creative;
    }
  }

  if ($('#addon_setup').length && $('#addon_setup').is(':checked')) {
    var setupCost = 149;
    if (freqVal === 'halfyear' || freqVal === 'annual') setupCost = 0;
    addons.push({title: 'Setup de implantação', amount: setupCost});
    total += setupCost;
  }

  if ($('#addon_exclusive').length) {
    var exclusive = parseFloat($('#addon_exclusive').val() || 0);
    if (exclusive > 0) {
      var amount = exclusive * months;
      addons.push({title: 'Exclusividade por segmento/bairro', amount: amount});
      total += amount;
    }
  }

  return { total: total, items: addons };
};

var addons_charge_now = function() {
  var p = $("input[type='radio'][name='payment']:checked").val();
  return (p === 'mercadopago' || p === 'banktransfer');
};

var refresh_addons_ui = function() {
  var a = compute_addons_total();
  var hasAddons = a.total > 0.001;

  // Nota (quando não entra no pagamento)
  var note = document.querySelector('#addons_payment_note');
  if (note) {
    if (hasAddons && !addons_charge_now()) note.classList.remove('uk-hidden');
    else note.classList.add('uk-hidden');
  }

  // Resumo
  var row = document.querySelector('#summary_addons_row');
  var list = document.querySelector('#summary_addons_list');
  var totalEl = document.querySelector('#summary_addons_total');

  if (row && list && totalEl) {
    if (hasAddons) {
      row.classList.remove('uk-hidden');
      list.classList.remove('uk-hidden');
      totalEl.innerHTML = nr(a.total, 2);

      var html = '';
      a.items.forEach(function(it){
        html += '<div class="uk-flex uk-flex-between"><span>' + it.title + '</span><span>' + nr(it.amount, 2) + '</span></div>';
      });
      list.innerHTML = html;
    } else {
      row.classList.add('uk-hidden');
      list.classList.add('uk-hidden');
      list.innerHTML = '';
      totalEl.innerHTML = nr(0, 2);
    }
  }
};

var calculate_prices = function() {
  var payment_amount = $('[name="frequency"]:checked').data('price');
  var price = parseFloat(payment_amount) || 0;

  var exclusive_taxes = 0;
  var price_without_inclusive_taxes = 0;
  var price_with_taxes = 0;

  if (typeof codeDiscount !== 'undefined' && codeDiscount) {
    var discount = parseInt(codeDiscount[0].percentage);
    var discount_value = parseFloat((price * discount / 100).toFixed(2));
    price = price - discount_value;
    var el = document.querySelector('#summary_discount #discount_price');
    if (el) el.innerHTML = nr(-discount_value, 2);
  }

  /* Calculate with taxes, if any */
  if (typeof plantaxes !== 'undefined' && plantaxes) {

    /* Check for the inclusives */
    var inclusive_taxes_total_percentage = 0;
    for (var i=0;i<plantaxes.length;i++) {
      var row = plantaxes[i];
      if (row.tax_type == 'exclusive') continue;
      inclusive_taxes_total_percentage += parseInt(row.tax_percentage);
    }

    var total_inclusive_tax = parseFloat((price - (price / (1 + inclusive_taxes_total_percentage / 100))).toFixed(2));

    for (var j=0;j<plantaxes.length;j++) {
      var row2 = plantaxes[j];
      if (row2.tax_type == 'exclusive') continue;
      var percentage_of_total_inclusive_tax = parseInt(row2.tax_percentage) * 100 / inclusive_taxes_total_percentage;
      var inclusive_tax = parseFloat(total_inclusive_tax * percentage_of_total_inclusive_tax / 100).toFixed(2);
      var $tax = $('#summary_tax_id_' + row2.tax_id + ' .tax-value');
      if ($tax.length) $tax.html(nr(inclusive_tax, 2));
    }

    price_without_inclusive_taxes = price - total_inclusive_tax;

    /* Check for the exclusives */
    var exclusive_taxes_array = [];
    for (var k=0;k<plantaxes.length;k++) {
      var row3 = plantaxes[k];
      if (row3.tax_type == 'inclusive') continue;
      var exclusive_tax = parseFloat(price_without_inclusive_taxes * (parseInt(row3.tax_percentage) / 100));
      exclusive_taxes_array.push(exclusive_tax);
      $('#summary_tax_id_' + row3.tax_id + ' .tax-value').html('+' + nr(exclusive_tax, 2));
    }
    exclusive_taxes = exclusive_taxes_array.reduce(function(total, n){ return total + n; }, 0);

    /* Price with all the taxes */
    price_with_taxes = price + exclusive_taxes;
    price = price_with_taxes;
  }

  if (payment_amount){
    var sp = document.querySelector('#summary_plan_price');
    if (sp) sp.innerHTML = nr(payment_amount, 2);
    $('#summary_total').html(nr(price, 2));
    $('#pay_total').html(nr(price, 2));
  }
};

var selected_frequency = function() {
  var value = $('[name="frequency"]:checked').data('freq');
  if (value) {
    var el = document.querySelector('#summary_plan_frequency');
    if (el) el.innerHTML = value;
  }
};

refresh_addons_ui();
calculate_prices();

$('[name="frequency"]').on('change', function(){
  refresh_addons_ui();
  removeParam('freq');
  selected_frequency();
  calculate_prices();
});
selected_frequency();

$('[name="payment"]').on('change', function(){
  refresh_addons_ui();
  calculate_prices();
});
$('.addon-input').on('change', function(){
  refresh_addons_ui();
  calculate_prices();
});

/* COUPON CODE */
$('.applyCode').on("click", function(event){ 
  event.preventDefault(); 
  var $this = $('#submit-coupon');
  var loadingText = '<span class="anim-rotate" uk-icon="refresh"></span>';
  if ($('#submit-coupon').html() !== loadingText) { $this.html(loadingText); }
  $.ajax({
    type: 'POST',
    url: SITEURL + "/controllers/coupon.php",
    data: {
      plan: $("#planid").val(),
      frequency: $("input[type='radio'][name='frequency']:checked").data('frequency'),
      code: $("#couponcode").val(),
    },
    success: function(data) {
      var dataResult = JSON.parse(data);
      $('#coderesults').html(dataResult.message);
      $this.html($this.val());
      if (dataResult.statusCode == 200){
        codeDiscount = [{value: dataResult.value, discount: dataResult.discounted, percentage: dataResult.percentage}];
        $('#summary_total').html(dataResult.value);
        $('#pay_total').html(dataResult.value);
        $('#discount_price').html(dataResult.discounted);
        $('#discount_percentage').html(dataResult.percentage);
        $('#summary_discount').removeClass('uk-hidden').addClass('uk-visible');
      }
      calculate_prices();
    }
  });
});

/* The rest of your original main.js stays unchanged below ... */


/* PAGINATION */

'use strict';
$(document).ready(function(){
  $('.change-page').on('click', function(){

    var paramName = 'p';
    var paramValue = $(this).data('page');

    var url = window.location.href;
    var hash = location.hash;
    url = url.replace(hash, '');
    if (url.indexOf(paramName + "=") >= 0)
    {
      var prefix = url.substring(0, url.indexOf(paramName + "=")); 
      var suffix = url.substring(url.indexOf(paramName + "="));
      suffix = suffix.substring(suffix.indexOf("=") + 1);
      suffix = (suffix.indexOf("&") >= 0) ? suffix.substring(suffix.indexOf("&")) : "";
      url = prefix + paramName + "=" + paramValue + suffix;
    }
    else
    {
      if (url.indexOf("?") < 0)
        url += "?" + paramName + "=" + paramValue;
      else
        url += "&" + paramName + "=" + paramValue;
    }

    window.location.href = url + hash;

  });
  
});

/* FILTERS */

'use strict';
function removeParam(parameter){
  var url=document.location.href;
  var urlparts= url.split('?');

 if (urlparts.length>=2)
 {
  var urlBase=urlparts.shift(); 
  var queryString=urlparts.join("?"); 

  var prefix = encodeURIComponent(parameter)+'=';
  var pars = queryString.split(/[&;]/g);
  for (var i= pars.length; i-->0;)               
      if (pars[i].lastIndexOf(prefix, 0)!==-1)   
          pars.splice(i, 1);
  url = urlBase+'?'+pars.join('&');
  window.history.pushState('',document.title,url);
}
return url;
}

'use strict';
function insertParam(key, value) {

  var kvp = document.location.search.substr(1).split('&');
  if (kvp == '') {
    document.location.search = '?' + key + '=' + value;
  }else{
    var i = kvp.length; var x; while (i--) {
      x = kvp[i].split('=');
      if (x[0] == key) {
        x[1] = value;
        kvp[i] = x.join('=');
        break;
      }
    }

    if (i < 0) { kvp[kvp.length] = [key, value].join('='); }
    document.location.search = kvp.join('&');
  }
}

'use strict';
$(document).ready(function(){
  $("#filterInput_1").on("keyup", function() {
    var value = $(this).val().toLowerCase();
    $("#filterData_1 li").filter(function() {
      $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
    });
  });
});

'use strict';
$(document).ready(function(){
  $("#filterInput_2").on("keyup", function() {
    var value = $(this).val().toLowerCase();
    $("#filterData_2 a").filter(function() {
      $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
    });
  });
});

'use strict';

'use strict';
$('.btnSubmitForm').on('click', function () {
  $('#searchForm').submit();
});

'use strict';
$('.searchForm').on("submit", function(){});

'use strict';
$('.filterTag').on('click', function () {
  
  var value = $(this).data('value');
  removeParam(value);
  window.location.reload();

});

'use strict';
$(document).ready(function(){
  $(window).on("load",function(){

    $.each($(".sortBy li[class*='uk-active']").find("a"), function () {
      $('#filterBtn').text($(this).text()); 
    });
});
  
});

'use strict';
$('.sortBy li a').on('click', function () {
  var key = 'sortby';
  var value = $(this).data('value');
  insertParam(key, value);
});

'use strict';
$('.filterSubCategory li a').on('click', function () {
  var key = 'sortby';
  var value = $(this).data('value');
  insertParam(key, value);
});

'use strict';
$('.filterStore a').on('click', function () {
  var key = 'store';
  var value = $(this).data('value');
  insertParam(key, value);
});

'use strict';
$('.filterCategory li a span').on('click', function () {
  removeParam("subcategory");
  var key = 'category';
  var current = $(this).data('current');
  var value = $(this).data('value');

  if(current == value){
    removeParam("category");
    window.location.reload();
    }else{
      insertParam(key, value);
    }
});

'use strict';
$('.filterSubCategory li a').on('click', function () {
  var key = 'subcategory';
  var value = $(this).data('value');
  insertParam(key, value);
});

'use strict';
$('.filterLocation li label').on('click', function () {
  var key = 'location';
  var current = $(this).data('current');
  var value = $(this).data('value');

  if(current == value){
  removeParam("location");
  window.location.reload();
  }else{
    insertParam(key, value);
  }

});

'use strict';
$('.filterRating li label').on('click', function () {
  var key = 'rating';
  var value = $(this).data('value');
  insertParam(key, value);
});

'use strict';
$('.filterPrice li label').on('click', function () {
  var key = 'price';
  var value = $(this).data('value');
  insertParam(key, value);
});

'use strict';
$('.resetFilters').on('click', function () {
window.location.href = window.location.href.split('?')[0]
});

'use strict';
$('.otherFilters li label').on('click', function () {
  var key = 'filter';
  var value = $(this).data('value');
  insertParam(key, value);
});

/* LIKES */
'use strict';
$(document).ready(function(){
  $('.addfav').on('click', function(){
    var itemId = $(this).data('item');
    var userId = $(this).data('user');
    $.ajax({
      url: SITEURL+"/controllers/like.php?action=add",
      type: 'post',
      data: {
        'item': itemId,
        'user': userId
      },
      success: function(response){
        $('.like').addClass('uk-hidden uk-animation-fade');
        $('.like').siblings().removeClass('uk-hidden');
        $('#likes_count').text(response); 
      },
    });
  });

  $('.removefav').on('click', function(){
    var itemId = $(this).data('item');
    var userId = $(this).data('user');
    $.ajax({
      url: SITEURL+"/controllers/like.php?action=remove",
      type: 'post',
      data: {
        'item': itemId,
        'user': userId
      },
      success: function(response){
        $('.unlike').addClass('uk-hidden uk-animation-fade');
        $('.unlike').siblings().removeClass('uk-hidden');
        $('#likes_count').text(response); 
      }
    });
  });
});

/* FILE VALIDATION & PREVIEW */

'use strict';

$("#image-upload").on('change', function(){

  var file = this.files[0];
  var fileType = file.type;
  var match = ['image/jpeg', 'image/png', 'image/jpg'];
  if(!((fileType == match[0]) || (fileType == match[1]) || (fileType == match[2]) || (fileType == match[3]) || (fileType == match[4]) || (fileType == match[5]))){
    alert('Sorry, only JPG, JPEG, & PNG files are allowed to upload.');
    $("#image-upload").val('');
    return false;
  }
});

$(document).ready(function() {
  $.uploadPreview({
    input_field: "#image-upload",
    preview_box: "#image-preview",
    label_field: "#image-label"
  });
});


/* NEWSLETTER */

'use strict';
$('.new-subscriber form').on("submit", function(event){ 

  event.preventDefault();  

  var $this = $('#submit-subscriber');
  var loadingText = '<span class="anim-rotate" uk-icon="refresh"></span>';
  if ($('#submit-subscriber').html() !== loadingText) {
    $this.html(loadingText);
  }

  $.ajax({
    type: 'POST',
    url: SITEURL+"/controllers/add-subscriber.php",
    data: {
      subscriber_email:$("#subscriber_email").val(),
    },
    success: function(data) {

      setTimeout(function(){
        $('#showresults').html(data);
        $this.html($this.val());
      }, 1000);

    }
  });
});

'use strict';
$('.newsletter form').on("submit", function(event){ 

  event.preventDefault();  

  var $this = $('#submit-newsletter');
  var loadingText = '<span class="anim-rotate" uk-icon="refresh"></span>';
  if ($('#submit-newsletter').html() !== loadingText) {
    $this.html(loadingText);
  }

  $.ajax({
    type: 'POST',
    url: SITEURL+"/controllers/add-subscriber.php",
    data: {
      subscriber_email:$("#newsletter_email").val(),
    },
    success: function(data) {

      setTimeout(function(){
        $('#getresults').html(data);
        $this.html($this.val());
      }, 1000);

    }
  });
});

/* DISABLE NICE SELECT MOBILE DEVICES */

'use strict';
$(document).ready(function() {
  checkSize();
  $(window).resize(checkSize);
});

function checkSize(){
  if (window.matchMedia("(min-width: 768px)").matches) {
    $("select").removeClass('uk-select');
    $("select").niceSelect();
    $("select").addClass('nc-select');
  } else {
    $("select").niceSelect("destroy");
    $("select").removeClass('nc-select');
    $("select").addClass('uk-select');
  }
}

/* UPDATE PROFILE */

'use strict';
$('.update-profile form').on("submit", function(event){ 

  event.preventDefault();  

  var $this = $('#submit-send');
  var loadingText = '<span class="anim-rotate" uk-icon="refresh"></span>';
  if ($('#submit-send').html() !== loadingText) {
    $this.html(loadingText);
  }

  $.ajax({
    type: 'POST',
    url: SITEURL+"/controllers/update-profile.php",
    data: new FormData(this),
    contentType: false,
    cache: false,
    processData:false,
    success: function(data) {

      setTimeout(function(){
        $('#showresults').html(data);
        $this.html($this.val());
      }, 1000);

    }
  });
});

'use strict';
$(document).ready(function(){
  $('#favorites_table').on('click', '.deleteItem', function(){
    var itemId = $(this).data('item');
    var userId = $(this).data('user');
    var table = $('#favorites_table').DataTable();
    $.ajax({
      url: SITEURL+"/controllers/like.php?action=remove",
      type: 'post',
      data: {
        'item': itemId,
        'user': userId
      },
      success: function(response){
                //UIkit.notification('This Favorite Has Been Removed', 'success');
                table.ajax.reload();
              }
            });
  });
});

/* REPORT FORM */

'use strict';
$(document).ready(function(){
 $('#reportForm').on("submit", function(event){  

  event.preventDefault();

  var $this = $('#btn-report');
  var loadingText = '<span class="anim-rotate" uk-icon="refresh"></span>';
  if ($('#btn-report').html() !== loadingText) {
    $this.html(loadingText);
  }

  $.ajax({  
    url: SITEURL+"/controllers/report.php",
    method:"POST",  
    data: new FormData(this),
    contentType: false,
    cache: false,
    processData:false,
    success: function(data) {

      setTimeout(function(){
        $('#showReportresults').html(data);
        $this.html($this.val());

        $("#reportForm")[0].reset();
        $('.form_fields').hide();

      }, 1000);

    } 
   });

  });  
 });

/* SUBMIT RATING */

$(document).ready(function () {
  $("#rating-form").niceSelect("destroy");
});


$(document).ready(function () {
  $('#rating-form').barrating({
    theme: 'css-stars',
    showSelectedRating: false,
  });
});

'use strict';
$(document).ready(function(){
 $('#formRating').on("submit", function(event){  

  event.preventDefault();

  var $this = $('#btn-review');
  var loadingText = '<span class="anim-rotate" uk-icon="refresh"></span>';
  if ($('#btn-review').html() !== loadingText) {
    $this.html(loadingText);
  }

  $.ajax({  
    url: SITEURL+"/controllers/add-review.php",
    method:"POST",  
    data: new FormData(this),
    contentType: false,
    cache: false,
    processData:false,
    success: function(data) {

      setTimeout(function(){
        $("#formRating")[0].reset();
        $('.form_fields').hide();
        $('#showReviewresults').html(data);
        $this.html($this.val());
      }, 1000);

    } 
   });

  });  
 });

/* GET REVIEWS */

  $(document).ready(function () {
    $(document).on('click', '#loadBtn', function () {
      var limit = Number($('#limit').val());
      var id = Number($('#itemId').val());
      var page = Number($('#page').val())+1;
      var count = Number($('#itemsCount').val());

      $('#page').val(page);

      var $this = $('#loadBtn');
      var loadingText = '<span class="anim-rotate" uk-icon="refresh"></span>';
      if ($('#loadBtn').html() !== loadingText) {
        $this.html(loadingText);
      }
      
      $.ajax({
        type: 'POST',
        url: SITEURL+"/controllers/reviews.php",
        data: {
          'page': page,
          'id': id
        },
        success: function (data) {
          var rowCount = page + limit;
          $('#content').append(data);
          if (rowCount+1 >= count) {
            $('#loadBtn').css("display", "none");
          } else {
            $this.html($this.val());
          }
        }
      });
    });
  });
