/*! ND badges + SEO v1.0
 * - Mostra "Novo" para itens com data-created ≤ 7 dias.
 * - Mostra/esconde "★ Exclusivo" com base em data-exclusive (1/0).
 * - Seta priceValidUntil no JSON-LD, se existir contagem regressiva.
 */
(function(){
  function $(sel, ctx){ return (ctx||document).querySelector(sel); }
  function $all(sel, ctx){ return Array.from((ctx||document).querySelectorAll(sel)); }

  function parseDate(s){
    if(!s) return null;
    var d = new Date(s);
    return isNaN(+d) ? null : d;
  }
  function daysBetween(a,b){
    return Math.floor((a - b) / 86400000);
  }

  // Badge "Novo" nos cards de lista (.nd-card) usando data-created="ISO"
  function applyNewBadges(){
    var today = new Date();
    $all('.nd-card').forEach(function(card){
      var created = parseDate(card.getAttribute('data-created'));
      var badge = card.querySelector('.nd-badge--new');
      if(!created || !badge){ return; }
      var diff = daysBetween(today, created);
      if(diff <= 7 && diff >= 0){
        badge.hidden = false;
        badge.textContent = 'Novo';
      }else{
        badge.hidden = true;
      }
    });
  }

  // Badge "★ Exclusivo" na hero: data-exclusive="1|0" no .nd-hero
  function applyExclusiveHero(){
    var hero = $('.nd-hero'); if(!hero) return;
    var flag = (hero.getAttribute('data-exclusive') || '').trim();
    var badge = hero.querySelector('.nd-badge-right');
    if(!badge) return;
    if(flag === '1' || flag.toLowerCase() === 'true'){
      badge.hidden = false;
    }else{
      badge.hidden = true;
    }
  }

  // JSON-LD priceValidUntil: se tivermos .nd-countdown[data-end], injeta/atualiza no JSON-LD existente
  function syncJsonLd(){
    var cd = $('.nd-countdown');
    if(!cd) return;
    var end = cd.getAttribute('data-end');
    if(!end) return;
    var blocks = $all('script[type="application/ld+json"]');
    blocks.forEach(function(b){
      try{
        var obj = JSON.parse(b.textContent.trim());
        var updated = false;
        // Suporte para { "@graph": [...] } ou objeto único
        if(obj && obj["@graph"] && Array.isArray(obj["@graph"])){
          obj["@graph"].forEach(function(node){
            if(node['@type']==='Offer'){
              node.priceValidUntil = end; updated = true;
            }
            // Product->offers
            if(node['@type']==='Product' && node.offers){
              if(Array.isArray(node.offers)){
                node.offers.forEach(function(o){ if(o['@type']==='Offer'){ o.priceValidUntil = end; updated = true; }});
              }else if(node.offers['@type']==='Offer'){
                node.offers.priceValidUntil = end; updated = true;
              }
            }
          });
        }else if(obj && obj['@type']==='Product' && obj.offers){
          if(Array.isArray(obj.offers)){
            obj.offers.forEach(function(o){ if(o['@type']==='Offer'){ o.priceValidUntil = end; updated = true; }});
          }else if(obj.offers['@type']==='Offer'){
            obj.offers.priceValidUntil = end; updated = true;
          }
        }else if(obj && obj['@type']==='Offer'){
          obj.priceValidUntil = end; updated = true;
        }
        if(updated){
          b.textContent = JSON.stringify(obj);
        }
      }catch(e){}
    });
  }

  document.addEventListener('DOMContentLoaded', function(){
    applyNewBadges();
    applyExclusiveHero();
    syncJsonLd();
  });
})();
