(function(){
  try {
    if (localStorage.getItem('nd_location_slug')) return;

    function setPreferred(slug, title){
      try {
        localStorage.setItem('nd_location_slug', slug);
        localStorage.setItem('nd_location_title', title || '');
      } catch(e) {}
      // Redirect to search filtered by location
      var url = '/search?location=' + encodeURIComponent(slug);
      if (window.location.pathname !== '/search') {
        window.location.href = url;
      } else {
        // If already on search, just reload with param
        var params = new URLSearchParams(window.location.search);
        if (params.get('location') !== slug) window.location.href = url;
      }
    }

    function fallbackIP(){
      fetch('/api/nearest-by-ip.php', {credentials:'same-origin'})
        .then(function(r){ return r.json(); })
        .then(function(loc){
          if (loc && loc.location_slug) setPreferred(loc.location_slug, loc.location_title);
        }).catch(function(){});
    }

    if ('geolocation' in navigator) {
      navigator.geolocation.getCurrentPosition(function(pos){
        var lat = pos.coords.latitude, lng = pos.coords.longitude;
        fetch('/api/nearest-location.php?lat='+lat+'&lng='+lng+'&max_km=80', {credentials:'same-origin'})
          .then(function(r){ return r.json(); })
          .then(function(loc){
            if (loc && loc.location_slug) setPreferred(loc.location_slug, loc.location_title);
            else fallbackIP();
          }).catch(fallbackIP);
      }, function(){ fallbackIP(); }, {enableHighAccuracy:false, timeout:5000});
    } else {
      fallbackIP();
    }
  } catch(e){}
})();