/*! ND Offer Card helpers v1.0 */
(function(){
  function $(sel, ctx){ return (ctx||document).querySelector(sel); }
  function $all(sel, ctx){ return Array.from((ctx||document).querySelectorAll(sel)); }
  function brl(n){
    try{ return new Intl.NumberFormat('pt-BR',{style:'currency',currency:'BRL'}).format(n); }
    catch(e){ return 'R$ ' + (Number(n)||0).toFixed(2).replace('.',','); }
  }
  function hydrateCard(card){
    if(!card) return;
    var priceNew = parseFloat(card.dataset.priceNew || 'NaN');
    var priceOld = parseFloat(card.dataset.priceOld || 'NaN');
    var elNew = card.querySelector('.nd-price-new');
    var elOld = card.querySelector('.nd-price-old');
    var elDisc = card.querySelector('.nd-discount-pill');
    var elSave = card.querySelector('.nd-saving');
    var stickyPrice = $('.nd-sticky-cta .nd-price');
    if(!isNaN(priceNew) && elNew){ elNew.textContent = brl(priceNew); if(stickyPrice) stickyPrice.textContent = brl(priceNew); }
    if(!isNaN(priceOld) && elOld){ elOld.textContent = brl(priceOld); }
    if(!isNaN(priceNew) && !isNaN(priceOld) && priceOld > priceNew && priceNew > 0){
      var pct = Math.round((1 - (priceNew/priceOld)) * 100);
      if(elDisc){ elDisc.textContent = '-' + pct + '%'; elDisc.hidden = false; }
      if(elSave){ elSave.textContent = 'Você economiza ' + brl(priceOld - priceNew); elSave.hidden = false; }
    }else{
      if(elDisc) elDisc.hidden = true;
      if(elSave) elSave.hidden = true;
    }
  }
  function runCountdown(node){
    if(!node) return;
    var endStr = node.dataset.end; if(!endStr) return;
    var end = new Date(endStr).getTime(); if(!end) return;
    function fmt(n){ return String(n).padStart(2,'0'); }
    function tick(){
      var now = Date.now();
      var diff = end - now;
      if(diff <= 0){ node.textContent = 'Encerrado'; node.classList.add('uk-text-danger'); return; }
      var s = Math.floor(diff/1000);
      var d = Math.floor(s/86400); s%=86400;
      var h = Math.floor(s/3600); s%=3600;
      var m = Math.floor(s/60); s%=60;
      var t = (d>0? d+' d ':'') + fmt(h) + ' h ' + fmt(m) + ' min ' + fmt(s) + ' s';
      node.textContent = 'Restam ' + t;
      requestAnimationFrame(function(){ setTimeout(tick, 1000); });
    }
    tick();
  }
  function setupSticky(){
    var sticky = $('.nd-sticky-cta'); if(!sticky) return;
    var cta = $('.nd-offer-card .nd-cta .uk-button'); if(!cta) return;
    var btn = sticky.querySelector('a.uk-button');
    if(btn){ btn.href = cta.getAttribute('href') || '#'; btn.target = cta.getAttribute('target') || '_self'; btn.rel = cta.getAttribute('rel') || 'noopener'; }
  }
  document.addEventListener('DOMContentLoaded', function(){
    var card = $('.nd-offer-card');
    hydrateCard(card);
    runCountdown($('.nd-countdown'));
    setupSticky();
  });
})();
