/*
 * nd-offer-upgrade.js — inicializador leve para a página de oferta
 * - Conserta link de login sem regex
 * - Garante modais (#report-modal e #submit-review) e liga uk-toggle
 * - Evita conflitos: roda após DOMContentLoaded e verifica UIkit
 */
(function(){
  function safeQueryAll(sel, ctx){ return Array.prototype.slice.call((ctx||document).querySelectorAll(sel)); }

  function rewireLoginLinks(){
    try{
      var anchors = safeQueryAll('a.button-header, a[href$="/login"], a[href="./login"], a[href*="/login"]');
      anchors.forEach(function(a){
        if(!a) return;
        var href = (a.getAttribute('href')||'').toLowerCase();
        var txt  = (a.textContent||'').toLowerCase();
        if (txt.includes('login') || href.endsWith('/login') || href.indexOf('/login?')>=0 || href.indexOf('/login#')>=0){
          a.setAttribute('href','/signin');
        }
      });
    }catch(e){ /* silencioso */ }
  }

  function ensureModal(id, html){
    var el = document.getElementById(id);
    if (!el){
      var wrap = document.createElement('div');
      wrap.innerHTML = html;
      document.body.appendChild(wrap.firstElementChild);
    }
  }

  function bootModals(){
    var reportHTML = ''
      + '<div id="report-modal" class="uk-flex-top" uk-modal>'
      + '  <div class="uk-modal-dialog uk-margin-auto-vertical">'
      + '    <button class="uk-modal-close-default" type="button" uk-close></button>'
      + '    <div class="uk-modal-header"><h3 class="uk-modal-title">Reportar oferta</h3></div>'
      + '    <div class="uk-modal-body">'
      + '      <form id="nd-report-form" class="uk-form-stacked">'
      + '        <div class="uk-margin">'
      + '          <label class="uk-form-label">Motivo</label>'
      + '          <div class="uk-form-controls">'
      + '            <select class="uk-select" name="reason" required>'
      + '              <option value="">Selecione…</option>'
      + '              <option>Link quebrado</option>'
      + '              <option>Preço incorreto</option>'
      + '              <option>Conteúdo inapropriado</option>'
      + '            </select>'
      + '          </div>'
      + '        </div>'
      + '        <div class="uk-margin">'
      + '          <label class="uk-form-label">Detalhes</label>'
      + '          <textarea class="uk-textarea" name="details" rows="4" placeholder="Descreva o problema…"></textarea>'
      + '        </div>'
      + '      </form>'
      + '    </div>'
      + '    <div class="uk-modal-footer uk-text-right">'
      + '      <button class="uk-button uk-button-default uk-modal-close" type="button">Cancelar</button>'
      + '      <button id="nd-report-send" class="uk-button uk-button-primary" type="button">Enviar</button>'
      + '    </div>'
      + '  </div>'
      + '</div>';

    var reviewHTML = ''
      + '<div id="submit-review" class="uk-flex-top" uk-modal>'
      + '  <div class="uk-modal-dialog uk-margin-auto-vertical">'
      + '    <button class="uk-modal-close-default" type="button" uk-close></button>'
      + '    <div class="uk-modal-header"><h3 class="uk-modal-title">Escrever avaliação</h3></div>'
      + '    <div class="uk-modal-body">'
      + '      <form id="nd-review-form" class="uk-form-stacked">'
      + '        <div class="uk-margin">'
      + '          <label class="uk-form-label">Seu nome</label>'
      + '          <input class="uk-input" name="name" required />'
      + '        </div>'
      + '        <div class="uk-margin">'
      + '          <label class="uk-form-label">Nota (0–5)</label>'
      + '          <input class="uk-range" name="rating" type="range" min="0" max="5" step="1" value="5">'
      + '        </div>'
      + '        <div class="uk-margin">'
      + '          <label class="uk-form-label">Comentário</label>'
      + '          <textarea class="uk-textarea" name="comment" rows="4" required></textarea>'
      + '        </div>'
      + '      </form>'
      + '    </div>'
      + '    <div class="uk-modal-footer uk-text-right">'
      + '      <button class="uk-button uk-button-default uk-modal-close" type="button">Fechar</button>'
      + '      <button id="nd-review-send" class="uk-button uk-button-primary" type="button">Publicar</button>'
      + '    </div>'
      + '  </div>'
      + '</div>';

    ensureModal('report-modal', reportHTML);
    ensureModal('submit-review', reviewHTML);

    // Eventos fake (apenas feedback visual; integre com backend se desejar)
    var byId = function(id){ return document.getElementById(id); };
    var toast = function(msg){
      if (window.UIkit && UIkit.notification){
        UIkit.notification({message: msg, status:'success', pos:'top-center'});
      }else{
        alert(msg);
      }
    };
    var btnReport = byId('nd-report-send');
    if (btnReport){
      btnReport.addEventListener('click', function(){
        toast('Obrigado! Recebemos seu reporte.');
        if (window.UIkit) UIkit.modal('#report-modal').hide();
      });
    }
    var btnReview = byId('nd-review-send');
    if (btnReview){
      btnReview.addEventListener('click', function(){
        toast('Obrigado pela avaliação!');
        if (window.UIkit) UIkit.modal('#submit-review').hide();
      });
    }
  }

  function domReady(fn){
    if (document.readyState === 'loading') document.addEventListener('DOMContentLoaded', fn);
    else fn();
  }

  domReady(function(){
    rewireLoginLinks();
    bootModals();
    // Marca ativa em language switch (defensivo; sem quebrar nada)
    try{
      var g = (document.cookie.match(/(?:^|;\s*)googtrans=([^;]+)/)||[])[1] || '';
      var cur = (decodeURIComponent(g).match(/\/pt\/(\w+)/)||[])[1] || 'pt';
      safeQueryAll('#langSwitchRoot [data-lang]').forEach(function(a){
        a.classList.toggle('active', a.getAttribute('data-lang')===cur);
      });
    }catch(e){}
  });
})();
