
(function(){
  function el(q,ctx){return (ctx||document).querySelector(q)}
  function els(q,ctx){return (ctx||document).querySelectorAll(q)}
  function post(url, data){
    return fetch(url, {method:'POST', headers:{'Content-Type':'application/json'}, body:JSON.stringify(data), credentials:'same-origin'}).then(r=>r.json());
  }
  function initModal(){
    var modal = el('#submit-review');
    if(!modal) return;
    var stars = els('.nd-star', modal);
    var out = el('#nd-rating-value', modal);
    var ipt = el('#nd-rating-input', modal);
    var form = el('#nd-review-form', modal);
    var item = (window.ND_RATING && ND_RATING.item) || (modal.getAttribute('data-item')||'').trim();
    if(!item) { console.warn('ND_RATING item ausente'); }
    var cur = 0;
    function paint(n){
      cur = n;
      stars.forEach(function(s,i){ s.classList.toggle('is-on', i < n); s.setAttribute('aria-checked', i < n ? 'true':'false'); });
      if(out) out.textContent = String(n||0);
      if(ipt) ipt.value = String(n||0);
    }
    stars.forEach(function(s,i){
      s.addEventListener('mouseover', function(){ paint(i+1) });
      s.addEventListener('focus', function(){ paint(i+1) });
      s.addEventListener('click', function(){ paint(i+1) });
      s.addEventListener('keydown', function(e){ if(e.key==='Enter' || e.key===' '){ e.preventDefault(); paint(i+1); } });
    });
    if(form){
      form.addEventListener('submit', function(e){
        e.preventDefault();
        var rating = +ipt.value||0;
        var comment = (el('#nd-review-text', modal)?.value||'').trim();
        if(!rating){ alert('Escolha uma nota de 1 a 5.'); return; }
        var payload = { item: item, rating: rating, comment: comment };
        post('/controllers/add-review.php', payload).then(function(resp){
          if(resp && resp.ok){
            alert('Avaliação enviada! Obrigado.');
            location.reload();
          }else{
            alert(resp && resp.error ? resp.error : 'Falha ao enviar. Tente novamente.');
          }
        }).catch(function(){ alert('Falha de rede.'); });
      });
    }
  }
  if(document.readyState==='loading'){ document.addEventListener('DOMContentLoaded', initModal); } else { initModal(); }
})();
