
(function(){
  function buildStars(input){
    try{
      if (!input || input.__ndStars) return;
      input.classList.add('nd-hidden');
      var wrap = document.createElement('div');
      wrap.className = 'nd-stars-input';
      var hint = document.createElement('span');
      hint.className = 'nd-hint';
      hint.textContent = 'Clique para avaliar';
      var val = parseInt(input.value || '0', 10) || 0;
      var btns = [];
      function render(v){
        btns.forEach(function(b,i){ b.classList.toggle('active', i < v); });
        hint.textContent = v ? (v + ' de 5') : 'Clique para avaliar';
      }
      for (var i=1;i<=5;i++){
        var b = document.createElement('button');
        b.type = 'button';
        b.setAttribute('aria-label', i + ' estrela' + (i>1?'s':''));
        b.textContent = '★';
        (function(score){
          b.addEventListener('mouseenter', function(){ render(score); });
          b.addEventListener('mouseleave', function(){ render(val); });
          b.addEventListener('click', function(){
            val = score; input.value = String(score);
            render(val);
          });
          b.addEventListener('keydown', function(e){
            if(e.key === 'ArrowRight' || e.key === 'ArrowUp'){ e.preventDefault(); val = Math.min(5, val+1); input.value = String(val); render(val); }
            if(e.key === 'ArrowLeft'  || e.key === 'ArrowDown'){ e.preventDefault(); val = Math.max(1, val-1); input.value = String(val); render(val); }
          });
        })(i);
        btns.push(b); wrap.appendChild(b);
      }
      wrap.appendChild(hint);
      input.parentNode.insertBefore(wrap, input.nextSibling);
      input.__ndStars = true;
      render(val);
    }catch(e){}
  }
  function scan(){
    var forms = document.querySelectorAll('#submit-review form, form[action*="review"], form[action*="add-review"]');
    forms.forEach(function(f){
      var rating = f.querySelector('input[name="rating"]') || f.querySelector('input[name="score"]');
      if (rating) buildStars(rating);
    });
  }
  if (document.readyState === 'loading') document.addEventListener('DOMContentLoaded', scan); else scan();
  document.addEventListener('shown', function(e){ scan(); }, true);
  document.addEventListener('click', function(e){
    if (e.target && e.target.matches('[uk-toggle],[data-uk-toggle],a[href^="#"]')){
      setTimeout(scan, 250);
    }
  });
})();
