// assets/js/nd-report.js
// Liga o formulário do modal "Reportar oferta" para enviar ao endpoint PHP e exibir feedback.
(function () {
  function qs(s, ctx){ return (ctx||document).querySelector(s); }
  function getParam(name){ var m=location.search.match(new RegExp('[?&]'+name+'=([^&]+)')); return m?decodeURIComponent(m[1]):''; }

  function dealId() {
    try {
      if (window.ND_RATING && ND_RATING.item) return String(ND_RATING.item);
      var el = qs('input[name="item"]'); if (el && el.value) return el.value;
      return getParam('deal_id') || '';
    } catch(e){ return ''; }
  }

  function bindReport() {
    var modal = document.getElementById('report-modal');
    if (!modal) return;

    var form = qs('form', modal);
    if (!form || form.__ndBoundReport) return;
    form.__ndBoundReport = true;

    // Garantir campo item
    var hid = qs('input[name="item"]', form);
    if (!hid) { hid = document.createElement('input'); hid.type='hidden'; hid.name='item'; form.appendChild(hid); }
    hid.value = dealId();

    form.addEventListener('submit', function (e) {
      e.preventDefault();
      hid.value = dealId();

      var reason = (qs('[name="reason"]', form) || {}).value || (qs('select', form) || {}).value || 'outro';
      var details = (qs('[name="details"]', form) || qs('textarea', form) || {}).value || '';

      var data = new URLSearchParams();
      data.set('item', hid.value || '');
      data.set('reason', reason);
      data.set('details', details);

      var btn = qs('button[type="submit"], .uk-button-primary', form);
      var oldTxt = btn ? btn.textContent : '';
      if (btn) { btn.disabled = true; btn.textContent = 'Enviando…'; }

      fetch('/controllers/report-offer.php', {
        method: 'POST',
        credentials: 'same-origin',
        headers: { 'Content-Type':'application/x-www-form-urlencoded;charset=UTF-8' },
        body: String(data)
      })
      .then(function(r){ return r.json(); })
      .then(function(resp){
        if (btn) { btn.disabled = false; btn.textContent = oldTxt || 'Enviar'; }
        if (resp && resp.ok) {
          alert('Obrigado! Recebemos o seu reporte.');
          // Tenta fechar o modal (UIkit)
          try { if (window.UIkit && UIkit.modal) UIkit.modal('#report-modal').hide(); } catch(e){}
          // Cleanup
          if (qs('textarea', form)) qs('textarea', form).value='';
        } else {
          alert((resp && resp.error) || 'Não foi possível enviar agora.');
        }
      })
      .catch(function(){
        if (btn) { btn.disabled = false; btn.textContent = oldTxt || 'Enviar'; }
        alert('Falha de rede ao enviar reporte.');
      });
    });
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', bindReport);
  } else { bindReport(); }

  // Também tenta depois do load (caso o modal seja injetado tardiamente)
  window.addEventListener('load', function(){ setTimeout(bindReport, 150); });
})();
