(function(){
  if (window.__ND_REVIEW_SUBMIT_BOUND__) return;
  window.__ND_REVIEW_SUBMIT_BOUND__ = true;
  function qs(s,ctx){return (ctx||document).querySelector(s);}
  function getParam(name){var m=location.search.match(new RegExp('[?&]'+name+'=([^&]+)'));return m?decodeURIComponent(m[1]):'';}
  function findItemId(ctx){
    var it = (qs('input[name="item"]', ctx)||{}).value || (window.ND_RATING&&window.ND_RATING.item) || getParam('deal_id') || '';
    return String(it||'').trim();
  }
  function getRating(ctx){
    var v = (qs('input[name="rating"]', ctx)||{}).value;
    if (!v){
      var active = qs('[data-ndstars] .nd-star.active', ctx);
      v = active ? active.getAttribute('data-v') : '5';
    }
    v = parseInt(v||5, 10);
    return Math.max(1, Math.min(5, isNaN(v)?5:v));
  }
  async function postReview(payload){
    var body = new URLSearchParams(payload).toString();
    var url = '/controllers/add-review.php';
    console.log('[ND] POST add-review ->', url, payload);
    const res = await fetch(url, {
      method:'POST',
      headers:{'Content-Type':'application/x-www-form-urlencoded;charset=UTF-8'},
      credentials:'same-origin',
      body
    });
    const raw = await res.text();
    let data=null; try{ data = JSON.parse(raw); }catch(e){}
    console.log('[ND] add-review response', res.status, data||raw);
    if (data && data.ok) return {ok:true,message:data.message||'OK'};
    if (data && data.ok===false) return {ok:false,message:data.message||'Erro ao enviar.'};
    if (res.ok && (!raw || raw.trim()==='' || raw.trim()==='1')) return {ok:true,message:'OK'};
    if (res.ok) return {ok:false,message:(raw&&raw.trim())||('HTTP '+res.status)};
    return {ok:false,message:'HTTP '+res.status};
  }
  document.addEventListener('submit', function(e){
    var form=e.target;
    if (!form || !form.closest('#submit-review')) return;
    e.preventDefault();
    var item=findItemId(form);
    var rating=getRating(form);
    var comment=(qs('textarea[name="comment"]', form)||{}).value||'';
    if (!item){ alert('Erro: item não identificado.'); return; }
    postReview({item:String(item), rating:String(rating), comment:String(comment)})
      .then(r=>{ if(r.ok){ alert('Avaliação enviada com sucesso!'); location.reload(); } else { alert(r.message||'Erro ao enviar avaliação.'); } })
      .catch(()=> alert('Falha de rede ao enviar avaliação.'));
  }, true);
  document.addEventListener('click', function(e){
    var btn=e.target.closest('#submit-review .uk-modal-footer [type="submit"], #submit-review [data-nd-publish]');
    if (!btn) return;
    var form=qs('#submit-review form') || qs('#submit-review #formRating') || btn.closest('form');
    if (!form) return;
    e.preventDefault();
    form.requestSubmit ? form.requestSubmit() : form.submit();
  });
})();