
window.ND = window.ND || {};
(function(){
  function shareOffer(e){
    if(e) e.preventDefault();
    var title = (document.querySelector('[itemprop="name"]')||{}).content || document.title;
    var tagline = (document.querySelector('[itemprop="description"]')||{}).content || '';
    var price = (document.querySelector('[itemprop="price"]')||{}).content;
    var text = [title, tagline, price ? ('Preço: R$ ' + price) : ''].filter(Boolean).join(' — ');
    var shareData = { title: title, text: text, url: window.location.href };
    if (navigator.share) {
      navigator.share(shareData).catch(function(){});
    } else if (navigator.clipboard && window.isSecureContext) {
      navigator.clipboard.writeText(window.location.href).then(function(){
        alert('Link copiado! Cole no Instagram para compartilhar.');
      }, function(){
        prompt('Copie o link da oferta:', window.location.href);
      });
    } else {
      prompt('Copie o link da oferta:', window.location.href);
    }
    return false;
  }
  ND.shareOffer = shareOffer;
  // copiar link (botão preto)
  document.addEventListener('click', function(ev){
    var a = ev.target.closest('.nd-share--copy');
    if(!a) return;
    ev.preventDefault();
    var u = window.location.href;
    if (navigator.clipboard && window.isSecureContext){
      navigator.clipboard.writeText(u).then(() => alert('Link copiado!'));
    } else {
      prompt('Copie o link:', u);
    }
  });
})();
