(function(){
  function findTarget(){
    var el = document.getElementById('ndLoginBtn');
    if (el) return el;
    el = document.querySelector('.uk-navbar-right .button-header');
    if (el) return el;
    var candidates = Array.from(document.querySelectorAll('a,button')).filter(function(el){
      var t = (el.textContent || '').trim().toLowerCase();
      return t === 'login' || t === 'entrar' || t.includes('login');
    });
    if (candidates.length) return candidates[0];
    candidates = Array.from(document.querySelectorAll('a,button,div')).filter(function(el){
      var t = (el.textContent || '').trim();
      return /\b(minha conta|perfil|account|profile)\b/i.test(t);
    });
    if (candidates.length) return candidates[0];
    return document.querySelector('.header-right, .topbar-right, header .right, .nd-top-right') || null;
  }
  function mount(){
    var tpl = document.getElementById('nd-user-menu-template');
    if (!tpl) return;
    var target = findTarget();
    if (!target || !target.parentNode) return;
    var node = tpl.content ? tpl.content.cloneNode(true) : (function(){ var d=document.createElement('div'); d.innerHTML=tpl.innerHTML; return d; })();
    var wrap = node.firstElementChild; if (!wrap) return;
    if (target.insertAdjacentElement) target.insertAdjacentElement('afterend', wrap);
    else target.parentNode.appendChild(wrap);
    var btn = wrap.querySelector('#ndUserBtn');
    var menu = wrap.querySelector('#ndUserMenu');
    if (!btn || !menu) return;
    function openMenu(){ menu.hidden=false; btn.setAttribute('aria-expanded','true'); }
    function closeMenu(){ menu.hidden=true; btn.setAttribute('aria-expanded','false'); }
    function toggle(){ menu.hidden ? openMenu() : closeMenu(); }
    btn.addEventListener('click', function(e){ e.preventDefault(); toggle(); });
    document.addEventListener('click', function(e){ if (!menu.contains(e.target) && !btn.contains(e.target)) closeMenu(); });
    document.addEventListener('keydown', function(e){ if (e.key === 'Escape') closeMenu(); });
  }
  if (document.readyState === 'loading') { document.addEventListener('DOMContentLoaded', mount); } else { mount(); }
})();