(function () {
  function mountInPlace() {
    var mount = document.getElementById('ndUserMount');
    if (!mount) return;

    var right = document.querySelector('.uk-navbar-right');
    if (!right) return;

    var grid = right.querySelector('.uk-grid, [uk-grid]');
    var nameCol = grid ? grid.querySelector('.uk-width-expand') : null;
    var title = nameCol ? nameCol.querySelector('h5') : null;

    // botão só com a setinha (sem avatar/nome)
    var btn = mount.querySelector('#ndUserBtn');
    if (btn) btn.classList.add('nd-caret-min');

    // quer a setinha IMEDIATAMENTE depois do <h5> (sem ficar por cima)
    if (title && typeof title.insertAdjacentElement === 'function') {
      title.insertAdjacentElement('afterend', mount);
      if (nameCol && !nameCol.style.position) nameCol.style.position = 'relative';
      return;
    }

    // fallback: final da barra direita
    right.appendChild(mount);
  }

  function wireDropdown() {
    var btn = document.getElementById('ndUserBtn');
    var menu = document.getElementById('ndUserMenu');
    if (!btn || !menu) return;

    function flipIfNeeded() {
      // remove estado anterior
      menu.classList.remove('nd-align-left');
      // mede a caixa aberta
      var r = menu.getBoundingClientRect();
      if (r.right > (window.innerWidth - 8)) {
        // ancora pela esquerda se estourar a viewport
        menu.classList.add('nd-align-left');
      }
    }

    function openM() {
      menu.hidden = false;
      btn.setAttribute('aria-expanded', 'true');
      // espera o layout aplicar e checa overflow
      requestAnimationFrame(flipIfNeeded);
    }
    function closeM() {
      menu.hidden = true;
      btn.setAttribute('aria-expanded', 'false');
    }
    function toggleM() {
      menu.hidden ? openM() : closeM();
    }

    btn.addEventListener('click', function (e) {
      e.preventDefault();
      toggleM();
    });

    document.addEventListener('click', function (e) {
      if (!menu.contains(e.target) && !btn.contains(e.target)) closeM();
    });

    document.addEventListener('keydown', function (e) {
      if (e.key === 'Escape') closeM();
    });

    window.addEventListener('scroll', closeM, { passive: true });
    window.addEventListener('resize', function () {
      if (!menu.hidden) flipIfNeeded();
    });
  }

  function init() {
    mountInPlace();
    wireDropdown();
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }
})();
