<?php
declare(strict_types=1);

/*--------------------*/
// Página: Meu desempenho do associado
// Uso: associate_me.php?code=SEU_CODIGO
/*--------------------*/

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/admin/functions.php';

$code = isset($_GET['code']) ? trim((string)$_GET['code']) : '';
if ($code === '' && isset($_GET['a'])) {
    $code = trim((string)$_GET['a']);
}

$associate = null;
$clicksByDay = array();
$totalClicks = 0;
$totalClicksMonth = 0;
$topAssociates = array();
$rankingMonthLabel = date('m/Y');

try {
    if ($code !== '') {
        $db = connect();
        $stmt = $db->prepare("SELECT * FROM associates WHERE associate_code = :code LIMIT 1");
        $stmt->execute(array(':code' => $code));
        $associate = $stmt->fetch();

        if ($associate) {
            // Total lifetime
            try {
                $stmtTotal = $db->prepare("SELECT COUNT(*) AS total FROM associate_clicks WHERE associate_id = :id");
                $stmtTotal->execute(array(':id' => $associate['associate_id']));
                $rt = $stmtTotal->fetch();
                if ($rt && isset($rt['total'])) {
                    $totalClicks = (int)$rt['total'];
                }
            } catch (Exception $e) {
                $totalClicks = 0;
            }

            // Total mês atual
            try {
                $stmtMonth = $db->prepare("SELECT COUNT(*) AS total FROM associate_clicks WHERE associate_id = :id AND click_time >= DATE_FORMAT(CURDATE(), '%Y-%m-01')");
                $stmtMonth->execute(array(':id' => $associate['associate_id']));
                $rm = $stmtMonth->fetch();
                if ($rm && isset($rm['total'])) {
                    $totalClicksMonth = (int)$rm['total'];
                }
            } catch (Exception $e) {
                $totalClicksMonth = 0;
            }

            // Cliques por dia (últimos 30 dias)
            try {
                $sql = "SELECT DATE(click_time) AS day, COUNT(*) AS total
                        FROM associate_clicks
                        WHERE associate_id = :id
                          AND click_time >= DATE_SUB(NOW(), INTERVAL 30 DAY)
                        GROUP BY DATE(click_time)
                        ORDER BY day ASC";
                $stmtDay = $db->prepare($sql);
                $stmtDay->execute(array(':id' => $associate['associate_id']));
                $clicksByDay = $stmtDay->fetchAll();
            } catch (Exception $e) {
                $clicksByDay = array();
            }
        }
    }
} catch (Exception $e) {
    $associate = null;
}

// Ranking dos 10 associados com mais cliques no mês atual
try {
    $dbRank = isset($db) && $db ? $db : connect();
    $sqlRank = "SELECT a.associate_name,
                       a.associate_code,
                       COUNT(c.click_id) AS total_clicks_month
                FROM associates a
                LEFT JOIN associate_clicks c
                  ON c.associate_id = a.associate_id
                 AND c.click_time >= DATE_FORMAT(CURDATE(), '%Y-%m-01')
                GROUP BY a.associate_id
                ORDER BY total_clicks_month DESC, a.associate_name ASC
                LIMIT 10";
    $stmtRank = $dbRank->prepare($sqlRank);
    $stmtRank->execute();
    $topAssociates = $stmtRank->fetchAll();
} catch (Exception $e) {
    $topAssociates = array();
}


// Monta dados para o gráfico
$chartLabels = array();
$chartValues = array();
if (!empty($clicksByDay)) {
    foreach ($clicksByDay as $row) {
        $chartLabels[] = isset($row['day']) ? (string)$row['day'] : '';
        $chartValues[] = isset($row['total']) ? (int)$row['total'] : 0;
    }
}

// Monta URL base do QR
$qrUrl = '';
if ($code !== '') {
    $qrUrl = rtrim(SITE_URL, '/') . '/qr.php?code=' . urlencode($code);
}
?><!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <title>Meu desempenho - Associado</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body { font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif; background:#f5f5f5; margin:0; padding:0; }
    .wrap { max-width: 960px; margin: 0 auto; padding: 20px; }
    .card { background:#fff; border-radius:8px; padding:20px; box-shadow:0 2px 6px rgba(0,0,0,.06); margin-bottom:20px; }
    h1, h2, h3, h4, h5 { margin-top:0; }
    .muted { color:#666; font-size:14px; }
    .badge { display:inline-block; padding:3px 9px; border-radius:20px; font-size:12px; }
    .badge-success { background:#e3f7ed; color:#108f4a; }
    .badge-danger { background:#fdecea; color:#b42b2b; }
    .stats { display:flex; flex-wrap:wrap; gap:16px; }
    .stat { flex:1 1 140px; background:#fafafa; border-radius:8px; padding:12px 14px; text-align:center; }
    .stat-title { font-size:12px; color:#777; text-transform:uppercase; letter-spacing:.04em; }
    .stat-value { font-size:20px; font-weight:600; margin-top:4px; }
    .qr-box { text-align:center; }
    .qr-box img { max-width:220px; }
    .small { font-size:13px; }
    code { background:#f1f1f1; padding:2px 4px; border-radius:4px; }
    canvas { max-width:100%; }
    .ranking-card-intro { margin-bottom:10px; }
    .ranking-table { width:100%; border-collapse:collapse; font-size:13px; }
    .ranking-table th, .ranking-table td { padding:6px 8px; border-bottom:1px solid #eee; }
    .ranking-table th { text-align:left; font-weight:600; color:#555; }
    .ranking-table th:nth-child(1),
    .ranking-table td:nth-child(1),
    .ranking-table th:nth-child(3),
    .ranking-table td:nth-child(3),
    .ranking-table th:nth-child(4),
    .ranking-table td:nth-child(4) { text-align:center; white-space:nowrap; }
    .ranking-medal { font-size:16px; }
  </style>
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
  <div class="wrap">
    <?php if (!$associate): ?>
      <div class="card">
        <h2>Meu desempenho</h2>
        <p class="muted">Não foi possível localizar o associado para o código informado.</p>
        <p class="small">Verifique com o suporte se o link está correto.</p>
      </div>
    <?php else: ?>
      <div class="card">
        <h2>Meu desempenho</h2>
        <p class="muted">Olá, <?php echo htmlspecialchars((string)$associate['associate_name'], ENT_QUOTES, 'UTF-8'); ?>! Aqui você acompanha o desempenho do seu QR Code.</p>
        <p>
          <strong>Grupo:</strong> 
          <?php 
            $grp = isset($associate['associate_group']) ? (string)$associate['associate_group'] : '';
            echo htmlspecialchars($grp, ENT_QUOTES, 'UTF-8');
          ?><br>
          <strong>Cidade / UF:</strong>
          <?php
            $city  = (string)($associate['associate_city'] ?? '');
            $state = (string)($associate['associate_state'] ?? '');
            echo htmlspecialchars(trim($city . ' / ' . $state), ENT_QUOTES, 'UTF-8');
          ?><br>
          <strong>Código do associado:</strong>
          <code><?php echo htmlspecialchars((string)$associate['associate_code'], ENT_QUOTES, 'UTF-8'); ?></code><br>
          <strong>Status:</strong>
          <?php if ((int)$associate['associate_status'] === 1): ?>
            <span class="badge badge-success">Ativo</span>
          <?php else: ?>
            <span class="badge badge-danger">Inativo</span>
          <?php endif; ?>
        </p>

        <div class="stats">
          <div class="stat">
            <div class="stat-title">Cliques totais</div>
            <div class="stat-value"><?php echo number_format((int)$totalClicks, 0, ',', '.'); ?></div>
          </div>
          <div class="stat">
            <div class="stat-title">Cliques no mês</div>
            <div class="stat-value"><?php echo number_format((int)$totalClicksMonth, 0, ',', '.'); ?></div>
          </div>
        </div>
      </div>

      <div class="card">
        <h3>Clique por dia (últimos 30 dias)</h3>
        <?php if (!empty($chartLabels)): ?>
          <canvas id="assocMeChart" height="140"></canvas>
        <?php else: ?>
          <p class="muted">Ainda não há cliques registrados no período analisado.</p>
        <?php endif; ?>
      </div>

      <?php if (!empty($topAssociates)): ?>
      <div class="card">
        <h3>Ranking de associados</h3>
        <p class="muted ranking-card-intro">
          Top 10 associados com mais cliques no QR Code no mês <?php echo htmlspecialchars($rankingMonthLabel, ENT_QUOTES, 'UTF-8'); ?>.
        </p>
        <table class="ranking-table">
          <thead>
            <tr>
              <th>#</th>
              <th>Associado</th>
              <th>Código</th>
              <th>Cliques no mês</th>
            </tr>
          </thead>
          <tbody>
            <?php $pos = 0; foreach ($topAssociates as $row): $pos++; ?>
              <tr>
                <td class="ranking-medal">
                  <?php if ($pos === 1): ?>
                    🥇
                  <?php elseif ($pos === 2): ?>
                    🥈
                  <?php elseif ($pos === 3): ?>
                    🥉
                  <?php else: ?>
                    <?php echo (int)$pos; ?>
                  <?php endif; ?>
                </td>
                <td><?php echo htmlspecialchars((string)($row['associate_name'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></td>
                <td>
                  <code><?php echo htmlspecialchars((string)($row['associate_code'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></code>
                </td>
                <td>
                  <?php echo number_format((int)($row['total_clicks_month'] ?? 0), 0, ',', '.'); ?>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <?php endif; ?>

      <div class="card qr-box">
        <h3>QR Code da sua mídia</h3>
        <p class="muted">Este é o endereço que você divulga nos adesivos e materiais. Qualquer acesso por ele será contado aqui.</p>
        <?php if ($qrUrl !== ''): ?>
          <img src="https://chart.googleapis.com/chart?chs=220x220&amp;cht=qr&amp;chl=<?php echo urlencode($qrUrl); ?>" alt="QR Code">
          <p class="small">
            <button type="button"
                    class="uk-button uk-button-default uk-button-small"
                    id="ndCopyQrBtn"
                    data-qr="<?php echo htmlspecialchars($qrUrl, ENT_QUOTES, 'UTF-8'); ?>">
              Copiar link do QR
            </button>
            <span id="ndCopyQrStatus" class="uk-text-meta" style="margin-left:6px; display:none;">
              Copiado!
            </span>
          </p>
        <?php else: ?>
          <p class="muted">Não foi possível montar a URL do QR Code.</p>
        <?php endif; ?>
      </div>
    <?php endif; ?>
  </div>

  <script>
  (function() {
    var ctx = document.getElementById('assocMeChart');
    if (!ctx) return;

    var labels = <?php echo json_encode($chartLabels ?: array()); ?>;
    var data   = <?php echo json_encode($chartValues ?: array()); ?>;

    if (!labels.length) return;

    new Chart(ctx, {
      type: 'line',
      data: {
        labels: labels,
        datasets: [{
          label: 'Cliques por dia',
          data: data,
          borderColor: '#18BCC9',
          borderWidth: 2,
          fill: false,
          pointRadius: 3,
          lineTension: 0
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        scales: {
          x: { ticks: { autoSkip: true, maxTicksLimit: 10 } },
          y: { beginAtZero: true, ticks: { precision: 0 } }
        }
      }
    });
  })();
  </script>

  <script>
  (function() {
    var btn = document.getElementById('ndCopyQrBtn');
    if (!btn) return;
    var status = document.getElementById('ndCopyQrStatus');

    function showStatus(msg) {
      if (!status) return;
      status.textContent = msg;
      status.style.display = 'inline';
      setTimeout(function() {
        status.style.display = 'none';
      }, 2000);
    }

    function fallbackCopy(url) {
      try {
        var tmp = document.createElement('textarea');
        tmp.value = url;
        document.body.appendChild(tmp);
        tmp.select();
        document.execCommand('copy');
        document.body.removeChild(tmp);
        showStatus('Copiado!');
      } catch (err) {
        showStatus('Falha ao copiar');
      }
    }

    btn.addEventListener('click', function(e) {
      e.preventDefault();
      var url = btn.getAttribute('data-qr') || '';
      if (!url) return;

      if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(url).then(function() {
          showStatus('Copiado!');
        }).catch(function() {
          fallbackCopy(url);
        });
      } else {
        fallbackCopy(url);
      }
    });
  })();
  </script>
</body>
</html>
