<?php

declare(strict_types=1);
header('Content-Type: text/plain; charset=utf-8');
$base = __DIR__;
$replacements = [
    '/\$(langStrings)\s*\[\s*0\s*\]/' => '$translation',
];
$excludeDirs = ['classes', 'vendor', '.git', 'node_modules'];

$rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($base, FilesystemIterator::SKIP_DOTS));
$changed = 0; $scanned = 0;
foreach ($rii as $file) {
    if ($file->isDir()) continue;
    $path = $file->getPathname();
    if (substr($path, -4) !== '.php') continue;
    // Exclude vendor-like dirs
    $skip = false;
    foreach ($excludeDirs as $ex) {
        if (strpos($path, DIRECTORY_SEPARATOR . $ex . DIRECTORY_SEPARATOR) !== false) {
            $skip = true; break;
        }
    }
    if ($skip) continue;

    $scanned++;
    $contents = @file_get_contents($path);
    if ($contents === false) continue;

    $orig = $contents;
    foreach ($replacements as $pattern => $to) {
        $contents = preg_replace($pattern, $to, $contents);
    }
    if ($contents !== $orig) {
        file_put_contents($path, $contents);
        echo "[UPDATED] $path\n";
        $changed++;
    }
}
echo "Scanned: $scanned files. Updated: $changed files.\n";
echo "Done. DELETE this file after use.\n";
?>