<?php

declare(strict_types=1);
class TOTP {
  public static function base32_decode($b32) {
    $b32 = strtoupper($b32);
    $alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ234567';
    $buffer = 0; $bitsLeft = 0; $result = '';
    for ($i=0; $i<strlen($b32); $i++) {
      $val = strpos($alphabet, $b32[$i]);
      if ($val === false) continue;
      $buffer = ($buffer << 5) | $val;
      $bitsLeft += 5;
      if ($bitsLeft >= 8) {
        $bitsLeft -= 8;
        $result .= chr(($buffer >> $bitsLeft) & 0xFF);
      }
    }
    return $result;
  }

  public static function hotp($secret_b32, $counter, $digits=6) {
    $key = self::base32_decode($secret_b32);
    $binCounter = pack('N*', 0) . pack('N*', $counter);
    $hash = hash_hmac('sha1', $binCounter, $key, true);
    $offset = ord($hash[19]) & 0x0F;
    $code = (
      ((ord($hash[$offset+0]) & 0x7F) << 24) |
      ((ord($hash[$offset+1]) & 0xFF) << 16) |
      ((ord($hash[$offset+2]) & 0xFF) << 8)  |
      (ord($hash[$offset+3]) & 0xFF)
    ) % pow(10, $digits);
    return str_pad($code, $digits, '0', STR_PAD_LEFT);
  }

  public static function totp($secret_b32, $timeStep=30, $digits=6, $t0=0, $atTime=null) {
    $t = $atTime ?? time();
    $counter = floor(($t - $t0) / $timeStep);
    return self::hotp($secret_b32, $counter, $digits);
  }

  public static function verify($secret_b32, $code, $skew=1, $timeStep=30, $digits=6) {
    $code = preg_replace('/\s+/', '', (string)$code);
    $now = time();
    for ($i=-$skew; $i<=$skew; $i++) {
      $calc = self::totp($secret_b32, $timeStep, $digits, 0, $now + ($i*$timeStep));
      if (hash_equals($calc, $code)) return true;
    }
    return false;
  }
}
