<?php

declare(strict_types=1);
?>
<?php
/*
 * NOTE: The examples are using a text file as a database.
 * Please use a real database like MySQL in production code.
 */

function database_read($orderId)
{
    $orderId = intval($orderId);
    $database = dirname(__FILE__) . "/database/order-{$orderId}.txt";

    $status = @file_get_contents($database);

    return $status ? $status : "unknown order";
}

function database_write($orderId, $status)
{
    $orderId = intval($orderId);
    $database = dirname(__FILE__) . "/database/order-{$orderId}.txt";

    file_put_contents($database, $status);
}

/* === ND SECURITY HELPERS (added) === */
if (!function_exists('nd_safe_html')) {
  function nd_safe_html(string $html): string {
    // Remove dangerous tags
    $html = preg_replace('#<(script|style|iframe|object|embed|meta|link)\b[^>]*>.*?</\1>#is', '', $html);
    // Remove on* attributes
    $html = preg_replace('#\son\w+\s*=\s*([\'"]).*?\1#i', '', $html);
    // Neutralize javascript: and data:
    $html = preg_replace('#(href|src)\s*=\s*([\'"])\s*(javascript:|data:)#i', '$1=$2#', $html);
    // Whitelist of safe tags
    $allowed = '<p><br><strong><em><ul><ol><li><blockquote><code><pre><h1><h2><h3><h4><h5><h6><a><img><hr><span><div>';
    $html = strip_tags($html, $allowed);
    // Secure links
    $html = preg_replace('#<a\b([^>]*)>#i', '<a$1 rel="nofollow noopener" target="_blank">', $html);
    return $html;
  }
}
if (!function_exists('nd_security_headers')) {
  function nd_security_headers(): void {
    @header('X-Frame-Options: SAMEORIGIN');
    @header('X-Content-Type-Options: nosniff');
    @header('Referrer-Policy: strict-origin-when-cross-origin');
    @header("Permissions-Policy: geolocation=(), microphone=(), camera=()");
    @header("Content-Security-Policy: default-src \'self\' https: data:; img-src \'self\' https: data:; script-src \'self\' https: \'unsafe-inline\' \'unsafe-eval\'; style-src \'self\' https: \'unsafe-inline\'");
  }
}
/* === /ND SECURITY HELPERS === */

