<?php
declare(strict_types=1);
namespace WhichBrowser\\Data;\n";
    $file .= "\n";
    $file .= "DeviceModels::\$" . strtoupper($type) . "_INDEX = " . var_export($index, true) . ";\n";

    file_put_contents(__DIR__ . '/../data/indices/models-' . $type . '.php', $file);
}

function getKeysFromRegexp($regexp) {
	$lexer = new Lexer($regexp);
	$lexer->moveNext();

	$keys = readKeysFromLexer($lexer);

	return array_unique($keys);
}


function readKeysFromLexer($lexer) {
	$keys = [];

	if ($lexer->isNextTokenAny([ Lexer::T_LITERAL_CHAR,Lexer::T_LITERAL_NUMERIC ])) {
		$current = strtoupper($lexer->lookahead['value']);

		$lexer->moveNext();
		if ($lexer->isNextTokenAny([ Lexer::T_LITERAL_CHAR,Lexer::T_LITERAL_NUMERIC ])) {
			$keys[] = $current . strtoupper($lexer->lookahead['value']);
		}
		else {
			$keys[] = '**';
		}
	}

	else if ($lexer->isNextToken(Lexer::T_GROUP_OPEN)) {
		$current = '';
		$active = true;

		while ($lexer->moveNext()) {
			if ($lexer->isNextTokenAny([ Lexer::T_LITERAL_CHAR,Lexer::T_LITERAL_NUMERIC ])) {
				if ($active && strlen($current) < 2) {
					$current .= strtoupper($lexer->lookahead['value']);
				}
			}

			else if ($lexer->isNextToken(Lexer::T_CHOICE_BAR)) {
				$keys[] = $current;
				$current = '';
				$active = true;
			}

			else if ($lexer->isNextToken(Lexer::T_GROUP_OPEN)) {
				if ($lexer->moveNext()) {
					$more = readKeysFromLexer($lexer);

					if (count($more)) {
						$keys = array_merge($keys, $more);
					} else {
						break;
					}
				}
			}

			else if ($lexer->isNextToken(Lexer::T_GROUP_CLOSE)) {
				if (strlen($current) == 2) {
					$keys[] = $current;
				} else {
					$keys[] = '**';
				}

				$current = '';
				$active = true;
				break;
			}

			else if ($lexer->isNextToken(Lexer::T_DOT)) {
				$keys[] = '**';
				$current = '';
				$active = false;
				break;
			}

			else {
				$active = false;
			}
		}

		while ($lexer->moveNext()) {
			if ($lexer->isNextToken(Lexer::T_QUANTIFIER_QUESTION)) {
				if ($lexer->moveNext()) {
					$more = readKeysFromLexer($lexer);

					if (count($more)) {
						$keys = array_merge($keys, $more);
					} else {
						break;
					}
				}
			}
			else {
				break;
			}
		}
	}

	else if ($lexer->isNextToken(Lexer::T_SET_OPEN)) {
		$keys[] = '**';
	}

	else if ($lexer->isNextToken(Lexer::T_DOT)) {
		$keys[] = '**';
	}

	return array_unique($keys);
}
