<?php
declare(strict_types=1);
namespace WhichBrowser\Data;

BuildIds::$ANDROID_BUILDS = [
    'CUPCAKE'       => '1.5',
    'DONUT'         => '1.6',
    'ECLAIR'        => '2.0',
    'FROYO'         => '2.2',
    'GINGERBREAD'   => '2.3',

    'DRC83'         => '1.6',
    'DRC92'         => '1.6',
    'DRD08'         => '1.6',
    'DRD20'         => '1.6',
    'DMD64'         => '1.6',
    'ESD20'         => '2.0',
    'ESD56'         => '2.0.1',
    'ERD79'         => '2.1',
    'ERE27'         => '2.1',
    'EPE54B'        => '2.1',
    'ESE81'         => '2.1',
    'EPF21B'        => '2.1',
    'FRF85B'        => '2.2',
    'FRF91'         => '2.2',
    'FRG01B'        => '2.2',
    'FRG22D'        => '2.2',
    'FRG83'         => '2.2.1',
    'FRG83D'        => '2.2.1',
    'FRG83G'        => '2.2.2',
    'FRK76'         => '2.2.3',
    'FRK76C'        => '2.2.3',
    'GRH55'         => '2.3',
    'GRH78'         => '2.3.1',
    'GRH78C'        => '2.3.2',
    'GRI40'         => '2.3.3',
    'GRI54'         => '2.3.3',
    'GRJ06D'        => '2.3.4',
    'GRJ22'         => '2.3.4',
    'GRJ90'         => '2.3.5',
    'GRK39C'        => '2.3.6',
    'GRK39F'        => '2.3.6',
    'GWK74'         => '2.3.7',

    'HRI39'         => '3.0',
    'HRI66'         => '3.0',
    'HWI69'         => '3.0',
    'HRI83'         => '3.0',
    'HMJ37'         => '3.1',
    'HTJ85B'        => '3.2',
    'HTK55D'        => '3.2.1',
    'HTK75'         => '3.2.1',
    'HTK75D'        => '3.2.1',
    'HLK75C'        => '3.2.2',
    'HLK75D'        => '3.2.2',
    'HLK75F'        => '3.2.4',
    'HLK75H'        => '3.2.6',

    'ITL41D'        => '4.0.1',
    'ITL41E'        => '4.0.1',
    'ITL41F'        => '4.0.1',
    'ICL53F'        => '4.0.2',
    'IML74K'        => '4.0.3',
    'IML77'         => '4.0.3',
    'IMM76'         => '4.0.4',
    'IMM76D'        => '4.0.4',
    'IMM76I'        => '4.0.4',
    'IMM76K'        => '4.0.4',
    'IMM76L'        => '4.0.4',
    'JRO03C'        => '4.1.1',
    'JRO03D'        => '4.1.1',
    'JRO03E'        => '4.1.1',
    'JRO03H'        => '4.1.1',
    'JRO03L'        => '4.1.1',
    'JRO03O'        => '4.1.1',
    'JRO03R'        => '4.1.1',
    'JRO03S'        => '4.1.1',
    'JZO54K'        => '4.1.2',
    'JZO54M'        => '4.1.2',
    'JVP15S'        => '4.2',           // Interim build used by the Nexus 7
    'JOP40C'        => '4.2',
    'JOP40D'        => '4.2.1',
    'JOP40F'        => '4.2.1',
    'JOP40G'        => '4.2.1',
    'JDQ39'         => '4.2.2',
    'JDQ39B'        => '4.2.2',
    'JDQ39E'        => '4.2.2',
    'JWR66L'        => '4.3',
    'JWR66N'        => '4.3',
    'JWR66N.S005'   => '4.3',           // Google Play Edition - Samsung Galaxy S4
    'JWR66V'        => '4.3',
    'JWR66V.H10'    => '4.3',           // Google Play Edition - HTC One
    'JWR66V.S014'   => '4.3',           // Google Play Edition - Samsung Galaxy S4
    'JWR66Y'        => '4.3',
    'JWR66Y.S003'   => '4.3',           // Google Play Edition - Samsung Galaxy S4
    'JSR78D'        => '4.3',
    'JSS15J'        => '4.3',
    'JSS15Q'        => '4.3',
    'KRT16S'        => '4.4',
    'KRT16M'        => '4.4',
    'KOT49E'        => '4.4.1',
    'KOT49H'        => '4.4.2',
    'KVT49L'        => '4.4.2',
    'KTU84L'        => '4.4.3',
    'KTU84M'        => '4.4.3',
    'KTU84P'        => '4.4.4',

    'LPV79'         => ['value' => '5.0', 'alias' => 'L'],
    'LPV81C'        => ['value' => '5.0', 'alias' => 'L'],
    'LPX13D'        => ['value' => '5.0', 'alias' => 'L'],

    'LRX21L'        => '5.0',
    'LRX21M'        => '5.0',
    'LRX21O'        => '5.0',
    'LRX21P'        => '5.0',
    'LRX21Q'        => '5.0',
    'LRX21R'        => '5.0',
    'LRX21T'        => '5.0',
    'LRX21V'        => '5.0',
    'LRX22C'        => '5.0.1',
    'LRX22G'        => '5.0.2',
    'LRX22L'        => '5.0.2',
    'LGZ23.S3'      => '5.0.2',         // Sony Bravia Android TV
    'LGZ23.S15'     => '5.0.2',         // Sony Bravia Android TV
    'LGZ23.S37'     => '5.0.2',         // Sony Bravia Android TV
    'LGZ23.S49'     => '5.0.2',         // Sony Bravia Android TV
    'LGZ23.S55'     => '5.0.2',         // Sony Bravia Android TV
    'LGZ23.S59'     => '5.0.2',         // Sony Bravia Android TV
    'LGZ23.S61'     => '5.0.2',         // Sony Bravia Android TV
    'LGZ23.S73'     => '5.0.2',         // Sony Bravia Android TV
    'LGY70.S1'      => '5.0.2',         // Sony Bravia Android TV
    'LGY75.S91'     => '5.0.2',         // Sony Bravia Android TV
    'LGY75.S105'    => '5.0.2',         // Sony Bravia Android TV
    'LGY75.S109'    => '5.0.2',         // Sony Bravia Android TV
    'LGY75.S131'    => '5.0.2',         // Sony Bravia Android TV
    'LGY75.S143'    => '5.0.2',         // Sony Bravia Android TV
    'LGY75.S147'    => '5.0.2',         // Sony Bravia Android TV
    'LMY47D'        => '5.1',
    'LMY47E'        => '5.1',
    'LMY47I'        => '5.1',
    'LMY47M'        => '5.1',
    'LMY47O'        => '5.1',
    'LMY47V'        => '5.1.1',
    'LMY47X'        => '5.1.1',
    'LMY47Z'        => '5.1.1',
    'LMY48B'        => '5.1.1',
    'LMY48E.S1'     => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S39'    => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S63'    => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S81'    => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S89'    => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S91'    => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S117'   => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S127'   => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S143'   => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S153'   => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S155'   => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S167'   => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S185'   => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S191'   => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S195'   => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S197'   => '5.1.1',         // Sony Bravia Android TV
    'LMY48E.S223'   => '5.1.1',         // Sony Bravia Android TV
    'LMY48B'        => '5.1.1',
    'LMY48G'        => '5.1.1',
    'LMY48I'        => '5.1.1',
    'LMY48J'        => '5.1.1',
    'LMY48M'        => '5.1.1',
    'LMY48N'        => '5.1.1',
    'LMY48P'        => '5.1.1',
    'LMY48T'        => '5.1.1',
    'LMY48U'        => '5.1.1',
    'LMY48W'        => '5.1.1',
    'LMY48X'        => '5.1.1',
    'LMY48Y'        => '5.1.1',
    'LMY48Z'        => '5.1.1',
    'LMY49F'        => '5.1.1',
    'LMY49G'        => '5.1.1',
    'LMY49H'        => '5.1.1',
    'LMY49I'        => '5.1.1',
    'LMY49J'        => '5.1.1',
    'LVY48C'        => '5.1.1',
    'LVY48E'        => '5.1.1',
    'LVY48F'        => '5.1.1',
    'LVY48H'        => '5.1.1',
    'LYZ28E'        => '5.1.1',
    'LYZ28J'        => '5.1.1',
    'LYZ28K'        => '5.1.1',
    'LYZ28M'        => '5.1.1',
    'LYZ28N'        => '5.1.1',

    'MPZ44Q'        => ['value' => '6.0', 'alias' => 'M'],
    'MPZ79M'        => ['value' => '6.0', 'alias' => 'M'],

    'MRA58K'        => '6.0',
    'MRA58N'        => '6.0',
    'MRA58U'        => '6.0',
    'MRA58V'        => '6.0',
    'MRA58X'        => '6.0',
    'MRA59B'        => '6.0',
    'MDA89D'        => '6.0',
    'MDA89E'        => '6.0',
    'MDB08I'        => '6.0',
    'MDB08K'        => '6.0',
    'MDB08L'        => '6.0',
    'MDB08M'        => '6.0',
    'MMB29N'        => '6.0',
    'MMB29K'        => '6.0.1',
    'MMB29M'        => '6.0.1',
    'MMB29O'        => '6.0.1',
    'MMB29P'        => '6.0.1',
    'MMB29S'        => '6.0.1',
    'MMB29T'        => '6.0.1',
    'MMB29Q'        => '6.0.1',
    'MMB29R'        => '6.0.1',
    'MMB29U'        => '6.0.1',
    'MMB29V'        => '6.0.1',
    'MMB29X'        => '6.0.1',
    'MHC19I'        => '6.0.1',
    'MHC19J'        => '6.0.1',
    'MHC19Q'        => '6.0.1',
    'MOB30D'        => '6.0.1',
    'MOB30G'        => '6.0.1',
    'MOB30H'        => '6.0.1',
    'MOB30I'        => '6.0.1',
    'MOB30J'        => '6.0.1',
    'MTC19T'        => '6.0.1',
    'MXB48J'        => '6.0.1',
    'MXB48K'        => '6.0.1',
    'MXB48T'        => '6.0.1',
    'MXC14G'        => '6.0.1',
    'MXC89F'        => '6.0.1',
    'M5C14J'        => '6.0.1',

    'NPC56P'        => ['value' => '7.0', 'alias' => 'N'],
    'NPC56W'        => ['value' => '7.0', 'alias' => 'N'],
    'NPC56X'        => ['value' => '7.0', 'alias' => 'N'],
    'NPC91K'        => ['value' => '7.0', 'alias' => 'N'],
    'NPD35K'        => ['value' => '7.0', 'alias' => 'N'],
    'NRD21D'        => ['value' => '7.0', 'alias' => 'N'],
    'NRD28C'        => ['value' => '7.0', 'alias' => 'N'],
];

// Source: http://source.android.com/source/build-numbers.html
