<?php
declare(strict_types=1);
namespace WhichBrowser\Data;

use WhichBrowser\Constants\DeviceType;

DeviceProfiles::$PROFILES = [
    'http://go.acer.com/?id=17884'                                                                        => [ 'Acer', 'All-in-One DA223HQL', 'Android',  ],
    'http://support.acer.com/uaprofile/Acer_E110_profile.xml'                                             => [ 'Acer', 'beTouch E110', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_E130_profile_no_3rd_drm_no_java.xml'                          => [ 'Acer', 'beTouch E130', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_E400_Profile.xml'                                             => [ 'Acer', 'beTouch E400', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_Acer_A9_Profile.xml'                                          => [ 'Acer', 'CloudMobile', 'Aliyun OS', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_S500_IML74K_Profile.xml'                                      => [ 'Acer', 'CloudMobile', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_S500_IMM76D_Profile.xml'                                      => [ 'Acer', 'CloudMobile', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_S500_IMM76I_Profile.xml'                                      => [ 'Acer', 'CloudMobile', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_S500_JRO03L_Profile.xml'                                      => [ 'Acer', 'CloudMobile', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_S500_JZO54K_Profile.xml'                                      => [ 'Acer', 'CloudMobile', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_E100_Profile.XML'                                             => [ 'Acer', 'E100', 'Windows Mobile', DeviceType::MOBILE ],
    'http://global-download.acer.com/SupportFiles/Files/UAProfile/XML/Acer_A1-810_JDQ39_Profile.xml'      => [ 'Acer', 'Iconia A1-810', 'Android', DeviceType::TABLET ],
    'http://global-download.acer.com/SupportFiles/Files/UAProfile/XML/Acer_A1-811_JDQ39_Profile.xml'      => [ 'Acer', 'Iconia A1-811', 'Android', DeviceType::MOBILE ],
    'http://global-download.acer.com/SupportFiles/Files/UAProfile/XML/Acer_A1-812_JDQ39_Profile.xml'      => [ 'Acer', 'Iconia A1-812', 'Android', DeviceType::TABLET ],
    'http://go.acer.com/?id=5566'                                                                         => [ 'Acer', 'Iconia A1-820', 'Android', DeviceType::TABLET ],
    'http://go.acer.com/?id=17979'                                                                        => [ 'Acer', 'Iconia A1-830', 'Android', DeviceType::TABLET ],
    'http://go.acer.com/?id=17995'                                                                        => [ 'Acer', 'Iconia One 7 B1-730 HD', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_S300_Profile.xml'                                             => [ 'Acer', 'Iconia Smart', 'Android', DeviceType::MOBILE ],
    'http://global-download.acer.com/SupportFiles/Files/UAProfile/XML/Acer_A1-713_JDQ39_Profile.xml'      => [ 'Acer', 'Iconia Tab 7 A1-713', 'Android', DeviceType::TABLET ],
    'http://global-download.acer.com/SupportFiles/Files/UAProfile/XML/Acer_A1-713_KOT49H_Profile.xml'     => [ 'Acer', 'Iconia Tab 7 A1-713', 'Android', DeviceType::TABLET ],
    'http://global-download.acer.com/SupportFiles/Files/UAProfile/XML/Acer_A1-713HD_KOT49H_Profile.xml'   => [ 'Acer', 'Iconia Tab 7 A1-713 HD', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A100_IML74K_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A100', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A100_Profile.xml'                                             => [ 'Acer', 'Iconia Tab A100', 'Android', DeviceType::TABLET ],
    'http://www.zte.com.cn/mobile/uaprof/A100.xml'                                                        => [ 'Acer', 'Iconia Tab A100', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A101_IML74K_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A101', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A101_Profile.xml'                                             => [ 'Acer', 'Iconia Tab A101', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A200_Profile.xml'                                             => [ 'Acer', 'Iconia Tab A200', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A210_IMM76D_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A210', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A210_JRO03H_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A210', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A210_JRO4HDb1_Profile.xml'                                    => [ 'Acer', 'Iconia Tab A210', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A210_JRO4HDb3_Profile.xml'                                    => [ 'Acer', 'Iconia Tab A210', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A210_JZO54K_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A210', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A211_IMM76D_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A211', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A211_JRO03H_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A211', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A500_IML74K_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A500', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A500_IMM76D_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A500', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A500_Profile.xml'                                             => [ 'Acer', 'Iconia Tab A500', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A501_IML74K_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A501', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A501_Profile.xml'                                             => [ 'Acer', 'Iconia Tab A501', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A510_JRO03H_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A510', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A510_JZO54K_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A510', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A510_Profile.xml'                                             => [ 'Acer', 'Iconia Tab A510', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A511_IML74K_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A511', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A511_JZO54K_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A511', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A700_IMM76D_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A700', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A700_JRO03H_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A700', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A700_Profile.xml'                                             => [ 'Acer', 'Iconia Tab A700', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A701_IMM76D_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A701', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_A701_JRO03H_Profile.xml'                                      => [ 'Acer', 'Iconia Tab A701', 'Android', DeviceType::TABLET ],
    'http://support.acer.com/UAprofile/Acer_S100_Profile.xml'                                             => [ 'Acer', 'Liquid', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com?id=17494'                                                                         => [ 'Acer', 'Liquid E2', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com/?id=17895'                                                                        => [ 'Acer', 'Liquid E3', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com?id=17895'                                                                         => [ 'Acer', 'Liquid E3', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com/?id=17999'                                                                        => [ 'Acer', 'Liquid E700', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_E210_Profile.xml'                                             => [ 'Acer', 'Liquid Express', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_E320_Profile.xml'                                             => [ 'Acer', 'Liquid Express', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com/?id=18008'                                                                        => [ 'Acer', 'Liquid Jade', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com/?id=18009'                                                                        => [ 'Acer', 'Liquid Jade S', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com/?id=83843'                                                                        => [ 'Acer', 'Liquid Jade Z', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_E310_Profile.xml'                                             => [ 'Acer', 'Liquid mini', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_S120_Profile.xml'                                             => [ 'Acer', 'Liquid mt', 'Android', DeviceType::MOBILE ],
    'http://global-download.acer.com/SupportFiles/Files/UAProfile/XML/Acer_S510_JDQ39_Profile.xml'        => [ 'Acer', 'Liquid S', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com/?id=17873'                                                                        => [ 'Acer', 'Liquid S', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com/?id=17891'                                                                        => [ 'Acer', 'Liquid S2', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_S520_JDQ39_Profile.xml'                                       => [ 'Acer', 'Liquid S2', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_Z110_UAProfile.xml'                                           => [ 'Acer', 'Liquid Z', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_Z120_UAProfile.xml'                                           => [ 'Acer', 'Liquid Z2', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com/?id=18020'                                                                        => [ 'Acer', 'Liquid Z200', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com/?id=83844'                                                                        => [ 'Acer', 'Liquid Z205', 'Android', DeviceType::MOBILE ],
    'http://global-download.acer.com/SupportFiles/Files/UAProfile/XML/Acer_Z130_JDQ39_Profile.xml'        => [ 'Acer', 'Liquid Z3', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com/?id=84411'                                                                        => [ 'Acer', 'Liquid Z330', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com/?id=17980'                                                                        => [ 'Acer', 'Liquid Z4', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com/?id=18083'                                                                        => [ 'Acer', 'Liquid Z410', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com/?id=17940'                                                                        => [ 'Acer', 'Liquid Z5', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com/?id=83841'                                                                        => [ 'Acer', 'Liquid Z520', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAProfile/Acer_P400_Profile.xml'                                             => [ 'Acer', 'neoTouch P400', 'Windows Mobile', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_S200_Profile.xml'                                             => [ 'Acer', 'neoTouch S200', 'Windows Mobile', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_S110_Profile.xml'                                             => [ 'Acer', 'Stream', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_TD600_profile.xml'                                            => [ 'Acer', 'TD600', 'Android', DeviceType::MOBILE ],
    'http://go.acer.com/?id=17684'                                                                        => [ 'Acer', 'Touch and 3D Monitor DA245HQL', 'Android',  ],
    'http://www.fly-phone.ru/UAP/Flylife_Connect_3G_2.xml'                                                => [ 'AG Mobile', 'Chrome Go-Tab 7.0', 'Android', DeviceType::TABLET ],
    'http://www.bluhelp.com/upload/xmlfiles/DASH_JR_TV_D140T.xml'                                         => [ 'AG Mobile', 'Chrome Selfie', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/STUDIO6_0HD.xml'                                              => [ 'Ainovo', 'Novo7 Aurora', 'Android', DeviceType::TABLET ],
    'http://www.airnessmobile.com/uaprof/Airness-Air99.xml'                                               => [ 'Airness', 'Air99', null, DeviceType::MOBILE ],
    'http://www.airnessmobile.com/uaprof/HT-1.xml'                                                        => [ 'Airness', 'HT-1', null, DeviceType::MOBILE ],
    'http://www.airnessmobile.com/uaprof/slide99.xml'                                                     => [ 'Airness', 'Slide99', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/9021A.xml'                                                          => [ 'Alcaltel', 'One Touch POP8', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Alcatel_A205G.rdf'                                                  => [ 'Alcatel', 'A205G', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Alcatel_A205G-B.rdf'                                                => [ 'Alcatel', 'A205G-B', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_A206G.rdf'                                                  => [ 'Alcatel', 'A206G', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Alcatel_A207BG.rdf'                                                 => [ 'Alcatel', 'A207BG', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_A383G.rdf'                                                  => [ 'Alcatel', 'A383G', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_A392G.rdf'                                                  => [ 'Alcatel', 'A392G', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_A392T.rdf'                                                  => [ 'Alcatel', 'A392T', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/A480G.xml'                                                          => [ 'Alcatel', 'A480G', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/A621R.xml'                                                          => [ 'Alcatel', 'A621R', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp-mpd.alcatel.com/files/ALCATEL-BF4_2.0.rdf'                                           => [ 'Alcatel', 'BF4', null, DeviceType::MOBILE ],
    'http://www-ccpp-mpd.alcatel.com/files/ALCATEL-BF5_1.0.rdf'                                           => [ 'Alcatel', 'BF5', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/odm/ALCATEL_D6.rdf'                                                       => [ 'Alcatel', 'D6', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/TCL/Alcatel4044T-Chameleon/4044TV02.RDF'                                 => [ 'Alcatel', 'Go Flip', 'KaiOS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/4044M.xml'                                                          => [ 'Alcatel', 'Go Flip', 'KaiOS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/4044N.xml'                                                          => [ 'Alcatel', 'Go Flip', 'KaiOS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/4044O.xml'                                                          => [ 'Alcatel', 'Go Flip', 'KaiOS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/4044V.XML'                                                          => [ 'Alcatel', 'Go Flip', 'KaiOS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/4044W.xml'                                                          => [ 'Alcatel', 'Go Flip', 'KaiOS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/4060A.xml'                                                          => [ 'Alcatel', 'IDEAL', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/alcatel/wsa622gl/wsa622gl.xml'                                               => [ 'Alcatel', 'Jitterbug Smart', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Mobile_Sosh.xml'                                                    => [ 'Alcatel', 'Le mobile Sosh', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-MD01.rdf'                                                   => [ 'Alcatel', 'MD01', null, DeviceType::MOBILE ],
    'http://www-ccpp-mpd.alcatel.com/odm/OH1C_UAProf.rdf'                                                 => [ 'Alcatel', 'OH1C', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_2067X.rdf'                                        => [ 'Alcatel', 'One Touch 2067', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_385JA.rdf'                                        => [ 'Alcatel', 'One Touch 385', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT510A.rdf'                                                 => [ 'Alcatel', 'One Touch 510A', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_585F.rdf'                                         => [ 'Alcatel', 'One Touch 585', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_602A.rdf'                                         => [ 'Alcatel', 'One Touch 602', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_720.rdf'                                          => [ 'Alcatel', 'One Touch 720', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_768T.rdf'                                         => [ 'Alcatel', 'One Touch 768T', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT-802.rdf'                                                 => [ 'Alcatel', 'One Touch 802', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_803A.rdf'                                         => [ 'Alcatel', 'One Touch 803', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT-806.rdf'                                                 => [ 'Alcatel', 'One Touch 806', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT-807D.rdf'                                                => [ 'Alcatel', 'One Touch 807', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_810D.rdf'                                         => [ 'Alcatel', 'One Touch 810D', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_813.rdf'                                          => [ 'Alcatel', 'One Touch 813', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_813A.rdf'                                         => [ 'Alcatel', 'One Touch 813', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_813D.rdf'                                         => [ 'Alcatel', 'One Touch 813', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_813FA.rdf'                                        => [ 'Alcatel', 'One Touch 813FA', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_815.rdf'                                          => [ 'Alcatel', 'One Touch 815', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_818A.rdf'                                         => [ 'Alcatel', 'One Touch 818', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_819.rdf'                                          => [ 'Alcatel', 'One Touch 819', null, DeviceType::MOBILE ],
    'http://www-ccpp-mpd.alcatel.com/odm/OT835_UAProf.rdf'                                                => [ 'Alcatel', 'One Touch 835', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_838.rdf'                                          => [ 'Alcatel', 'One Touch 838', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT871A.rdf'                                                 => [ 'Alcatel', 'One Touch 871A', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_890.xml'                                          => [ 'Alcatel', 'One Touch 890', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_890D.xml'                                         => [ 'Alcatel', 'One Touch 890', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_900A.rdf'                                         => [ 'Alcatel', 'One Touch 900', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_900M.rdf'                                         => [ 'Alcatel', 'One Touch 900M', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_902A.rdf'                                         => [ 'Alcatel', 'One Touch 902A', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_903.xml'                                          => [ 'Alcatel', 'One Touch 903', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_903A.xml'                                         => [ 'Alcatel', 'One Touch 903', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_903D.xml'                                         => [ 'Alcatel', 'One Touch 903', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_905M.rdf'                                         => [ 'Alcatel', 'One Touch 905', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_908.xml'                                          => [ 'Alcatel', 'One Touch 908', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_908F.xml'                                         => [ 'Alcatel', 'One Touch 908', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_908S.xml'                                         => [ 'Alcatel', 'One Touch 908', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_909A.xml'                                         => [ 'Alcatel', 'One Touch 909', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_916.xml'                                          => [ 'Alcatel', 'One Touch 916', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_916A.xml'                                         => [ 'Alcatel', 'One Touch 916', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_918.xml'                                          => [ 'Alcatel', 'One Touch 918', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_918A.xml'                                         => [ 'Alcatel', 'One Touch 918', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_918D.xml'                                         => [ 'Alcatel', 'One Touch 918', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_918N.xml'                                         => [ 'Alcatel', 'One Touch 918', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_918S.xml'                                         => [ 'Alcatel', 'One Touch 918', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_918_Orange.xml'                                   => [ 'Alcatel', 'One Touch 918', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT-919.xml'                                                 => [ 'Alcatel', 'One Touch 919', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_922.xml'                                          => [ 'Alcatel', 'One Touch 922', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_928D.xml'                                         => [ 'Alcatel', 'One Touch 928', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT-980.xml'                                                 => [ 'Alcatel', 'One Touch 980', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT-980A.xml'                                                => [ 'Alcatel', 'One Touch 980', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT-981A.xml'                                                => [ 'Alcatel', 'One Touch 981', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_One_touch_983.xml'                                          => [ 'Alcatel', 'One Touch 983', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_One_touch_983A.xml'                                         => [ 'Alcatel', 'One Touch 983', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_One_touch_983A_3G.xml'                                      => [ 'Alcatel', 'One Touch 983', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_One_touch_983_3G.xml'                                       => [ 'Alcatel', 'One Touch 983', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_985.xml'                                          => [ 'Alcatel', 'One Touch 985', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_985A.xml'                                         => [ 'Alcatel', 'One Touch 985', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_985D.xml'                                         => [ 'Alcatel', 'One Touch 985', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_985N.xml'                                         => [ 'Alcatel', 'One Touch 985', 'Android', DeviceType::MOBILE ],
    'http://uaprof.qma.com.tw/ALCATEL-one_touch_990C+.xml'                                                => [ 'Alcatel', 'One Touch 990', 'Android', DeviceType::MOBILE ],
    'http://uaprof.qma.com.tw/OT-990C.xml'                                                                => [ 'Alcatel', 'One Touch 990', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_990.xml'                                          => [ 'Alcatel', 'One Touch 990', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_990A.xml'                                         => [ 'Alcatel', 'One Touch 990', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_990S.xml'                                         => [ 'Alcatel', 'One Touch 990', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_OT_990M.xml'                                                => [ 'Alcatel', 'One Touch 990', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_991.xml'                                          => [ 'Alcatel', 'One Touch 991', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_991A.xml'                                         => [ 'Alcatel', 'One Touch 991', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_991D.xml'                                         => [ 'Alcatel', 'One Touch 991', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_991T.xml'                                         => [ 'Alcatel', 'One Touch 991', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_991_Orange.xml'                                   => [ 'Alcatel', 'One Touch 991', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_992D.xml'                                         => [ 'Alcatel', 'One Touch 992', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_993.xml'                                          => [ 'Alcatel', 'One Touch 993', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_995.xml'                                          => [ 'Alcatel', 'One Touch 995', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_995A.xml'                                         => [ 'Alcatel', 'One Touch 995', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_996.xml'                                          => [ 'Alcatel', 'One Touch 996', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_997.xml'                                          => [ 'Alcatel', 'One Touch 997', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_one_touch_997D.xml'                                         => [ 'Alcatel', 'One Touch 997', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_A392CC_CC.rdf'                                              => [ 'Alcatel', 'One Touch A392G', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_A392CC_TELUS.rdf'                                           => [ 'Alcatel', 'One Touch A392G', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5056O.xml'                                                          => [ 'Alcatel', 'One Touch Allura', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp-mpd.alcatel.com/files/ALCATEL-CTH3_MMS11_1.0.rdf'                                    => [ 'Alcatel', 'One Touch C651', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT-C700A.rdf'                                               => [ 'Alcatel', 'One Touch C700', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT-C701.rdf'                                                => [ 'Alcatel', 'One Touch C701', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT-C717.rdf'                                                => [ 'Alcatel', 'One Touch C717', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT-C825.rdf'                                                => [ 'Alcatel', 'One Touch C825', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/onetouch_EVO7.xml'                                                  => [ 'Alcatel', 'One Touch Evo 7', 'Android', DeviceType::TABLET ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_EVO7HD.xml'                                               => [ 'Alcatel', 'One Touch Evo 7 HD', 'Android', DeviceType::TABLET ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_EVO8HD.xml'                                               => [ 'Alcatel', 'One Touch Evo 8 HD', 'Android', DeviceType::TABLET ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7024N.xml'                                        => [ 'Alcatel', 'One Touch Fierce', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7024R.xml'                                        => [ 'Alcatel', 'One Touch Fierce', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7024W.xml'                                        => [ 'Alcatel', 'One Touch Fierce', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5054N.xml'                                                          => [ 'Alcatel', 'One Touch Fierce XL', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATELOneTouch4012X.xml'                                           => [ 'Alcatel', 'One Touch Fire', 'Firefox OS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_4012A.xml'                                                => [ 'Alcatel', 'One Touch Fire', 'Firefox OS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_4012X.xml'                                                => [ 'Alcatel', 'One Touch Fire', 'Firefox OS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/fils/ONE_TOUCH_4012A.xml'                                                 => [ 'Alcatel', 'One Touch Fire', 'Firefox OS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATELOneTouch4019A.xml'                                           => [ 'Alcatel', 'One Touch Fire C', 'Firefox OS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATELOneTouch4019X.xml'                                           => [ 'Alcatel', 'One Touch Fire C', 'Firefox OS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATELOneTouch4019X_V2.0.xml'                                      => [ 'Alcatel', 'One Touch Fire C', 'Firefox OS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_4020D.xml'                                        => [ 'Alcatel', 'One Touch Fire C', 'Firefox OS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATELOneTouch6015X.xml'                                           => [ 'Alcatel', 'One Touch Fire E', 'Firefox OS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATELOneTouch6015X_v2.0.xml'                                      => [ 'Alcatel', 'One Touch Fire E', 'Firefox OS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONETOUCH_Flash_Plus.xml'                                    => [ 'Alcatel', 'One Touch Flash Plus', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/7048A.xml'                                                          => [ 'Alcatel', 'One Touch Go Play', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/7048X.xml'                                                          => [ 'Alcatel', 'One Touch Go Play', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_8020A.xml'                                                => [ 'Alcatel', 'One Touch Hero', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_8020E.xml'                                                => [ 'Alcatel', 'One Touch Hero', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/7055A.xml'                                                          => [ 'Alcatel', 'One Touch Hero 2C', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6030A.xml'                                        => [ 'Alcatel', 'One Touch Idol', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6030D.xml'                                        => [ 'Alcatel', 'One Touch Idol', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6030N.xml'                                        => [ 'Alcatel', 'One Touch Idol', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6030X.xml'                                        => [ 'Alcatel', 'One Touch Idol', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6030X_Orange.xml'                                 => [ 'Alcatel', 'One Touch Idol', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6037Y.xml'                                                          => [ 'Alcatel', 'One Touch Idol 2', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6037B.xml'                                                          => [ 'Alcatel', 'One Touch Idol 2 Dual', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6037K.xml'                                                          => [ 'Alcatel', 'One Touch Idol 2 Dual', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6016A.xml'                                                          => [ 'Alcatel', 'One Touch Idol 2 Mini', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6016D.xml'                                                          => [ 'Alcatel', 'One Touch Idol 2 Mini', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6016X.xml'                                                          => [ 'Alcatel', 'One Touch Idol 2 Mini', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6036A.xml'                                                          => [ 'Alcatel', 'One Touch Idol 2 Mini S', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6036X.xml'                                                          => [ 'Alcatel', 'One Touch Idol 2 Mini S', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6036Y.xml'                                                          => [ 'Alcatel', 'One Touch Idol 2 Mini S', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6036Y_KK.xml'                                                       => [ 'Alcatel', 'One Touch Idol 2 Mini S', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONETOUCH_6036X.xml'                                         => [ 'Alcatel', 'One Touch Idol 2 Mini S', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6036X.xml'                                        => [ 'Alcatel', 'One Touch Idol 2 Mini S', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6050A.xml'                                                          => [ 'Alcatel', 'One Touch Idol 2S', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6050F.xml'                                                          => [ 'Alcatel', 'One Touch Idol 2S', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6050Y.xml'                                                          => [ 'Alcatel', 'One Touch Idol 2S', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6039A.xml'                                                          => [ 'Alcatel', 'One Touch Idol 3 (4.7)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6039H.xml'                                                          => [ 'Alcatel', 'One Touch Idol 3 (4.7)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6039J.xml'                                                          => [ 'Alcatel', 'One Touch Idol 3 (4.7)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6039K.xml'                                                          => [ 'Alcatel', 'One Touch Idol 3 (4.7)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6039S.xml'                                                          => [ 'Alcatel', 'One Touch Idol 3 (4.7)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6039Y.xml'                                                          => [ 'Alcatel', 'One Touch Idol 3 (4.7)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH6039K.xml'                                         => [ 'Alcatel', 'One Touch Idol 3 (4.7)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH6039S.xml'                                         => [ 'Alcatel', 'One Touch Idol 3 (4.7)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6045F.xml'                                                          => [ 'Alcatel', 'One Touch Idol 3 (5.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH6045B.xml'                                         => [ 'Alcatel', 'One Touch Idol 3 (5.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH6045I.xml'                                         => [ 'Alcatel', 'One Touch Idol 3 (5.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH6045I_M.xml'                                       => [ 'Alcatel', 'One Touch Idol 3 (5.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH6045K.xml'                                         => [ 'Alcatel', 'One Touch Idol 3 (5.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH6045K_M.xml'                                       => [ 'Alcatel', 'One Touch Idol 3 (5.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH6045O.xml'                                         => [ 'Alcatel', 'One Touch Idol 3 (5.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH6045Y.xml'                                         => [ 'Alcatel', 'One Touch Idol 3 (5.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH6045Y_M.xml'                                       => [ 'Alcatel', 'One Touch Idol 3 (5.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6055B.xml'                                                          => [ 'Alcatel', 'One Touch Idol 4', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6055I.xml'                                                          => [ 'Alcatel', 'One Touch Idol 4', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6055K.xml'                                                          => [ 'Alcatel', 'One Touch Idol 4', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6055P.xml'                                                          => [ 'Alcatel', 'One Touch Idol 4', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6055U.xml'                                                          => [ 'Alcatel', 'One Touch Idol 4', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6012D.xml'                                        => [ 'Alcatel', 'One Touch Idol Mini', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6014X.xml'                                        => [ 'Alcatel', 'One Touch Idol Mini', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_6012A.xml'                                                => [ 'Alcatel', 'One Touch Idol Mini', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_6012D.xml'                                                => [ 'Alcatel', 'One Touch Idol Mini', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_6012E.xml'                                                => [ 'Alcatel', 'One Touch Idol Mini', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_6012X.xml'                                                => [ 'Alcatel', 'One Touch Idol Mini', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6034M.xml'                                        => [ 'Alcatel', 'One Touch Idol S', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6034R.xml'                                        => [ 'Alcatel', 'One Touch Idol S', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6034Y.xml'                                        => [ 'Alcatel', 'One Touch Idol S', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6035R.xml'                                        => [ 'Alcatel', 'One Touch Idol S', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6031X.xml'                                                          => [ 'Alcatel', 'One Touch Idol Ultra', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6033A.xml'                                        => [ 'Alcatel', 'One Touch Idol Ultra', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6033X.xml'                                        => [ 'Alcatel', 'One Touch Idol Ultra', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6040A.xml'                                        => [ 'Alcatel', 'One Touch Idol X', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6040D.xml'                                        => [ 'Alcatel', 'One Touch Idol X', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6040X.xml'                                        => [ 'Alcatel', 'One Touch Idol X', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6043D.xml'                                                          => [ 'Alcatel', 'One Touch Idol X+', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6032.xml'                                         => [ 'Alcatel', 'One Touch Idol α', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6032A.xml'                                        => [ 'Alcatel', 'One Touch Idol α', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5020A.xml'                                        => [ 'Alcatel', 'One Touch M\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5020D.xml'                                        => [ 'Alcatel', 'One Touch M\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5020E.xml'                                        => [ 'Alcatel', 'One Touch M\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5020N.xml'                                        => [ 'Alcatel', 'One Touch M\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5020T.xml'                                        => [ 'Alcatel', 'One Touch M\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5020W.xml'                                        => [ 'Alcatel', 'One Touch M\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5020X.xml'                                        => [ 'Alcatel', 'One Touch M\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/9005X.xml'                                                          => [ 'Alcatel', 'One Touch One Touch Pixi 3 (8)', 'Android', DeviceType::TABLET ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_4007A.xml'                                                => [ 'Alcatel', 'One Touch Pixi', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_4007D.xml'                                                => [ 'Alcatel', 'One Touch Pixi', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_4007X.xml'                                                => [ 'Alcatel', 'One Touch Pixi', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATELOneTouch4022D.xml'                                           => [ 'Alcatel', 'One Touch Pixi 3 (3.5)', 'Firefox OS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATELOneTouch4023A.xml'                                           => [ 'Alcatel', 'One Touch Pixi 3 (3.5)', 'Firefox OS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATELOneTouch4023X.xml'                                           => [ 'Alcatel', 'One Touch Pixi 3 (3.5)', 'Firefox OS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_4014D.xml'                                                => [ 'Alcatel', 'One Touch Pixi 3 (4)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5065A.xml'                                                          => [ 'Alcatel', 'One Touch Pixi 3 (5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5065D.xml'                                                          => [ 'Alcatel', 'One Touch Pixi 3 (5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5065X.xml'                                                          => [ 'Alcatel', 'One Touch Pixi 3 (5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5054D.xml'                                                          => [ 'Alcatel', 'One Touch Pixi 3 (5.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5054O.xml'                                                          => [ 'Alcatel', 'One Touch Pixi 3 (5.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5054S.xml'                                                          => [ 'Alcatel', 'One Touch Pixi 3 (5.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5054T.xml'                                                          => [ 'Alcatel', 'One Touch Pixi 3 (5.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5054X.xml'                                                          => [ 'Alcatel', 'One Touch Pixi 3 (5.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/9007A.xml'                                                          => [ 'Alcatel', 'One Touch Pixi 3 (7)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/9022X.xml'                                                          => [ 'Alcatel', 'One Touch Pixi 3 (8)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Alcatel_9022S.xml'                                                  => [ 'Alcatel', 'One Touch Pixi 3 (8)', 'Android', DeviceType::TABLET ],
    'http://www-ccpp.tcl-ta.com/files/Alcatel_4060O.xml'                                                  => [ 'Alcatel', 'One Touch Pixi 4 (6)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/alcatel_5098O.xml'                                                  => [ 'Alcatel', 'One Touch Pixi 4 (6)', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/alcatel/wsa571vl/wsa571vl.xml'                                               => [ 'Alcatel', 'One Touch Pixi Avion', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/A570BL.xml'                                                         => [ 'Alcatel', 'One Touch Pixi Avion', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/alcatel/oda573vc/oda573vc.xml'                                               => [ 'Alcatel', 'One Touch Pixi Bond', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONETOUCH_4024D.xml'                                         => [ 'Alcatel', 'One Touch Pixi First', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONETOUCH_4024X.xml'                                         => [ 'Alcatel', 'One Touch Pixi First', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/4045A.xml'                                                          => [ 'Alcatel', 'One Touch Pop 2 (4)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/4045D.xml'                                                          => [ 'Alcatel', 'One Touch Pop 2 (4)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/4045L.xml'                                                          => [ 'Alcatel', 'One Touch Pop 2 (4)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5042A.xml'                                                          => [ 'Alcatel', 'One Touch Pop 2 (4.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5042D.xml'                                                          => [ 'Alcatel', 'One Touch Pop 2 (4.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5042W.xml'                                                          => [ 'Alcatel', 'One Touch Pop 2 (4.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5042X.xml'                                                          => [ 'Alcatel', 'One Touch Pop 2 (4.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5042Y.xml'                                                          => [ 'Alcatel', 'One Touch Pop 2 (4.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONETOUCH_5042G.xml'                                         => [ 'Alcatel', 'One Touch Pop 2 (4.5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/7043K.xml'                                                          => [ 'Alcatel', 'One Touch Pop 2 (5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/7043Y.xml'                                                          => [ 'Alcatel', 'One Touch Pop 2 (5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/7044A.xml'                                                          => [ 'Alcatel', 'One Touch Pop 2 (5) Premium', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/7044X.xml'                                                          => [ 'Alcatel', 'One Touch Pop 2 (5) Premium', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/7051X.xml'                                                          => [ 'Alcatel', 'One Touch Pop 3 (5)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5051J.xml'                                                          => [ 'Alcatel', 'One Touch Pop 4 (5.0)', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/4016A.xml'                                                          => [ 'Alcatel', 'One Touch Pop C1', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/4016X.xml'                                                          => [ 'Alcatel', 'One Touch Pop C1', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_4015T.xml'                                                  => [ 'Alcatel', 'One Touch Pop C1', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_4015A.xml'                                                => [ 'Alcatel', 'One Touch Pop C1', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_4015D.xml'                                                => [ 'Alcatel', 'One Touch Pop C1', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_4015N.xml'                                                => [ 'Alcatel', 'One Touch Pop C1', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_4015T.xml'                                                => [ 'Alcatel', 'One Touch Pop C1', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_4015X.xml'                                                => [ 'Alcatel', 'One Touch Pop C1', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/one_touch_4016X.xml'                                                => [ 'Alcatel', 'One Touch Pop C1', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/4032A.xml'                                                          => [ 'Alcatel', 'One Touch Pop C2', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/4032D.xml'                                                          => [ 'Alcatel', 'One Touch Pop C2', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/4032X.xml'                                                          => [ 'Alcatel', 'One Touch Pop C2', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_4033A.xml'                                                => [ 'Alcatel', 'One Touch Pop C3', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_4033D.xml'                                                => [ 'Alcatel', 'One Touch Pop C3', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_4033E.xml'                                                => [ 'Alcatel', 'One Touch Pop C3', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_4033X.xml'                                                => [ 'Alcatel', 'One Touch Pop C3', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5036A.xml'                                        => [ 'Alcatel', 'One Touch Pop C5', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5036D.xml'                                        => [ 'Alcatel', 'One Touch Pop C5', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5036X.xml'                                        => [ 'Alcatel', 'One Touch Pop C5', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5037A.xml'                                        => [ 'Alcatel', 'One Touch Pop C5', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5037E.xml'                                        => [ 'Alcatel', 'One Touch Pop C5', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5037X.xml'                                        => [ 'Alcatel', 'One Touch Pop C5', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7040A.xml'                                        => [ 'Alcatel', 'One Touch Pop C7', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7040D.xml'                                        => [ 'Alcatel', 'One Touch Pop C7', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7040E.xml'                                        => [ 'Alcatel', 'One Touch Pop C7', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7041D.xml'                                        => [ 'Alcatel', 'One Touch Pop C7', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7041X.xml'                                        => [ 'Alcatel', 'One Touch Pop C7', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7047A.xml'                                        => [ 'Alcatel', 'One Touch Pop C9', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7047D.xml'                                        => [ 'Alcatel', 'One Touch Pop C9', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7047E.xml'                                        => [ 'Alcatel', 'One Touch Pop C9', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_A995L.xml'                                                  => [ 'Alcatel', 'One Touch Pop Mega', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5050A.xml'                                                          => [ 'Alcatel', 'One Touch Pop S3', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5050X.xml'                                                          => [ 'Alcatel', 'One Touch Pop S3', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5050Y.xml'                                                          => [ 'Alcatel', 'One Touch Pop S3', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/7050Y.xml'                                                          => [ 'Alcatel', 'One Touch Pop S9', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7050Y.xml'                                        => [ 'Alcatel', 'One Touch Pop S9', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_A845L.xml'                                                  => [ 'Alcatel', 'One Touch Pop Star', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/6044D.xml'                                                          => [ 'Alcatel', 'One Touch Pop Up', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/P360X.xml'                                                          => [ 'Alcatel', 'One Touch POP10', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/9015B.xml'                                                          => [ 'Alcatel', 'One Touch POP7', 'Android', DeviceType::TABLET ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_P310A.xml'                                        => [ 'Alcatel', 'One Touch POP7', 'Android', DeviceType::TABLET ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_P310X.xml'                                        => [ 'Alcatel', 'One Touch POP7', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_P310X_KK.xml'                                     => [ 'Alcatel', 'One Touch POP7', 'Android', DeviceType::TABLET ],
    'http://www-ccpp.tcl-ta.com/files/P330X.xml'                                                          => [ 'Alcatel', 'One Touch POP7S', 'Android', DeviceType::TABLET ],
    'http://www-ccpp.tcl-ta.com/files/P330X_orange.xml'                                                   => [ 'Alcatel', 'One Touch POP7S', 'Android', DeviceType::TABLET ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_P320A_TELUS.xml'                                  => [ 'Alcatel', 'One Touch POP8', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_P320X.xml'                                        => [ 'Alcatel', 'One Touch POP8', 'Android', DeviceType::TABLET ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_P321X.xml'                                        => [ 'Alcatel', 'One Touch POP8', 'Android', DeviceType::TABLET ],
    'www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_P320A.xml'                                               => [ 'Alcatel', 'One Touch POP8', 'Android', DeviceType::TABLET ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_4030A.xml'                                        => [ 'Alcatel', 'One Touch S\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_4030D.xml'                                        => [ 'Alcatel', 'One Touch S\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_4030E.xml'                                        => [ 'Alcatel', 'One Touch S\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_4030X.xml'                                        => [ 'Alcatel', 'One Touch S\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_4030Y.xml'                                        => [ 'Alcatel', 'One Touch S\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT-S218.rdf'                                                => [ 'Alcatel', 'One Touch S218', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT-S319.rdf'                                                => [ 'Alcatel', 'One Touch S319', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT-S520.rdf'                                                => [ 'Alcatel', 'One Touch S520', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_8000A.xml'                                        => [ 'Alcatel', 'One Touch Scribe Easy', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_8000D.xml'                                        => [ 'Alcatel', 'One Touch Scribe Easy', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_8008D.xml'                                        => [ 'Alcatel', 'One Touch Scribe HD', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_8008W.xml'                                        => [ 'Alcatel', 'One Touch Scribe HD', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_8008X.xml'                                        => [ 'Alcatel', 'One Touch Scribe HD', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_8020D.xml'                                        => [ 'Alcatel', 'One Touch Scribe Pro', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_8020D.xml'                                                => [ 'Alcatel', 'One Touch Scribe Pro', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_8020X.xml'                                                => [ 'Alcatel', 'One Touch Scribe Pro', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_7030L.xml'                                                  => [ 'Alcatel', 'One Touch Snap', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7025D.xml'                                        => [ 'Alcatel', 'One Touch Snap', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7025X.xml'                                        => [ 'Alcatel', 'One Touch Snap', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7042A.xml'                                        => [ 'Alcatel', 'One Touch Snap', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_7042D.xml'                                        => [ 'Alcatel', 'One Touch Snap', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5021E.xml'                                        => [ 'Alcatel', 'One Touch Soleil', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_A851L.xml'                                                  => [ 'Alcatel', 'One Touch Sonic', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL ONE TOUCH 6010D.xml'                                        => [ 'Alcatel', 'One Touch Star', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6010D.xml'                                        => [ 'Alcatel', 'One Touch Star', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6010X.xml'                                        => [ 'Alcatel', 'One Touch Star', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_6010X_Orange.xml'                                 => [ 'Alcatel', 'One Touch Star', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_4010A.xml'                                        => [ 'Alcatel', 'One Touch T\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_4010D.xml'                                        => [ 'Alcatel', 'One Touch T\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_4010E.xml'                                        => [ 'Alcatel', 'One Touch T\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_4010X.xml'                                        => [ 'Alcatel', 'One Touch T\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_4011X.xml'                                        => [ 'Alcatel', 'One Touch T\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ONE_TOUCH_TAB_7.xml'                                                => [ 'Alcatel', 'One Touch Tab 7', 'Android', DeviceType::TABLET ],
    'http://www-ccpp.tcl-ta.com/files/3075A.rdf'                                                          => [ 'Alcatel', 'One Touch Tribe 3075A', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL-OT-V670.rdf'                                                => [ 'Alcatel', 'One Touch V670', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5035D.xml'                                        => [ 'Alcatel', 'One Touch X\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5035E.xml'                                        => [ 'Alcatel', 'One Touch X\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_ONE_TOUCH_5035X.xml'                                        => [ 'Alcatel', 'One Touch X\'Pop', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/4044C.xml'                                                          => [ 'Alcatel', 'QUICKFLIP', 'KaiOS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/ALCATEL_TRIBE_3075A.rdf'                                            => [ 'Alcatel', 'Tribe 3075A', null, DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/PCD/ADR2045-VMUB/1.0/UAProf.xml'                                             => [ 'Alcatel', 'Venture', 'Android', DeviceType::MOBILE ],
    'http://pluto.alphacell.com/uaprof/m5p.xml'                                                           => [ 'AlphaCell', 'M5', null, DeviceType::MOBILE ],
    'http://www.amobile.com.cn/ua/Amoi-8512.xml'                                                          => [ 'Amoi', '8512', null, DeviceType::MOBILE ],
    'http://www.amobile.com.cn/ua/Amoi-8709.xml'                                                          => [ 'Amoi', '8709', null, DeviceType::MOBILE ],
    'http://www.amobile.com.cn/ua/Amoi-8710.xml'                                                          => [ 'Amoi', '8710', null, DeviceType::MOBILE ],
    'http://www.amoi.com.cn/ua/AMOI_A726T_JB3_UAprofile.xml'                                              => [ 'Amoi', 'A726T', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOAMOI A920W.xml'                                             => [ 'Amoi', 'A920W', 'Android', DeviceType::MOBILE ],
    'http://www.amobile.com.cn/ua/c200.xml'                                                               => [ 'Amoi', 'C200', null, DeviceType::MOBILE ],
    'http://www.amobile.com.cn/ua/CA6.xml'                                                                => [ 'Amoi', 'CA6', null, DeviceType::MOBILE ],
    'http://www.amobile.com.cn/ua/E610.xml'                                                               => [ 'Amoi', 'E610', null, DeviceType::MOBILE ],
    'http://www.amobile.com.cn/ua/E72.xml'                                                                => [ 'Amoi', 'E72', null, DeviceType::MOBILE ],
    'http://www.amobile.com.cn/ua/F8.xml'                                                                 => [ 'Amoi', 'F8', null, DeviceType::MOBILE ],
    'http://www.amobile.com.cn/ua/M636.xml'                                                               => [ 'Amoi', 'M636', null, DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOAMOI_N828.xml'                                              => [ 'Amoi', 'N828', 'Android', DeviceType::MOBILE ],
    'http://www.amobile.com.cn/ua/S6.xml'                                                                 => [ 'Amoi', 'S6', null, DeviceType::MOBILE ],
    'https://servicios.iusacell.com.mx/amoi/v810/v810v1.xml'                                              => [ 'Amoi', 'V810', null, DeviceType::MOBILE ],
    'http://www.apanda.com.cn/apanda-A60-ua-profile.xml'                                                  => [ 'Apanda', 'A60', 'Android', DeviceType::MOBILE ],
    'http://asmobile.ehosting.com.tw/uaprof/castor.xml'                                                   => [ 'Asmobile', 'Castor', null, DeviceType::MOBILE ],
    'http://asmobile.ehosting.com.tw/uaprof/PAVO.xml'                                                     => [ 'Asmobile', 'PAVO', null, DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS1210-1.0.xml'                                                   => [ 'Asus', '1210', null, DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-NAPA-1.0.xml'                                                  => [ 'Asus', 'Eee Pc T10', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-NAPA-MINI-1.0.xml'                                             => [ 'Asus', 'Eee Pc T20', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ASUS-K00S.xml'                                                 => [ 'Asus', 'Fonepad', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-ME371MG-1.0.xml'                                               => [ 'Asus', 'Fonepad', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-K00E.xml'                                                      => [ 'Asus', 'Fonepad 7', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-K00Z.xml'                                                      => [ 'Asus', 'Fonepad 7', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-ME175CG.xml'                                                   => [ 'Asus', 'Fonepad 7', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-ME175CG_KK.xml'                                                => [ 'Asus', 'Fonepad 7', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-ME372CG.xml'                                                   => [ 'Asus', 'Fonepad 7', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-ME372CL.xml'                                                   => [ 'Asus', 'Fonepad 7', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-FE170CG.xml'                                                   => [ 'Asus', 'Fonepad 7 2014', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-FE171CG.xml'                                                   => [ 'Asus', 'Fonepad 7 2015', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-FE375CL.xml'                                                   => [ 'Asus', 'Fonepad 7 2015', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-FE380CG.xml'                                                   => [ 'Asus', 'Fonepad 8 2014', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-K00G.xml'                                                      => [ 'Asus', 'Fonepad Note 6', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/K00G.xml'                                                           => [ 'Asus', 'Fonepad Note 6', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-J501_UAProf.xml'                                               => [ 'Asus', 'J501', null, DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-M530w-1.0.xml'                                                 => [ 'Asus', 'M530w', 'Windows Mobile', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-M930-1.0.xml'                                                  => [ 'Asus', 'M930', 'Windows Mobile', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-K00F.xml'                                                      => [ 'Asus', 'MemoPad 10', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-ME375CL.xml'                                                   => [ 'Asus', 'MemoPad 7', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ME572CL.xml'                                                   => [ 'Asus', 'MemoPad 7', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-K00L.xml'                                                      => [ 'Asus', 'MemoPad 8', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-ME302C-1.0.xml'                                                => [ 'Asus', 'MemoPad FHD 10', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-grouper.xml'                                                   => [ 'Asus', 'Nexus 7', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/grouper.xml'                                                        => [ 'Asus', 'Nexus 7', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-GalaxyMini-1.0.xml'                                            => [ 'Asus', 'P320', 'Windows Mobile', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-Pegasus-1.0.xml'                                               => [ 'Asus', 'P526', 'Windows Mobile', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-P527-1.0.xml'                                                  => [ 'Asus', 'P527', 'Windows Mobile', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-GalaxyII-1.0.xml'                                              => [ 'Asus', 'P535', 'Windows Mobile', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-P550-1.0.xml'                                                  => [ 'Asus', 'P550', 'Windows Mobile', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-GalaxyMini2-1.0.xml'                                           => [ 'Asus', 'P552', 'Windows Mobile', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-P750-1.0.xml'                                                  => [ 'Asus', 'P750', 'Windows Mobile', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-PadFone-1.0.xml'                                               => [ 'Asus', 'Padfone', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-PadFone.xml'                                                   => [ 'Asus', 'Padfone', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-A68.xml'                                                       => [ 'Asus', 'Padfone 2', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-PadFone 2.xml'                                                 => [ 'Asus', 'Padfone 2', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-ASUS-T008.xml'                                                 => [ 'Asus', 'Padfone E', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-A80.xml'                                                       => [ 'Asus', 'Padfone Infinity', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-A86.xml'                                                       => [ 'Asus', 'Padfone Infinity', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ASUS-A86.xml'                                                  => [ 'Asus', 'Padfone Infinity', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-ASUS-T00C.xml'                                                 => [ 'Asus', 'Padfone Mini', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ASUS_T00E.xml'                                                 => [ 'Asus', 'Padfone Mini', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-PF451CL.xml'                                                   => [ 'Asus', 'Padfone Mini', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-A91.xml'                                                       => [ 'Asus', 'Padfone X', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-PF500KL.xml'                                                   => [ 'Asus', 'Padfone X', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS_T00N.xml'                                                      => [ 'Asus', 'Padfone X', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-PF450CL.xml'                                                   => [ 'Asus', 'Padfone X Mini', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-TX201LA.xml'                                                   => [ 'Asus', 'Transformer Book Trio', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-TF300TG.xml'                                                   => [ 'Asus', 'Transformer Pad 300', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-TF300TL.xml'                                                   => [ 'Asus', 'Transformer Pad 300', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-K00C.xml'                                                      => [ 'Asus', 'Transformer Pad Infinity', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-TF700KL-1.0.xml'                                               => [ 'Asus', 'Transformer Pad Infinity 700', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-TF700KL.xml'                                                   => [ 'Asus', 'Transformer Pad Infinity 700', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-V75_UAProf.xml'                                                => [ 'Asus', 'V75', null, DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ZE500CL.xml'                                                   => [ 'Asus', 'ZenFone 2', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ZE550ML.xml'                                                   => [ 'Asus', 'ZenFone 2', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ZE551ML.xml'                                                   => [ 'Asus', 'ZenFone 2', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ZE500KG.xml'                                                   => [ 'Asus', 'ZenFone 2 Laser', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ZE500KL.xml'                                                   => [ 'Asus', 'ZenFone 2 Laser', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ZE550KL.xml'                                                   => [ 'Asus', 'ZenFone 2 Laser', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ASUS_T00I.xml'                                                 => [ 'Asus', 'ZenFone 4', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/AMAX-UAP.xml'                                                       => [ 'Asus', 'ZenFone 5', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-A500CG.xml'                                                    => [ 'Asus', 'ZenFone 5', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-A500KL.xml'                                                    => [ 'Asus', 'ZenFone 5', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ASUS_T00F.xml'                                                 => [ 'Asus', 'ZenFone 5', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ASUS_T00J.xml'                                                 => [ 'Asus', 'ZenFone 5', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-T00J.xml'                                                      => [ 'Asus', 'ZenFone 5', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-A600CG.xml'                                                    => [ 'Asus', 'ZenFone 6', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ASUS_T00G.xml'                                                 => [ 'Asus', 'ZenFone 6', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ZB551KL.xml'                                                   => [ 'Asus', 'ZenFone Go (ZB551KL)', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ZC500TG.xml'                                                   => [ 'Asus', 'ZenFone Go (ZC500TG)', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ZC550KL.xml'                                                   => [ 'Asus', 'ZenFone Max', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-ZX551ML.xml'                                                   => [ 'Asus', 'ZenFone Zoom', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/ASUS-Z300CL.xml'                                                    => [ 'Asus', 'ZenPad 10', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-Z170C.xml'                                                     => [ 'Asus', 'ZenPad 7', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-Z370KL.xml'                                                    => [ 'Asus', 'ZenPad 7.0 (Z370KL)', 'Android', DeviceType::TABLET ],
    'http://uaprofile.asus.com/uaprof/ASUS-Z380KL.xml'                                                    => [ 'Asus', 'ZenPad 8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8652GPRS-ATT.xml'                                               => [ 'AT&T', 'Fusion', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8652WCDMA-ATT.xml'                                              => [ 'AT&T', 'Fusion', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/9020A.xml'                                                          => [ 'AT&T', 'Trek HD', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Y536A1.xml'                                                  => [ 'AT&T', 'Tribute', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Audiovox/CDM-8450SP/T060SP2T36.rdf'                                      => [ 'Audiovox', 'CDM-8450', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Audiovox/CDM-8450SP/T060SP2T37.rdf'                                      => [ 'Audiovox', 'CDM-8450', null, DeviceType::MOBILE ],
    'http://uaprof.bellmobilite.ca/BMC_Audiovox_CDM-8450_P08.rdf'                                         => [ 'Audiovox', 'CDM-8450', null, DeviceType::MOBILE ],
    'http://www.pocket.com/phone_data/CDM8615.xml'                                                        => [ 'Audiovox', 'CDM-8615', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/audiovox/cdm-8900.rdf'                                               => [ 'Audiovox', 'CDM-8900', null, DeviceType::MOBILE ],
    'http://www.alltel.net/uaprof/audiovox/8910/8910.xml'                                                 => [ 'Audiovox', 'CDM-8910', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Audiovox/CDM8912SP/T115SP0T13.rdf'                                       => [ 'Audiovox', 'CDM-8912', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/audiovox/cdm-8920.rdf'                                               => [ 'Audiovox', 'CDM-8920', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Audiovox/CDM9950SP/132037.rdf'                                           => [ 'Audiovox', 'CDM-9950', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Audiovox/PM8920KIT/T120SP0T19.rdf'                                       => [ 'Audiovox', 'PM-8920', null, DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/ZTE_Blade_Q_Maxi.xml'                                            => [ 'Avea', 'inTouch 3 Large', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Avea_inTouch_4.xml'                                              => [ 'Avea', 'inTouch 4', 'Android', DeviceType::TABLET ],
    'http://www.jeekomi.com/hw/Avvio489_WAP_BROWSER.xml'                                                  => [ 'Avvio', '489', 'Android', DeviceType::MOBILE ],
    'http://guardsys.museui.com/Avvio750_PEP_WAP_BROWSER.xml'                                             => [ 'Avvio', '750', 'Android', DeviceType::MOBILE ],
    'http://guardsys.museui.com/Avvio750_WAP_BROWSER.xml'                                                 => [ 'Avvio', '750', 'Android', DeviceType::MOBILE ],
    'http://www.ilakia.com/uaprof/Avvio774.xml'                                                           => [ 'Avvio', '774', 'Android', DeviceType::MOBILE ],
    'http://www.kcmobile.net/UAProf/UAP_AVVIO_776.xml'                                                    => [ 'Avvio', '776', 'Android', DeviceType::MOBILE ],
    'http://config.51coolpad.com/UAProfile/Brightstar/Avvio_L500.xml'                                     => [ 'Avvio', 'L500', 'Android', DeviceType::MOBILE ],
    'http://www.kcmobile.net/UAProf/WAP2_SEC_MMS_AvvioPAD10.1.xml'                                        => [ 'Avvio', 'Pad', 'Android', DeviceType::MOBILE ],
    'http://www.jeekomi.com/hw/AvvioQ797_WAP_BROWSER.xml'                                                 => [ 'Avvio', 'Q797', 'Android', DeviceType::MOBILE ],
    'http://www.axiooworld.com'                                                                           => [ 'Axioo', 'Picopad', 'Android', DeviceType::TABLET ],
    'http://www.axiooworld.com/uaprof/uaprof_picopad.xml'                                                 => [ 'Axioo', 'Picopad', 'Android', DeviceType::TABLET ],
    'http://www.axiooworld.com/uaprof/uaprof_VIGO350.xml'                                                 => [ 'Axioo', 'Vigo 350', 'Android', DeviceType::MOBILE ],
    'http://www.axiooworld.com/uaprof/uaprof_VIGO410.xml'                                                 => [ 'Axioo', 'Vigo 410', 'Android', DeviceType::MOBILE ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_A35C_Lite.xml'                               => [ 'Azumi', 'A35c Lite', 'Android', DeviceType::MOBILE ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_A35S.xml'                                    => [ 'Azumi', 'A35s', 'Android', DeviceType::MOBILE ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_A35S_Lite.xml'                               => [ 'Azumi', 'A35s Lite', 'Android', DeviceType::MOBILE ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_A40Style_Lite.xml'                           => [ 'Azumi', 'A40 Style Lite', 'Android', DeviceType::MOBILE ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_A40C.xml'                                    => [ 'Azumi', 'A40c', 'Android', DeviceType::MOBILE ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_A45T.xml'                                    => [ 'Azumi', 'A45c', 'Android', DeviceType::MOBILE ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_A45S.xml'                                    => [ 'Azumi', 'A45s', 'Android', DeviceType::MOBILE ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_A50c.xml'                                    => [ 'Azumi', 'A50c', 'Android', DeviceType::MOBILE ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_A50c+.xml'                                   => [ 'Azumi', 'A50c+', 'Android', DeviceType::MOBILE ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_AT7.xml'                                     => [ 'Azumi', 'AT7', 'Android', DeviceType::TABLET ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_IRO_A5_Q.xml'                                => [ 'Azumi', 'Iro A5Q', 'Android', DeviceType::MOBILE ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_IRO_A5_QL.xml'                               => [ 'Azumi', 'Iro A5QL', 'Android', DeviceType::MOBILE ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_KL32.xml'                                    => [ 'Azumi', 'KL32', 'Android', DeviceType::MOBILE ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_LT50.xml'                                    => [ 'Azumi', 'LT50', 'Android', DeviceType::MOBILE ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_LT50+.xml'                                   => [ 'Azumi', 'LT50+', 'Android', DeviceType::MOBILE ],
    'http://343761.ctc-w228.dns.com.cn/UAProfile/EVE.xml'                                                 => [ 'b-mobile', 'EVE', null, DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/BASE_Tab.xml'                                                    => [ 'BASE', 'Tab', 'Android', DeviceType::MOBILE ],
    'http://www.bbk.com/uaprof/BBKi710.xml'                                                               => [ 'BBK', 'i710', 'MRE', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Beeline_E400.xml'                                                => [ 'Beeline', 'E400', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Beeline_E600.xml'                                                => [ 'Beeline', 'E600', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/BeelineM2_22.xml'                                                => [ 'Beeline', 'M2', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Beeline_Pro.xml'                                                 => [ 'Beeline', 'Pro', 'Android', DeviceType::MOBILE ],
    'http://staticfiles.technoserv.com/uap/BG1_TS.xml'                                                    => [ 'Beeline', 'Pro 2', 'Android', DeviceType::MOBILE ],
    'http://staticfiles.technoserv.com/uap/BeelineSmartDual.xml'                                          => [ 'Beeline', 'Smart Dual', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Beeline_Smart2.xml'                                              => [ 'Beeline', 'Smart2', 'Android', DeviceType::MOBILE ],
    'http://staticfiles.technoserv.com/uap/Beeline_Smart_3.xml'                                           => [ 'Beeline', 'Smart3', 'Android', DeviceType::MOBILE ],
    'http://tehnoligadevice.ru/uap/Beeline_Smart_4.xml'                                                   => [ 'Beeline', 'Smart4', 'Android', DeviceType::MOBILE ],
    'http://staticfiles.technoserv.com/uap/BEE703G02.xml'                                                 => [ 'Beeline', 'Tab', 'Android', DeviceType::TABLET ],
    'http://senseit.ru/UAProfile/beelinetab2.xml'                                                         => [ 'Beeline', 'Tab 2', 'Android', DeviceType::TABLET ],
    'http://www.bellwave.co.uk/uaprof/Neo100.xml'                                                         => [ 'Bellwave', 'Neo100', null, DeviceType::MOBILE ],
    'https://s3-eu-west-1.amazonaws.com/fotabucket/uaprof/uaprof_f4_benq.xml'                             => [ 'BenQ', 'A3s', 'Android', DeviceType::MOBILE ],
    'http://communication-market.siemens.de/portal/UAProf/UAP.aspx?device=C11C&v=11'                      => [ 'BenQ', 'C11C', null, DeviceType::MOBILE ],
    'http://uap.benq.com/mb_c30/benq_c30_v1.xml'                                                          => [ 'BenQ', 'C30', null, DeviceType::MOBILE ],
    'http://communication-market.siemens.de/portal/UAProf/UAP.aspx?DeviceID=ELC1&v=36'                    => [ 'BenQ', 'ELC1', null, DeviceType::MOBILE ],
    'http://market.benqmobile.com/portal/UAProf/UAP.aspx?DeviceID=ELC1&v=36'                              => [ 'BenQ', 'ELC1', null, DeviceType::MOBILE ],
    'http://dpg.openwave.com/downloadfun/29756742/Vulcan.xml'                                             => [ 'BenQ', 'Vulcan', null, DeviceType::MOBILE ],
    'http://communication-market.siemens.de/portal/UAProf/UAP.aspx?DeviceID=EF81'                         => [ 'BenQ-Siemens', 'EF81', null, DeviceType::MOBILE ],
    'http://uap.benq.com/mb_ef91/benq_ef91_3g.xml'                                                        => [ 'BenQ-Siemens', 'EF91', null, DeviceType::MOBILE ],
    'http://communication-market.siemens.de/portal/UAProf/UAP.aspx?device=S68'                            => [ 'BenQ-Siemens', 'S68', null, DeviceType::MOBILE ],
    'http://uap.benq.com/mb_s81/benq_s81_v1.xml'                                                          => [ 'BenQ-Siemens', 'S81', null, DeviceType::MOBILE ],
    'http://uap.benq.com/mb_s82/benq_S82_voda_2g.xml'                                                     => [ 'BenQ-Siemens', 'S82', null, DeviceType::MOBILE ],
    'http://uap.benq.com/mb_s88/benq_s88_v3_300k.xml'                                                     => [ 'BenQ-Siemens', 'S88', null, DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/BGH_Joy_Smart_A7G.xml'                                           => [ 'BGH', 'Joy Smart A7G', 'Android', DeviceType::MOBILE ],
    'http://www.bbk.com/uaprof/BBKV205.xml'                                                               => [ 'BKK', 'V205', null, DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/ADVANCE_3.5.XML'                                              => [ 'BLU', 'Advance 3.5', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/ADVANCE4.0.xml'                                               => [ 'BLU', 'Advance 4.0', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/ADVANCE_4.0.XML'                                              => [ 'BLU', 'Advance 4.0', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/Advance 4.0 L.xml'                                            => [ 'BLU', 'Advance 4.0 L', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/ZTE_U_V856_V3.xml'                                               => [ 'BLU', 'Dash', 'Android', DeviceType::MOBILE ],
    'http://ctmexico.com.mx/UA_DASH.xml'                                                                  => [ 'BLU', 'Dash 3.5', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/DASH_3.5.XML'                                                 => [ 'BLU', 'Dash 3.5', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/DASH_3.5_II.xml'                                              => [ 'BLU', 'Dash 3.5 II', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/DASH_4.0.XML'                                                 => [ 'BLU', 'Dash 4.0', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/Dash4.0Ce.xml'                                                => [ 'BLU', 'Dash 4.0 CE', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/dash_4.5.XML'                                                 => [ 'BLU', 'Dash 4.5', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/DASH_5.0.XML'                                                 => [ 'BLU', 'Dash 5.0', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/DASH5.5.xml'                                                  => [ 'BLU', 'Dash 5.5', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/DASH_C_MUSIC_D390u.xml'                                       => [ 'BLU', 'Dash C Music', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/DASH_J_D070.xml'                                              => [ 'BLU', 'Dash J', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/BLU_D140_UAP.xml'                                             => [ 'BLU', 'Dash Jr', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/DASH_JR_3G_blu.xml'                                           => [ 'BLU', 'Dash Jr', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/dashjr.4.0.xml'                                               => [ 'BLU', 'Dash Jr 4.0', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/DASH_JR_K.XML'                                                => [ 'BLU', 'Dash Jr K', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/BLU-D140S_UAP.xml'                                            => [ 'BLU', 'Dash Jr Social', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/DASH_L_D050.xml'                                              => [ 'BLU', 'Dash L', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/DASH_MUSIC_4.0.XML'                                           => [ 'BLU', 'Dash Music 4.0', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/Dash music 4.5.xml'                                           => [ 'Blu', 'Dash Music 4.5', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/DASHMUSICII.xml'                                              => [ 'BLU', 'Dash Music II', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/DASH_MUSIC_JR.xml'                                            => [ 'BLU', 'Dash Music Jr', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/BLU_ENERGY_X_PLUS.xml'                                        => [ 'BLU', 'Energy X Plus', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/Studio_Energey_5.5.xml'                                       => [ 'BLU', 'Energy X Plus', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/LIFE8.xml'                                                    => [ 'BLU', 'Life 8', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/LifeOne.xml'                                                  => [ 'BLU', 'Life One', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/Life_One_M.xml'                                               => [ 'BLU', 'Life One M', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/LIFE ONE X.XML'                                               => [ 'BLU', 'Life One X', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/LIFE PLAY.XML'                                                => [ 'BLU', 'Life Play', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/LIFE_PLAY_MINI.xml'                                           => [ 'BLU', 'Life Play Mini', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/LIFE_PLAY_S.xml'                                              => [ 'BLU', 'Life Play S', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/LifeView.xml'                                                 => [ 'BLU', 'Life View', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/ADVANCE_JR.xml'                                               => [ 'Blu', 'Neo 3.5', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/Neo_3.5.xml'                                                  => [ 'BLU', 'Neo 3.5', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/STUDIO5.0.xml'                                                => [ 'BLU', 'Studio 5.0', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/STUDIO5.0_2.xml'                                              => [ 'BLU', 'Studio 5.0 II', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/Tank4.5.XML'                                                  => [ 'BLU', 'Studio 5.0c HD', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/LIFEPLAY.xml'                                                 => [ 'BLU', 'Studio 5.0ce', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/studio5.0e.xml'                                               => [ 'BLU', 'Studio 5.0e', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/STUDIO_5.0K.xml'                                              => [ 'BLU', 'Studio 5.0k', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/ STUDIO5.0SII.XML'                                            => [ 'BLU', 'Studio 5.0s II', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/STUDIO5.5S.xml'                                               => [ 'BLU', 'Studio 5.5s', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/Studio_7.0_II.xml'                                            => [ 'BLU', 'Studio 7.0 II', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/STUDIO_C.XML'                                                 => [ 'BLU', 'Studio C', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/STUDIO_G.xml'                                                 => [ 'BLU', 'Studio G', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/STUDIO_G_PLUS.xml'                                            => [ 'BLU', 'Studio G Plus', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/STUDIO5.0S_HD.xml'                                            => [ 'BLU', 'Studio X', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/STUDIO_X.xml'                                                 => [ 'BLU', 'Studio X', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/BLU_STUDIO_X_PLUS.xml'                                        => [ 'BLU', 'Studio X Plus', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/Studio_X_Plus.xml'                                            => [ 'BLU', 'Studio X Plus', 'Android', DeviceType::MOBILE ],
    'http://112.74.195.169/upload/xmlfiles/STUDIO_X8_HD.XML'                                              => [ 'BLU', 'Studio X8 HD', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/Touchbook_7.0_3G.xml'                                         => [ 'BLU', 'Touch Book 7.0', 'Android', DeviceType::TABLET ],
    'http://www.bmobile.eu.com/uaprofile/Bmobile_AX1020.xml'                                              => [ 'Bmobile', 'AX1020', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/Bmobile_AX1030.xml'                                              => [ 'Bmobile', 'AX1030', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/UAProfile_BmobileAX1035.xml'                                     => [ 'Bmobile', 'AX1035', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/Bmobile_AX1060.xml'                                              => [ 'Bmobile', 'AX1060', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/Bmobile_AX1065.xml'                                              => [ 'Bmobile', 'AX1065', 'Android', DeviceType::MOBILE ],
    'http://bmobile.eu.com/uaprofile/UAProfile_BmobileAX512.xml'                                          => [ 'Bmobile', 'AX512', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/UAProfile_BmobileAX512.xml'                                      => [ 'Bmobile', 'AX512', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/Bmobile_AX570.xml'                                               => [ 'Bmobile', 'AX570', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/Bmobile_AX600.xml'                                               => [ 'Bmobile', 'AX600', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/UAProfile_BmobileAX600.xml'                                      => [ 'Bmobile', 'AX600', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/BmobileAX605.xml'                                                => [ 'Bmobile', 'AX605', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/UAProfile_BmobileAX620.xml'                                      => [ 'Bmobile', 'AX620', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/Bmobile_AX670.xml'                                               => [ 'Bmobile', 'AX670', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/Bmobile_AX675.xml'                                               => [ 'Bmobile', 'AX675', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/Bmobile_AX680.xml'                                               => [ 'Bmobile', 'AX680', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/Bmobile_AX710.xml'                                               => [ 'Bmobile', 'AX710', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/BmobileAX745.xml'                                                => [ 'Bmobile', 'AX745', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/Bmobile_AX810.xml'                                               => [ 'Bmobile', 'AX810', 'Android', DeviceType::MOBILE ],
    'http://www.bmobile.eu.com/uaprofile/UAprofile_BmobileQW125.xml'                                      => [ 'Bmobile', 'QW125', null, DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Bouygues Telecom Bs 351.xml'                                     => [ 'Bouygues', 'Bs 351', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Bouygues_Telecom_Bs_402.xml'                                     => [ 'Bouygues', 'Bs 402', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/BS471.xml'                                                          => [ 'Bouygues', 'Bs 471', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Bouygues_Telecom_Ultym_5_2.xml'                                  => [ 'Bouygues', 'Ultym 5.2', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Bouygues_Telecom_Ultym_5L.xml'                                   => [ 'Bouygues', 'Ultym 5L', 'Android', DeviceType::MOBILE ],
    'http://files.bq.com/uaprof/bq_aquaris_45_JB.xml'                                                     => [ 'bq', 'Aquaris', 'Android', DeviceType::MOBILE ],
    'http://files.bq.com/uaprof/bq_aquaris_E4_KK.xml'                                                     => [ 'bq', 'Aquaris E4', 'Android', DeviceType::MOBILE ],
    'http://files.bq.com/uaprof/bq_aquaris_E45_KK.xml'                                                    => [ 'bq', 'Aquaris E4.5', 'Android', DeviceType::MOBILE ],
    'http://files.bq.com/uaprof/bq_aquaris_5lte_KK.xml'                                                   => [ 'bq', 'Aquaris E5', 'Android', DeviceType::MOBILE ],
    'http://files.bq.com/uaprof/bq_aquaris_E5_FHD_KK.xml'                                                 => [ 'bq', 'Aquaris E5 FHD', 'Android', DeviceType::MOBILE ],
    'http://files.bq.com/uaprof/bq_aquaris_E5_HD_KK.xml'                                                  => [ 'bq', 'Aquaris E5 HD', 'Android', DeviceType::MOBILE ],
    'http://files.bq.com/uaprof/fnac_aquaris_E5_HD_KK.xml'                                                => [ 'bq', 'Aquaris E5 HD', 'Android', DeviceType::MOBILE ],
    'http://files.bq.com/uaprof/bq_aquaris_E6_KK.xml'                                                     => [ 'bq', 'Aquaris E6', 'Android', DeviceType::MOBILE ],
    'http://files.bq.com/uaprof/bq_edison_3_KK.xml'                                                       => [ 'bq', 'Edison 3', 'Android', DeviceType::TABLET ],
    'http://uaprof.vtext.com/pcd/c771/c771.xml'                                                           => [ 'Casio', 'Gz\'One Commando', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/pcd/vzw/vzw.xml'                                                             => [ 'Casio', 'Gz\'One Commando 811', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/pcd/vietnam/vietnam.xml'                                                     => [ 'Casio', 'GzOne CA201', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/pcd/c811/c811.xml'                                                           => [ 'Casio', 'GzOne Commando 811', 'Android', DeviceType::MOBILE ],
    'http://www.catphones.com/uaprof/Cat_B10-2_UAprofile.xml'                                             => [ 'Cat', 'B15', 'Android', DeviceType::MOBILE ],
    'http://www.catphones.com/uaprof/b15q.xml'                                                            => [ 'CAT', 'B15Q', 'Android', DeviceType::MOBILE ],
    'http://www.catphones.com/uaprof/s50.xml'                                                             => [ 'CAT', 'S50', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/celkon/A95Pro.xml'                                                    => [ 'Celkon', 'A95 Pro', 'Android', DeviceType::MOBILE ],
    'http://uap.cellon.com/M8050QM.xml'                                                                   => [ 'Celkon', 'S1', 'Android', DeviceType::MOBILE ],
    'http://uap.cellon.com/C1038.xml'                                                                     => [ 'Cellon', 'C1038', null, DeviceType::MOBILE ],
    'http://uap.cellon.com/C2573.xml'                                                                     => [ 'Cellon', 'C2573', null, DeviceType::MOBILE ],
    'http://uap.cellon.com/C8660.xml'                                                                     => [ 'Cellon', 'C8660', 'Android', DeviceType::MOBILE ],
    'http://uap.cellon.com/UAP/C8660.xml'                                                                 => [ 'Cellon', 'C8660', 'Android', DeviceType::MOBILE ],
    'http://uap.cellon.com/M8047IU.xml'                                                                   => [ 'Cellon', 'M8047IU', 'Android', DeviceType::MOBILE ],
    'http://uap.cellon.com/M8047QM.xml'                                                                   => [ 'Cellon', 'M8047QM', 'Android', DeviceType::MOBILE ],
    'http://uap.cellon.com/M8140PT.xml'                                                                   => [ 'Cellon', 'M8140PT', 'Android', DeviceType::MOBILE ],
    'http://www.fih.com/uaprof/FIH000/UAProf_FIH000_Froyo.xml'                                            => [ 'ChangHong', 'Z-me', 'Android', DeviceType::MOBILE ],
    'http://221.176.65.117/uaprof/CMDC_M601.xml'                                                          => [ 'China Mobile', 'M601', 'Android', DeviceType::TABLET ],
    'http://phone.hisense.com/khfw/rjxz/201306/P020130627360412430072.xml'                                => [ 'China Mobile', 'M701', 'Android', DeviceType::TABLET ],
    'http://221.176.65.117/uaprof/CMCC-M812.xml'                                                          => [ 'China Mobile Device', 'and M812', 'Android', DeviceType::MOBILE ],
    'http://221.176.65.117/uaprof/M821.xml'                                                               => [ 'China Mobile Device', 'and M821', 'Android', DeviceType::MOBILE ],
    'http://221.176.65.117/uaprof/M823.xml'                                                               => [ 'China Mobile Device', 'and M823', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/CHL/CHL-S800_1_20101228.xml'                                             => [ 'CHL', 'S800', 'Android', DeviceType::MOBILE ],
    'http://www.commtiva.com/uaprof/HD700/UAProf_HD700_Gingerbread.xml'                                   => [ 'Commtiva', 'HD700', 'Android', DeviceType::MOBILE ],
    'http://www.commtiva.com/uaprof/UAProf_Froyo.xml'                                                     => [ 'Commtiva', 'N700', 'Android', DeviceType::MOBILE ],
    'http://mms.openmobilepr.com/uaprof/Coolpad-3700A.xml'                                                => [ 'Coolpad', '3700', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Coolpad/5560S/Coolpad-5560S-SP004.rdf'                                   => [ 'Coolpad', '5560S', 'Android', DeviceType::MOBILE ],
    'http://www.cgmobile.com.cn/8810G_UAProfile.xml'                                                      => [ 'Coolpad', '8010', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.YuLong.com/uaprof/CoolPad8026-1.0.xml'                                              => [ 'Coolpad', '8026', 'Android', DeviceType::MOBILE ],
    'http://ota.ragentek.com:8002/RgkOTA/UAprofile/Coolpad8122_UAprofile.xml'                             => [ 'Coolpad', '8122', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOCoolpad 8730L.xml'                                          => [ 'Coolpad', '8730L', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.YuLong.com/uaprof/YuLong-CoolPad8809-1.0.xml'                                       => [ 'CoolPad', '8809', 'Android', DeviceType::MOBILE ],
    'http://nmsc.vnet.com.cn/uaprof/YL/COOLPAD-E600.xml'                                                  => [ 'Coolpad', 'D510', 'Brew', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/YL/YL_Coolpad_E230_2_20100520.xml'                                       => [ 'Coolpad', 'E230', 'Brew', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Coolpad/801ES/Coolpad-801ES-CP021.rdf'                                   => [ 'Coolpad', 'Quattro II 4G', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOCoolpad Y80D.xml'                                           => [ 'Coolpad', 'Y80', 'Android', DeviceType::MOBILE ],
    'http://www.azumi-mobile.com/agenteprofile/equipos/Azumi_A50.xml'                                     => [ 'Cozco', 'C1 Plus', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOCUBOT ONE.xml'                                              => [ 'Cubot', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOMC002.xml'                                                  => [ 'Dakele', 'MC002', 'Android', DeviceType::MOBILE ],
    'http://ftp.us.dell.com/Factor_Software_Updates/Grappa_UA_Profile.xml'                                => [ 'Dell', 'Grappa', 'Android', DeviceType::MOBILE ],
    'http://122.200.68.229/docs/mini3ix.xml'                                                              => [ 'Dell', 'Mini 3ix', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/XCD35.xml'                                                       => [ 'Dell', 'XCD35', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5056A.xml'                                                          => [ 'Digicel', 'DL1 Plus', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/DL800.xml'                                                       => [ 'Digicel', 'DL800', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Juno-1.0.xml'                                                           => [ 'Dopod', 'C750', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Tachi-1.0.xml'                                                          => [ 'Dopod', 'T5399', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Qilin-1.0.xml'                                                          => [ 'Dopod', 'T8388', 'Windows Mobile', DeviceType::MOBILE ],
    'http://ua.doro.com/ua/Doro810_UAProfile.xml'                                                         => [ 'Doro', 'Liberto 810', 'Android', DeviceType::MOBILE ],
    'http://ua.doro.com/ua/Doro820_UAProfile.xml'                                                         => [ 'Doro', 'Liberto 820', 'Android', DeviceType::MOBILE ],
    'http://ua.doro.com/ua/Doro820Mini_UAProfile.xml'                                                     => [ 'Doro', 'Liberto 820 Mini', 'Android', DeviceType::MOBILE ],
    'http://ua.doro.com/ua/Doro740_UAProfile.xml'                                                         => [ 'Doro', 'PhoneEasy 745', 'Android', DeviceType::MOBILE ],
    'http://www.elitemodellookmobile.com/uaprof/eml2.xml'                                                 => [ 'Elite Model Look', 'EML2', null, DeviceType::MOBILE ],
    'http://mobileinternet.ericsson.com/UAprof/R380e.xml'                                                 => [ 'Ericsson', 'R380', null, DeviceType::MOBILE ],
    'http://wap.sonyericsson.com/UAprof/R520.xml'                                                         => [ 'Ericsson', 'R520', null, DeviceType::MOBILE ],
    'http://wap.sonyericsson.com/UAprof/R600.xml'                                                         => [ 'Ericsson', 'R600', null, DeviceType::MOBILE ],
    'http://wap.sonyericsson.com/UAprof/T39.xml'                                                          => [ 'Ericsson', 'T39', null, DeviceType::MOBILE ],
    'http://mobileinternet.ericsson.com/UAprof/T60d.xml'                                                  => [ 'Ericsson', 'T60', null, DeviceType::MOBILE ],
    'http://mobileinternet.ericsson.com/UAprof/T65.xml'                                                   => [ 'Ericsson', 'T65', null, DeviceType::MOBILE ],
    'http://mobileinternet.ericsson.com/UAprof/T68R1.xml'                                                 => [ 'Ericsson', 'T68', null, DeviceType::MOBILE ],
    'http://wap.sonyericsson.com/UAprof/T68R201.xml'                                                      => [ 'Ericsson', 'T68', null, DeviceType::MOBILE ],
    'http://wap.sonyericsson.com/UAprof/T68R301.xml'                                                      => [ 'Ericsson', 'T68', null, DeviceType::MOBILE ],
    'http://wap.sonyericsson.com/UAprof/T68R401.xml'                                                      => [ 'Ericsson', 'T68', null, DeviceType::MOBILE ],
    'http://wap.sonyericsson.com/UAprof/T68R402.xml'                                                      => [ 'Ericsson', 'T68', null, DeviceType::MOBILE ],
    'http://wap.sonyericsson.com/UAprof/T68R501.xml'                                                      => [ 'Ericsson', 'T68', null, DeviceType::MOBILE ],
    'http://wap.sonyericsson.com/UAprof/T68R502.xml'                                                      => [ 'Ericsson', 'T68', null, DeviceType::MOBILE ],
    'http://wap.sonyericsson.com/UAprof/T68R503.xml'                                                      => [ 'Ericsson', 'T68', null, DeviceType::MOBILE ],
    'http://www.ztemt.com/mobile/uaprof/V6500_Etisalat_EG.xml'                                            => [ 'Etisalat', 'Smartphone', 'Android', DeviceType::MOBILE ],
    'http://uaprof.qma.com.tw/BenQ-A3c.xml'                                                               => [ 'Ezcast', 'Dongle', 'Android',  ],
    'http://mobiwire.com/uaprofile/Telekom_Austria_Group_FP1.xml'                                         => [ 'Fairphone', '1', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/Flair%20P2.xml'                                                       => [ 'Fairphone', '2', 'Android', DeviceType::MOBILE ],
    'http://www.c2dms.com/UAProfile/N26/FarEastone_Smart501.xml'                                          => [ 'Fareastone', 'Smart 501', 'Android', DeviceType::MOBILE ],
    'http://www.wizdevice.com/support/rise/uaprof.xml'                                                    => [ 'Fareastone', 'Smart 701', 'Android', DeviceType::TABLET ],
    'http://211.42.201.70/ua_profile/FLY-2040i.xml'                                                       => [ 'Fly', '2040', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/FLY-2040L.xml'                                                       => [ 'Fly', '2040', null, DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_E154.xml'                                                            => [ 'Fly', 'E154', 'MTK', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_E190.xml'                                                            => [ 'Fly', 'E190', 'MTK', DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/Fly-E300.xml'                                                        => [ 'Fly', 'E300', null, DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Flylife_Connect_7_3G.xml'                                                => [ 'Fly', 'Flylife Connect 7 3G', 'Android', DeviceType::TABLET ],
    'http://www.fly-phone.ru/UAP/Flylife_Connect_7.85_3G_2.xml'                                           => [ 'Fly', 'Flylife Connect 7.85 3G 2', 'Android', DeviceType::TABLET ],
    'http://www.fly-phone.ru/UAP/Flylife_Connect_7.85_3G_Slim.xml'                                        => [ 'Fly', 'Flylife Connect 7.85 3G Slim', 'Android', DeviceType::TABLET ],
    'http://www.fly-phone.ru/UAP/Fly_FS403.xml'                                                           => [ 'Fly', 'FS403 Cumulus 1', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_FS451.xml'                                                           => [ 'Fly', 'FS451 Nimbus 1', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ237.xml'                                                           => [ 'Fly', 'IQ237 Dynamic', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ238.xml'                                                           => [ 'Fly', 'IQ238 Jazz', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ239.xml'                                                           => [ 'Fly', 'IQ239 Era Nano 2', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ246.xml'                                                           => [ 'Fly', 'IQ246 Power', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ430.xml'                                                           => [ 'Fly', 'IQ430 Evoke', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ431.xml'                                                           => [ 'Fly', 'IQ431 Glory', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ432.xml'                                                           => [ 'Fly', 'IQ432 Era Nano 1', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ434.xml'                                                           => [ 'Fly', 'IQ434 Era Nano 5', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ436.xml'                                                           => [ 'Fly', 'IQ434 Era Nano 9', 'Android', DeviceType::MOBILE ],
    'http://www.bluhelp.com/upload/xmlfiles/STAR_4.5.xml'                                                 => [ 'Fly', 'IQ440 Energie', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_EVO_Chic_1.xml'                                                      => [ 'Fly', 'IQ440 Energie', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ440.xml'                                                           => [ 'Fly', 'IQ440 Energie', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4403.xml'                                                          => [ 'Fly', 'IQ440 Energie', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4404.xml'                                                          => [ 'Fly', 'IQ440 Energie', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4407.xml'                                                          => [ 'Fly', 'IQ440 Energie', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4409_Quad.xml'                                                     => [ 'Fly', 'IQ440 Energie', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4405_Quad.xml'                                                     => [ 'Fly', 'IQ4405 Evo Chic', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4410_Quad.xml'                                                     => [ 'Fly', 'IQ441 Radiance', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4411_Quad.xml'                                                     => [ 'Fly', 'IQ441 Radiance', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4412_Quad.xml'                                                     => [ 'Fly', 'IQ441 Radiance', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4414_Quad.xml'                                                     => [ 'Fly', 'IQ441 Radiance', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4415_Ouad.xml'                                                     => [ 'Fly', 'IQ441 Radiance', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4416.xml'                                                          => [ 'Fly', 'IQ441 Radiance', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4410i.xml'                                                         => [ 'Fly', 'IQ4410i Phoenix 2', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4413_Quad.xml'                                                     => [ 'Fly', 'IQ4413 Evo Chic 3', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ442.xml'                                                           => [ 'Fly', 'IQ442 Miracle', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ443.xml'                                                           => [ 'Fly', 'IQ443 Trend', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ444.xml'                                                           => [ 'Fly', 'IQ444 Diamond', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ444_Quattro.xml'                                                   => [ 'Fly', 'IQ444 Diamond', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ445.xml'                                                           => [ 'Fly', 'IQ445 Genius', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ446.xml'                                                           => [ 'Fly', 'IQ446 Magic', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ447.xml'                                                           => [ 'Fly', 'IQ447 Era Life 1', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ449.xml'                                                           => [ 'Fly', 'IQ449 Pronto', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4490.xml'                                                          => [ 'Fly', 'IQ449 Pronto', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4491_Quad.xml'                                                     => [ 'Fly', 'IQ449 Pronto', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4503_Quad.xml'                                                     => [ 'Fly', 'IQ450 Horizon', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ450_Quattro.xml'                                                   => [ 'Fly', 'IQ450 Horizon', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ451.xml'                                                           => [ 'Fly', 'IQ451 Vista', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4511_Octa.xml'                                                     => [ 'Fly', 'IQ451 Vista', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4514_Quad.xml'                                                     => [ 'Fly', 'IQ451 Vista', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4515_Quad.xml'                                                     => [ 'Fly', 'IQ451 Vista', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOIQ451.xml'                                                  => [ 'Fly', 'IQ451 Vista', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4512_Quad.xml'                                                     => [ 'Fly', 'IQ4512 Evo Chic 4', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4516_Octa.xml'                                                     => [ 'Fly', 'IQ4516 Tornado Slim', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ452_Quad.xml'                                                      => [ 'Fly', 'IQ452 Ego Vision 1', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ453_Quad.xml'                                                      => [ 'Fly', 'IQ453 Luminor', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ454.xml'                                                           => [ 'Fly', 'IQ454 Evo Tech 1', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ455_Octa.xml'                                                      => [ 'Fly', 'IQ455 Ego Art 1', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ456.xml'                                                           => [ 'Fly', 'IQ456 Era Life 2', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ458_Quad.xml'                                                      => [ 'Fly', 'IQ458 Quad', 'Android', DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/Fly-LX610.xml'                                                       => [ 'Fly', 'LX610', null, DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_MC100.xml'                                                           => [ 'Fly', 'MC100', null, DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_MC110.xml'                                                           => [ 'Fly', 'MC110', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/FLY-MX200i.xml'                                                      => [ 'Fly', 'MX200', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/FLY-MX230.xml'                                                       => [ 'Fly', 'MX230', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/FLY-MX300.xml'                                                       => [ 'Fly', 'MX300', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/FLY-MX330.xml'                                                       => [ 'Fly', 'MX330', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/FLY-SL300m.xml'                                                      => [ 'Fly', 'SL300', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/Fly-SL399E.xml'                                                      => [ 'Fly', 'SL399', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/SL500i.xml'                                                          => [ 'Fly', 'SL500i', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/SL500m.xml'                                                          => [ 'Fly', 'SL500m', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/SL600.xml'                                                           => [ 'Fly', 'SL600', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/Fly-SLT100.xml'                                                      => [ 'Fly', 'SLT100', null, DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_SX200.xml'                                                           => [ 'Fly', 'SX200', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/FLY-SX210.xml'                                                       => [ 'Fly', 'SX210', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/FLY-SX300.xml'                                                       => [ 'Fly', 'SX300', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/FLY-SX305.xml'                                                       => [ 'Fly', 'SX305', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/FLY-SX310.xml'                                                       => [ 'Fly', 'SX310', null, DeviceType::MOBILE ],
    'http://211.42.201.70/ua_profile/FLY-SX390.xml'                                                       => [ 'Fly', 'SX390', null, DeviceType::MOBILE ],
    'http://218.249.89.125/UAprof/FLY-V120.xml'                                                           => [ 'Fly', 'V120', null, DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_X3.xml'                                                              => [ 'Fly', 'X3', null, DeviceType::MOBILE ],
    'http://spf.fmworld.net/fujitsu/c/data/UAProf/STYLISTIC/S01.xml'                                      => [ 'Fujitsu', 'STYLISTIC S01', 'Android', DeviceType::MOBILE ],
    'http://www.fujitsu-siemens.com/uaprof/PLT830.xml'                                                    => [ 'Fujitsu Siemens', 'Pocket LOOX T830', 'Windows Mobile', DeviceType::MOBILE ],
    'http://static.garmincdn.com/uaprof/A10_1_0.xml'                                                      => [ 'Garmin-Asus', 'Nuvifone A10', 'Android', DeviceType::MOBILE ],
    'http://static.garmincdn.com/uaprof/A50_1_0.xml'                                                      => [ 'Garmin-Asus', 'Nuvifone A50', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.asus.com/uaprof/garmin-asus-Nuvifone-M10-1.0.xml'                                   => [ 'Garmin-Asus', 'Nuvifone M10', 'Windows Mobile', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_TPA60W_Profile.xml'                                           => [ 'Gateway', 'TPA60W', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/GM-FOXv100WCDMA.xml'                                                   => [ 'General Mobile', 'Fox', 'Android', DeviceType::MOBILE ],
    'http://eip2.gigabytecm.com/GIGABYTE-g-smart.xml'                                                     => [ 'Gigabyte', 'GSmart', null, DeviceType::MOBILE ],
    'http://eip2.gigabytecm.com/GSMART-G1310.xml'                                                         => [ 'Gigabyte', 'GSmart G1310', 'Android', DeviceType::MOBILE ],
    'http://eip2.gigabytecm.com/GSMART-G1315.xml'                                                         => [ 'Gigabyte', 'GSmart G1315', 'Android', DeviceType::MOBILE ],
    'http://eip2.gigabytecm.com/GSMART-G1317.xml'                                                         => [ 'Gigabyte', 'GSmart G1317', 'Android', DeviceType::MOBILE ],
    'http://eip2.gigabytecm.com/GIGABYTE-MS800.xml'                                                       => [ 'Gigabyte', 'GSmart MS800', null, DeviceType::MOBILE ],
    'http://eip2.gigabytecm.com/GIGABYTE-g-smart-vga.xml'                                                 => [ 'Gigabyte', 'GSmart T600', null, DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-1GPRS-GM_Turkey.xml'                                       => [ 'GM', 'Ultimate Slim', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/Dsi6X_y8P_In4gbf/xel-M3-D1.xml'                                          => [ 'Google', 'Pixel', 'Android', DeviceType::MOBILE ],
    'http://mobile.haier.com/UAProf/uapA62.xml'                                                           => [ 'Haier', 'A62', null, DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOHT-I860.xml'                                                => [ 'Haier', 'I860', 'Android', DeviceType::MOBILE ],
    'http://www.yeezonetech.com/wap/SMDK4x12_UAProfile.xml'                                               => [ 'Haier', 'I928', 'Android', DeviceType::MOBILE ],
    'http://mobile.haier.com/UAProf/uapM1610.xml'                                                         => [ 'Haier', 'M1610', null, DeviceType::MOBILE ],
    'http://www.ehaier.com/download/mobile/uapHaier-HW-N86W.xml'                                          => [ 'Haier', 'N86W', 'Android', DeviceType::MOBILE ],
    'http://www.ehaier.com/download/mobile/uapHaier-HW-N88W.xml'                                          => [ 'Haier', 'N88W', 'Android', DeviceType::MOBILE ],
    'http://www.ehaier.com/download/mobile/uapHaier-HW-W718.xml'                                          => [ 'Haier', 'N88W', 'Android', DeviceType::MOBILE ],
    'http://uaprof.uni-wise.com/uaprof/Haier/Haier-T10C.xml'                                              => [ 'Haier', 'T10C', null, DeviceType::MOBILE ],
    'http://mobile.haier.com/UAProf/uapV7000.xml'                                                         => [ 'Haier', 'V7000', null, DeviceType::MOBILE ],
    'http://www.ehaier.com/download/mobile/uapHW-W617.xml'                                                => [ 'Haier', 'W617', 'Android', DeviceType::MOBILE ],
    'http://www.ehaier.com/download/mobile/uapHaier-HW-W716.xml'                                          => [ 'Haier', 'W716', 'Android', DeviceType::MOBILE ],
    'http://cdn09.ehaier.com/download/mobile/uapHaier-W867.xml'                                           => [ 'Haier', 'W867', 'Android', DeviceType::MOBILE ],
    'http://www.ehaier.com/download/mobile/uapHW-W910.xml'                                                => [ 'Haier', 'W910', 'Android', DeviceType::MOBILE ],
    'http://mobile.haier.com/UAProf/uapZ3000.xml'                                                         => [ 'Haier', 'Z3000', null, DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOAlpha Ice.xml'                                              => [ 'Highscreen', 'Alpha Ice', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/ZTE Blade L370.xml'                                              => [ 'Highscreen', 'Zera S', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOHIKe 868.xml'                                               => [ 'HIKe', 'Z1 868', 'Android', DeviceType::MOBILE ],
    'http://phone.hisense.com/khfw/rjxz/201310/P020131012478952694173.xml'                                => [ 'Hisense', 'E360M', 'Android', DeviceType::MOBILE ],
    'http://www.hisensephone.com/Hisense_E51-M_ua_profile.xml'                                            => [ 'Hisense', 'E51-M', 'Android', DeviceType::MOBILE ],
    'http://www.hisensephone.com/Hisense_F20T_ua_profile.xml'                                             => [ 'Hisense', 'F20T', 'Android', DeviceType::MOBILE ],
    'http://www.hisensephone.com/Hisense_F21T_ua_profile.xml'                                             => [ 'Hisense', 'F21T', 'Android', DeviceType::MOBILE ],
    'http://phone.hisense.com/khfw/rjxz/201303/P020130307299783065342.xml'                                => [ 'Hisense', 'T820', 'Android', DeviceType::MOBILE ],
    'http://phone.hisense.com/khfw/rjxz/201208/P020120809608224982262.xml'                                => [ 'Hisense', 'T830', 'Android', DeviceType::MOBILE ],
    'http://phone.hisense.com/khfw/rjxz/201205/P020120521576380789573.xml'                                => [ 'Hisense', 'T860', 'Android', DeviceType::MOBILE ],
    'http://phone.hisense.com/khfw/rjxz/201301/P020130130568107298317.xml'                                => [ 'Hisense', 'T912', 'Android', DeviceType::MOBILE ],
    'http://phone.hisense.com/khfw/rjxz/201306/P020130626391746806303.xml'                                => [ 'Hisense', 'T928', 'Android', DeviceType::MOBILE ],
    'http://phone.hisense.com/khfw/rjxz/201301/P020130121342541959752.xml'                                => [ 'Hisense', 'T958', 'Android', DeviceType::MOBILE ],
    'http://phone.hisense.com/khfw/rjxz/201306/P020130626392019424761.xml'                                => [ 'Hisense', 'T959', 'Android', DeviceType::MOBILE ],
    'http://phone.hisense.com/khfw/rjxz/201309/P020130909487904900221.xml'                                => [ 'Hisense', 'T959', 'Android', DeviceType::MOBILE ],
    'http://phone.hisense.com/khfw/rjxz/201307/P020130710551710631695.xml'                                => [ 'Hisense', 'T959S', 'Android', DeviceType::MOBILE ],
    'http://phone.hisense.com/khfw/rjxz/201306/P020130626585426555510.xml'                                => [ 'Hisense', 'T968', 'Android', DeviceType::MOBILE ],
    'http://phone.hisense.com/khfw/rjxz/201304/P020130425502003281721.xml'                                => [ 'Hisense', 'T970', 'Android', DeviceType::MOBILE ],
    'http://phone.hisense.com/khfw/rjxz/201308/P020130805555147328699.xml'                                => [ 'Hisense', 'T980', 'Android', DeviceType::MOBILE ],
    'http://phone.hisense.com/khfw/rjxz/201405/P020140505487949781524.xml'                                => [ 'Hisense', 'U939', 'Android', DeviceType::MOBILE ],
    'http://picture-us.hismarttv.com/txfile/Hisense_HS-U961_20150304.XML'                                 => [ 'Hisense', 'U961', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Hitachi/SH-P300/S2A31.rdf'                                               => [ 'Hitachi', 'SH-P300', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Hitachi/SH-P300/S2A33.rdf'                                               => [ 'Hitachi', 'SH-P300', null, DeviceType::MOBILE ],
    'http://www.hp.com/ipaqcarrier/hpipaq510v10.xml'                                                      => [ 'HP', 'iPAQ 510', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.hp.com/ipaqcarrier/hpipaq610v10.xml'                                                      => [ 'HP', 'iPAQ 610', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.hp.com/ipaqcarrier/hpipaq910v10.xml'                                                      => [ 'HP', 'iPAQ 910', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.hp.com/ipaqcarrier/HPiPAQDataMessenger10.xml'                                             => [ 'HP', 'iPAQ Data Messenger', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.hp.com/ipaqcarrier/hpipaqhw692xv10.xml'                                                   => [ 'HP', 'iPAQ hw6920', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.hp.com/ipaqcarrier/hpipaqrw6815v10.xml'                                                   => [ 'HP', 'iPAQ rw6815', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.hp.com/ipaqcarrier/HPiPAQVoiceMessenger10.xml'                                            => [ 'HP', 'iPAQ Voice Messenger', 'Windows Mobile', DeviceType::MOBILE ],
    'http://js.redirect.hp.com/jumpstation?bd=all&c=none&locale=ww_ww&pf=all&s=hp_linkplus_uaprofile&tp=mobility'=> [ 'HP', 'Slate 10 Plus', 'Android', DeviceType::TABLET ],
    'http://js.redirect.hp.com/jumpstation?bd=all&c=none&locale=ww_ww&pf=all&s=hp_vogue_uaprofile&tp=mobility'=> [ 'HP', 'Slate 8 Plus', 'Android', DeviceType::TABLET ],
    'http://device.sprintpcs.com/HTC/0PJA2-SPRINT/ViperOneM9 610.rdf'                                     => [ 'HTC', '10', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/NxVAjJl9Mq/ua-profile.xml'                                   => [ 'HTC', '10', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Strk-1.0.xml'                                                           => [ 'HTC', '3100', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/SongShan/ua-profile.xml'                                     => [ 'HTC', 'A3360', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Tianshan/ua-profile.xml'                                     => [ 'HTC', 'A3380', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Athena-1.0.xml'                                                         => [ 'HTC', 'Advantage X7500', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/HTC_Amaze_4G/ua-profile.xml'                                 => [ 'HTC', 'Amaze 4G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PH85/ua-profile.xml'                                         => [ 'HTC', 'Amaze 4G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PH851/ua-profile.xml'                                        => [ 'HTC', 'Amaze 4G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telus/Ruby/ua-profile.xml'                                          => [ 'HTC', 'Amaze 4G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Videotron/Ruby/ua-profile.xml'                                      => [ 'HTC', 'Amaze 4G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/apache-2.0.xml'                                                         => [ 'HTC', 'Apache', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Aria/ua-profile.xml'                                         => [ 'HTC', 'Aria', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Liberty/A6366-1.0.xml'                                       => [ 'HTC', 'Aria', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/eMobile/Liberty/ua-profile.xml'                                     => [ 'HTC', 'Aria', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PM651/ua-profile.xml'                                        => [ 'HTC', 'au Infobar A02', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/beacon-1.0.xml'                                                         => [ 'HTC', 'Beacon', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/RLyrImabWh/ua-profile.xml'                                   => [ 'HTC', 'Butterfly 2', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HTC/HTC_909d_1_20130601.XML'                                             => [ 'HTC', 'Butterfly S', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HTC/HTC_909d_2_20130801.XML'                                             => [ 'HTC', 'Butterfly S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PO68/ua-profile.xml'                                         => [ 'HTC', 'Butterfly S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PO681/ua-profile.xml'                                        => [ 'HTC', 'Butterfly S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PO682/ua-profile.xml'                                        => [ 'HTC', 'Butterfly S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PO684/ua-profile.xml'                                        => [ 'HTC', 'Butterfly S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PO685/ua-profile.xml'                                        => [ 'HTC', 'Butterfly S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/ChaChaCha/ua-profile.xml'                                    => [ 'HTC', 'ChaCha', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/HTC_ChaCha_A810e/ua-profile.xml'                             => [ 'HTC', 'ChaCha', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PH06/ua-profile.xml'                                         => [ 'HTC', 'ChaCha', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/ChaChaCha/ua-profile.xml'                                    => [ 'HTC', 'ChaCha', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/PH06/ua-profile.xml'                                         => [ 'HTC', 'ChaCha', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PD11/ua-profile.xml'                                         => [ 'HTC', 'Cullinan', 'Android', DeviceType::MOBILE ],
    'http://mms.cellcom.com/uaprofs/cellcom_htc_DLX.xml'                                                  => [ 'HTC', 'Deluxe', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ACG/PL832/ua-profile_500K.xml'                                      => [ 'HTC', 'Deluxe', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Bravo/HTC_Desire.xml'                                        => [ 'HTC', 'Desire', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Bravo/HTC_Desire_A8181.xml'                                  => [ 'HTC', 'Desire', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Desire/ua-profile.xml'                                       => [ 'HTC', 'Desire', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/eris/ua-profile.xml'                                         => [ 'HTC', 'Desire', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Orange/Desire-profile.xml'                                   => [ 'HTC', 'Desire', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/SBM/SBM_X06HT-1.0.xml'                                              => [ 'HTC', 'Desire', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telstra/Desire/ua-profile.xml'                                      => [ 'HTC', 'Desire', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telus/Bravo/ua-profile.xml'                                         => [ 'HTC', 'Desire', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/tmo/HTC_Desire-1.0.xml'                                             => [ 'HTC', 'Desire', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/cvA1671TDt/ua-profile.xml'                                   => [ 'HTC', 'Desire 10 Pro', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PO601/ua-profile.xml'                                        => [ 'HTC', 'Desire 200', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/vHfmvk5H3n/ua-profile.xml'                                   => [ 'HTC', 'Desire 210', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/4WaXiSSfCP/ua-profile.xml'                                   => [ 'HTC', 'Desire 300', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telstra/4WaXiSSfCP/ua-profile.xml'                                  => [ 'HTC', 'Desire 300', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/AIO/nhYHJ3dbMv/ua-profile.xml'                                      => [ 'HTC', 'Desire 310', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/l9kfHYvA01/ua-profile.xml'                                   => [ 'HTC', 'Desire 310', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/nhYHJ3dbMv/ua-profile.xml'                                   => [ 'HTC', 'Desire 310', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/vBSZ5hs37J/ua-profile.xml'                                   => [ 'HTC', 'Desire 310', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/O2/l9kfHYvA01/ua-profile.xml'                                       => [ 'HTC', 'Desire 310', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/l9kfHYvA01/ua-profile.xml'                                   => [ 'HTC', 'Desire 310', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/l9kfHYvA01/ua-profile.xml'                                      => [ 'HTC', 'Desire 310', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Vodafone/l9kfHYvA01/ua-profile.xml'                                 => [ 'HTC', 'Desire 310', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telcel/nhYHJ3dbMv/ua-profile.xml'                                   => [ 'HTC', 'Desire 320', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TELUS/nhYHJ3dbMv/ua-profile.xml'                                    => [ 'HTC', 'Desire 320', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Vodafone/nhYHJ3dbMv/ua-profile.xml'                                 => [ 'HTC', 'Desire 320', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/nJwqkkNk4t/ua-profile.xml'                                   => [ 'HTC', 'Desire 326G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/AMX/0P3Z11/ua-profile.xml'                                          => [ 'HTC', 'Desire 500', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/0P3Z1/ua-profile.xml'                                        => [ 'HTC', 'Desire 500', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/0P3Z11/ua-profile.xml'                                       => [ 'HTC', 'Desire 500', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telcel/0P3Z1/ua-profile.xml'                                        => [ 'HTC', 'Desire 500', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TIM/0P3Z11/ua-profile.xml'                                          => [ 'HTC', 'Desire 500', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/0P3Z11/ua-profile.xml'                                          => [ 'HTC', 'Desire 500', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Vodafone/0P3Z11/ua-profile.xml'                                     => [ 'HTC', 'Desire 500', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/jV8CnoJUaO/ua-profile.xml'                                   => [ 'HTC', 'Desire 501', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/0P3Z2/ua-profile.xml'                                        => [ 'HTC', 'Desire 5088', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PCV1-2012071301/1476521.rdf'                                        => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PCV1-2012071301/1486522.rdf'                                        => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PCV1-2012071301/1496523.rdf'                                        => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PCV1-BOOST/1426521.rdf'                                             => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PCV1-BOOST/1476521.rdf'                                             => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PCV1-BOOST/1486522.rdf'                                             => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PCV1-BOOST/1496523.rdf'                                             => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PCV1-Chameleon/1486522.rdf'                                         => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PCV1-SPRINT/1426521.rdf'                                            => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PCV1-SPRPRE/1486522.rdf'                                            => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PCV1-SPRPRE/1496523.rdf'                                            => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PCV1-VIRGIN/1426521.rdf'                                            => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PCV1-VIRGIN/1476521.rdf'                                            => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PCV1-VIRGIN/1486522.rdf'                                            => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PCV1-VIRGIN/1496523.rdf'                                            => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ATT/7l3xFmWvDC/ua-profile.xml'                                      => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/BM/7l3xFmWvDC/ua-profile.xml'                                       => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/R183PSZ1oa/ua-profile.xml'                                   => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Cricket/EwxIAccCJC/ua-profile.xml'                                  => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telcel/7l3xFmWvDC/ua-profile.xml'                                   => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telstra/R183PSZ1oa/ua-profile.xml'                                  => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telus/7l3xFmWvDC/ua-profile.xml'                                    => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/R183PSZ1oa/ua-profile.xml'                                      => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Vodafone/R183PSZ1oa/ua-profile.xml'                                 => [ 'HTC', 'Desire 510', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/VTy7Pu6T6N/ua-profile.xml'                                   => [ 'HTC', 'Desire 520', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TELCEL/hkQ3fFqw1h/ua-profile.xml'                                   => [ 'HTC', 'Desire 526G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/hkQ3fFqw1h/ua-profile.xml'                                   => [ 'HTC', 'Desire 526G+', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/hwX6V8P1Mn/ua-profile.xml'                                   => [ 'HTC', 'Desire 526G+', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PO49120/ua-profile.xml'                                      => [ 'HTC', 'Desire 600', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PO471/ua-profile.xml'                                        => [ 'HTC', 'Desire 600c', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTC0P4E1-VIRGIN/1106526.rdf'                                         => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTC0P4E1-VIRGIN/1106529.rdf'                                         => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTC0P4E1-VIRGIN/2156523.rdf'                                         => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://mms.ntwls.net/uaprofs/ua-profile_1M.xml'                                                      => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://uaprof.cccomm.csky.us/ua/ua-profile_500k.xml'                                                 => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ACG/PqjMKRKt4Z/ua-profile_1M.xml'                                   => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ACG/PqjMKRKt4Z/ua-profile_500K.xml'                                 => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/BM/CjnctPc6Sf/ua-profile.xml'                                       => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/CBW/CjnctPc6Sf/ua-profile.xml'                                      => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/CjnctPc6Sf/ua-profile.xml'                                   => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/SLl2AjRgr3/ua-profile.xml'                                   => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/CjnctPc6Sf/ua-profile.xml'                                   => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Rogers/CjnctPc6Sf/ua-profile.xml'                                   => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telus/CjnctPc6Sf/ua-profile.xml'                                    => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TIM/CjnctPc6Sf/ua-profile.xml'                                      => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Videotron/CjnctPc6Sf/ua-profile.xml'                                => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/WIND/CjnctPc6Sf/ua-profile.xml'                                     => [ 'HTC', 'Desire 601', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PO491/ua-profile.xml'                                        => [ 'HTC', 'Desire 606w', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PO481/ua-profile.xml'                                        => [ 'HTC', 'Desire 608t', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HTC/HTC_609d_1_20130501.XML'                                             => [ 'HTC', 'Desire 609d', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ATT/GcDNB3aMvX/ua-profile.xml'                                      => [ 'HTC', 'Desire 610', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/GcDNB3aMvX/ua-profile.xml'                                   => [ 'HTC', 'Desire 610', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/HQEJRedmsG/ua-profile.xml'                                   => [ 'HTC', 'Desire 610', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/HQEJRedmsG/ua-profile.xml'                                   => [ 'HTC', 'Desire 610', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telstra/HQEJRedmsG/ua-profile.xml'                                  => [ 'HTC', 'Desire 610', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/HQEJRedmsG/ua-profile.xml'                                      => [ 'HTC', 'Desire 610', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Vodafone/HQEJRedmsG/ua-profile.xml'                                 => [ 'HTC', 'Desire 610', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/gwLkpXJlS0/ua-profile.xml'                                   => [ 'HTC', 'Desire 616', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/LC7XQ0af2u/ua-profile.xml'                                   => [ 'HTC', 'Desire 616', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HTC/HTC_619d_1_20130815.XML'                                             => [ 'HTC', 'Desire 619d', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/e1NGCirnFB/ua-profile.xml'                                   => [ 'HTC', 'Desire 620', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/e1NGCirnFB/ua-profile.xml'                                   => [ 'HTC', 'Desire 620', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/e1NGCirnFB/ua-profile.xml'                                      => [ 'HTC', 'Desire 620', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/rdV77sS2Jt/ua-profile.xml'                                   => [ 'HTC', 'Desire 620G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/CMCC/RT7rIequXv/ua-profile.xml'                                     => [ 'HTC', 'Desire 626', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/jpsQ9TJbx4/ua-profile.xml'                                   => [ 'HTC', 'Desire 626', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/RT7rIequXv/ua-profile.xml'                                   => [ 'HTC', 'Desire 626', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/vas6Y725FU/ua-profile.xml'                                   => [ 'HTC', 'Desire 626', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Europe/EKgo2FnRlG/ua-profile.xml'                                   => [ 'HTC', 'Desire 626G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/EKgo2FnRlG/ua-profile.xml'                                   => [ 'HTC', 'Desire 626G+', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PM92-BOOST/1246512.rdf'                                             => [ 'HTC', 'Desire 626s', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PM92-VIRGIN/1246512.rdf'                                            => [ 'HTC', 'Desire 626s', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PM92-VIRGIN/2276516.rdf'                                            => [ 'HTC', 'Desire 626s', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/AMX/ASJJ0xGajy/ua-profile.xml'                                      => [ 'HTC', 'Desire 626s', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ATT/4GjJvIf3I5/ua-profile.xml'                                      => [ 'HTC', 'Desire 626s', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/ASJJ0xGajy/ua-profile.xml'                                   => [ 'HTC', 'Desire 626s', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Cricket/ASJJ0xGajy/ua-profile.xml'                                  => [ 'HTC', 'Desire 626s', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/nn9cpSwLNa/ua-profile.xml'                                   => [ 'HTC', 'Desire 7060', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/mmxr4Fc9EJ/ua-profile.xml'                                   => [ 'HTC', 'Desire 7088', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/azxFLxeBCm/ua-profile.xml'                                   => [ 'HTC', 'Desire 709d', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/710C-SPRPRE/2336525.rdf'                                             => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/710C-VIRGIN/1136521.rdf'                                             => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/710C-VIRGIN/1506523.rdf'                                             => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/710C-VIRGIN/2336522.rdf'                                             => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/710C-VIRGIN/2336525.rdf'                                             => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/710C-VIRGIN/InsertCoin 100.rdf'                                      => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://uaprof.qma.com.tw/HTC_D816d.xml'                                                              => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ACG/weCs1tpPUG/ua-profile_500K.xml'                                 => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/7QtMcMcyB2/ua-profile.xml'                                   => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/geUXhkfboO/ua-profile.xml'                                   => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/HRobRleNsO/ua-profile.xml'                                   => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Khlg9cPNZP/ua-profile.xml'                                   => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/miKNCjjDHJ/ua-profile.xml'                                   => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/rLgUe79qmx/ua-profile.xml'                                   => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/rYMdtoVVAt/ua-profile.xml'                                   => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/yKVvh30qEM/ua-profile.xml'                                   => [ 'HTC', 'Desire 816', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/j4yjajckun/ua-profile.xml'                                   => [ 'HTC', 'Desire 816G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/pPB1MJUnqf/ua-profile.xml'                                   => [ 'HTC', 'Desire 816G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/x7cG56PcBk/ua-profile.xml'                                   => [ 'HTC', 'Desire 816G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Bouygues/GC0znJc20B/ua-profile.xml'                                 => [ 'HTC', 'Desire 820', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/CMCC/B3BRtglhHJ/ua-profile.xml'                                     => [ 'HTC', 'Desire 820', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/CMCC/rTlnYuch0E/ua-profile.xml'                                     => [ 'HTC', 'Desire 820', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/8y4niiluZ7/ua-profile.xml'                                   => [ 'HTC', 'Desire 820', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/B3BRtglhHJ/ua-profile.xml'                                   => [ 'HTC', 'Desire 820', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/EjHarhDDvK/ua-profile.xml'                                   => [ 'HTC', 'Desire 820', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/GC0znJc20B/ua-profile.xml'                                   => [ 'HTC', 'Desire 820', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/rTlnYuch0E/ua-profile.xml'                                   => [ 'HTC', 'Desire 820', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/wLkc0BX3An/ua-profile.xml'                                   => [ 'HTC', 'Desire 820', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/GC0znJc20B/ua-profile.xml'                                   => [ 'HTC', 'Desire 820', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/CMCC/EjHarhDDvK/ua-profile.xml'                                     => [ 'HTC', 'Desire 820G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/mJQD40NuOR/ua-profile.xml'                                   => [ 'HTC', 'Desire 820G+', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Europe/mJQD40NuOR/ua-profile.xml'                                   => [ 'HTC', 'Desire 820G+', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/aXk2CNmBRo/ua-profile.xml'                                   => [ 'HTC', 'Desire 826', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/c8HDMjoq7Q/ua-profile.xml'                                   => [ 'HTC', 'Desire 826', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/L7YHOLHUJE/ua-profile.xml'                                   => [ 'HTC', 'Desire 826', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/6G97EEWjge/ua-profile.xml'                                   => [ 'HTC', 'Desire 828', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Liurl1pXZW/ua-profile.xml'                                   => [ 'HTC', 'Desire 830', 'Android', DeviceType::MOBILE ],
    'http://mms.mycricket.com/htc_h1000c.xml'                                                             => [ 'HTC', 'Desire C', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Bell/A320a/ua-profile.xml'                                          => [ 'HTC', 'Desire C', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/L01/ua-profile.xml'                                          => [ 'HTC', 'Desire C', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/L01/ua-profile.xml'                                          => [ 'HTC', 'Desire C', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Rogers/A320a/ua-profile.xml'                                        => [ 'HTC', 'Desire C', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telstra/L01/ua-profile.xml'                                         => [ 'HTC', 'Desire C', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TIM/L01/ua-profile.xml'                                             => [ 'HTC', 'Desire C', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/L01/ua-profile.xml'                                             => [ 'HTC', 'Desire C', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Vodafone/L01/ua-profile.xml'                                        => [ 'HTC', 'Desire C', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ATT/60qf87NvHb/ua-profile.xml'                                      => [ 'HTC', 'Desire Eye', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/kuAD9zppzP/ua-profile.xml'                                   => [ 'HTC', 'Desire Eye', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/R6vdFCdZmJ/ua-profile.xml'                                   => [ 'HTC', 'Desire Eye', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/O2/R6vdFCdZmJ/ua-profile.xml'                                       => [ 'HTC', 'Desire Eye', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/R6vdFCdZmJ/ua-profile.xml'                                      => [ 'HTC', 'Desire Eye', 'Android', DeviceType::MOBILE ],
    'http://uaprof.sonymobile.com/Desire HDR402.xml'                                                      => [ 'HTC', 'Desire HD', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Ace/A9192-1.0.xml'                                           => [ 'HTC', 'Desire HD', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/DesireHD/ua-profile.xml'                                     => [ 'HTC', 'Desire HD', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/SBM/SBM_001HT-1.0.xml'                                              => [ 'HTC', 'Desire HD', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telus/DesireHD/ua-profile.xml'                                      => [ 'HTC', 'Desire HD', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/Ace/ua-profile.xml'                                             => [ 'HTC', 'Desire HD', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PM6014/ua-profile.xml'                                       => [ 'HTC', 'Desire L', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PM862/ua-profile.xml'                                        => [ 'HTC', 'Desire P', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/DesireS/ua-profile.xml'                                      => [ 'HTC', 'Desire S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PG88/ua-profile.xml'                                         => [ 'HTC', 'Desire S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telstra/S510b/ua-profile.xml'                                       => [ 'HTC', 'Desire S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TME/DesireS/ua-profile.xml'                                         => [ 'HTC', 'Desire S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/Saga/ua-profile.xml'                                            => [ 'HTC', 'Desire S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PM861/ua-profile.xml'                                        => [ 'HTC', 'Desire SV', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PL112DS/ua-profile.xml'                                      => [ 'HTC', 'Desire U', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PL113/ua-profile.xml'                                        => [ 'HTC', 'Desire U', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PL111/ua-profile.xml'                                        => [ 'HTC', 'Desire V', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HTC/HTC_T328d_1_20120301.XML'                                            => [ 'HTC', 'Desire VC', 'Android', DeviceType::MOBILE ],
    'http://uaprof.qma.com.tw/HTC_Desire_VC_T328d.xml'                                                    => [ 'HTC', 'Desire VC', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PK781/ua-profile.xml'                                        => [ 'HTC', 'Desire VC', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PK79/ua-profile.xml'                                         => [ 'HTC', 'Desire VT', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Bouygues/PO73/ua-profile.xml'                                       => [ 'HTC', 'Desire X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PM661/ua-profile.xml'                                        => [ 'HTC', 'Desire X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PM661U/ua-profile.xml'                                       => [ 'HTC', 'Desire X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PO73/ua-profile.xml'                                         => [ 'HTC', 'Desire X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/PO73/ua-profile.xml'                                         => [ 'HTC', 'Desire X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/PO73/ua-profile.xml'                                            => [ 'HTC', 'Desire X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Bell/Vision/ua-profile.xml'                                         => [ 'HTC', 'Desire Z', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/DesireZ/ua-profile.xml'                                      => [ 'HTC', 'Desire Z', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/DreamX/ua-profile-htc-dream-Orange.xml'                      => [ 'HTC', 'Dream', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/htc/htc6435lvw/htc6435lvw.xml'                                               => [ 'HTC', 'Droid DNA', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/pcd/adr6435/adr6435.xml'                                                     => [ 'HTC', 'Droid DNA', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PL832/ua-profile.xml'                                        => [ 'HTC', 'Droid DNA', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/adr62k/adr62k.xml'                                                           => [ 'HTC', 'Droid Eris', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/pcd/adr63k/adr63k.xml'                                                       => [ 'HTC', 'Droid Incredible', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/IncredibleC/ua-profile.xml'                                  => [ 'HTC', 'Droid Incredible', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/pcd/adr6350/adr6350.xml'                                                     => [ 'HTC', 'Droid Incredible 2', 'Android', DeviceType::MOBILE ],
    'http://mms.openmobilepr.com/uaprof/fireball_1M.xml'                                                  => [ 'HTC', 'Droid Incredible 4G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PO091/ua-profile.xml'                                        => [ 'HTC', 'E1', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX325CKT/%CDMA_ROM_VERSION%.rdf'                                    => [ 'HTC', 'EVO', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX325CKT/1106510.rdf'                                               => [ 'HTC', 'EVO', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX325CKT/1136511.rdf'                                               => [ 'HTC', 'EVO', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX325CKT/1226513.rdf'                                               => [ 'HTC', 'EVO', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX325CKT/2136511.rdf'                                               => [ 'HTC', 'EVO', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX325CKT/31565116.rdf'                                              => [ 'HTC', 'EVO', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX325CKT/3166513.rdf'                                               => [ 'HTC', 'EVO', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX325CKT/3176514.rdf'                                               => [ 'HTC', 'EVO', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX325CKT/3176515.rdf'                                               => [ 'HTC', 'EVO', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX325CKT/3176519.rdf'                                               => [ 'HTC', 'EVO', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX325CKT/4036511.rdf'                                               => [ 'HTC', 'EVO', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX325CKT/4136513.rdf'                                               => [ 'HTC', 'EVO', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-Chameleon/4066514.rdf'                                      => [ 'HTC', 'EVO', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX515CKT/1116512.rdf'                                               => [ 'HTC', 'EVO 3D', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX515CKT/1116513.rdf'                                               => [ 'HTC', 'EVO 3D', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX515CKT/1136517.rdf'                                               => [ 'HTC', 'EVO 3D', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX515CKT/2086512.rdf'                                               => [ 'HTC', 'EVO 3D', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX515CKT/2086513.rdf'                                               => [ 'HTC', 'EVO 3D', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX515CKT/2176515.rdf'                                               => [ 'HTC', 'EVO 3D', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX515CKT/2896512.rdf'                                               => [ 'HTC', 'EVO 3D', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX515CKT/2956515.rdf'                                               => [ 'HTC', 'EVO 3D', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APX515CKT/2956516.rdf'                                               => [ 'HTC', 'EVO 3D', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HTC/HTC_X515d_1_20110831.XML'                                            => [ 'HTC', 'EVO 3D', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/HTC/X515C-VMUB/1.0/UAProf.xml'                                               => [ 'HTC', 'EVO 3D', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PG863/ua-profile.xml'                                        => [ 'HTC', 'EVO 3D', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/KDDI/ISW12HT/ua-profile.xml'                                        => [ 'HTC', 'EVO 3D', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Rogers/PG863/ua-profile.xml'                                        => [ 'HTC', 'EVO 3D', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA9292KT/1326511.rdf'                                               => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA9292KT/3266516.rdf'                                               => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA9292KT/3296515.rdf'                                               => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA9292KT/3306512.rdf'                                               => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA9292KT/3306513.rdf'                                               => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA9292KT/3706511.rdf'                                               => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA9292KT/4126511.rdf'                                               => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA9292KT/4226512.rdf'                                               => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA9292KT/4246511.rdf'                                               => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA9292KT/4536511.rdf'                                               => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA9292KT/4546511.rdf'                                               => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA9292KT/4676513.rdf'                                               => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA9292KT/5076511.rdf'                                               => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA9292KT/5076512.rdf'                                               => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA9292KT/5076516.rdf'                                               => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/KDDI/ISW11HT/ua-profile.xml'                                        => [ 'HTC', 'EVO 4G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/KT/HTC_X515E/ua-profile.xml'                                        => [ 'HTC', 'EVO 4G+', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APC715CKT/2126515.rdf'                                               => [ 'HTC', 'EVO Design 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APC715CKT/2126518.rdf'                                               => [ 'HTC', 'EVO Design 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APC715CKT/3146510.rdf'                                               => [ 'HTC', 'EVO Design 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APC715CKT/4026512.rdf'                                               => [ 'HTC', 'EVO Design 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTC715ABB/1056533.rdf'                                               => [ 'HTC', 'EVO Design 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTC715ABB/1116530.rdf'                                               => [ 'HTC', 'EVO Design 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTC715ABB/1146530.rdf'                                               => [ 'HTC', 'EVO Design 4G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PH441/ua-profile.xml'                                        => [ 'HTC', 'EVO Design 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA7373KT/1176511.rdf'                                               => [ 'HTC', 'EVO Shift 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA7373KT/2726512.rdf'                                               => [ 'HTC', 'EVO Shift 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA7373KT/2766515.rdf'                                               => [ 'HTC', 'EVO Shift 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA7373KT/2766516.rdf'                                               => [ 'HTC', 'EVO Shift 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA7373KT/2776513.rdf'                                               => [ 'HTC', 'EVO Shift 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA7373KT/2776518.rdf'                                               => [ 'HTC', 'EVO Shift 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/ATP515CKIT/2236511.rdf'                                              => [ 'HTC', 'EVO View 4G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PJ03/ua-profile.xml'                                         => [ 'HTC', 'Explorer', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/pcd/adr6410/adr6410.xml'                                                     => [ 'HTC', 'Fireball', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ATT/PM331/ua-profile.xml'                                           => [ 'HTC', 'First', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PG411/ua-profile.xml'                                        => [ 'HTC', 'Flyer', 'Android', DeviceType::TABLET ],
    'http://www.htcmms.com.tw/Brew/Aqua/F5151-1.0.xml'                                                    => [ 'HTC', 'Freestyle', 'Brew', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/att/P4600-1.0.xml'                                                          => [ 'HTC', 'Fuze', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Gratia/ua-profile.xml'                                       => [ 'HTC', 'Gratia', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/HTC_HD_mini_T5555-1.0.xml'                                              => [ 'HTC', 'HD mini', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/HTC_HD2_T8585-1.0.xml'                                                  => [ 'HTC', 'HD2', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/HTC_HD2_T9193-1.0.xml'                                                  => [ 'HTC', 'HD2', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Leo-1.5.xml'                                                            => [ 'HTC', 'HD2', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/voda/HTC_HD2-1.0.xml'                                                       => [ 'HTC', 'HD2', 'Windows Mobile', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA6277KT/1566512.rdf'                                               => [ 'HTC', 'Hero', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA6277KT/2276516.rdf'                                               => [ 'HTC', 'Hero', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA6277KT/2316517.rdf'                                               => [ 'HTC', 'Hero', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/APA6277KT/2326512.rdf'                                               => [ 'HTC', 'Hero', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Hero/ua-profile.xml'                                         => [ 'HTC', 'Hero', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telus/Hero/ua-profile.xml'                                          => [ 'HTC', 'Hero', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ATT/PH39100/ua-profile.xml'                                         => [ 'HTC', 'Holiday', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Alltel/Desire/ua-profile.xml'                                       => [ 'HTC', 'HTC Desire', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/WhitestoneW-1.0.xml'                                                    => [ 'HTC', 'Imagio', 'Windows Mobile', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HTC/HTC_S710d_2_20110301.XML'                                            => [ 'HTC', 'Incredible S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Bell/Vivo/ua-profile.xml'                                           => [ 'HTC', 'Incredible S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PG32/ua-profile.xml'                                         => [ 'HTC', 'Incredible S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/KT/HTC_S710E/ua-profile.xml'                                        => [ 'HTC', 'Incredible S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PK071/ua-profile.xml'                                        => [ 'HTC', 'J', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/KDDI/ISW13HT/ua-profile.xml'                                        => [ 'HTC', 'J', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PL9911/ua-profile.xml'                                       => [ 'HTC', 'J Butterfly', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PL993/ua-profile.xml'                                        => [ 'HTC', 'J Butterfly', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/KDDI/HTL21/ua-profile.xml'                                          => [ 'HTC', 'J Butterfly', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/2Q6jdXut9s/ua-profile.xml'                                   => [ 'HTC', 'J Butterfly (HTL23)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/KDDI/HTL22/ua-profile.xml'                                          => [ 'HTC', 'J One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Bell/Legend/ua-profile.xml'                                         => [ 'HTC', 'Legend', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Legend/ua-profile.xml'                                       => [ 'HTC', 'Legend', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/nTelos/Merge/ua-profile.xml'                                        => [ 'HTC', 'Lexikon', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/love-1.0.xml'                                                           => [ 'HTC', 'Love', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/HTC_Magic/ua-profile.xml'                                    => [ 'HTC', 'Magic', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/HTC_Magic/ua-profile_mr.xml'                                 => [ 'HTC', 'Magic', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/tmo/Mail-1.0.xml'                                                           => [ 'HTC', 'Mail', null, DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/quartz-1.0.xml'                                                         => [ 'HTC', 'Max 4G', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Merge/ua-profile.xml'                                        => [ 'HTC', 'Merge', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/PPC6800/3566510.rdf'                                                 => [ 'HTC', 'Mogul', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Breeze-2.0.xml'                                                         => [ 'HTC', 'MTeoR', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/common/NexusOne/ua-profile.xml'                                     => [ 'HTC', 'Nexus One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTC0P3P7-Chameleon/3026515.rdf'                                      => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-11/3056516.rdf'                                             => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-2011011301/3046512.rdf'                                     => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-2011011301/62365110.rdf'                                    => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-2011011301/6236516.rdf'                                     => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-Chameleon/12965110.rdf'                                     => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-Chameleon/1296517.rdf'                                      => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-Chameleon/1316512.rdf'                                      => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-Chameleon/3046512.rdf'                                      => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-Chameleon/3056516.rdf'                                      => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-Chameleon/4066519.rdf'                                      => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-Chameleon/5036513.rdf'                                      => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-Chameleon/5056512.rdf'                                      => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-Chameleon/6166512.rdf'                                      => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-Chameleon/62365110.rdf'                                     => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-Chameleon/6236516.rdf'                                      => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/12965110.rdf'                                        => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/1296517.rdf'                                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/1316512.rdf'                                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/3046512.rdf'                                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/3056515.rdf'                                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/3056516.rdf'                                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/4066514.rdf'                                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/4066519.rdf'                                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/42ONE Inverted ROM v12.rdf'                          => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/5036513.rdf'                                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/5056512.rdf'                                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/6166512.rdf'                                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/62365110.rdf'                                        => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/6236516.rdf'                                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/6236517.rdf'                                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/Ava-OneV1//ALPHA1.rdf'                               => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/Bad Boyz Sprint ONE M7 Lollipop v20.rdf'             => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/Bad Boyz Sprint ONE M7 Lollipop v30.rdf'             => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/Bad Boyz Sprint ONE Sense 6 v10.rdf'                 => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/benny\'s 43.rdf'                                      => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/BSC Tranquil One RLS42.rdf'                          => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/InsertCoin 711.rdf'                                  => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/RageOne CDMA v100.rdf'                               => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/RageOne v151.rdf'                                    => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/Stock 12965110 Odex by -viperboy-.rdf'               => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/Stock w Goodies One 115.rdf'                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/Stock w Goodies One 201.rdf'                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/Stock.rdf'                                           => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/TrickDroid 551.rdf'                                  => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/ViperOne 350.rdf'                                    => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/ViperOne 701.rdf'                                    => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTCPN702-SPRINT/viperROM One v102.rdf'                               => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/PN071/ua-SPRINT/ViperOne 800.rdf'                                    => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/PN071/ua-SPRINT/ViperOne 900.rdf'                                    => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://mms.cellcom.com/uaprofs/htc_M7_8M.xml'                                                        => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HTC/HTC_802d_1_20130301.XML'                                             => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HTC/HTC_One_1_20130301.XML'                                              => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://pix.cspire.com/UA/profile/htc/PN072/PN072.xml'                                                => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://uaprof.qma.com.tw/HTC_802d.xml'                                                               => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/htc/htc6500lvw/htc6500lvw.xml'                                               => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ACG/PN072/ua-profile_1M.xml'                                        => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/AMX/PN0711/ua-profile.xml'                                          => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ATT/PN071/ua-profile.xml'                                           => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/BM/801a/ua-profile.xml'                                             => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/CBW/PN071/ua-profile.xml'                                           => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/82ZtOKlRiO/ua-profile.xml'                                   => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PN071/ua-profile.xml'                                        => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PN0711/ua-profile.xml'                                       => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PN072/ua-profile.xml'                                        => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PN07310/ua-profile.xml'                                      => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PN077U/ua-profile.xml'                                       => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PN078T/ua-profile.xml'                                       => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PN078U/ua-profile.xml'                                       => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PN078W/ua-profile.xml'                                       => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/LRA/PN07310/ua-profile_500K.xml'                                    => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Nextel/PN071/ua-profile.xml'                                        => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/O2/PN071/ua-profile.xml'                                            => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/PN071/ua-profile.xml'                                        => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Rogers/801a/ua-profile.xml'                                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telcel/PN071/ua-profile.xml'                                        => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telstra/PN071/ua-profile.xml'                                       => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telus/801a/ua-profile.xml'                                          => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TIM/PN071/ua-profile.xml'                                           => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/PN071/ua-profile.xml'                                           => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMOUS/PN071/ua-profile.xml'                                         => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TNZ/PN071/ua-profile.xml'                                           => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Vodafone/PN071/ua-profile.xml'                                      => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/WIND/PN071/ua-profile.xml'                                          => [ 'HTC', 'One', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/2PQ93-SPRINT/1106511.rdf'                                            => [ 'HTC', 'One (A9)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/2PQ93-SPRINT/1576511.rdf'                                            => [ 'HTC', 'One (A9)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/2PQ93-SPRINT/1606514.rdf'                                            => [ 'HTC', 'One (A9)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/fJ1ZSlse0F/ua-profile.xml'                                   => [ 'HTC', 'One (A9)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/rjXLBq21RC/ua-profile.xml'                                   => [ 'HTC', 'One (A9)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PAJ5-Chameleon/1116512.rdf'                                         => [ 'HTC', 'One (E8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PAJ5-Chameleon/1226511.rdf'                                         => [ 'HTC', 'One (E8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PAJ5-Chameleon/23265111.rdf'                                        => [ 'HTC', 'One (E8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PAJ5-MVNO/2326517.rdf'                                              => [ 'HTC', 'One (E8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PAJ5-SPRINT/1076511.rdf'                                            => [ 'HTC', 'One (E8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PAJ5-SPRINT/1226511.rdf'                                            => [ 'HTC', 'One (E8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PAJ5-SPRINT/23265111.rdf'                                           => [ 'HTC', 'One (E8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PAJ5-SPRINT/2326517.rdf'                                            => [ 'HTC', 'One (E8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PAJ5-SPRINT/3106516.rdf'                                            => [ 'HTC', 'One (E8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/3vpxk6Z5ZS/ua-profile.xml'                                   => [ 'HTC', 'One (E8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/q5lv3bcp7D/ua-profile.xml'                                   => [ 'HTC', 'One (E8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Uriwn0DyqH/ua-profile.xml'                                   => [ 'HTC', 'One (E8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/zlxtuCDKgt/ua-profile.xml'                                   => [ 'HTC', 'One (E8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/CMCC/mifaCnXW7o/ua-profile.xml'                                     => [ 'HTC', 'One (E9)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/mifaCnXW7o/ua-profile.xml'                                   => [ 'HTC', 'One (E9)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/mK8zhMmjOr/ua-profile.xml'                                   => [ 'HTC', 'One (E9)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/CMCC/cIIxkEojnw/ua-profile.xml'                                     => [ 'HTC', 'One (M8 Eye)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/cIIxkEojnw/ua-profile.xml'                                   => [ 'HTC', 'One (M8 Eye)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/RIGWqFpTj2/ua-profile.xml'                                   => [ 'HTC', 'One (M8 Eye)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-Chameleon/11265117.rdf'                                         => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-Chameleon/15465110.rdf'                                         => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-Chameleon/1546518.rdf'                                          => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-Chameleon/2166514.rdf'                                          => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-Chameleon/3306512.rdf'                                          => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-Chameleon/42065110.rdf'                                         => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-Chameleon/4209065110.rdf'                                       => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-Chameleon/42565114.rdf'                                         => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-Chameleon/42565118.rdf'                                         => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-Chameleon/6206513.rdf'                                          => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-MVNO/2166514.rdf'                                               => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-MVNO/42065110.rdf'                                              => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-MVNO/42565114.rdf'                                              => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/15465110.rdf'                                            => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/1546518.rdf'                                             => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/2166514.rdf'                                             => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/3306512.rdf'                                             => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/3316512.rdf'                                             => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/42065110.rdf'                                            => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/42565114.rdf'                                            => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/42565118.rdf'                                            => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/42565418.rdf'                                            => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/6206513.rdf'                                             => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/6206543.rdf'                                             => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/Bad Boyz Sprint ONE M8 Harman v21 ART.rdf'               => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/Bad Boyz Sprint ONE M8 L Sense 7 v10.rdf'                => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/Bad Boyz Sprint ONE M8 Lollipop v30.rdf'                 => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/Bad Boyz Sprint ONE M8 Lollipop v32.rdf'                 => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/InsertCoin 716.rdf'                                      => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/InsertCoin 719.rdf'                                      => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831C-SPRINT/ViperOneM8 430.rdf'                                      => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831CH-Chameleon/15465413.rdf'                                        => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831CH-Chameleon/42065410.rdf'                                        => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831CH-Chameleon/42565414.rdf'                                        => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/831CH-Chameleon/6206543.rdf'                                         => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/1546518.rdf'                                                => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/15465413.rdf'                                               => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/15465415.rdf'                                               => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/1546549.rdf'                                                => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/2166544.rdf'                                                => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/3306512.rdf'                                                => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/3306542.rdf'                                                => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/3316542.rdf'                                                => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/42065410.rdf'                                               => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/42565114.rdf'                                               => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/42565414.rdf'                                               => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/42565418.rdf'                                               => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/6206513.rdf'                                                => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/6206543.rdf'                                                => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/Bad Boyz Sprint ONE M8 L Sense 7 v10.rdf'                   => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/Bad Boyz Sprint ONE M8 Lollipop v30.rdf'                    => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/Bad Boyz Sprint ONE M8 Lollipop v32 HK.rdf'                 => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/SkyDragon M8 v 100 Sprint Sense 7.rdf'                      => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/SkyDragon M8 v 80 Sprint Sense 7.rdf'                       => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/ViperOneM8 430.rdf'                                         => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/AP831CHK/ViperOneM8 502.rdf'                                         => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://mms.cellcom.com/uaprofs/htc_M8_8M.xml'                                                        => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/htc/htc6525lvw/htc6525lvw.xml'                                               => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/AMX/fL0fd1AcEY/ua-profile.xml'                                      => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ATT/fL0fd1AcEY/ua-profile.xml'                                      => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/BM/fL0fd1AcEY/ua-profile.xml'                                       => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/0YC9TSsPzu/ua-profile.xml'                                   => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/3EdRGieOMj/ua-profile.xml'                                   => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/3f2Kak1ivc/ua-profile.xml'                                   => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/5iCu8aRdPo/ua-profile.xml'                                   => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/ABUe39rODk/ua-profile.xml'                                   => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/fL0fd1AcEY/ua-profile.xml'                                   => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/JLnzRx2IlE/ua-profile.xml'                                   => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/MaGxKOfxPJ/ua-profile.xml'                                   => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/LRA/82ZtOKlRiO/ua-profile_500K.xml'                                 => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/O2/fL0fd1AcEY/ua-profile.xml'                                       => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/fL0fd1AcEY/ua-profile.xml'                                   => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Rogers/fL0fd1AcEY/ua-profile.xml'                                   => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/SFR/fL0fd1AcEY/ua-profile.xml'                                      => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telcel/fL0fd1AcEY/ua-profile.xml'                                   => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telstra/fL0fd1AcEY/ua-profile.xml'                                  => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telus/fL0fd1AcEY/ua-profile.xml'                                    => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TIM/fL0fd1AcEY/ua-profile.xml'                                      => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/fL0fd1AcEY/ua-profile.xml'                                      => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMOUS/fL0fd1AcEY/ua-profile.xml'                                    => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TNZ/fL0fd1AcEY/ua-profile.xml'                                      => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Vodafone/fL0fd1AcEY/ua-profile.xml'                                 => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/WIND/fL0fd1AcEY/ua-profile.xml'                                     => [ 'HTC', 'One (M8)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PPzlrbleWf/ua-profile.xml'                                   => [ 'HTC', 'One (M8s)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/PPzlrbleWf/ua-profile.xml'                                      => [ 'HTC', 'One (M8s)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Vodafone/PPzlrbleWf/ua-profile.xml'                                 => [ 'HTC', 'One (M8s)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/RBuZib3xtL/ua-profile.xml'                                   => [ 'HTC', 'One (M9 Plus)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PJA2-Chameleon/3416514.rdf'                                         => [ 'HTC', 'One (M9)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PJA2-SPRINT/13265130.rdf'                                           => [ 'HTC', 'One (M9)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PJA2-SPRINT/21165119.rdf'                                           => [ 'HTC', 'One (M9)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PJA2-SPRINT/2665111.rdf'                                            => [ 'HTC', 'One (M9)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PJA2-SPRINT/3416514.rdf'                                            => [ 'HTC', 'One (M9)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/0PJA2-SPRINT/Bad Boyz Sprint ONE M9 v20.rdf'                         => [ 'HTC', 'One (M9)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ATT/xbKGNh1DoH/ua-profile.xml'                                      => [ 'HTC', 'One (M9)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/CMCC/c8HDMjoq7Q/ua-profile.xml'                                     => [ 'HTC', 'One (M9)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/15Y7tWDPNn/ua-profile.xml'                                   => [ 'HTC', 'One (M9)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/uej4ao2E9J/ua-profile.xml'                                   => [ 'HTC', 'One (M9)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/WDfCkeuHE6/ua-profile.xml'                                   => [ 'HTC', 'One (M9)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/WOCIeZasGc/ua-profile.xml'                                   => [ 'HTC', 'One (M9)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/xbKGNh1DoH/ua-profile.xml'                                   => [ 'HTC', 'One (M9)', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/bDZc52YZeG/ua-profile.xml'                                   => [ 'HTC', 'One (X9)', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTC0P3P7-Chameleon/%CDMA_ROM_VERSION%.rdf'                           => [ 'HTC', 'One Max', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTC0P3P7-Chameleon/0576512.rdf'                                      => [ 'HTC', 'One Max', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTC0P3P7-Chameleon/3036513.rdf'                                      => [ 'HTC', 'One Max', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTC0P3P7-SPRINT/1166514.rdf'                                         => [ 'HTC', 'One Max', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTC0P3P7-SPRINT/2096511.rdf'                                         => [ 'HTC', 'One Max', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTC0P3P7-SPRINT/3026515.rdf'                                         => [ 'HTC', 'One Max', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/HTC0P3P7-SPRINT/SkyDragon Max v 20 Sprint.rdf'                       => [ 'HTC', 'One Max', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/0O5MHN0Mig/ua-profile.xml'                                   => [ 'HTC', 'One Max', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/arYPBWMPCx/ua-profile.xml'                                   => [ 'HTC', 'One Max', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/LDdI1qcVhL/ua-profile.xml'                                   => [ 'HTC', 'One Max', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/V79ccMv3KO/ua-profile.xml'                                   => [ 'HTC', 'One Max', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/w778dYholc/ua-profile.xml'                                   => [ 'HTC', 'One Max', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/O2/w778dYholc/ua-profile.xml'                                       => [ 'HTC', 'One Max', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/w778dYholc/ua-profile.xml'                                      => [ 'HTC', 'One Max', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Vodafone/w778dYholc/ua-profile.xml'                                 => [ 'HTC', 'One Max', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/CMCC/15Y7tWDPNn/ua-profile.xml'                                     => [ 'HTC', 'One ME', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ATT/PO582/ua-profile.xml'                                           => [ 'HTC', 'One Mini', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PO581/ua-profile.xml'                                        => [ 'HTC', 'One Mini', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PO582/ua-profile.xml'                                        => [ 'HTC', 'One Mini', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/O2/PO582/ua-profile.xml'                                            => [ 'HTC', 'One Mini', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/PO582/ua-profile.xml'                                        => [ 'HTC', 'One Mini', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Rogers/PO582/ua-profile.xml'                                        => [ 'HTC', 'One Mini', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telstra/PO582//ua-profile.xml'                                      => [ 'HTC', 'One Mini', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TIM/PO582/ua-profile.xml'                                           => [ 'HTC', 'One Mini', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/PO582/ua-profile.xml'                                           => [ 'HTC', 'One mini', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/UlrIAz8JY9/ua-profile.xml'                                   => [ 'HTC', 'One Mini 2', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telstra/UlrIAz8JY9/ua-profile.xml'                                  => [ 'HTC', 'One Mini 2', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/UlrIAz8JY9/ua-profile.xml'                                      => [ 'HTC', 'One Mini 2', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Vodafone/UlrIAz8JY9/ua-profile.xml'                                 => [ 'HTC', 'One Mini 2', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Bell/Z520m/ua-profile.xml'                                          => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Bouygues/PJ401/ua-profile.xml'                                      => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Canada/Z520m/ua-profile.xml'                                        => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/CBW/PJ401/ua-profile.xml'                                           => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PJ401/ua-profile.xml'                                        => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PJ402/ua-profile.xml'                                        => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/TX408/ua-profile.xml'                                        => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Mobilicity/Z520m/ua-profile.xml'                                    => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Nextel/PJ401/ua-profile.xml'                                        => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/O2/PJ401/ua-profile.xml'                                            => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/PJ401/ua-profile.xml'                                        => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Rogers/Z520m/ua-profile.xml'                                        => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telcel/PJ401/ua-profile.xml'                                        => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telstra/PJ401/ua-profile.xml'                                       => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telus/Z520m/ua-profile.xml'                                         => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TIM/PJ401/ua-profile.xml'                                           => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/PJ401/ua-profile.xml'                                           => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMOUS/PJ401/ua-profile.xml'                                         => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Videotron/Z520m/ua-profile.xml'                                     => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Vodafone/PJ401/ua-profile.xml'                                      => [ 'HTC', 'One S', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HTC/HTC_T528d_1_20120801.XML'                                            => [ 'HTC', 'One SC', 'Android', DeviceType::MOBILE ],
    'http://uaprof.qma.com.tw/HTC_One_SC_T528d.xml'                                                       => [ 'HTC', 'One SC', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PM6010/ua-profile.xml'                                       => [ 'HTC', 'One SC', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PM6011/ua-profile.xml'                                       => [ 'HTC', 'One ST', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PM6012/ua-profile.xml'                                       => [ 'HTC', 'One SU', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/C525c-BOOST/1116531.rdf'                                             => [ 'HTC', 'One SV', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/C525c-BOOST/2066535.rdf'                                             => [ 'HTC', 'One SV', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/C525c-BOOST/2066536.rdf'                                             => [ 'HTC', 'One SV', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/C525c-BOOST/3056533.rdf'                                             => [ 'HTC', 'One SV', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/C525c-BOOST/3056534.rdf'                                             => [ 'HTC', 'One SV', 'Android', DeviceType::MOBILE ],
    'http://mms.mycricket.com/htc_h3000c.xml'                                                             => [ 'HTC', 'One SV', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Bouygues/PL801/ua-profile.xml'                                      => [ 'HTC', 'One SV', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PL801/ua-profile.xml'                                        => [ 'HTC', 'One SV', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PL8011/ua-profile.xml'                                       => [ 'HTC', 'One SV', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/PL801/ua-profile.xml'                                        => [ 'HTC', 'One SV', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TIM/PL8011/ua-profile.xml'                                          => [ 'HTC', 'One SV', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/PL801/ua-profile.xml'                                           => [ 'HTC', 'One SV', 'Android', DeviceType::MOBILE ],
    'http://mms.mycricket.com/htc_h2000c.xml'                                                             => [ 'HTC', 'One V', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/HTC/T120C-VMUB/1.0/UAProf.xml'                                               => [ 'HTC', 'One V', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Bell/T320a/ua-profile.xml'                                          => [ 'HTC', 'One V', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PJ835/ua-profile.xml'                                        => [ 'HTC', 'One V', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PK76/ua-profile.xml'                                         => [ 'HTC', 'One V', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PK7631/ua-profile.xml'                                       => [ 'HTC', 'One V', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telcel/PK76/ua-profile.xml'                                         => [ 'HTC', 'One V', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telstra/PJ831/ua-profile.xml'                                       => [ 'HTC', 'One V', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telus/T320a/ua-profile.xml'                                         => [ 'HTC', 'One V', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/PK76/ua-profile.xml'                                            => [ 'HTC', 'One V', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TNZ/PK76/ua-profile.xml'                                            => [ 'HTC', 'One V', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ATT/PM361/ua-profile.xml'                                           => [ 'HTC', 'One VX', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ATT/PJ831/ua-profile.xml'                                           => [ 'HTC', 'One X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PJ461/ua-profile.xml'                                        => [ 'HTC', 'One X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PJ831/ua-profile.xml'                                        => [ 'HTC', 'One X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PM3511/ua-profile.xml'                                       => [ 'HTC', 'One X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/O2/PJ461/ua-profile.xml'                                            => [ 'HTC', 'One X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/O2/PJ831/ua-profile.xml'                                            => [ 'HTC', 'One X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/O2/PM3511/ua-profile.xml'                                           => [ 'HTC', 'One X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/PJ461/ua-profile.xml'                                        => [ 'HTC', 'One X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Rogers/X325a/ua-profile.xml'                                        => [ 'HTC', 'One X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telcel/PJ461/ua-profile.xml'                                        => [ 'HTC', 'One X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telus/X325a/ua-profile.xml'                                         => [ 'HTC', 'One X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/PJ461/ua-profile.xml'                                           => [ 'HTC', 'One X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/PJ831/ua-profile.xml'                                           => [ 'HTC', 'One X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TNZ/PJ461/ua-profile.xml'                                           => [ 'HTC', 'One X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Vodafone/PJ461/ua-profile.xml'                                      => [ 'HTC', 'One X', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ATT/PM631/ua-profile.xml'                                           => [ 'HTC', 'One X+', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PM631/ua-profile.xml'                                        => [ 'HTC', 'One X+', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telus/X525a/ua-profile.xml'                                         => [ 'HTC', 'One X+', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HTC/HTC_X720d_1_20120401.XML'                                            => [ 'HTC', 'One XC', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Vodafone/PJ831/ua-profile.xml'                                      => [ 'HTC', 'One XL', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PJ462/ua-profile.xml'                                        => [ 'HTC', 'One XT', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Oxygen-1.0.xml'                                                         => [ 'HTC', 'Oxygen', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/CedarW-1.0.xml'                                                         => [ 'HTC', 'Ozone', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/wave-1.0.xml'                                                           => [ 'HTC', 'P3000', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/artemis-1.0.xml'                                                        => [ 'HTC', 'P3300', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/elf-1.0.xml'                                                            => [ 'HTC', 'P3450', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Trinity-1.0.xml'                                                        => [ 'HTC', 'P3600', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Herald-1.0.xml'                                                         => [ 'HTC', 'P4350', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/sedna-1.0.xml'                                                          => [ 'HTC', 'P6500', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Panda-1.0.xml'                                                          => [ 'HTC', 'Panda', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Pharos-1.0.xml'                                                         => [ 'HTC', 'Pharos', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Prophet-2.0.xml'                                                        => [ 'HTC', 'Prophet', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/pu10-2.0.xml'                                                           => [ 'HTC', 'PU10', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Bell/Holiday/ua-profile.xml'                                        => [ 'HTC', 'Raider', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Rogers/Holiday/ua-profile.xml'                                      => [ 'HTC', 'Raider', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PH39/ua-profile.xml'                                         => [ 'HTC', 'Raider 4G', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/pcd/adr6425/adr6425.xml'                                                     => [ 'HTC', 'Rezound', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/pcd/adr6330/adr6330.xml'                                                     => [ 'HTC', 'Rhyme', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PI4610/ua-profile.xml'                                       => [ 'HTC', 'Rhyme', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PD421/ua-profile.xml'                                        => [ 'HTC', 'S610d', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Cavalier-1.0.xml'                                                       => [ 'HTC', 'S630', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Vox-1.0.xml'                                                            => [ 'HTC', 'S710', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Volans-1.0.xml'                                                         => [ 'HTC', 'S730', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/HTC_S740-1.0.xml'                                                       => [ 'HTC', 'S740', null, DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PH11/ua-profile.xml'                                         => [ 'HTC', 'Salsa', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Bell/Pyramid/ua-profile.xml'                                        => [ 'HTC', 'Sensation', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/HTC_Sensation_4G/ua-profile.xml'                             => [ 'HTC', 'Sensation', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PG58/ua-profile.xml'                                         => [ 'HTC', 'Sensation', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PG5814/ua-profile.xml'                                       => [ 'HTC', 'Sensation', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Orange/PG58/ua-profile.xml'                                         => [ 'HTC', 'Sensation', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telstra/Z710a/ua-profile.xml'                                       => [ 'HTC', 'Sensation', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/Pyramid/ua-profile.xml'                                         => [ 'HTC', 'Sensation', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PG5813/ua-profile.xml'                                       => [ 'HTC', 'Sensation XE', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/SensationXE/ua-profile.xml'                                  => [ 'HTC', 'Sensation XE', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PI39/ua-profile.xml'                                         => [ 'HTC', 'Sensation XL', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/KT/HTC-X315E/ua-profile.xml'                                        => [ 'HTC', 'Sensation XL', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/Runnymede/ua-profile.xml'                                       => [ 'HTC', 'Sensation XL', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/tme/HTC_Snap_S521-1.0.xml'                                                  => [ 'HTC', 'Snap', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/st20-1.0.xml'                                                           => [ 'HTC', 'ST20', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/ATT/PH06130/ua-profile.xml'                                         => [ 'HTC', 'Status', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PK793/ua-profile.xml'                                        => [ 'HTC', 'T327t', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HTC/HTC_T329d_1_20120901.XML'                                            => [ 'HTC', 'T329d', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HTC/HTC_T9199_2_20100902.xml'                                            => [ 'HTC', 'T9199', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/HTC_TATTOO_A3288/ua-profile.xml'                             => [ 'HTC', 'Tattoo', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Tattoo/ua-profile.xml'                                       => [ 'HTC', 'Tattoo', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/UTSTARCOM/PG051/ua-profile.xml'                                     => [ 'HTC', 'ThunderBolt', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/pcd/adr6325/adr6325.xml'                                                     => [ 'HTC', 'Thunderbolt 4G', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Titan-1.0.xml'                                                          => [ 'HTC', 'Titan', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/tornado-2.0.xml'                                                        => [ 'HTC', 'Tornado', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/brightstar/ELFIN-1.0.xml'                                                   => [ 'HTC', 'Touch', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Elfin_Opera-1.0.xml'                                                    => [ 'HTC', 'Touch', 'Windows', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/HTC_Touch_Viva_T2223-1.0.xml'                                           => [ 'HTC', 'Touch', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/HTC_Touch2_T3333-1.0.xml'                                               => [ 'HTC', 'Touch 2', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/mega-1.0.xml'                                                           => [ 'HTC', 'Touch 2', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/HTC_Touch_3G_T3232-1.0.xml'                                             => [ 'HTC', 'Touch 3G', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/voda/Jade-1.0.xml'                                                          => [ 'HTC', 'Touch 3G', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Polaris-1.0.xml'                                                        => [ 'HTC', 'Touch Cruise', 'Windows Mobile', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/MP6950SP/1096515.rdf'                                                => [ 'HTC', 'Touch Diamond', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/diamond-1.0.xml'                                                        => [ 'HTC', 'Touch Diamond', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/victor-1.0.xml'                                                         => [ 'HTC', 'Touch Diamond', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/VictorC-1.0.xml'                                                        => [ 'HTC', 'Touch Diamond', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/VictorCT-1.0.xml'                                                       => [ 'HTC', 'Touch Diamond', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/voda/diamond-1.0.xml'                                                       => [ 'HTC', 'Touch Diamond', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/HTC_Touch_Diamond2_T5353-1.0.xml'                                       => [ 'HTC', 'Touch Diamond 2', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/HTC_Touch_Diamond2_T5360-1.0.xml'                                       => [ 'HTC', 'Touch Diamond 2', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/neon-1.0.xml'                                                           => [ 'HTC', 'Touch Dual', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/NeonC_BM-1.0.xml'                                                       => [ 'HTC', 'Touch Dual', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/nike-1.0.xml'                                                           => [ 'HTC', 'Touch Dual', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/HTC_Touch_HD_T8282-1.0.xml'                                             => [ 'HTC', 'Touch HD', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/voda/HTC_Touch_HD_T8282-1.0.xml'                                            => [ 'HTC', 'Touch HD', 'Windows Mobile', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/PPC6850SP/1036513.rdf'                                               => [ 'HTC', 'Touch Pro', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/HermannC_BM-1.0.xml'                                                    => [ 'HTC', 'Touch Pro', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/HTC_Touch_Pro_T7272-1.0.xml'                                            => [ 'HTC', 'Touch Pro', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Raphael-1.0.xml'                                                        => [ 'HTC', 'Touch Pro', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/swisscom/HTC_Touch_Pro-1.0.xml'                                             => [ 'HTC', 'Touch Pro', 'Windows Mobile',  ],
    'http://www.htcmms.com.tw/voda/HTC_Touch_Pro-1.0.xml'                                                 => [ 'HTC', 'Touch Pro', 'Windows Mobile', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/PPCT7380SP/1216514.rdf'                                              => [ 'HTC', 'Touch Pro 2', 'Windows Mobile', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HTC/PPCT7380SP/2046514.rdf'                                              => [ 'HTC', 'Touch Pro 2', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/HTC_Touch_Pro2_T7373-1.0.xml'                                           => [ 'HTC', 'Touch Pro 2', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/RhodiumW-1.0.xml'                                                       => [ 'HTC', 'Touch Pro 2', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Hermes-1.0.xml'                                                         => [ 'HTC', 'TyTN', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Hermes-2.0.xml'                                                         => [ 'HTC', 'TyTN', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/kaiser-1.0.xml'                                                         => [ 'HTC', 'TyTN II', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/LaQXqvY3I3/ua-profile.xml'                                   => [ 'HTC', 'U Ultra', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/rlIC3c716z/ua-profile.xml'                                   => [ 'HTC', 'U11', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/KMKeMMeWHK/ua-profile.xml'                                   => [ 'HTC', 'U11 Plus', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/Wildfire/ua-profile.xml'                                     => [ 'HTC', 'Wildfire', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telstra/A3335/ua-profile.xml'                                       => [ 'HTC', 'Wildfire', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TME/Wildfire/ua-profile.xml'                                        => [ 'HTC', 'Wildfire', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/Buzz/ua-profile.xml'                                            => [ 'HTC', 'Wildfire', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Alltel/Bee/ua-profile.xml'                                          => [ 'HTC', 'Wildfire 6225', 'Android', DeviceType::MOBILE ],
    'http://mmsc1.uscc.net/mmsc/MMS'                                                                      => [ 'HTC', 'Wildfire S', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HTC/HTC_A510c_1_20110425.XML'                                            => [ 'HTC', 'Wildfire S', 'Android', DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/HTC-PG762.xml'                                                     => [ 'HTC', 'Wildfire S', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/HTC/A510c-VMUB/1.0/UAProf.xml'                                               => [ 'HTC', 'Wildfire S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Bell/Marvel/ua-profile.xml'                                         => [ 'HTC', 'Wildfire S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/PG76/ua-profile.xml'                                         => [ 'HTC', 'Wildfire S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Common/WildfireS/ua-profile.xml'                                    => [ 'HTC', 'Wildfire S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/Telstra/A510b/ua-profile.xml'                                       => [ 'HTC', 'Wildfire S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/Android/TMO/Marvel/ua-profile.xml'                                          => [ 'HTC', 'Wildfire S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/TME/WildfireS/ua-profile.xml'                                               => [ 'HTC', 'Wildfire S', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Wizard-2.0.xml'                                                         => [ 'HTC', 'Wizard', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/X1i-1.0.xml'                                                            => [ 'HTC', 'X1i', 'Windows Mobile', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HTC/HTC_Z510d_1_20110831.XML'                                            => [ 'HTC', 'Z510d', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_A199_1_20130121.xml'                                         => [ 'Huawei', 'A199', 'Android', DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/Huawei-M920.xml'                                                   => [ 'Huawei', 'Activa 4G', 'Android', DeviceType::MOBILE ],
    'http://mms.mycricket.com/Huawei-M860.xml'                                                            => [ 'Huawei', 'Ascend', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Huawei_M860_Normal.xml'                                                => [ 'Huawei', 'Ascend', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiC8812CDMA-NORMAL.xml'                                            => [ 'Huawei', 'Ascend C8812', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiC8812CDMA2000-NORMAL.xml'                                        => [ 'Huawei', 'Ascend C8812', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiC8812WCDMA-NORMAL.xml'                                           => [ 'Huawei', 'Ascend C8812', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8812E_1_20120713.xml'                                       => [ 'Huawei', 'Ascend C8812', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8812E_1_20121018.xml'                                       => [ 'Huawei', 'Ascend C8812', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8812_1_20120228.xml'                                        => [ 'Huawei', 'Ascend C8812', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8813D_1_20121018.xml'                                       => [ 'Huawei', 'Ascend C8813', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8813Q_1_20130108.xml'                                       => [ 'Huawei', 'Ascend C8813', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8813Q_1_20130425.xml'                                       => [ 'Huawei', 'Ascend C8813', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8813_1_20121018.xml'                                        => [ 'Huawei', 'Ascend C8813', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8813Q_1_20121018.xml'                                       => [ 'Huawei', 'Ascend C8815', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8816D_1_20131107.xml'                                       => [ 'Huawei', 'Ascend C8816', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8816_1_20131106.xml'                                        => [ 'Huawei', 'Ascend C8816', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U9501L_UAProfile.xml'                                           => [ 'Huawei', 'Ascend D LTE', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U9510E_UAProfile.xml'                                           => [ 'Huawei', 'Ascend D quad', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U9510_UAProfile.xml'                                            => [ 'Huawei', 'Ascend D quad', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U9500_UAProfile.xml'                                            => [ 'Huawei', 'Ascend D1', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_T9510E_UAProfile.xml'                                           => [ 'Huawei', 'Ascend D1 Quad XL', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U9500E_UAProfile.xml'                                           => [ 'Huawei', 'Ascend D1 XL', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_D2-0082_Global_UAProfile.XML'                                   => [ 'Huawei', 'Ascend D2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_D2_6114_UAProfile.xml'                                          => [ 'Huawei', 'Ascend D2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_D2-0082_1_20121221_UAProfile.XML'                            => [ 'Huawei', 'Ascend D2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_D2-2010_1_20121026_UAProfile.XML'                            => [ 'Huawei', 'Ascend D2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_D2-2010_2_20130106_UAProfile.XML'                            => [ 'Huawei', 'Ascend D2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_D2-5000_2_20121218_UAProfile.XML'                            => [ 'Huawei', 'Ascend D2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8815GPRS-NORMAL-ICS.xml'                                        => [ 'Huawei', 'Ascend G300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8815GPRS-NORMAL.xml'                                            => [ 'Huawei', 'Ascend G300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8815NWCDMA-NORMAL.xml'                                          => [ 'Huawei', 'Ascend G300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8815WCDMA-NORMAL.xml'                                           => [ 'Huawei', 'Ascend G300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8818GPRS-NORMAL.xml'                                            => [ 'Huawei', 'Ascend G300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8818WCDMA-NORMAL.xml'                                           => [ 'Huawei', 'Ascend G300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_c8800_2_20111116.xml'                                        => [ 'Huawei', 'Ascend G300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8810_2_20111116.xml'                                        => [ 'Huawei', 'Ascend G300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8816WCDMA-NORMAL.xml'                                           => [ 'Huawei', 'Ascend G301', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.huawei.com/uaprof/HUAWEI_T8828-1.0.xml'                                             => [ 'Huawei', 'Ascend G305T', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_T8830_UAProfile.xml'                                            => [ 'Huawei', 'Ascend G309T', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_T8830Pro_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G309T Pro', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8681GPRS-VTR.xml'                                               => [ 'Huawei', 'Ascend G312', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8681GPRS-WIND.xml'                                              => [ 'Huawei', 'Ascend G312', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG330-0100GPRS.xml'                                               => [ 'Huawei', 'Ascend G330', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8825-1GPRS.xml'                                                 => [ 'Huawei', 'Ascend G330', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8825DGPRS-Unicom.xml'                                           => [ 'Huawei', 'Ascend G330', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8825D_1_20120530.xml'                                       => [ 'Huawei', 'Ascend G330C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_U8825D_1_20121018.xml'                                       => [ 'Huawei', 'Ascend G330D', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8836Dv100CHNC00WCDMA.xml'                                       => [ 'Huawei', 'Ascend G500', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8826D_1_20120926.xml'                                       => [ 'Huawei', 'Ascend G500C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG510-0010GPRS-Normal.xml'                                        => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG510-0010GPRS-Russia.xml'                                        => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG510-0010GPRS-UNICOM.xml'                                        => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG510-0010GPRS.xml'                                               => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG510-0100GPRS-FL.xml'                                            => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG510-0100GPRS-NORMAL.xml'                                        => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG510-0100GPRS-Vodafone.xml'                                      => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG510-0100GPRS.xml'                                               => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG510-0100WCDMA-FL.xml'                                           => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG510-0200GPRS-NORMAL.xml'                                        => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG510-0200GPRS-Yoigo.xml'                                         => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG510-0200GPRS.xml'                                               => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG510-0251GPRS-DRM.xml'                                           => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG510-0251GPRS-NORMAL.xml'                                        => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_T8951_UAProfile.xml'                                            => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_U8951_1_20121018.xml'                                        => [ 'Huawei', 'Ascend G510', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG520-0000GPRS-UNICOM.xml'                                        => [ 'Huawei', 'Ascend G520', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G520-5000_UAProfile.xml'                                        => [ 'Huawei', 'Ascend G520', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G520-T10_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G520', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G520-U00_1_20121018.xml'                                     => [ 'Huawei', 'Ascend G520', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG525-U00GPRS-NORMAL.xml'                                         => [ 'Huawei', 'Ascend G525', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG525-U00GPRS-UNICOM.xml'                                         => [ 'Huawei', 'Ascend G525', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG525-U00GPRS.xml'                                                => [ 'Huawei', 'Ascend G525', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G525-UOO_1_20130425.xml'                                     => [ 'Huawei', 'Ascend G525', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HUAWEI/PLTFH882KT/H882LV100R001C378B145.rdf'                             => [ 'Huawei', 'Ascend G526', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG526-L11LTE-Normal.xml'                                          => [ 'Huawei', 'Ascend G526', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG526-L22LTE-Normal.xml'                                          => [ 'Huawei', 'Ascend G526', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG526-L33LTE-Normal.xml'                                          => [ 'Huawei', 'Ascend G526', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG527-U081-Normal.xml'                                            => [ 'Huawei', 'Ascend G527', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG535.xml'                                                        => [ 'Huawei', 'Ascend G535', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG6L11-3G.xml'                                                    => [ 'Huawei', 'Ascend G6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG6L11_KK_EU.xml'                                                 => [ 'Huawei', 'Ascend G6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG6L22.xml'                                                       => [ 'Huawei', 'Ascend G6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG6L33.xml'                                                       => [ 'Huawei', 'Ascend G6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G6-T00_EMUI3_UAProfile.xml'                                     => [ 'Huawei', 'Ascend G6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G6-T00_UAProfile.xml'                                           => [ 'Huawei', 'Ascend G6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G6-U10_KK_UAProfile.xml'                                        => [ 'Huawei', 'Ascend G6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G6-U10_UAProfile-DRM.xml'                                       => [ 'Huawei', 'Ascend G6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G6-U10_UAProfile.xml'                                           => [ 'Huawei', 'Ascend G6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G6-U251_UAProfile.xml'                                          => [ 'Huawei', 'Ascend G6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G6_C00_KK.xml'                                                  => [ 'Huawei', 'Ascend G6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G6_U00.xml'                                                     => [ 'Huawei', 'Ascend G6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G6_U00_KK.xml'                                                  => [ 'Huawei', 'Ascend G6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8950-1GPRS-Normal.xml'                                          => [ 'Huawei', 'Ascend G600', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8950-51GPRS-Normal.xml'                                         => [ 'Huawei', 'Ascend G600', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8950DGPRS-UNICOM.xml'                                           => [ 'Huawei', 'Ascend G600', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8950N-1GPRS-Normal.xml'                                         => [ 'Huawei', 'Ascend G600', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8950N-51GPRS-Normal.xml'                                        => [ 'Huawei', 'Ascend G600', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8950N-51WCDMA-Normal.xml'                                       => [ 'Huawei', 'Ascend G600', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_T8950_UAProfile.xml'                                            => [ 'Huawei', 'Ascend G600', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G610-T00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G610', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G610-T11_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G610', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G610-U00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G610', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G610-U15_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G610', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G610-U20_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G610', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G610-U30_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G610', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G610-C00_1_20130108.xml'                                     => [ 'Huawei', 'Ascend G610', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G615_U10.xml'                                                   => [ 'Huawei', 'Ascend G615', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G616-T00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G616', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G620-A2.xml'                                                 => [ 'Huawei', 'Ascend G620', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G620-A2_CC.xml'                                              => [ 'Huawei', 'Ascend G620', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G620-L72.xml'                                                => [ 'Huawei', 'Ascend G620', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G620-L75.xml'                                                => [ 'Huawei', 'Ascend G620', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G620S-L03.xml'                                               => [ 'Huawei', 'Ascend G620', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G620_1_20130917.xml'                                         => [ 'Huawei', 'Ascend G620', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G620S-L01.xml'                                               => [ 'Huawei', 'Ascend G620S', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G620S-L02.xml'                                               => [ 'Huawei', 'Ascend G620S', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G620S-L03_PERU.xml'                                          => [ 'Huawei', 'Ascend G620S', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/G621-TL00.xml'                                                         => [ 'Huawei', 'Ascend G621', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G621-TL00.xml'                                               => [ 'Huawei', 'Ascend G621', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/G628-TL00_LTE_UAProfile.xml'                                           => [ 'Huawei', 'Ascend G628', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/G629_LTE_UAProfile.xml'                                                => [ 'Huawei', 'Ascend G629', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG630-U20-DRM.xml'                                                => [ 'Huawei', 'Ascend G630', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG630-U20-Normal-WCDMA.xml'                                       => [ 'Huawei', 'Ascend G630', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG630-U20-Normal.xml'                                             => [ 'Huawei', 'Ascend G630', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG630-U251-Normal.xml'                                            => [ 'Huawei', 'Ascend G630', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G630_U00.xml'                                                   => [ 'Huawei', 'Ascend G630', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G630_U10.xml'                                                   => [ 'Huawei', 'Ascend G630', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CHC-U03_NLA_UAProfile.xml'                                      => [ 'Huawei', 'Ascend G650', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CHC-U03_UAProfile.xml'                                          => [ 'Huawei', 'Ascend G650', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G660-L075.xml'                                               => [ 'Huawei', 'Ascend G660', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_%s_lollipop_UAProfile.xml'                                      => [ 'Huawei', 'Ascend G7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_%s_UAProfile.xml'                                               => [ 'Huawei', 'Ascend G7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G7-L01_OrangeUAProfile.xml'                                     => [ 'Huawei', 'Ascend G7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G7-L01_UAProfile.xml'                                           => [ 'Huawei', 'Ascend G7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G7-L02_UAProfile.xml'                                           => [ 'Huawei', 'Ascend G7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G7-L03_DRMFL_UAProfile.xml'                                     => [ 'Huawei', 'Ascend G7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G7-L03_UAProfile.xml'                                           => [ 'Huawei', 'Ascend G7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G7-L11_UAProfile.xml'                                           => [ 'Huawei', 'Ascend G7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G7-TL00_UAProfile.xml'                                          => [ 'Huawei', 'Ascend G7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G7-UL20_UAProfile.xml'                                          => [ 'Huawei', 'Ascend G7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Rock-L01_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Rock-L01_UAProfile_DRM.xml'                                     => [ 'Huawei', 'Ascend G7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Rock-L03_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G760-L01-TME.xml'                                            => [ 'Huawei', 'Ascend G7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_Rock-L01_DT_UAProfile.xml'                                          => [ 'Huawei', 'Ascend G7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G700-T00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G700', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G700-U00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G700', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G700-U10_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G700', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G700-U20_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G700', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOHuawei G700-U00.xml'                                        => [ 'Huawei', 'Ascend G700', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG716-L070LTE.xml'                                                => [ 'Huawei', 'Ascend G716', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G718_1_20130805.xml'                                         => [ 'Huawei', 'Ascend G718', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G730-T00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G730', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G730-U00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G730', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G730-U10_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G730', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G730-U251_UAProfile.xml'                                        => [ 'Huawei', 'Ascend G730', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G730-U27_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G730', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G730-U30_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G730', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G730-C00_20130826.xml'                                       => [ 'Huawei', 'Ascend G730', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G730-C10_1_20130828.xml'                                     => [ 'Huawei', 'Ascend G730', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G730-L075.xml'                                               => [ 'Huawei', 'Ascend G730', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G735-L03_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G735', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G735-L03__NLA_UAProfile.xml'                                    => [ 'Huawei', 'Ascend G735', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G735-L23_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G735', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG740-L00LTE-DRM.xml'                                             => [ 'Huawei', 'Ascend G740', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG740-L00LTE-Normal.xml'                                          => [ 'Huawei', 'Ascend G740', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G750-T01_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G750', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G750-T20_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G750', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G750-U10_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G750', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G760-TL00_UAProfile.xml'                                        => [ 'Huawei', 'Ascend G760', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G620S-UL00.xml'                                              => [ 'Huawei', 'Ascend G760', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G760-L01.xml'                                                => [ 'Huawei', 'Ascend G760', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G760-L01_Europe_DRM-UAProfile.xml'                           => [ 'Huawei', 'Ascend G760', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_G760-L071.xml'                                               => [ 'Huawei', 'Ascend G760', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_RIO-AL00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_RIO-CL00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Huawei_RIO-L01_DT_UAProfile.xml'                                       => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_RIO-L01_UAProfile.xml'                                          => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_RIO-L01_UAProfile_DRM.xml'                                      => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_RIO-L01_UAProfile_DRM_FL.xml'                                   => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_RIO-L01_UAProfile_Orange_DRM.xml'                               => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_RIO-L02_UAProfile.xml'                                          => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_RIO-L02_UAProfile_DRM.xml'                                      => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_RIO-L03_UAProfile.xml'                                          => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_RIO-L03_UAProfile_DRM.xml'                                      => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_RIO-L03_UAProfile_DRMALL.xml'                                   => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_RIO-L03_UAProfile_DRMALL_1MB.xml'                               => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_RIO-TL00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_RIO-UL00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_RIOL03_UAProfile.xml'                                           => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Rock-CL00_UAProfile.xml'                                        => [ 'Huawei', 'Ascend G8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/SC-UL10_LTE_UAProfile.xml'                                             => [ 'Huawei', 'Ascend GX1', 'Android', DeviceType::MOBILE ],
    'http://mms.mycricket.com/Huawei-M865.xml'                                                            => [ 'Huawei', 'Ascend II', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/Huawei/ADR3310/ADR3310v1.xml'                                                => [ 'Huawei', 'Ascend II', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/OEM/ADR3305/ADR3305v1.xml'                                                   => [ 'Huawei', 'Ascend II', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Huawei-M865C.xml'                                                      => [ 'Huawei', 'Ascend II', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_MATE_T00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Mate', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_MATE_UAProfile.XML'                                             => [ 'Huawei', 'Ascend Mate', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_MATE_Wind_UAProfile.XML'                                        => [ 'Huawei', 'Ascend Mate', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Huawei_MT2-L02_UAProfile.xml'                                          => [ 'Huawei', 'Ascend Mate 2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Huawei_MT2-L05_UAProfile.xml'                                          => [ 'Huawei', 'Ascend Mate 2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_MT2_L05_UAProfile.xml'                                          => [ 'Huawei', 'Ascend Mate 2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Mate2.xml'                                                   => [ 'Huawei', 'Ascend Mate 2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_MT2-C00_1_20130425.xml'                                      => [ 'Huawei', 'Ascend Mate 2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_MT2-C00_1_20131227.xml'                                      => [ 'Huawei', 'Ascend Mate 2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_MT7-TL00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Mate 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_MT7-TL10_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Mate 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_MT7-UL00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Mate 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_MT7_L09_UAProfile.xml'                                          => [ 'Huawei', 'Ascend Mate 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Z100-TL00_UAProfile.xml'                                        => [ 'Huawei', 'Ascend Mate 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Z100_L09_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Mate 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_MT7-CL00_2_20140903.xml'                                     => [ 'Huawei', 'Ascend Mate 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Z100-CL00_1_20140709.xml'                                    => [ 'Huawei', 'Ascend Mate 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_GS03_UAProfile.xml'                                             => [ 'Huawei', 'Ascend P1', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_T9200_UAProfile.xml'                                            => [ 'Huawei', 'Ascend P1', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U9200_UAProfile.xml'                                            => [ 'Huawei', 'Ascend P1', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U9201L_UAProfile.xml'                                           => [ 'Huawei', 'Ascend P1', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U9202L-1_UAProfile.xml'                                         => [ 'Huawei', 'Ascend P1', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U9202L-3_UAProfile.xml'                                         => [ 'Huawei', 'Ascend P1', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_P2_NewZealand_UAProfile.xml'                                    => [ 'Huawei', 'Ascend P2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_P2_UAProfile.xml'                                               => [ 'Huawei', 'Ascend P2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U9700L_UAProfile.xml'                                           => [ 'Huawei', 'Ascend P2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_P6_S_U00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend P6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_P6_T00_UAProfile.xml'                                           => [ 'Huawei', 'Ascend P6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_P6_U06_MTN_UAProfile.xml'                                       => [ 'Huawei', 'Ascend P6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_P6_U06_UAProfile.xml'                                           => [ 'Huawei', 'Ascend P6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_P6_U06_Wind_UAProfile.xml'                                      => [ 'Huawei', 'Ascend P6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_P6-C00_1_20130425.xml'                                       => [ 'Huawei', 'Ascend P6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_MT2_T00_UAProfile.xml'                                          => [ 'Huawei', 'Ascend P7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_MT2_U071_UAProfile.xml'                                         => [ 'Huawei', 'Ascend P7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_SOPHIA_L07_UAProfile.xml'                                       => [ 'Huawei', 'Ascend P7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_SOPHIA_L10_UAProfile.xml'                                       => [ 'Huawei', 'Ascend P7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_SOPHIA_L10_UAProfile_3G.xml'                                    => [ 'Huawei', 'Ascend P7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_SOPHIA_L11_UAProfile.xml'                                       => [ 'Huawei', 'Ascend P7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_SOPHIA_L12_UAProfile.xml'                                       => [ 'Huawei', 'Ascend P7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_P7-L09_1_20140327.xml'                                       => [ 'Huawei', 'Ascend P7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_GRA-TL00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend P8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_GRA-UL00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend P8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_GRA-UL10_UAProfile.xml'                                         => [ 'Huawei', 'Ascend P8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_GRA_L09_DRM_UAProfile.xml'                                      => [ 'Huawei', 'Ascend P8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_GRA_L09_UAProfile.xml'                                          => [ 'Huawei', 'Ascend P8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_GRA_L09_VDF_UAProfile_3G.xml'                                   => [ 'Huawei', 'Ascend P8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_GRA_TL00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend P8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_X100-UL00_UAProfile.xml'                                        => [ 'Huawei', 'Ascend P8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_GRA-CL00_1_20150105.xml'                                            => [ 'Huawei', 'Ascend P8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_GRA-CL00_1_20150317.xml'                                     => [ 'Huawei', 'Ascend P8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_GRA-CL10_1_20150317.xml'                                     => [ 'Huawei', 'Ascend P8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_M100-CL00_1_20150120.xml'                                           => [ 'Huawei', 'Ascend P8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ALE-L02_NLA_UAProfile.xml'                                      => [ 'Huawei', 'Ascend P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ALE-L02_UAProfile.xml'                                          => [ 'Huawei', 'Ascend P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ALE-L04_5.1_UAProfile.xml'                                      => [ 'Huawei', 'Ascend P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ALE-L21_DRM_UAProfile.xml'                                      => [ 'Huawei', 'Ascend P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ALE-L21_FT_UAProfile.xml'                                       => [ 'Huawei', 'Ascend P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ALE-L21_PL_UAProfile.xml'                                       => [ 'Huawei', 'Ascend P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ALE-L21_UAProfile.xml'                                          => [ 'Huawei', 'Ascend P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ALE-L23_NLA_UAProfile.xml'                                      => [ 'Huawei', 'Ascend P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ALE-L23_UAProfile.xml'                                          => [ 'Huawei', 'Ascend P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ALE-TL00_6.0_UAProfile.xml'                                     => [ 'Huawei', 'Ascend P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ALE-TL00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ALE-UL00_UAProfile.xml'                                         => [ 'Huawei', 'Ascend P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ALEL04_UAProfile.xml'                                           => [ 'Huawei', 'Ascend P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_ALE-CL00_1_20141217.xml'                                     => [ 'Huawei', 'Ascend P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/huawei/h881c/h881c.xml'                                                      => [ 'Huawei', 'Ascend Plus', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiM660-Cricket.xml'                                                => [ 'Huawei', 'Ascend Q', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU9000v100WCDMA.xml'                                              => [ 'Huawei', 'Ascend X', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/huawei/h866c/h866c.xml'                                                      => [ 'Huawei', 'Ascend Y H866C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8185GPRS-NORMAL.xml'                                            => [ 'Huawei', 'Ascend Y100', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8185WCDMA-NORMAL.xml'                                           => [ 'Huawei', 'Ascend Y100', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8186GPRS-NORMAL.xml'                                            => [ 'Huawei', 'Ascend Y101', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8186WCDMA-NORMAL.xml'                                           => [ 'Huawei', 'Ascend Y101', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8655GPRS-NORMAL.xml'                                            => [ 'Huawei', 'Ascend Y200', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8655WCDMA-NORMAL.xml'                                           => [ 'Huawei', 'Ascend Y200', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_T8620_UAProfile.xml'                                            => [ 'Huawei', 'Ascend Y200T', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8666E-1GPRS-NORMAL.xml'                                         => [ 'Huawei', 'Ascend Y201', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8666E-51GPRS-NORMAL.xml'                                        => [ 'Huawei', 'Ascend Y201', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8666EGPRS-NORMAL-ICS.xml'                                       => [ 'Huawei', 'Ascend Y201', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8666EGPRS-NORMAL.xml'                                           => [ 'Huawei', 'Ascend Y201', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8666GPRS-NORMAL.xml'                                            => [ 'Huawei', 'Ascend Y201', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8666N-1GPRS-2Degrees.xml'                                       => [ 'Huawei', 'Ascend Y201', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8666N-1GPRS-NORMAL.xml'                                         => [ 'Huawei', 'Ascend Y201', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8666WCDMA-NORMAL.xml'                                           => [ 'Huawei', 'Ascend Y201', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8655_20120206.xml'                                          => [ 'Huawei', 'Ascend Y201C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY210-C10CDMA-Orinoquia.xml'                                      => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Y210-2010_1_20120206.xml'                                    => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Y210S_1_20121105.xml'                                        => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y210-0010GPRS-NORMAL.xml'                                              => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y210-0010WCDMA-NORMAL.xml'                                             => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y210-0100GPRS-NORMAL.xml'                                              => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y210-0100WCDMA-NORMAL.xml'                                             => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y210-0151GPRS-DRM.xml'                                                 => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y210-0151GPRS-NORMAL.xml'                                              => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y210-0151WCDMA-DRM.xml'                                                => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y210-0151WCDMA-NORMAL.xml'                                             => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y210-0151WCDMA-TELUS.xml'                                              => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y210-0200GPRS-NORMAL.xml'                                              => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y210-0200WCDMA-NORMAL.xml'                                             => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y210-0251GPRS-NORMAL.xml'                                              => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y210-0251WCDMA-NORMAL.xml'                                             => [ 'Huawei', 'Ascend Y210', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY220-U00_UAProfile.xml'                                          => [ 'Huawei', 'Ascend Y220', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY220-U05_UAProfile.xml'                                          => [ 'Huawei', 'Ascend Y220', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY220-U10_UAProfile.xml'                                          => [ 'Huawei', 'Ascend Y220', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY221-U03_UAProfile.xml'                                          => [ 'Huawei', 'Ascend Y221', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY221-U12_UAProfile.xml'                                          => [ 'Huawei', 'Ascend Y221', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY221-U22_UAProfile.xml'                                          => [ 'Huawei', 'Ascend Y221', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY221-U53_UAProfile.xml'                                          => [ 'Huawei', 'Ascend Y221', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/OrinoquiaAuyantepui+Y221-U03_UAProfile.xml'                            => [ 'Huawei', 'Ascend Y221', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY300-0000GPRS-UNICOM.xml'                                        => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY300-0000GPRS.xml'                                               => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY300-0100GPRS-FL.xml'                                            => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY300-0100GPRS-MTN.xml'                                           => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY300-0100GPRS-NORMAL.xml'                                        => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY300-0100GPRS.xml'                                               => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY300-0100WCDMA-Yoigo.xml'                                        => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY300-0151GPRS-DRM.xml'                                           => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY300-0151GPRS-FL.xml'                                            => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY300-0151GPRS-Telefonica.xml'                                    => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY300-0151GPRS-Telstra.xml'                                       => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY300-0151GPRS.xml'                                               => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY300-0151WCDMA.xml'                                              => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY300-0159GPRS.xml'                                               => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_T8833_UAProfile.xml'                                            => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Y300C_1_20121018.xml'                                        => [ 'Huawei', 'Ascend Y300', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/HUAWEI/PLTFH882KT/H882LV100R001C378B170SP02.rdf'                         => [ 'Huawei', 'Ascend Y301', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY301-A1-Normal.xml'                                              => [ 'Huawei', 'Ascend Y301', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY301-A2-Normal.xml'                                              => [ 'Huawei', 'Ascend Y301', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Beeline_Smart-v100WCDMA.xml'                                           => [ 'Huawei', 'Ascend Y320', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY320-U01v100WCDMA.xml'                                           => [ 'Huawei', 'Ascend Y320', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY320-U10v100WCDMA.xml'                                           => [ 'Huawei', 'Ascend Y320', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY320-U151v100WCDMA.xml'                                          => [ 'Huawei', 'Ascend Y320', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY320-U30v100WCDMA.xml'                                           => [ 'Huawei', 'Ascend Y320', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY320-U351v100WCDMA.xml'                                          => [ 'Huawei', 'Ascend Y320', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY321-U051v100WCDMA.xml'                                          => [ 'Huawei', 'Ascend Y321', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y330-U01_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y330', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y330-U05_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y330', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y330-U07_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y330', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y330-U11_Normal_UAProfile.xml'                                  => [ 'Huawei', 'Ascend Y330', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y330-U15_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y330', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Y330-C00_1_20140418.xml'                                     => [ 'Huawei', 'Ascend Y330', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y336-U02_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y336', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Y336-A1.xml'                                                 => [ 'Huawei', 'Ascend Y336', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY340-U081-Normal.xml'                                            => [ 'Huawei', 'Ascend Y340', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y360-U03_UAProfile.xml'                                                => [ 'Huawei', 'Ascend Y360', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y360-U23_UAProfile.xml'                                                => [ 'Huawei', 'Ascend Y360', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y360-U31_UAProfile.xml'                                                => [ 'Huawei', 'Ascend Y360', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y360-U61_UAProfile.xml'                                                => [ 'Huawei', 'Ascend Y360', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y360-U72_UAProfile.xml'                                                => [ 'Huawei', 'Ascend Y360', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y360-U82_UAProfile.xml'                                                => [ 'Huawei', 'Ascend Y360', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y360-U93_UAProfile.xml'                                                => [ 'Huawei', 'Ascend Y360', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y511-U00.xml'                                                   => [ 'Huawei', 'Ascend Y511', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y511-U10.xml'                                                   => [ 'Huawei', 'Ascend Y511', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y511-U251.xml'                                                  => [ 'Huawei', 'Ascend Y511', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y511-U30.xml'                                                   => [ 'Huawei', 'Ascend Y511', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y511_TD_UAProfile.xml'                                                 => [ 'Huawei', 'Ascend Y516', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y516_TD_UAProfile.xml'                                                 => [ 'Huawei', 'Ascend Y516', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y518_TD_UAProfile.xml'                                                 => [ 'Huawei', 'Ascend Y518', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY520-U03v100WCDMA.xml'                                           => [ 'Huawei', 'Ascend Y520', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY520-U12v100WCDMA.xml'                                           => [ 'Huawei', 'Ascend Y520', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY520-U22v100WCDMA.xml'                                           => [ 'Huawei', 'Ascend Y520', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY520-U33v100WCDMA.xml'                                           => [ 'Huawei', 'Ascend Y520', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y523_LTE_UAProfile.xml'                                                => [ 'Huawei', 'Ascend Y523', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY530-U00-DT.xml'                                                 => [ 'Huawei', 'Ascend Y530', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY530-U00-Normal.xml'                                             => [ 'Huawei', 'Ascend Y530', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY530-U051-Normal-DRM.xml'                                        => [ 'Huawei', 'Ascend Y530', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY530-U051-Normal-MMS.xml'                                        => [ 'Huawei', 'Ascend Y530', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY530-U051-Normal.xml'                                            => [ 'Huawei', 'Ascend Y530', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY530-U051-Telecom-NZ.xml'                                        => [ 'Huawei', 'Ascend Y530', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY530-U051-Telstra-MMS.xml'                                       => [ 'Huawei', 'Ascend Y530', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Y536-A1.xml'                                                 => [ 'Huawei', 'Ascend Y536', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY540-U01v100WCDMA.xml'                                           => [ 'Huawei', 'Ascend Y540', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y541-U02_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y541', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Y541-U02_UAProfile.xml'                                                => [ 'Huawei', 'Ascend Y541', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Y550-L01.xml'                                                => [ 'Huawei', 'Ascend Y550', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Y550-L01_EE.xml'                                             => [ 'Huawei', 'Ascend Y550', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Y550-L02-VHA-AU.xml'                                         => [ 'Huawei', 'Ascend Y550', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Y550-L03.xml'                                                => [ 'Huawei', 'Ascend Y550', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Y550-L03_PERU.xml'                                           => [ 'Huawei', 'Ascend Y550', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y560-L01_DT_GR_UAProfile.xml'                                   => [ 'Huawei', 'Ascend Y560', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y560-U02_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y560', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y560_L02_Telstra_UAProfile.xml'                                 => [ 'Huawei', 'Ascend Y560', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y560_L_UAProfile.xml'                                           => [ 'Huawei', 'Ascend Y560', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y560_U_UAProfile.xml'                                           => [ 'Huawei', 'Ascend Y560', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY600-U00_UAProfile.xml'                                          => [ 'Huawei', 'Ascend Y600', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY600-U151_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y600', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY600-U20_UAProfile.xml'                                          => [ 'Huawei', 'Ascend Y600', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY600-U351_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y600', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY600-U40_UAProfile.xml'                                          => [ 'Huawei', 'Ascend Y600', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY610-U00_UAProfile.xml'                                          => [ 'Huawei', 'Ascend Y610', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y625_U13_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y625', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y625_U21_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y625', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y625_U32_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y625', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y625_U43_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y625', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y625_U51_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y625', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y635-L01_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y635', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y635-L01_UAProfile_EUROPE.xml'                                  => [ 'Huawei', 'Ascend Y635', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y635-L01_UAProfile_TME.xml'                                     => [ 'Huawei', 'Ascend Y635', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y635-L02_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y635', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y635-L02_UAProfile_DRM.xml'                                     => [ 'Huawei', 'Ascend Y635', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y635-L02_UAProfile_DRM_MMS.xml'                                 => [ 'Huawei', 'Ascend Y635', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y635-L03_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y635', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y635-L03_UAProfile_DRM.xml'                                     => [ 'Huawei', 'Ascend Y635', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y635-L03_UAProfile_DRM_FL.xml'                                  => [ 'Huawei', 'Ascend Y635', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y635-L03_UAProfile_MMS_FL_DRM.xml'                              => [ 'Huawei', 'Ascend Y635', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y635-L21_UAProfile.xml'                                         => [ 'Huawei', 'Ascend Y635', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y635-L21_UAProfile_EUROPE.xml'                                  => [ 'Huawei', 'Ascend Y635', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Y635-TL00_UAProfile.xml'                                        => [ 'Huawei', 'Ascend Y635', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Y635-CL00_1_20140930.xml'                                    => [ 'Huawei', 'Ascend Y635', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_B199.xml'                                                    => [ 'Huawei', 'B199', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_B199_1_20130806.xml'                                         => [ 'Huawei', 'B199', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_B199_1_20131113.xml'                                         => [ 'Huawei', 'B199', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8350v100GPRS.xml'                                               => [ 'Huawei', 'Boulder', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8350v100WCDMA.xml'                                              => [ 'Huawei', 'Boulder', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C199.xml'                                                    => [ 'Huawei', 'C199', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_C199s_UAProfile.xml'                                            => [ 'Huawei', 'C199s', 'Android', DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiC5720CDMA1X.xml'                                                  => [ 'Huawei', 'C5720', null, DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HW/HW_HUAWEI_C5735_1_20110406.xml'                                       => [ 'Huawei', 'C5735', null, DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_C8500_1_20100127.xml'                                               => [ 'Huawei', 'C8500', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8500S_1_20110511.xml'                                       => [ 'Huawei', 'C8500', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8511_1_20110511.xml'                                        => [ 'Huawei', 'C8511', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8512_20110817.xml'                                          => [ 'Huawei', 'C8512', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8550_1_20111103.xml'                                        => [ 'Huawei', 'C8550', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_C8600_1_20100127.xml'                                               => [ 'Huawei', 'C8600', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8650PLUS_1_20111025.xml'                                    => [ 'Huawei', 'C8650', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8650_1_20110512.xml'                                        => [ 'Huawei', 'C8650', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_c8650_2_20111116.xml'                                        => [ 'Huawei', 'C8650', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8815_1_20130425.xml'                                        => [ 'Huawei', 'C8815', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8817D.xml'                                                  => [ 'Huawei', 'C8817', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8817E.xml'                                                  => [ 'Huawei', 'C8817', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8817L.xml'                                                  => [ 'Huawei', 'C8817', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8818_1_20141217.xml'                                        => [ 'Huawei', 'C8818', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiC8850v100CDMA.xml'                                               => [ 'Huawei', 'C8850', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8687-Normal.xml'                                                => [ 'Huawei', 'Chronos', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_TIT-AL00_Oversea_UAProfile.xml'                                 => [ 'Huawei', 'Enjoy 5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_TIT-AL00_UAProfile .xml'                                        => [ 'Huawei', 'Enjoy 5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_TIT-CL10_UAProfile.xml'                                         => [ 'Huawei', 'Enjoy 5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_TIT-L01_UAProfile .xml'                                         => [ 'Huawei', 'Enjoy 5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_TIT-L01_UAProfile.xml'                                          => [ 'Huawei', 'Enjoy 5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_TIT-TL00_UAProfile.xml'                                         => [ 'Huawei', 'Enjoy 5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_TIT-U02_UAProfile .xml'                                         => [ 'Huawei', 'Enjoy 5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/TIT-AL00C583_UAProfile.xml'                                            => [ 'Huawei', 'Enjoy 5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_TANGO_UAProfile.xml'                                            => [ 'Huawei', 'Enjoy 5S', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_NCE-AL00_UAProfile.xml'                                         => [ 'Huawei', 'Enjoy 6', 'Windows', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_NCE-TL10_UAProfile.xml'                                         => [ 'Huawei', 'Enjoy 6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_SLA-TL10_UAProfile.xml'                                         => [ 'Huawei', 'Enjoy 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_TRT-TL10A_UAProfile.xml'                                        => [ 'Huawei', 'Enjoy 7 Plus', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_TRT-TL10_UAProfile.xml'                                         => [ 'Huawei', 'Enjoy 7 Plus', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_CM990_1_20130108.xml'                                        => [ 'Huawei', 'Evolución 3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiUM840v100GPRS.xml'                                               => [ 'Huawei', 'Evolution', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiUM840v100WCDMA.xml'                                              => [ 'Huawei', 'Evolution', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_CM980.xml'                                                   => [ 'Huawei', 'Evolution II', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8665GPRS-ATT.xml'                                               => [ 'Huawei', 'Fusion 2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8665WCDMA-ATT.xml'                                              => [ 'Huawei', 'Fusion 2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CHC-U01_UAProfile.xml'                                          => [ 'Huawei', 'G Play Mini', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CHC-U23_UAProfile.xml'                                          => [ 'Huawei', 'G Play Mini', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG6L11.xml'                                                       => [ 'Huawei', 'G6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G6_C00.xml'                                                     => [ 'Huawei', 'G6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/G6609UAprofileV1.1.xml'                                                => [ 'Huawei', 'G6609', 'MTK', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/G7300UAprofileV1.1.xml'                                                => [ 'Huawei', 'G7300', 'MTK', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_G750-T00_UAProfile.xml'                                         => [ 'Huawei', 'G750', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/G7500_UAProfile.xml'                                                   => [ 'Huawei', 'G7500', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/huawei/h868c/h868c.xml'                                                      => [ 'Huawei', 'Glory', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KII-L03_UAProfile.xml'                                              => [ 'Huawei', 'GR5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KII-L05_UAProfile_1mb.xml'                                          => [ 'Huawei', 'GR5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KII-L21_UAProfile.xml'                                              => [ 'Huawei', 'GR5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KII-L22_UAProfile.xml'                                              => [ 'Huawei', 'GR5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KII-L23_DRM_UAProfile.xml'                                          => [ 'Huawei', 'GR5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KII-L23_UAProfile.xml'                                              => [ 'Huawei', 'GR5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KII-L23_UAProfile_FL_Only.xml'                                      => [ 'Huawei', 'GR5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KII-L23_UA_DRM_FL_Profile.xml'                                      => [ 'Huawei', 'GR5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_H870C.xml'                                                   => [ 'Huawei', 'H870C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8860-51GPRS-Normal.xml'                                         => [ 'Huawei', 'Honor', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8860-51WCDMA-Normal.xml'                                        => [ 'Huawei', 'Honor', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8860-92GPRS-EAccess.xml'                                        => [ 'Huawei', 'Honor', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8860-92WCDMA-EAccess.xml'                                       => [ 'Huawei', 'Honor', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8860GPRS-NORMAL-ICS.xml'                                        => [ 'Huawei', 'Honor', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8860GPRS-NORMAL.xml'                                            => [ 'Huawei', 'Honor', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8860WCDMA-NORMAL-ICS.xml'                                       => [ 'Huawei', 'Honor', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8860WCDMA-NORMAL.xml'                                           => [ 'Huawei', 'Honor', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8860E_1_20111103.xml'                                       => [ 'Huawei', 'Honor', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8860_1_20110704.xml'                                        => [ 'Huawei', 'Honor', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U9508_U06_UAProfile.xml'                                        => [ 'Huawei', 'Honor 2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U9508_UAProfile.xml'                                            => [ 'Huawei', 'Honor 2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_HN3_U01_UAProfile.xml'                                          => [ 'Huawei', 'Honor 3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Hol-U19_UAProfile.xml'                                                 => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Hol_T00_UAProfile.xml'                                                 => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Hol_U10_UAProfile.xml'                                                 => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_H30-L01M_UAProfile.xml'                                          => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_H30-L01_UAProfile.xml'                                           => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_H30-L02_Global_UAProfile.xml'                                    => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_H30-L02_UAProfile.xml'                                           => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_H30-T00_Global_UAProfile.xml'                                   => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_H30-T00_UAProfile.xml'                                          => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_H30-T10_Global_UAProfile.xml'                                   => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_H30-T10_UAProfile.xml'                                          => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_H30-U00_UAProfile.xml'                                          => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_H30-U10_Global_UAProfile.xml'                                   => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_H30-U10_UAProfile.xml'                                          => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HONOR_H30-C00_20140420.xml'                                         => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_H30-C00_20140420.xml'                                        => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Hol-T00.xml'                                                     => [ 'Huawei', 'Honor 3C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_SCL-U31_UAProfile.xml'                                          => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-AL00_UAProfile.xml'                                             => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-CL00_1_20150420.xml'                                            => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-L01_DT_UAProfile.xml'                                           => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-L01_Europe_DRM-UAProfile.xml'                                   => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-L01_UAProfile.xml'                                              => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-L01_UAProfile_OrangeDive70.xml'                                 => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-L02_UAProfile.xml'                                              => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-L03_DRMFL_TIGO_UAProfile.xml'                                   => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-L03_DRMFL_UAProfile.xml'                                        => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-L03_UAProfile-DRM.xml'                                          => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-L03_UAProfile.xml'                                              => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-L03_UAProfile_DRM_FL_Only.xml'                                  => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-L04_UAProfile.xml'                                              => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-L04_UAProfile_1MB.xml'                                          => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-L21_Europe_DRM-UAProfile.xml'                                   => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-L21_UAProfile.xml'                                              => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-TL00H_UAProfile.xml'                                            => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-TL00_UAProfile.xml'                                             => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-U23_UAProfile.xml'                                              => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCL-U31_UAProfile.xml'                                              => [ 'Huawei', 'Honor 4A', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CHM-TL00H_UAProfile.xml'                                        => [ 'Huawei', 'Honor 4C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CHM-U01_UAProfile.xml'                                          => [ 'Huawei', 'Honor 4C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CHM-UL00_UAProfile.xml'                                         => [ 'Huawei', 'Honor 4C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_CHM-CL00_1_20141217.xml'                                            => [ 'Huawei', 'Honor 4C', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/huawei/wsh892l/wsh892l.xml'                                                  => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_CHE-TL00H_6.0_UAProfile.xml'                                     => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_CHE-TL00_6.0_UAProfile.xml'                                      => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_Che1-CL10_6_0_UAProfile.xml'                                     => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_Che1-CL20_6_0_UAProfile.xml'                                     => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_Che1-L04_UAProfile.xml'                                          => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_Che2-L11_Russia_UAProfile.xml'                                   => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_Che2-L11_UAProfile.xml'                                          => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_Che2-L12_5.1_UAProfile.xml'                                      => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_Che2-L12_UAProfile.xml'                                          => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_Che2-L23_UAProfile.xml'                                          => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_Che2-TL00H_UAProfile.xml'                                        => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_Che2-TL00M_5.1_UAProfile.xml'                                    => [ 'Huawei', 'Honor 4X', 'Android',  ],
    'http://wap1.huawei.com/uaprof/HONOR_Che2-TL00M_6.0_UAProfile.xml'                                    => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_Che2-TL00M_UAProfile.xml'                                        => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_Che2-TL00_6.0_UAProfile.xml'                                     => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_Che2-TL00_UAProfile.xml'                                         => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_Che2-UL00_6.0_UAProfile.xml'                                     => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_Che2-UL00_UAProfile.xml'                                         => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CHE-TL00H_UAProfile.xml'                                        => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CHE-TL00_UAProfile.xml'                                         => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Che1-CL10_5.1_UAProfile.xml'                                    => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Che1-CL20_5.1_UAProfile.xml'                                    => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Che2-L23_UAProfile.xml'                                         => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_Che2-UL00_UAProfile.xml'                                        => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Che1-CL10_1_20140801.xml'                                    => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_Che1-CL20.xml'                                               => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOChe1-CL20.xml'                                              => [ 'Huawei', 'Honor 4X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_UAProfile.xml'                                                      => [ 'Huawei', 'Honor 5C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KIW-AL10_6.0_UAProfile.xml'                                         => [ 'Huawei', 'Honor 5X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KIW-AL10_UAProfile.xml'                                             => [ 'Huawei', 'Honor 5X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KIW-CL00_1_20150425.xml'                                            => [ 'Huawei', 'Honor 5X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KIW-CL00_6.0_UAProfile.xml'                                         => [ 'Huawei', 'Honor 5X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KIW-L21_UAProfile.xml'                                              => [ 'Huawei', 'Honor 5X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KIW-L21_UAProfile_DRM.xml'                                          => [ 'Huawei', 'Honor 5X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KIW-L22_UAProfile.xml'                                              => [ 'Huawei', 'Honor 5X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KIW-TL00H_6.0_UAProfile.xml'                                        => [ 'Huawei', 'Honor 5X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KIW-TL00H_UAProfile.xml'                                            => [ 'Huawei', 'Honor 5X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KIW-TL00_6.0_UAProfile.xml'                                         => [ 'Huawei', 'Honor 5X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KIW-TL00_UAProfile.xml'                                             => [ 'Huawei', 'Honor 5X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KIW-UL00_UAProfile.xml'                                             => [ 'Huawei', 'Honor 5X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_KIWL24_UAProfile.xml'                                               => [ 'Huawei', 'Honor 5X', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_H60_J1_UAProfile.xml'                                           => [ 'Huawei', 'Honor 6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_H60_L01_UAProfile.xml'                                          => [ 'Huawei', 'Honor 6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_H60_L02_UAProfile.xml'                                          => [ 'Huawei', 'Honor 6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_H60_L03_UAProfile.xml'                                          => [ 'Huawei', 'Honor 6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_H60_L04_UAProfile.xml'                                          => [ 'Huawei', 'Honor 6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_H60_L11_UAProfile.xml'                                          => [ 'Huawei', 'Honor 6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_H60_L12_UAProfile.xml'                                          => [ 'Huawei', 'Honor 6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_E100-TL10_UAProfile.xml'                                        => [ 'Huawei', 'Honor 6 Plus', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_E100-TL20_UAProfile.xml'                                        => [ 'Huawei', 'Honor 6 Plus', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_E100-UL00_UAProfile.xml'                                        => [ 'Huawei', 'Honor 6 Plus', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_E100_TL00M_UAProfile.xml'                                       => [ 'Huawei', 'Honor 6 Plus', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_PE-TL10_UAProfile.xml'                                          => [ 'Huawei', 'Honor 6 Plus', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_PE-TL20_UAProfile.xml'                                          => [ 'Huawei', 'Honor 6 Plus', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_PE-UL00_UAProfile.xml'                                          => [ 'Huawei', 'Honor 6 Plus', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_PE_TL00M_UAProfile.xml'                                         => [ 'Huawei', 'Honor 6 Plus', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_E100-CL00_1_20141103.xml'                                    => [ 'Huawei', 'Honor 6 Plus', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_PE-CL00_1_20141225.xml'                                             => [ 'Huawei', 'Honor 6 Plus', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_PLK-AL10-Uaprofile.xml'                                         => [ 'Huawei', 'Honor 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_PLK-L01-Uaprofile.xml'                                          => [ 'Huawei', 'Honor 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_PLK-L01_UAProfile.xml'                                          => [ 'Huawei', 'Honor 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_PLK-TL00-Uaprofile.xml'                                         => [ 'Huawei', 'Honor 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_PLK-TL01H-Uaprofile.xml'                                        => [ 'Huawei', 'Honor 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_PLK-UL00-Uaprofile.xml'                                         => [ 'Huawei', 'Honor 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_C9746_1_20150319.xml'                                               => [ 'Huawei', 'Honor 7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ATH-AL00_Uaprofile.xml'                                         => [ 'Huawei', 'Honor 7i', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ATH-CL00_Uaprofile.xml'                                         => [ 'Huawei', 'Honor 7i', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ATH-TL00H_Uaprofile.xml'                                        => [ 'Huawei', 'Honor 7i', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ATH-TL00_Uaprofile.xml'                                         => [ 'Huawei', 'Honor 7i', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ATH-UL00_Uaprofile.xml'                                         => [ 'Huawei', 'Honor 7i', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_CHM-TL00H_6.0_UAProfile.xml'                                     => [ 'Huawei', 'Honor Play 4C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_CHM-TL00_5.1_UAProfile.xml'                                      => [ 'Huawei', 'Honor Play 4C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_CHM-TL00_6.0_UAProfile.xml'                                      => [ 'Huawei', 'Honor Play 4C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_CHM-U01_UAProfile.xml'                                           => [ 'Huawei', 'Honor Play 4C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HONOR_CHM-UL00_6.0_UAProfile.xml'                                      => [ 'Huawei', 'Honor Play 4C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CHM-TL00_UAProfile.xml'                                         => [ 'Huawei', 'Honor Play 4C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CHM-U01_Russia_UAProfile.xml'                                   => [ 'Huawei', 'Honor Play 4C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_CHM-CL00_6_0_UAProfile.xml'                                         => [ 'Huawei', 'Honor Play 4C', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ATH-UL01_DRM_Uaprofile.xml'                                     => [ 'Huawei', 'Honor ShotX', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ATH-UL01_Uaprofile.xml'                                         => [ 'Huawei', 'Honor ShotX', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ATH-UL06_Uaprofile.xml'                                         => [ 'Huawei', 'Honor ShotX', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_HDN-L09_UAProfile.xml'                                          => [ 'Huawei', 'Honor WaterPlay', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8950D_1_20120704.xml'                                       => [ 'Huawei', 'Honor+', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8150v100WCDMA.xml'                                              => [ 'Huawei', 'IDEOS', 'Android', DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/Huawei-S7.xml'                                                          => [ 'Huawei', 'IDEOS S7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiS7v100EVDONormal.xml'                                            => [ 'Huawei', 'IDEOS S7', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiS7v100GPRSNormal.xml'                                            => [ 'Huawei', 'IDEOS S7', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiS7v100WCDMA.xml'                                                 => [ 'Huawei', 'IDEOS S7', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiS7v100WCDMANormal.xml'                                           => [ 'Huawei', 'IDEOS S7', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiS7Slimv100WCDMA.xml'                                             => [ 'Huawei', 'IDEOS S7 Slim', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8180GPRS.xml'                                                   => [ 'Huawei', 'IDEOS X1', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8180WCDMA.xml'                                                  => [ 'Huawei', 'IDEOS X1', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8500v100GPRSNormal.xml'                                         => [ 'Huawei', 'IDEOS X2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8500v100WCDMANormal.xml'                                        => [ 'Huawei', 'IDEOS X2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-1GPRS-2degrees.xml'                                        => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-1GPRS-o2-Tchibo.xml'                                       => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-1GPRS-o2.xml'                                              => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-1GPRS-VDF_HU.xml'                                          => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-1GPRS-VDF_PT.xml'                                          => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-1GPRS-Wind_GR.xml'                                         => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-1WCDMA-2degrees.xml'                                       => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-1WCDMA-o2-Tchibo.xml'                                      => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-1WCDMA-o2.xml'                                             => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-1WCDMA-TAM_ID.xml'                                         => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-1WCDMA-VDF_HU.xml'                                         => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-1WCDMA-VDF_PT.xml'                                         => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-5WCDMA-Iusacell_MX.xml'                                    => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-5WCDMA-Iusacell_MX236.xml'                                 => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510-92WCDMA-EAccess.xml'                                       => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510GPRS-NORMAL235.xml'                                         => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510GPRS-NORMAL236.xml'                                         => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510WCDMA-NORMAL.xml'                                           => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8510WCDMA-NORMAL235.xml'                                        => [ 'Huawei', 'IDEOS X3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8800-51v100GPRS.xml'                                            => [ 'Huawei', 'IDEOS X5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8800-51v100WCDMA-ATT.xml'                                       => [ 'Huawei', 'IDEOS X5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8800-51v100WCDMA.xml'                                           => [ 'Huawei', 'IDEOS X5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8800iGPRS-NORMAL.xml'                                           => [ 'Huawei', 'IDEOS X5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8800v100C2WCDMA.xml'                                            => [ 'Huawei', 'IDEOS X5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8800v100GPRS.xml'                                               => [ 'Huawei', 'IDEOS X5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8800v100WCDMA.xml'                                              => [ 'Huawei', 'IDEOS X5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_C8800_1_20110222.xml'                                        => [ 'Huawei', 'IDEOS X5', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8800proGPRS-NORMAL.xml'                                         => [ 'Huawei', 'IDEOS X5 Pro', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8800PROiGPRS-NORMAL.xml'                                        => [ 'Huawei', 'IDEOS X5 Pro', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8800prov100GPRS.xml'                                            => [ 'Huawei', 'IDEOS X5 Pro', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8800prov100WCDMA.xml'                                           => [ 'Huawei', 'IDEOS X5 Pro', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8800proWCDMA-NORMAL.xml'                                        => [ 'Huawei', 'IDEOS X5 Pro', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiH867GGPRS-Normal.xml'                                            => [ 'Huawei', 'Inspira', 'Android', DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/Huawei-M328.xml'                                                   => [ 'Huawei', 'M328', null, DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/HUAWEI-M570.xml'                                                   => [ 'Huawei', 'M570', null, DeviceType::MOBILE ],
    'http://mms.mycricket.com/HUAWEI-M615.xml'                                                            => [ 'Huawei', 'M615', null, DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/Huawei-M635.xml'                                                   => [ 'Huawei', 'M635', null, DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/Huawei-M735.xml'                                                   => [ 'Huawei', 'M735', null, DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/Huawei-M835.xml'                                                   => [ 'Huawei', 'M835', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_M835_1_20110720.xml'                                         => [ 'Huawei', 'M835', 'Android', DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/Huawei-M860.xml'                                                   => [ 'Huawei', 'M860', 'Android', DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/Huawei-M860F.xml'                                                  => [ 'Huawei', 'M860', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_H871G.xml'                                                   => [ 'Huawei', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CRR_L09_UAProfile.xml'                                          => [ 'Huawei', 'Mate 8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_M200_L09_UAProfile.xml'                                         => [ 'Huawei', 'Mate 8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_NXT-AL10_UAProfile.xml'                                         => [ 'Huawei', 'Mate 8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_NXT-TL00_UAProfile.xml'                                         => [ 'Huawei', 'Mate 8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_NXT-UL00_UAProfile.xml'                                         => [ 'Huawei', 'Mate 8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_NXT-CL00_1_20151102.xml'                                            => [ 'Huawei', 'Mate 8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CRR-UL00_UAProfile.xml'                                         => [ 'Huawei', 'Mate S', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CRR-UL20_UAProfile.xml'                                         => [ 'Huawei', 'Mate S', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CRR_L09_UAProfile_3G.xml'                                       => [ 'Huawei', 'Mate S', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_CRR-CL00_1_20150310.xml'                                            => [ 'Huawei', 'Mate S', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_CRR-CL20_1_20150310.xml'                                            => [ 'Huawei', 'Mate S', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPadEVDODataOnly.xml'                                        => [ 'Huawei', 'MediaPad', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPadWCDMADataOnly.xml'                                       => [ 'Huawei', 'MediaPad', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPadWCDMA_ICS.xml'                                           => [ 'Huawei', 'MediaPad', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPadWIFIOnly.xml'                                            => [ 'Huawei', 'MediaPad', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPadWIFIOnly_ICS.xml'                                        => [ 'Huawei', 'MediaPad', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_201u.xml'                                               => [ 'Huawei', 'MediaPad 10 Link', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_201wa.xml'                                              => [ 'Huawei', 'MediaPad 10 Link', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_S10-231L.xml'                                           => [ 'Huawei', 'MediaPad 10 Link', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_S10-231u.xml'                                           => [ 'Huawei', 'MediaPad 10 Link', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_S10-231w.xml'                                           => [ 'Huawei', 'MediaPad 10 Link', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/MediaPad7LiteWCDMA_ICS.xml'                                            => [ 'Huawei', 'MediaPad 7 Lite', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/MediaPad7LiteWIFIOnly_ICS.xml'                                         => [ 'Huawei', 'MediaPad 7 Lite', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad71111WCDMA.xml'                                          => [ 'Huawei', 'MediaPad 7 Vivid', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad7611WCDMA.xml'                                           => [ 'Huawei', 'MediaPad 7 Vivid', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad7601WCDMA.xml'                                           => [ 'Huawei', 'MediaPad 7 Vogue', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad7601WIFIOnly.xml'                                        => [ 'Huawei', 'MediaPad 7 Vogue', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_S7-601c.xml'                                            => [ 'Huawei', 'MediaPad 7 Vogue', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad7701WIFIOnly.xml'                                        => [ 'Huawei', 'MediaPad 7 Youth', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad770XWCDMA.xml'                                           => [ 'Huawei', 'MediaPad 7 Youth', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad721XWCDMA.xml'                                           => [ 'Huawei', 'MediaPad 7 Youth 2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_S7-721g.xml'                                            => [ 'Huawei', 'MediaPad 7 Youth 2', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_S7-721w.xml'                                            => [ 'Huawei', 'MediaPad 7 Youth 2', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_S7-72Xu.xml'                                            => [ 'Huawei', 'MediaPad 7 Youth 2', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_S8-301L.xml'                                            => [ 'Huawei', 'MediaPad 8 Vogue', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_S8-301u.xml'                                            => [ 'Huawei', 'MediaPad M1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_S8-301u_4_4.xml'                                        => [ 'Huawei', 'MediaPad M1', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_S8-301w.xml'                                            => [ 'Huawei', 'MediaPad M1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_S8-301L_4_4.xml'                                        => [ 'Huawei', 'MediaPad M1 403HW', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/LST.xml'                                                               => [ 'Huawei', 'MediaPad M2', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HUAWEI_BAH-AL00_UAProfile.xml'                                         => [ 'Huawei', 'MediaPad M3 Lite', 'Windows',  ],
    'http://wap1.huawei.com/uaprof/HUAWEI_BAH-W09_UAProfile.xml'                                          => [ 'Huawei', 'MediaPad M3 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CPN-AL00_UAProfile.xml'                                         => [ 'Huawei', 'MediaPad M3 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CPN-W09_UAProfile.xml'                                          => [ 'Huawei', 'MediaPad M3 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/7D-501w.xml'                                                           => [ 'Huawei', 'MediaPad T1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad701XWCDMA.xml'                                           => [ 'Huawei', 'MediaPad T1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_S8-701w.xml'                                            => [ 'Huawei', 'MediaPad T1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediapad_S8-70Xu.xml'                                            => [ 'Huawei', 'MediaPad T1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediapad_T1-701g.xml'                                            => [ 'Huawei', 'MediaPad T1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediapad_T1-701u.xml'                                            => [ 'Huawei', 'Mediapad T1', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiMediapad_T1-701ua.xml'                                           => [ 'Huawei', 'MediaPad T1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediapad_T1-701w.xml'                                            => [ 'Huawei', 'MediaPad T1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediapad_T1-702u.xml'                                            => [ 'Huawei', 'MediaPad T1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_T1-821L.xml'                                            => [ 'Huawei', 'MediaPad T1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_T1-A21L.xml'                                            => [ 'Huawei', 'MediaPad T1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/T1-701u.xml'                                                           => [ 'Huawei', 'MediaPad T1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_PLE-703L.xml'                                           => [ 'Huawei', 'MediaPad T2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_T2-10.xml'                                              => [ 'Huawei', 'MediaPad T2', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HUAWEI_KOB-L09_UAProfile.xml'                                          => [ 'Huawei', 'MediaPad T3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_KOB-W09_UAProfile.xml'                                          => [ 'Huawei', 'MediaPad T3', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/7D-501L.xml'                                                           => [ 'Huawei', 'MediaPad X1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/7D-501L_4_4.xml'                                                       => [ 'Huawei', 'MediaPad X1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/7D-501u.xml'                                                           => [ 'Huawei', 'MediaPad X1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/7D-501u_4_4.xml'                                                       => [ 'Huawei', 'MediaPad X1', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_7D-501L.xml'                                            => [ 'Huawei', 'MediaPad X1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_7D-501u.xml'                                            => [ 'Huawei', 'MediaPad X1', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/X1S-703L.xml'                                                          => [ 'Huawei', 'MediaPad X1 S', 'Android', DeviceType::MOBILE ],
    'http://mms.openmobilepr.com/uaprof/HuaweiM886.xml'                                                   => [ 'Huawei', 'Mercury', 'Android', DeviceType::MOBILE ],
    'http://provantage.cleartalk.csky.us/ua/huawei_M886.xml'                                              => [ 'Huawei', 'Mercury', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiM886-Cricket.xml'                                                => [ 'Huawei', 'Mercury', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CAZ-TL10_UAProfile.xml'                                         => [ 'Huawei', 'Nova', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CAZ-TL20_UAProfile.xml'                                         => [ 'Huawei', 'Nova', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_BAC-TL00_UAProfile.xml'                                         => [ 'Huawei', 'Nova 2 Plus', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_VTR-TL00_UAProfile.xml'                                         => [ 'Huawei', 'P10', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_WAS-TL10_UAProfile.xml'                                         => [ 'Huawei', 'P10 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_VKY-TL00_UAProfile.xml'                                         => [ 'Huawei', 'P10 Plus', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_GRA-CL10_1_20150105.xml'                                            => [ 'Huawei', 'P8', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ALE-L21_5.1_UAProfile.xml'                                      => [ 'Huawei', 'P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_ALE-UL00_6.0_UAProfile.xml'                                     => [ 'Huawei', 'P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_ALE-CL00_6_0_UAProfile.xml'                                         => [ 'Huawei', 'P8 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_A168-AL10_UAProfile.xml'                                        => [ 'Huawei', 'P9', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_EVA-AL00_UAProfile.xml'                                         => [ 'Huawei', 'P9', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_EVA-AL10_UAProfile.xml'                                         => [ 'Huawei', 'P9', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_EVA-DL00_UAProfile.xml'                                         => [ 'Huawei', 'P9', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_EVA-TL00_UAProfile.xml'                                         => [ 'Huawei', 'P9', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_EVA-CL00_3_20160226.xml'                                            => [ 'Huawei', 'P9', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_VNS-TL00_UAProfile.xml'                                         => [ 'Huawei', 'P9 Lite', 'Windows', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_VNS_AL00_UAProfile.xml'                                         => [ 'Huawei', 'P9 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_VNS_DL00_UAProfile.xml'                                         => [ 'Huawei', 'P9 Lite', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_VIE-AL10_UAProfile.xml'                                         => [ 'Huawei', 'P9 Plus', 'Android', DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/Huawei-M931.xml'                                                   => [ 'Huawei', 'Premia 4G', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_HUAWEI_H891L.xml'                                                   => [ 'Huawei', 'Pronto', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad_FDR-A04L.xml'                                           => [ 'Huawei', 'Qua tab 02 HWT31', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HW/HW_HUAWEI_S8520_1_20110819.xml'                                       => [ 'Huawei', 'S8520', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/HW/HW_HUAWEI_S8600_1_20110825.xml'                                       => [ 'Huawei', 'S8600', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650GPRS-Normal.xml'                                            => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650GPRS-Normal236.xml'                                         => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650GPRS-UNICOM.xml'                                            => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650GPRS-Vodafone-It.xml'                                       => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650GPRS-Yoigo.xml'                                             => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650WCDMA-Normal.xml'                                           => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650WCDMA-Normal236.xml'                                        => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650WCDMA-Taiwan.xml'                                           => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650WCDMA-Tele2-HR.xml'                                         => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650WCDMA-Tele2-LT.xml'                                         => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650WCDMA-Tele2-SE.xml'                                         => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650WCDMA-UNICOM.xml'                                           => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650WCDMA-Vodafone-It.xml'                                      => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650WCDMA-Yoigo.xml'                                            => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8660GPRS-Normal.xml'                                            => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8660WCDMA-Normal.xml'                                           => [ 'Huawei', 'Sonic', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8661GPRS.xml'                                                   => [ 'Huawei', 'Sonic+', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8661WCDMA.xml'                                                  => [ 'Huawei', 'Sonic+', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.huawei.com/uaprof/HUAWEI-T8300-1.0.xml'                                             => [ 'Huawei', 'T8300', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.huawei.com/uaprof/HUAWEI-T8600-1.0.xml'                                             => [ 'Huawei', 'T8600', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_T8950N_UAProfile.xml'                                           => [ 'Huawei', 'T8950N', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8651WCDMA-VTR.xml'                                              => [ 'Huawei', 'Talon', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8651WCDMA-WIND.xml'                                             => [ 'Huawei', 'Talon', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8820GPRS-NII.xml'                                               => [ 'Huawei', 'Titan', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8820WCDMA-NII.xml'                                              => [ 'Huawei', 'Titan', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU120v100.xml'                                                    => [ 'Huawei', 'U120', null, DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U2800A_UAProfile.xml'                                           => [ 'Huawei', 'U2800', null, DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U2801_UAProfile.xml'                                            => [ 'Huawei', 'U2801', 'Brew', DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiU3100v100UNIWCDMA.xml'                                            => [ 'Huawei', 'U3100', null, DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiU3205v100WCDMA.xml'                                               => [ 'Huawei', 'U3205', null, DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiU3300v100GPRS.xml'                                                => [ 'Huawei', 'U3300', null, DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U3900_ATTNormal.xml'                                            => [ 'Huawei', 'U3900', null, DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U5120_UAProfile.xml'                                            => [ 'Huawei', 'U5120', null, DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U5200_UAProfile.xml'                                            => [ 'Huawei', 'U5200', 'Brew', DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiU526v100.xml'                                                     => [ 'Huawei', 'U526', null, DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiU528v100.xml'                                                     => [ 'Huawei', 'U528', null, DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U5300_UAProfile.xml'                                            => [ 'Huawei', 'U5300', 'Brew', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U5310_UAProfile.xml'                                            => [ 'Huawei', 'U5310', 'Brew', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU535v100GPRS.xml'                                                => [ 'Huawei', 'U535', null, DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U6150_UAProfile.xml'                                            => [ 'Huawei', 'U6150', null, DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_U6150_WIND_UAProfile.xml'                                       => [ 'Huawei', 'U6150', 'Brew', DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiU626v100.xml'                                                     => [ 'Huawei', 'U626', null, DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiV715v100WCDMA.xml'                                                => [ 'Huawei', 'U715', null, DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiV716v100WCDMA.xml'                                                => [ 'Huawei', 'U716', null, DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiV720v100WCDMA.xml'                                                => [ 'Huawei', 'U720', null, DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiV725v100GPRS.xml'                                                 => [ 'Huawei', 'U725', null, DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiV725v100WCDMA.xml'                                                => [ 'Huawei', 'U725', null, DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiU7510v100WCDMA.xml'                                               => [ 'Huawei', 'U7510', null, DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiV810v100GPRS.xml'                                                 => [ 'Huawei', 'U810', null, DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiV810v100WCDMA.xml'                                                => [ 'Huawei', 'U810', null, DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8100-9v100WCDMA.xml'                                            => [ 'Huawei', 'U8100', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8100v100GPRSNormal.xml'                                         => [ 'Huawei', 'U8100', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8100v100WCDMANormal.xml'                                        => [ 'Huawei', 'U8100', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8109GPRS.xml'                                                   => [ 'Huawei', 'U8109', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8109v100WCDMA.xml'                                              => [ 'Huawei', 'U8109', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8110v100GPRS.xml'                                               => [ 'Huawei', 'U8110', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8110v100GPRSNormal.xml'                                         => [ 'Huawei', 'U8110', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8110v100WCDMA.xml'                                              => [ 'Huawei', 'U8110', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8110v100WCDMANormal.xml'                                        => [ 'Huawei', 'U8110', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8160WCDMA-MTS.xml'                                              => [ 'Huawei', 'U8160', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8230v100GPRS.xml'                                               => [ 'Huawei', 'U8230', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8230v100WCDMAEclair.xml'                                        => [ 'Huawei', 'U8230', 'Android', DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiV830v100WCDMA.xml'                                                => [ 'Huawei', 'U830', null, DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8300v100GPRSNormal.xml'                                         => [ 'Huawei', 'U8300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8300v100WCDMANormal.xml'                                        => [ 'Huawei', 'U8300', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8652-51WCDMA-Normal236.xml'                                     => [ 'Huawei', 'U8652', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8652WCDMA-Normal.xml'                                           => [ 'Huawei', 'U8652', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8667GPRS-NII.xml'                                               => [ 'Huawei', 'U8667', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8667WCDMA-NII.xml'                                              => [ 'Huawei', 'U8667', 'Android', DeviceType::MOBILE ],
    'http://wap.huawei.com/uaprof/HuaweiU9130v100GPRS.xml'                                                => [ 'Huawei', 'U9130', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Huawei/Y538-2012071301/Y538C237B128.rdf'                                 => [ 'Huawei', 'Union', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Huawei/Y538-BOOST/Y538C237B128.rdf'                                      => [ 'Huawei', 'Union', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Huawei/Y538-BOOST/Y538C237B138.rdf'                                      => [ 'Huawei', 'Union', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Huawei/Y538-VIRGIN/Y538C237B150.rdf'                                     => [ 'Huawei', 'Union', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8850v100WCDMA.xml'                                              => [ 'Huawei', 'Vision', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_LUNA_UAProfile.xml'                                             => [ 'Huawei', 'Y3 II', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/LUA-U03_UAProfile.xml'                                                 => [ 'Huawei', 'Y3 II', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/LUA-U22_UAProfile.xml'                                                 => [ 'Huawei', 'Y3 II', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/LUA-U23_UAProfile.xml'                                                 => [ 'Huawei', 'Y3 II', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CANCUN_UAProfile.xml,http://wap1.huawei.com/uaprof/HUAWEI_CUN_L_UAProfile.xml'=> [ 'Huawei', 'Y5 II', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CUN_L_UAProfile.xml'                                            => [ 'Huawei', 'Y5 II', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CUN_U_UAProfile.xml'                                            => [ 'Huawei', 'Y5 II', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HW_SCC-U21_UAProfile.xml'                                              => [ 'Huawei', 'Y6', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_CAM_TL00H_UAProfile.xml'                                        => [ 'Huawei', 'Y6 II', 'Android', DeviceType::MOBILE ],
    'http://imatemms.imate.com/gen/UAProf_8502_v1.xml'                                                    => [ 'i-mate', '8502', null, DeviceType::MOBILE ],
    'http://imatemms.imate.com/gen/UAProf_9502_v1.xml'                                                    => [ 'i-mate', '9502', null, DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/tmo/i-mate K-JAM PPC-1.3.xml'                                               => [ 'i-mate', 'K-JAM', 'Windows Mobile', DeviceType::MOBILE ],
    'http://imatemms.imate.com/gen/UAProf_Pebble_v1.xml'                                                  => [ 'i-mate', 'Pebble', null, DeviceType::MOBILE ],
    'http://asmobile.ehosting.com.tw/uaprof/i-mobile607.xml'                                              => [ 'i-mobile', '607', null, DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/i-mobile/i-STYLE2.9.xml'                                              => [ 'i-Mobile', 'i-Style 2.9', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/i-mobile/i-STYLE7.6.xml'                                              => [ 'i-Mobile', 'i-Style 7.6', 'Android', DeviceType::MOBILE ],
    'http://uap.cellon.com/i-mobile IQ X.xml'                                                             => [ 'i-Mobile', 'iQ X', 'Android', DeviceType::MOBILE ],
    'http://uap.cellon.com/i-mobile IQ X2.xml'                                                            => [ 'i-Mobile', 'iQ X2', 'Android', DeviceType::MOBILE ],
    'http://uap.cellon.com/i-mobile IQ XA.xml'                                                            => [ 'i-mobile', 'iQ XA', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/BS/Brightstar_Avvio_760.xml'                                          => [ 'Ilium', 'Avvio 760', 'Android', DeviceType::MOBILE ],
    'http://xmlsite3.webs.com/Brightstar_Avvio_760.xml'                                                   => [ 'Ilium', 'Avvio 760', 'Android', DeviceType::MOBILE ],
    'http://ua.tinno.com/profile/latinamerica/brightstar/Avvio765_UAProf.xml'                             => [ 'Ilium', 'AVVIO 765', 'Android', DeviceType::MOBILE ],
    'http://ua.tinno.com/profile/latinamerica/brightstar/Avvio785_UAProf.xml'                             => [ 'Ilium', 'AVVIO 785', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/Brightstar/Avvio_790.xml'                                             => [ 'Ilium', 'Avvio 790', 'Android', DeviceType::MOBILE ],
    'http://guardsys.museui.com/Avvio793_WAP_BROWSER.xml'                                                 => [ 'Ilium', 'AVVIO 793', 'Android', DeviceType::MOBILE ],
    'http://cn.c2dms.com/UAProfile/N26/IN260.xml'                                                         => [ 'InFocus', 'IN260', 'Android', DeviceType::MOBILE ],
    'http://www.c2dms.com/UAProfile/IVM/IN330.xml'                                                        => [ 'InFocus', 'IN330', 'Android', DeviceType::MOBILE ],
    'http://cn.c2dms.com/UAProfile/MG2/IN610.xml'                                                         => [ 'InFocus', 'IN610', 'Android', DeviceType::MOBILE ],
    'http://cn.c2dms.com/UAProfile/VKY/IN810.xml'                                                         => [ 'InFocus', 'IN810', 'Android', DeviceType::MOBILE ],
    'http://www.c2dms.com/UAProfile/VKY/IN810.xml'                                                        => [ 'InFocus', 'IN810', 'Android', DeviceType::MOBILE ],
    'http://cn.c2dms.com/UAProfile/LSO/M2.xml'                                                            => [ 'InFocus', 'M2', 'Android', DeviceType::MOBILE ],
    'http://www.c2dms.com/UAProfile/LSO/M2.xml'                                                           => [ 'InFocus', 'M2', 'Android', DeviceType::MOBILE ],
    'http://cn.c2dms.com/UAProfile/H1M/M210.xml'                                                          => [ 'InFocus', 'M210', 'Android', DeviceType::MOBILE ],
    'http://www.c2dms.com/UAProfile/H1M/M210.xml'                                                         => [ 'InFocus', 'M210', 'Android', DeviceType::MOBILE ],
    'http://cn.c2dms.com/UAProfile/H1W/M310.xml'                                                          => [ 'InFocus', 'M310', 'Android', DeviceType::MOBILE ],
    'http://cn.c2dms.com/UAProfile/D70/M320m.xml'                                                         => [ 'InFocus', 'M320', 'Android', DeviceType::MOBILE ],
    'http://cn.c2dms.com/UAProfile/D70/M320u.xml'                                                         => [ 'InFocus', 'M320', 'Android', DeviceType::MOBILE ],
    'http://www.c2dms.com/UAProfile/D70/M320u.xml'                                                        => [ 'InFocus', 'M320', 'Android', DeviceType::MOBILE ],
    'http://cn.c2dms.com/UAProfile/TID/InFocus M510t.xml'                                                 => [ 'InFocus', 'M510', 'Android', DeviceType::MOBILE ],
    'http://cn.c2dms.com/UAProfile/TID/PZ_InFocus_M510t.xml'                                              => [ 'InFocus', 'M510', 'Android', DeviceType::MOBILE ],
    'http://www.c2dms.com/UAProfile/TID_CHT/M510.xml'                                                     => [ 'InFocus', 'M510', 'Android', DeviceType::MOBILE ],
    'http://www.c2dms.com/UAProfile/TID_TWN/InFocus M511.xml'                                             => [ 'InFocus', 'M511', 'Android', DeviceType::MOBILE ],
    'http://cn.c2dms.com/UAProfile/MC2_CN/M512.xml'                                                       => [ 'InFocus', 'M512', 'Android', DeviceType::MOBILE ],
    'http://cn.c2dms.com/UAProfile/VNA/M810u.xml'                                                         => [ 'InFocus', 'M810', 'Android', DeviceType::MOBILE ],
    'http://cn.c2dms.com/UAProfile/VNA/PZ_M810t.xml'                                                      => [ 'Infocus', 'M810', 'Android', DeviceType::MOBILE ],
    'http://wap.innostream.com/uaprof/INNO30.xml'                                                         => [ 'Innostream', 'INNO 30', null, DeviceType::MOBILE ],
    'http://wap.innostream.com/uaprof/INNO55.xml'                                                         => [ 'Innostream', 'INNO 55', null, DeviceType::MOBILE ],
    'http://wap.innostream.com/uaprof/INNO89.xml'                                                         => [ 'Innostream', 'INNO 89', null, DeviceType::MOBILE ],
    'http://wap.innostream.com/uaprof/INNO90.xml'                                                         => [ 'Innostream', 'INNO 90', null, DeviceType::MOBILE ],
    'http://wap.innostream.com/uaprof/INNO98.xml'                                                         => [ 'Innostream', 'INNO 98', null, DeviceType::MOBILE ],
    'http://wap.innostream.com/uaprof/INNOA10.xml'                                                        => [ 'Innostream', 'INNO A10', null, DeviceType::MOBILE ],
    'http://wap.innostream.com/uaprof/INNOA10_W2.xml'                                                     => [ 'Innostream', 'INNO A10', null, DeviceType::MOBILE ],
    'http://www.inqmobile.com/ua/inq1.xml'                                                                => [ 'INQ', 'INQ1', null, DeviceType::MOBILE ],
    'http://50.18.182.85/profile/AZ210_UA_Profile.xml'                                                    => [ 'Intel', 'AZ210', 'Android', DeviceType::MOBILE ],
    'http://50.18.182.85/profile/AZ210A_UA_Profile.xml'                                                   => [ 'Intel', 'AZ210A', 'Android', DeviceType::MOBILE ],
    'http://downloadmirror.intel.com/20932/eng/AZ210A_UA_Profile.xml'                                     => [ 'Intel', 'AZ210A', 'Android', DeviceType::MOBILE ],
    'http://downloadmirror.intel.com/20932/eng/AZ210B_UA_Profile.xml'                                     => [ 'Intel', 'AZ210B', 'Android', DeviceType::MOBILE ],
    'http://www.ibbprof.com/uaprof/AZ210B_UA_Profile.xml'                                                 => [ 'Intel', 'AZ210B', 'Android', DeviceType::MOBILE ],
    'http://50.18.182.85/profile/AZ510_UA_Profile.xml'                                                    => [ 'Intel', 'AZ510', 'Android', DeviceType::MOBILE ],
    'http://downloadmirror.intel.com/20932/eng/AZ510_UA_Profile.xml'                                      => [ 'Intel', 'AZ510', 'Android', DeviceType::MOBILE ],
    'http://www.ibbprof.com/uaprof/AZ510_UA_Profile.xml'                                                  => [ 'Intel', 'AZ510', 'Android', DeviceType::MOBILE ],
    'http://downloadmirror.intel.com/20932/eng/BT210_UA_Profile.xml'                                      => [ 'Intel', 'BT210', 'Android', DeviceType::MOBILE ],
    'http://downloadmirror.intel.com/20932/eng/BT230_UA_Profile.xml'                                      => [ 'Intel', 'BT230', 'Android', DeviceType::MOBILE ],
    'http://downloadmirror.intel.com/20932/eng/BT510_UA_Profile.xml'                                      => [ 'Intel', 'BT510', 'Android', DeviceType::MOBILE ],
    'http://intextechnologies.com/wap/intex_Cloud-X3.xml'                                                 => [ 'Intex', 'Cloud X3', 'Android', DeviceType::MOBILE ],
    'http://www.intextechnologies.com/wap/intex_Cloud-Y1.xml'                                             => [ 'Intex', 'Cloud Y1', 'Android', DeviceType::MOBILE ],
    'http://intextechnologies.com/wap/intex_Cloud-y2.xml'                                                 => [ 'Intex', 'Cloud Y2', 'Android', DeviceType::MOBILE ],
    'http://mobile.itelcospa.it/useragent/ITELCO-IT2500.xml'                                              => [ 'Itelco', 'IT2500', null, DeviceType::MOBILE ],
    'http://uaprofs.scm.ixi.com:8080/UAProfs/ct-25m-scm-q0108.xml'                                        => [ 'IXI', 'CT 25m', null, DeviceType::MOBILE ],
    'http://www.nyxmobile.com/UAProfile/zeuzhd/NYX_ZEUZ_HD.xml'                                           => [ 'Jiayu', 'G4C', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Jiayu_G4S.xml'                                                      => [ 'Jiayu', 'G4S', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOJY-G5.xml'                                                  => [ 'Jiayu', 'G5', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/TY/TY_E619+_1_20121123.xml'                                              => [ 'K-Touch', 'E619', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/TY/TY_K-Touch_E619+_1_20121203.xml'                                      => [ 'K-Touch', 'E619', 'Android', DeviceType::MOBILE ],
    'http://uaprof.qma.com.tw/ktouch-e620.xml'                                                            => [ 'K-Touch', 'E620', 'Android', DeviceType::MOBILE ],
    'http://uaprof.qma.com.tw/ktouch-e650.xml'                                                            => [ 'K-Touch', 'E650', 'Android', DeviceType::MOBILE ],
    'http://uaprof.qma.com.tw/ktouch-e780.xml'                                                            => [ 'K-Touch', 'E780', 'Android', DeviceType::MOBILE ],
    'http://uaprof.qma.com.tw/ktouch-e815.xml'                                                            => [ 'K-Touch', 'E815', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S898t+_KK_UAprofile.xml'            => [ 'K-Touch', 'Niburu Mars One H1', 'Android', DeviceType::MOBILE ],
    'http://www.ontim.com.cn/ua/K-Touch_T580_uaprofile.xml'                                               => [ 'K-Touch', 'T580', 'Android', DeviceType::MOBILE ],
    'http://114.251.81.153/t660/K-Touch_T660_profile_3G.xml'                                              => [ 'K-Touch', 'T660', 'Android', DeviceType::MOBILE ],
    'http://114.251.81.153/UAProfile/U81t/K-Touch_U81t_UAProfile.xml'                                     => [ 'K-Touch', 'U81t', 'Android', DeviceType::MOBILE ],
    'http://218.206.177.209:8080/waptest/browser15/TC3.html'                                              => [ 'KATA', 'i3s', 'Android', DeviceType::MOBILE ],
    'http://tsprdev.com/kazam/ua/spain/movistar/KAZAM_Trooper_450_UAprofile.xml'                          => [ 'KAZAM', 'Trooper 450', 'Android', DeviceType::MOBILE ],
    'http://www.fly-phone.ru/UAP/Fly_IQ4505_Quad.xml'                                                     => [ 'KAZAM', 'Trooper 451', 'Android', DeviceType::MOBILE ],
    'http://asmobile.ehosting.com.tw/uaprof/KingcomInjoyMS02.xml'                                         => [ 'Kingcom', 'Injoy MS02', null, DeviceType::MOBILE ],
    'http://guardsys.museui.com/KIOTO793_WAP_BROWSER.xml'                                                 => [ 'KIOTO', '793', 'Android', DeviceType::MOBILE ],
    'http://www.mobilesoft.com.cn/UAProfile/CMSMMS2003.xml'                                               => [ 'Konka', 'C908', null, DeviceType::MOBILE ],
    'http://www.konkamobile.com/profile/konka_k3.xml'                                                     => [ 'Konka', 'K3', 'Android', DeviceType::MOBILE ],
    'http://www.konkamobile.com/uploadfile/KONKA_V926_UAProfile.xml'                                      => [ 'Konka', 'V926', 'Android', DeviceType::MOBILE ],
    'http://www.kkcool.com/hw/KONKA_V936.xml'                                                             => [ 'Konka', 'V936', 'Android', DeviceType::MOBILE ],
    'http://www.kkcool.com/hw/KONKA_V980.xml'                                                             => [ 'Konka', 'V980', 'Android', DeviceType::MOBILE ],
    'http://www.konkamobile.com/Profile/KONKA_V985.xml'                                                   => [ 'Konka', 'V985', 'Android', DeviceType::MOBILE ],
    'http://www.konkamobile.com/profile/KONKA_V987.xml'                                                   => [ 'Konka', 'V987', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/KPN_Smart_300.xml'                                               => [ 'KPN', 'Smart 300', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/KPN_Smart_400.xml'                                               => [ 'KPN', 'Smart 400', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Kyivstar Spark.xml'                                              => [ 'Kyivstar', 'Spark', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/S2151-BST/1.001BT.rdf'                                           => [ 'Kyocera', 'Coast S2151', 'Brew MP', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/S2151-PLB/1.001VM.rdf'                                           => [ 'Kyocera', 'Coast S2151', 'Brew', DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/Kyocera/vmk325/VMU_Thunder_UAProf.xml'                                       => [ 'Kyocera', 'Cyclops', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Kyocera/E4233/1400SP.rdf'                                                => [ 'Kyocera', 'E4233', 'Brew MP', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Kyocera/E4277/1308SP.rdf'                                                => [ 'Kyocera', 'E4277', 'Brew', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Kyocera/M9300/1100SP.rdf'                                                => [ 'Kyocera', 'Echo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Kyocera/M9300/2002SP.rdf'                                                => [ 'Kyocera', 'Echo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Kyocera/M9300/2006SP.rdf'                                                => [ 'Kyocera', 'Echo', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/JC/JC_KSP8000_3_20111228.xml'                                            => [ 'Kyocera', 'Echo', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/JC/JC_KSP8000_3_20120209.xml'                                            => [ 'Kyocera', 'Echo', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/JC/JC_KSP8000_4_20120308.xml'                                            => [ 'Kyocera', 'Echo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5133-2012102201/1.020VM.rdf'                                    => [ 'Kyocera', 'Event', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5133-823/1.020VM.rdf'                                           => [ 'Kyocera', 'Event', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5133-Chameleon/latest'                                          => [ 'Kyocera', 'Event', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5133-VIRGIN/1.005VM.rdf'                                        => [ 'Kyocera', 'Event', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5133-VIRGIN/1.010VM.rdf'                                        => [ 'Kyocera', 'Event', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5133-VIRGIN/1.020VM.rdf'                                        => [ 'Kyocera', 'Event', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5170-2011050301/1.200BT.rdf'                                    => [ 'Kyocera', 'Hydro', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5170-2012051001/1.001BT.rdf'                                    => [ 'Kyocera', 'Hydro', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5170-2012102201/1.200BT.rdf'                                    => [ 'Kyocera', 'Hydro', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5170-BOOST/1.000BT.rdf'                                         => [ 'Kyocera', 'Hydro', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5170-BOOST/1.001BT.rdf'                                         => [ 'Kyocera', 'Hydro', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5170-BOOST/1.006BT.rdf'                                         => [ 'Kyocera', 'Hydro', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5170-BOOST/1.010BT.rdf'                                         => [ 'Kyocera', 'Hydro', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5170-BOOST/1.200BT.rdf'                                         => [ 'Kyocera', 'Hydro', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5170-BOOST/1.201BT.rdf'                                         => [ 'Kyocera', 'Hydro', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Kyocera/C5170-BST/0510BT.rdf'                                            => [ 'Kyocera', 'Hydro', 'Android', DeviceType::MOBILE ],
    'http://wapuaprof.mycricket.com/kyo_c5171.xml'                                                        => [ 'Kyocera', 'Hydro', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5215-BOOST/1.001.rdf'                                           => [ 'Kyocera', 'Hydro Edge', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5215-BOOST/1.002.rdf'                                           => [ 'Kyocera', 'Hydro Edge', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5215-BOOST/1.010.rdf'                                           => [ 'Kyocera', 'Hydro Edge', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5215-BOOST/1.020.rdf'                                           => [ 'Kyocera', 'Hydro Edge', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5215-Chameleon/latest'                                          => [ 'Kyocera', 'Hydro Edge', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5215-SPRINT/1.020.rdf'                                          => [ 'Kyocera', 'Hydro Edge', 'Android', DeviceType::MOBILE ],
    'http://uaprof.publicmobile.ca/Kyocera/Hydro_C5216_0.200NP.rdf'                                       => [ 'Kyocera', 'Hydro Edge', 'Android', DeviceType::MOBILE ],
    'http://uaprof.publicmobile.ca/Kyocera/Hydro_C5216_0.300NP.rdf'                                       => [ 'Kyocera', 'Hydro Edge', 'Android', DeviceType::MOBILE ],
    'http://uaprof.publicmobile.ca/Kyocera/Hydro_C5216_0.350NP.rdf'                                       => [ 'Kyocera', 'Hydro Edge', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C6730-BOOST/1.003.rdf'                                           => [ 'Kyocera', 'Hydro Icon', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C6730-BOOST/1.010.rdf'                                           => [ 'Kyocera', 'Hydro Icon', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C6730-Chameleon/latest'                                          => [ 'Kyocera', 'Hydro Icon', 'Android', DeviceType::MOBILE ],
    'http://www.kyocera-wireless.com/UAProf/C6530/C6530N_TM002.xml'                                       => [ 'Kyocera', 'Hydro Life', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C6725-SPRINT/1.003.rdf'                                          => [ 'Kyocera', 'Hydro Vibe', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C6725-VIRGIN/1.003.rdf'                                          => [ 'Kyocera', 'Hydro Vibe', 'Android', DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/kyocera-C6721.xml'                                                 => [ 'Kyocera', 'Hydro XTRM', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/KYOCERA/C6721/0.920US.xml'                                                   => [ 'Kyocera', 'Hydro XTRM', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/KYOCERA/C6721/0.990US.xml'                                                   => [ 'Kyocera', 'Hydro XTRM', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/KYOCERA/C6721/1.000US.xml'                                                   => [ 'Kyocera', 'Hydro XTRM', 'Android', DeviceType::MOBILE ],
    'http://www.kyocera-wireless.com/UAProf/C6522/C6522N_TM001.xml'                                       => [ 'Kyocera', 'Hydro XTRM', 'Android', DeviceType::MOBILE ],
    'http://www.kyocera-wireless.com/UAProf/C6522/C6522N_TM002.xml'                                       => [ 'Kyocera', 'Hydro XTRM', 'Android', DeviceType::MOBILE ],
    'http://www.kyocera-wireless.com/UAProf/C6522/C6522_TM001.xml'                                        => [ 'Kyocera', 'Hydro XTRM', 'Android', DeviceType::MOBILE ],
    'https://servicios.iusacell.com.mx/kyo/KX18.xml'                                                      => [ 'Kyocera', 'KX18', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Kyocera/C5120-BST/1.100BT.rdf'                                           => [ 'Kyocera', 'Milano', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Kyocera/C5120/1007SP.rdf'                                                => [ 'Kyocera', 'Milano', 'Android', DeviceType::MOBILE ],
    'http://mms.revol.us/uaprofs/Oblique_C5121.xml'                                                       => [ 'Kyocera', 'Milano', 'Android', DeviceType::MOBILE ],
    'http://www.kyoceramobile.com/UAProf/S1370/S1370_TB001.xml'                                           => [ 'Kyocera', 'Rally', 'Brew MP', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5155-2011011301/1.011SP.rdf'                                    => [ 'Kyocera', 'Rise', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5155-SPRINT/1.003SP.rdf'                                        => [ 'Kyocera', 'Rise', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5155-SPRINT/1.005SP.rdf'                                        => [ 'Kyocera', 'Rise', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/C5155-SPRINT/1.011SP.rdf'                                        => [ 'Kyocera', 'Rise', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Kyocera/C5155/0401SP.rdf'                                                => [ 'Kyocera', 'Rise', 'Android', DeviceType::MOBILE ],
    'http://profile.kyocera-wireless.com/uaprof/Rise_C5156_1.002PM.rdf'                                   => [ 'Kyocera', 'Rise', 'Android', DeviceType::MOBILE ],
    'http://profile.kyocera-wireless.com/uaprof/Rise_C5156_1.101PM.rdf'                                   => [ 'Kyocera', 'Rise', 'Android', DeviceType::MOBILE ],
    'http://uaprof.publicmobile.ca/Kyocera/Rise_C5156_1.101PM.rdf'                                        => [ 'Kyocera', 'Rise', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/Kyocera/C5155-VMUB/1.0/UAProf.xml'                                           => [ 'Kyocera', 'Rise', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/KYOCERA/K10-Royale/VMU_Royale_UAProf.xml'                                    => [ 'Kyocera', 'Royale', null, DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/kyocera/S2000i/VMU_S2000i_UAProf.xml'                                        => [ 'Kyocera', 'S2000i', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/S3015-PLB/1.001VM.rdf'                                           => [ 'Kyocera', 'S3015-PLB', 'Brew MP', DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/KYOCERA/K612/VMU_Switch_Back_UAProf.xml'                                     => [ 'Kyocera', 'Strobe', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/E6710-Chameleon/latest'                                          => [ 'Kyocera', 'Torque', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/E6710-SPRINT/1.005SP.rdf'                                        => [ 'Kyocera', 'Torque', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/E6710-SPRINT/1.006SP.rdf'                                        => [ 'Kyocera', 'Torque', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/E6710-SPRINT/1.007SP.rdf'                                        => [ 'Kyocera', 'Torque', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/E6710-SPRINT/2.002SP.rdf'                                        => [ 'Kyocera', 'Torque', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/E6710-SPRINT/2.300SP.rdf'                                        => [ 'Kyocera', 'Torque', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/E6710-SPRINT/2.602SP.rdf'                                        => [ 'Kyocera', 'Torque', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/KYOCERA/E6710-SPRINT/3.000SP.rdf'                                        => [ 'Kyocera', 'Torque', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Sanyo/PL8600/1004PL.rdf'                                                 => [ 'Kyocera', 'Zio', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Sanyo/PL8600/2103PL.rdf'                                                 => [ 'Kyocera', 'Zio', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Sanyo/SCP8600/2200SP.rdf'                                                => [ 'Kyocera', 'Zio', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/profiles/Lanix_Ilium_L1100.xml'                                           => [ 'Lanix', 'Ilium L1100', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/profiles/LANIX_IliumL1200_Chrome.xml'                                     => [ 'Lanix', 'Ilium L1200', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/profiles/Lanix_IliumL400.xml'                                             => [ 'Lanix', 'Ilium L400', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/profiles/Lanix_ILIUM_L820.xml'                                            => [ 'Lanix', 'Ilium L820', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/profiles/Lanix_IliumL950_LP.xml'                                          => [ 'Lanix', 'Ilium L950', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/profiles/Lanix_IliumLT500.xml'                                            => [ 'Lanix', 'Ilium LT500', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/profiles/Lanix_ILIUM_S106.xml'                                            => [ 'Lanix', 'Ilium S106', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/Profiles/Lanix_IliumS115.xml'                                             => [ 'Lanix', 'Ilium S115', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/Profiles/Lanix_IliumS120.xml'                                             => [ 'Lanix', 'Ilium S120', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/profiles/Lanix_ILIUM_S130.xml'                                            => [ 'Lanix', 'Ilium S130', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/Profiles/Lanix_iliumS200.xml'                                             => [ 'Lanix', 'Ilium S200', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/Profiles/Lanix_IliumS210.xml'                                             => [ 'Lanix', 'Ilium S210', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/Profiles/Lanix_iliumS400.xml'                                             => [ 'Lanix', 'Ilium S400', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/Profiles/Lanix_IliumS410.xml'                                             => [ 'Lanix', 'Ilium S410', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/Profiles/Lanix_iliumS420.xml'                                             => [ 'Lanix', 'Ilium S420', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/Profiles/Lanix_iliumS50.xml'                                              => [ 'Lanix', 'Ilium S50', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/Profiles/Lanix_IliumS500.xml'                                             => [ 'Lanix', 'Ilium S500', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/profiles/Lanix_IliumS520.xml'                                             => [ 'Lanix', 'Ilium S520', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/profiles/Lanix_ILIUM_S520.xml'                                            => [ 'Lanix', 'Ilium S520', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/Profiles/Lanix_IliumS700.xml'                                             => [ 'Lanix', 'Ilium S700', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/profiles/Lanix_IliumX110.xml'                                             => [ 'Lanix', 'Ilium X110', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/profiles/Lanix_IliumX200.xml'                                             => [ 'Lanix', 'Ilium X200', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/profiles/Lanix_IliumX210.xml'                                             => [ 'Lanix', 'Ilium X210', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/profiles/Lanix_IliumX400.xml'                                             => [ 'Lanix', 'Ilium X400', 'Android', DeviceType::MOBILE ],
    'http://www.lanixmobile.com/profiles/Lanix_IliumX500B.xml'                                            => [ 'Lanix', 'Ilium X500B', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/LAVA_IRIS349_UAP.xml'                                                 => [ 'Lava', 'Flair E3', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/Flair%20P8.xml'                                                       => [ 'Lava', 'Flair P8', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/lava/LAVA_IRIS_355.xml'                                               => [ 'Lava', 'Iris 355', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/lava/LAVA_IRIS356.xml'                                                => [ 'Lava', 'Iris 356', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/LAVA_IRIS_360m_style.xml'                                             => [ 'Lava', 'Iris 360M', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/IRIS_400C.XML'                                                        => [ 'Lava', 'Iris 400 Colour', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/Lava%20Iris%20401.xml'                                                => [ 'Lava', 'Iris 401', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/lava/LAVA_IRIS402.xml'                                                => [ 'Lava', 'Iris 402', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/LAVA_IRIS412.xml'                                                     => [ 'Lava', 'Iris 412', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/LAVA_IRIS415.xml'                                                     => [ 'Lava', 'Iris 415', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/LAVA_iris_460.xml'                                                    => [ 'Lava', 'Iris 460', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/lava_iris500.xml'                                                     => [ 'Lava', 'Iris 500', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/lava/LAVA_IRIS_501.xml'                                               => [ 'Lava', 'Iris 501', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/lava/LAVA_IRIS504Q.xml'                                               => [ 'Lava', 'Iris 504Q', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/LAVA_IRIS504Q+.xml'                                                   => [ 'Lava', 'Iris 504QP', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/lava/LAVA_IRIS506Q.xml'                                               => [ 'Lava', 'Iris 506Q', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/iris_alfa.xml'                                                        => [ 'Lava', 'Iris Alfa', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/Iris_Alfa_L.xml'                                                      => [ 'Lava', 'Iris Alfa L', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/iris_fuel_10.xml'                                                     => [ 'Lava', 'Iris fuel10', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/iris_Fuel20.xml'                                                      => [ 'Lava', 'Iris fuel20', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/Micromax/Micromax_A107.xml'                                           => [ 'Lava', 'Iris fuel50', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/Iris%20Fuel60.xml'                                                    => [ 'Lava', 'Iris fuel60', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/lava/LAVA_N320.xml'                                                   => [ 'Lava', 'Iris N320', 'Android', DeviceType::MOBILE ],
    'http://uap.cellon.com/M8047LAL.xml'                                                                  => [ 'Lava', 'Iris Pro 20', 'Android', DeviceType::MOBILE ],
    'http://uap.cellon.com/M8047LA.xml'                                                                   => [ 'Lava', 'Iris Pro 30', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/Lava_Iris_X1_Grand.xml'                                               => [ 'Lava', 'Iris X1 Grand', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/iris_X1_Selfie.xml'                                                   => [ 'Lava', 'Iris X1 Selfie', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/Lava_Iris_X5.xml'                                                     => [ 'Lava', 'Iris X5', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/LAVA_IRISX8.xml'                                                      => [ 'Lava', 'Iris X8', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/Lava/X9.xml'                                                               => [ 'Lava', 'Iris X9', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/XOLO/XOLO_A500L.xml'                                                       => [ 'Lava', 'XOLO A500L', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/XOLO/XOLO_A500sLite.xml'                                                   => [ 'Lava', 'XOLO A500S Lite', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/XOLO/BLACK.xml'                                                            => [ 'Lava', 'XOLO Black', 'Android', DeviceType::MOBILE ],
    'http://msai.in/uaprof/XOLO/Play%20100.xml'                                                           => [ 'Lava', 'XOLO Play 6X-1000', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/XOLO/Play%208X-1100.xml'                                                   => [ 'Lava', 'XOLO Play 8X-1100', 'Android', DeviceType::MOBILE ],
    'http://wap.msaiuap.in/xolo/Q1000S.xml'                                                               => [ 'Lava', 'XOLO Q1000S', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/XOLO/XOLO_Q1010i.xml'                                                      => [ 'Lava', 'XOLO Q1010i', 'Android', DeviceType::MOBILE ],
    'http://msai.in/uaprof/XOLO/Q1011.xml'                                                                => [ 'Lava', 'XOLO Q1011', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/XOLO/Q2100.xml'                                                            => [ 'Lava', 'XOLO Q2100', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/XOLO/Q3000.xml'                                                            => [ 'Lava', 'XOLO Q3000', 'Android', DeviceType::MOBILE ],
    'http://www.msai.in/uaprof/XOLO/XOLO_Q900T.xml'                                                       => [ 'Lava', 'XOLO Q900T', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/lava/Q700.xml'                                                        => [ 'Lava', 'XOLO X900', 'Android', DeviceType::MOBILE ],
    'http://www.lemonmobiles.com/UAP/LemonP105.xml'                                                       => [ 'Lemon', 'P105', 'Android', DeviceType::MOBILE ],
    'http://www.lemonmobiles.com/UAP/LemonP3.xml'                                                         => [ 'Lemon', 'P3', 'Android', DeviceType::MOBILE ],
    'http://www.lemonmobiles.com/UAP/LemonP5.xml'                                                         => [ 'Lemon', 'P5', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A300_UAProfile.xml'                 => [ 'Lenovo', 'A300', 'Android', DeviceType::MOBILE ],
    'http://10.125.33.169:8080/LNV_Lenovo_A305e_2_20130627.xml'                                           => [ 'Lenovo', 'A305', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A319_AMX_UAProfile.xml'             => [ 'Lenovo', 'A319', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A326_UAProfile.xml'                 => [ 'Lenovo', 'A326', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A360_UAProfile.xml'                 => [ 'Lenovo', 'A360', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/downfile/LNV_Lenovo_A360e_1_20130925.xml'           => [ 'Lenovo', 'A360', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A366t_UAProfile.xml'                => [ 'Lenovo', 'A366', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A378t_UAProfile.xml'                => [ 'Lenovo', 'A378', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A500_UAProfile.xml'                 => [ 'Lenovo', 'A500', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A516_ROW_UAProfile.xml'             => [ 'Lenovo', 'A516', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A516_UAProfile.xml'                 => [ 'Lenovo', 'A516', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A520_UAProfile.xml'                 => [ 'Lenovo', 'A520', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo%20A526_ROW_UAProfile_0120.xml'      => [ 'Lenovo', 'A526', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S650_KK_ROW_UAprofile.xml'          => [ 'Lenovo', 'A536', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/TYZ/LNV_Lenovo_A560e_1_20111220.xml'                                     => [ 'Lenovo', 'A560', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A588t_UAProfile.xml'                => [ 'Lenovo', 'A588', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A60_UAProfile.xml'                  => [ 'Lenovo', 'A60', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A630e_UAProfile.xml'                => [ 'Lenovo', 'A630', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A630t_UAProfile.xml'                => [ 'Lenovo', 'A630', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A65_UAProfile.xml'                  => [ 'Lenovo', 'A65', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A656_UAProfile.xml'                 => [ 'Lenovo', 'A656', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A66t_profile_3G.xml'                => [ 'Lenovo', 'A66', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/A660_UAprofile.xml'                        => [ 'Lenovo', 'A660', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A678t_UAProfile.xml'                => [ 'Lenovo', 'A678', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/LNV/LNV_Lenovo_A68e_1_20110715.xml'                                      => [ 'Lenovo', 'A68', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A698t_UAProfile.xml'                => [ 'Lenovo', 'A698', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A700e_UAProfile.xml'                => [ 'Lenovo', 'A700', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A750_UAProfile.xml'                 => [ 'Lenovo', 'A750', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A7600-m_UAprofile.xml'              => [ 'Lenovo', 'A760', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A7600_UAprofile.xml'                => [ 'Lenovo', 'A7600', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A766_UAProfile.xml'                 => [ 'Lenovo', 'A766', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A789_UAProfile.xml'                 => [ 'Lenovo', 'A789', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/LNV/LNV_AE760_1_20111024.xml'                                            => [ 'Lenovo', 'A790', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A798t_UAProfile.xml'                => [ 'Lenovo', 'A798', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A800_UAProfile.xml'                 => [ 'Lenovo', 'A800', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A806_UAprofile.xml'                 => [ 'Lenovo', 'A806', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A808t-i_UAprofile.xml'              => [ 'Lenovo', 'A808', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A808t_UAprofile.xml'                => [ 'Lenovo', 'A808', 'Android', DeviceType::MOBILE ],
    'http://www.Lenovo.com.cn/mobile/uaprof/Lenovo_A820t.xml'                                             => [ 'Lenovo', 'A820', 'Android', DeviceType::MOBILE ],
    'http://www.Lenovo.com.cn/mobile/uaprof/ZTE_V967S.xml'                                                => [ 'Lenovo', 'A820', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A820t_UAProfile.xml'                => [ 'Lenovo', 'A820', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A820_UAProfile.xml'                 => [ 'Lenovo', 'A820', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOLenovo A820.xml'                                            => [ 'Lenovo', 'A820', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A830_UAProfile.xml'                 => [ 'Lenovo', 'A830', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A850+_UAprofile.xml'                => [ 'Lenovo', 'A850', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A850plus_UAprofile.xml'             => [ 'Lenovo', 'A850', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A850_ROW_UAProfile.xml'             => [ 'Lenovo', 'A850', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A850_UAProfile.xml'                 => [ 'Lenovo', 'A850', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A859_ROW_UAprofile.xml'             => [ 'Lenovo', 'A859', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A936_UAprofile.xml'                 => [ 'Lenovo', 'A936', 'Android', DeviceType::TABLET ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_A938t_UAprofile.xml'                => [ 'Lenovo', 'A938', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_B6000-HV_UAProfile.xml'             => [ 'Lenovo', 'B6000 Yoga Tablet 8', 'Android', DeviceType::TABLET ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_B6000-H_UAProfile.xml'              => [ 'Lenovo', 'B6000 Yoga Tablet 8', 'Android', DeviceType::TABLET ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/download_20071165379380.xml'               => [ 'Lenovo', 'E303', null, DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/i325wg_Profile.xml'                        => [ 'Lenovo', 'i325wg', null, DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/download_2006815893438.xml'                => [ 'Lenovo', 'I720', null, DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/download_2007736634847.xml'                => [ 'Lenovo', 'I906', null, DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/download_20075225142784.xml'               => [ 'Lenovo', 'I908', null, DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_B8000-H_UAProfile.xml'              => [ 'Lenovo', 'IdeaTab B8000', 'Android', DeviceType::TABLET ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S5000-H_UAProfile.xml'              => [ 'Lenovo', 'IdeaTab S5000', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOLenovo K31-t3.xml'                                          => [ 'Lenovo', 'K3', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_K50-T5_UAprofile.xml'               => [ 'Lenovo', 'K50', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_P70-A.xml'                          => [ 'Lenovo', 'P70', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_P70_UAProfile.xml'                  => [ 'Lenovo', 'P70', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/download_20071236069306.xml'               => [ 'Lenovo', 'P768', null, DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_P770_ROW_UAProfile.xml'             => [ 'Lenovo', 'P770', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_P770_UAProfile.xml'                 => [ 'Lenovo', 'P770', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/download_20067105107369.xml'               => [ 'Lenovo', 'P780', null, DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_P780_KK_UAProfile.xml'              => [ 'Lenovo', 'P780', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_P780_ROW_UAProfile.xml'             => [ 'Lenovo', 'P780', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_P780_UAProfile.xml'                 => [ 'Lenovo', 'P780', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOLenovo P780.xml'                                            => [ 'Lenovo', 'P780', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S650_KK_UAprofile.xml'              => [ 'Lenovo', 'S650', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S650_ROW_UAprofile.xml'             => [ 'Lenovo', 'S650', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S650_UAprofile.xml'                 => [ 'Lenovo', 'S650', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S658t_KK_UAprofile.xml'             => [ 'Lenovo', 'S658', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S658t_UAprofile.xml'                => [ 'Lenovo', 'S658', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/download_2008423595403.xml'                => [ 'Lenovo', 'S707', null, DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S720i_UAProfile.xml'                => [ 'Lenovo', 'S720', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S720_ROW_UAProfile.xml'             => [ 'Lenovo', 'S720', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S820_KK_UAprofile.xml'              => [ 'Lenovo', 'S820', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S820_ROW_UAProfile.xml'             => [ 'Lenovo', 'S820', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S820_UAProfile.xml'                 => [ 'Lenovo', 'S820', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HUAWEI_S850t_UAProfile.xml'                                            => [ 'Lenovo', 'S850', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S850T_UAprofile.xml'                => [ 'Lenovo', 'S850', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S850_KK_UAprofile.xml'              => [ 'Lenovo', 'S850', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S850_ROW_UAprofile.xml'             => [ 'Lenovo', 'S850', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S850_UAprofile.xml'                 => [ 'Lenovo', 'S850', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S860t_UAprofile.xml'                => [ 'Lenovo', 'S860', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S860_KK_UAprofile.xml'              => [ 'Lenovo', 'S860', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S860_ROW_UAprofile.xml'             => [ 'Lenovo', 'S860', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S860_UAprofile.xml'                 => [ 'Lenovo', 'S860', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S890i_UAProfile.xml'                => [ 'Lenovo', 'S890', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S890_ROW_UAProfile.xml'             => [ 'Lenovo', 'S890', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S898t+_UAProfile.xml'               => [ 'Lenovo', 'S898', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S898t_UAProfile.xml'                => [ 'Lenovo', 'S898', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S968t_KK_UAprofile.xml'             => [ 'Lenovo', 'S898', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/download_20075256251113.xml'               => [ 'Lenovo', 'S9', null, DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Lenovo S90-A.xml'                                                => [ 'Lenovo', 'S90', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S920_KK_UAProfile.xml'              => [ 'Lenovo', 'S920', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S920_ROW_UAProfile.xml'             => [ 'Lenovo', 'S920', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S920_UAProfile.xml'                 => [ 'Lenovo', 'S920', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S930_KK_UAprofile.xml'              => [ 'Lenovo', 'S930', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S930_ROW_UAprofile.xml'             => [ 'Lenovo', 'S930', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S930_UAprofile.xml'                 => [ 'Lenovo', 'S930', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S938t_UAprofile.xml'                => [ 'Lenovo', 'S938t', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S939_KK_UAprofile.xml'              => [ 'Lenovo', 'S939', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S939_UAprofile.xml'                 => [ 'Lenovo', 'S939', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S960_KK_UAprofile.xml'              => [ 'Lenovo', 'S960', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S960_ROW_UAProfile.xml'             => [ 'Lenovo', 'S960', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S960_UAprofile.xml'                 => [ 'Lenovo', 'S960', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_S968t_UAProfile.xml'                => [ 'Lenovo', 'S968t', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/download_20069185728203.xml'               => [ 'Lenovo', 'V800', null, DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_X2-CU_UAprofile.xml'                => [ 'Lenovo', 'Vibe X2', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_X2-TO_UAprofile.xml'                => [ 'Lenovo', 'Vibe X2', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/Lenovo_X2-TR_UAprofile.xml'                => [ 'Lenovo', 'Vibe X2', 'Android', DeviceType::MOBILE ],
    'http://www.lenovomobile.com/admin/module/product/DownFile/download_200710186443397.xml'              => [ 'Lenovo', 'X1', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-LG306G.xml'                                                           => [ 'LG', '306G', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-LG441G.xml'                                                           => [ 'LG', '441G', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-A165-M3-D1.xml'                                                       => [ 'LG', 'A165', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-A350-M3-D1.xml'                                                       => [ 'LG', 'A350', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-A380.xml'                                                             => [ 'LG', 'A380', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-A447.xml'                                                             => [ 'LG', 'A447', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/n0xwBQ5qwfIlsJPX/H788SG-M3-D1.xml'                                       => [ 'LG', 'AKA', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/oOTiaX1x1bTXYvdu/H788-M3-D1.xml'                                         => [ 'LG', 'AKA', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/oOTiaX1x1bTXYvdu/H788n-M3-D1.xml'                                        => [ 'LG', 'AKA', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/C710h-M6-D1-GB.xml'                                                      => [ 'LG', 'Aloha', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/C710h-M6-D1.xml'                                                         => [ 'LG', 'Aloha', 'Android', DeviceType::MOBILE ],
    'http://www.alltel.net/uaprof/lg/ax245/ax245.xml'                                                     => [ 'LG', 'AX245', null, DeviceType::MOBILE ],
    'http://www.alltel.net/uaprof/lg/ax260/ax260.xml'                                                     => [ 'LG', 'AX260 Scoop', null, DeviceType::MOBILE ],
    'http://www.alltel.net/uaprof/lg/ax355/ax355.xml'                                                     => [ 'LG', 'AX355', null, DeviceType::MOBILE ],
    'http://www.alltel.net/uaprof/lg/ax380/ax380.xml'                                                     => [ 'LG', 'AX380 Wave', null, DeviceType::MOBILE ],
    'http://www.alltel.net/uaprof/lg/ax4750/ax4750.xml'                                                   => [ 'LG', 'AX4750', null, DeviceType::MOBILE ],
    'http://www.alltel.net/uaprof/lg/ax490/ax490.xml'                                                     => [ 'LG', 'AX490', null, DeviceType::MOBILE ],
    'http://www.alltel.net/uaprof/lg/ax830/ax830.xml'                                                     => [ 'LG', 'AX830 Glimmer', null, DeviceType::MOBILE ],
    'http://www.alltel.net/uaprof/lg/ax8600/ax8600.xml'                                                   => [ 'LG', 'AX8600', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-B2070.xml'                                                            => [ 'LG', 'B2070', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-B450.xml'                                                             => [ 'LG', 'B450', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/4r8SiMuCXFiuV_W9/LG-B470.xml'                                            => [ 'LG', 'B470', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/BL40-M6-D2CL.xml'                                                        => [ 'LG', 'BL40', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C130.xml'                                                             => [ 'LG', 'C130', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C1300.xml'                                                            => [ 'LG', 'C1300', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C1500.xml'                                                            => [ 'LG', 'C1500', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C195-M3-D1.xml'                                                       => [ 'LG', 'C195', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C195N-M3-D1.xml'                                                      => [ 'LG', 'C195N', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C199-M3-D1.xml'                                                       => [ 'LG', 'C199', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C2000.xml'                                                            => [ 'LG', 'C2000', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C205-M3-D1.xml'                                                       => [ 'LG', 'C205', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C207-M3-D1.xml'                                                       => [ 'LG', 'C207', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C2500.xml'                                                            => [ 'LG', 'C2500', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C330-M3-D1.xml'                                                       => [ 'LG', 'C330', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C360-M3-D1.xml'                                                       => [ 'LG', 'C360', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C365-M3-D1.xml'                                                       => [ 'LG', 'C365', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C395.xml'                                                             => [ 'LG', 'C395', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C397-M3-D1.xml'                                                       => [ 'LG', 'C397', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C410.xml'                                                             => [ 'LG', 'C410', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-CB630.xml'                                                            => [ 'LG', 'CB630 Invision', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-CE110.xml'                                                            => [ 'LG', 'CE110', null, DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/LG-MS840.xml'                                                      => [ 'LG', 'Connect 4G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T300-M3-D1-NS.xml'                                                    => [ 'LG', 'Cookie Light T300', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-CT810.xml'                                                            => [ 'LG', 'CT810 Incite', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-CU320.xml'                                                            => [ 'LG', 'CU320', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-CU920.xml'                                                            => [ 'LG', 'CU920 Vu', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/_ogUJjFY_IgTaMCN/LGL21G-M10-D1.xml'                                      => [ 'LG', 'Destiny', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/C729-M10-D1.xml'                                                         => [ 'LG', 'DoublePlay', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-E300-M3-D1.xml'                                                       => [ 'LG', 'E300', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/C800G-M10-D1.xml'                                                        => [ 'LG', 'Eclypse', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS696/LS696ZVF.rdf'                                                   => [ 'LG', 'Elite', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lge/vs700/vs700.xml'                                                         => [ 'LG', 'Enlighten', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lg/vx11000/vx11000.xml'                                                      => [ 'LG', 'Env Touch', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lg/vx9200/vx9200.xml'                                                        => [ 'LG', 'Env3', 'Brew', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P870-M10-D1.xml'                                                         => [ 'LG', 'Escape', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P870-M6-D2.xml'                                                          => [ 'LG', 'Escape', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/AK1bQ_G8_-S9ccPj/H445-M10-D1.xml'                                        => [ 'LG', 'Escape2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/ojFJqSe94jShCXCN/H443-M3-D1.xml'                                         => [ 'LG', 'Escape2', 'Android', DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/LG-MS910.xml'                                                      => [ 'LG', 'Esteem', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-F2200.xml'                                                            => [ 'LG', 'F2200', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-F3000.xml'                                                            => [ 'LG', 'F3000', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/a_ygkA6q45TBK1IF/D393-M10-D1.xml'                                        => [ 'LG', 'F60', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D392-M3-D1.xml'                                                          => [ 'LG', 'F60', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LGMS395-M10-D0.xml'                                                      => [ 'LG', 'F60', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D315-M3-D1.xml'                                                          => [ 'LG', 'F70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D315-M6-D1.xml'                                                          => [ 'LG', 'F70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D315s-M6-D1.xml'                                                         => [ 'LG', 'F70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F370L-M3-D1.xml'                                                         => [ 'LG', 'F70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/L31L-M10-D1.xml'                                                         => [ 'LG', 'F70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-F7250.xml'                                                            => [ 'LG', 'F7250', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LGLS740-Chameleon/latest'                                             => [ 'LG', 'F90', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS740-2012071301/LS740ZV5.rdf'                                        => [ 'LG', 'F90', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS740-BOOST/LS740ZV3.rdf'                                             => [ 'LG', 'F90', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS740-BOOST/LS740ZV4.rdf'                                             => [ 'LG', 'F90', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS740-BOOST/LS740ZV5.rdf'                                             => [ 'LG', 'F90', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS740-BOOST/LS740ZV6.rdf'                                             => [ 'LG', 'F90', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS740-Chameleon/latest'                                               => [ 'LG', 'F90', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS740-SPRPRE/LS740ZV5.rdf'                                            => [ 'LG', 'F90', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS740-VIRGIN/LS740ZV3.rdf'                                            => [ 'LG', 'F90', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS740-VIRGIN/LS740ZV4.rdf'                                            => [ 'LG', 'F90', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS740-VIRGIN/LS740ZV5.rdf'                                            => [ 'LG', 'F90', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS740-VIRGIN/LS740ZV6.rdf'                                            => [ 'LG', 'F90', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.comLS740.rdf'                                                                => [ 'LG', 'F90', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-F9100.xml'                                                            => [ 'LG', 'F9100', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-F9200.xml'                                                            => [ 'LG', 'F9200', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS995-Chameleon/latest'                                               => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS995-SPRINT/LS995ZV3.rdf'                                            => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS995-SPRINT/LS995ZV6.rdf'                                            => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS995-SPRINT/LS995ZV7.rdf'                                            => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS995-SPRINT/LS995ZVA.rdf'                                            => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS995-SPRINT/LS995ZVB.rdf'                                            => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS995-SPRPRE/LS995ZVA.rdf'                                            => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS995-SPRPRE/LS995ZVB.rdf'                                            => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D950-M10-D1-KK.xml'                                                      => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D950-M10-D1.xml'                                                         => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D950-M3-D1.xml'                                                          => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D950G-M10-D1-KK.xml'                                                     => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D955-M10-D1.xml'                                                         => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D955-M3-D1-KK.xml'                                                       => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D955-M3-D1.xml'                                                          => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D955-M6-D1-KK.xml'                                                       => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D955-M6-D1.xml'                                                          => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D956-M3-D1.xml'                                                          => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D958-M10-D1.xml'                                                         => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D958-M3-D1-KK.xml'                                                       => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D958-M3-D1.xml'                                                          => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D959-M10-D1-KK.xml'                                                      => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D959-M10-D1.xml'                                                         => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F340L-M3-D1-KK.xml'                                                      => [ 'LG', 'G Flex', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS991-SPRINT/LS996ZV8.rdf'                                            => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS996-BOOST/LS996ZV9.rdf'                                             => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS996-Chameleon/latest'                                               => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS996-SPRINT/LS996ZV5.rdf'                                            => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS996-SPRINT/LS996ZV6.rdf'                                            => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS996-SPRINT/LS996ZV7.rdf'                                            => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS996-SPRINT/LS996ZV8.rdf'                                            => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS996-SPRINT/LS996ZV9.rdf'                                            => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS996-SPRINT/LS996ZVB.rdf'                                            => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS996-SPRINT/LS996ZVC.rdf'                                            => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/2D_2BD_BlBeXhXq5/H955-M3-D1.xml'                                         => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/2D_2BD_BlBeXhXq5/H955-M5-D1.xml'                                         => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/2D_2BD_BlBeXhXq5/H955-M6-D1.xml'                                         => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LS996-M10-D1.xml'                                                        => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/MbAHlRXTX34T2a8f/H950-M10-D1.xml'                                        => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/MbAHlRXTX34T2a8f/H950-M3-D1.xml'                                         => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/MbAHlRXTX34T2a8f/H955-M10-D1.xml'                                        => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/MbAHlRXTX34T2a8f/H955-M20-D1.xml'                                        => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/MbAHlRXTX34T2a8f/H955-M3-D1.xml'                                         => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/MbAHlRXTX34T2a8f/H955-M5-D1.xml'                                         => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/MbAHlRXTX34T2a8f/H955-M6-D1.xml'                                         => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/MbAHlRXTX34T2a8f/H959-M3-D1.xml'                                         => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://pix.cspire.com/UA/profile/lg/as995/as995.xml'                                                 => [ 'LG', 'G Flex 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/V410-D1.xml'                                                             => [ 'LG', 'G Pad 7.0', 'Android', DeviceType::TABLET ],
    'http://gsm.lge.com/html/gsm/V410-M10-D1.xml'                                                         => [ 'LG', 'G Pad 7.0', 'Android', DeviceType::TABLET ],
    'http://gsm.lge.com/html/gsm/V410-M3-D1.xml'                                                          => [ 'LG', 'G Pad 7.0', 'Android', DeviceType::TABLET ],
    'http://gsm.lge.com/html/gsm/V410GO-D1.xml'                                                           => [ 'LG', 'G Pad 7.0', 'Android', DeviceType::TABLET ],
    'http://gsm.lge.com/html/gsm/V490-M3-D1.xml'                                                          => [ 'LG', 'G Pad 7.0', 'Android', DeviceType::TABLET ],
    'http://device.sprintpcs.com/LG/LK430-Chameleon/latest'                                               => [ 'LG', 'G Pad F 7.0', 'Android', DeviceType::TABLET ],
    'http://device.sprintpcs.com/LG/LK430-SPRINT/LK430ZV3.rdf'                                            => [ 'LG', 'G Pad F 7.0', 'Android', DeviceType::TABLET ],
    'http://device.sprintpcs.com/LG/LK430-SPRINT/LK430ZV4.rdf'                                            => [ 'LG', 'G Pad F 7.0', 'Android', DeviceType::TABLET ],
    'http://device.sprintpcs.com/LG/LK430-SPRINT/LK430ZV5.rdf'                                            => [ 'LG', 'G Pad F 7.0', 'Android', DeviceType::TABLET ],
    'http://device.sprintpcs.com/LG/LK430-SPRINT/LK430ZV6.rdf'                                            => [ 'LG', 'G Pad F 7.0', 'Android', DeviceType::TABLET ],
    'http://device.sprintpcs.com/LG/LK430-SPRINT/LK430ZV7.rdf'                                            => [ 'LG', 'G Pad F 7.0', 'Android', DeviceType::TABLET ],
    'http://gsm.lge.com/html/gsm/iBpgg_0u_ASxAV_F/V495-D1.xml'                                            => [ 'LG', 'G Pad F 7.0', 'Android', DeviceType::TABLET ],
    'http://gsm.lge.com/html/gsm/iBpgg_0u_ASxAV_F/V499-D1.xml'                                            => [ 'LG', 'G Pad F 8.0', 'Android', DeviceType::TABLET ],
    'http://gsm.lge.com/html/gsm/rGTs_Yxuw5wT0ZyW/V495-D1.xml'                                            => [ 'LG', 'G Pad F 8.0', 'Android', DeviceType::TABLET ],
    'http://gsm.lge.com/html/gsm/TksSP_-GkCHZ7K__/V930-D1.xml'                                            => [ 'LG', 'G Pad X 10.1', 'Android', DeviceType::TABLET ],
    'http://gsm.lge.com/html/gsm/_-0_bP_4P_s73ov-/V930-D1.xml'                                            => [ 'LG', 'G Pad X 10.1', 'Android', DeviceType::TABLET ],
    'http://gsm.lge.com/html/gsm/D830-M3-D1.xml'                                                          => [ 'LG', 'G Pro 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D838-M3-D1-KK.xml'                                                       => [ 'LG', 'G Pro 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D838-M3-D1.xml'                                                          => [ 'LG', 'G Pro 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D838-M9-D1-KK.xml'                                                       => [ 'LG', 'G Pro 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F350K-M3-D1-KK.xml'                                                      => [ 'LG', 'G Pro 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F350K-M3-D1.xml'                                                         => [ 'LG', 'G Pro 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F350L-M3-D1.xml'                                                         => [ 'LG', 'G Pro 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F350L-M9-D1.xml'                                                         => [ 'LG', 'G Pro 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F350S-M10-D1.xml'                                                        => [ 'LG', 'G Pro 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F350S-M3-D1.xml'                                                         => [ 'LG', 'G Pro 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D680-M10-D1-KK.xml'                                                      => [ 'LG', 'G Pro Lite', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D680-M10-D1.xml'                                                         => [ 'LG', 'G Pro Lite', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D680-M3-D1-KK.xml'                                                       => [ 'LG', 'G Pro Lite', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D680-M3-D1.xml'                                                          => [ 'LG', 'G Pro Lite', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D681-M3-D1-KK.xml'                                                       => [ 'LG', 'G Pro Lite', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D681-M3-D1.xml'                                                          => [ 'LG', 'G Pro Lite', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D682-M3-D1.xml'                                                          => [ 'LG', 'G Pro Lite', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D682TR-M3-D1.xml'                                                        => [ 'LG', 'G Pro Lite', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D682TR-M5-D1.xml'                                                        => [ 'LG', 'G Pro Lite', 'Android', DeviceType::MOBILE ],
    'http://tool.xcdn.gdms.lge.com/html/uap/BZGZ3OH0HR/D682TR-M3-D1.xml'                                  => [ 'LG', 'G Pro Lite', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D685-M3-D1-KK.xml'                                                       => [ 'LG', 'G Pro Lite Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D685-M3-D1.xml'                                                          => [ 'LG', 'G Pro Lite Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D686-M3-D1-KK.xml'                                                       => [ 'LG', 'G Pro Lite Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D686-M3-D1.xml'                                                          => [ 'LG', 'G Pro Lite Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D686-M5-D1-KK.xml'                                                       => [ 'LG', 'G Pro Lite Dual', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-BOOST/LS770ZV3.rdf'                                             => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-BOOST/LS770ZV4.rdf'                                             => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-BOOST/LS770ZV5.rdf'                                             => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-BOOST/LS770ZV7.rdf'                                             => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-BOOST/LS770ZV8.rdf'                                             => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-BOOST/LS770ZV9.rdf'                                             => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-BOOST/LS770ZVA.rdf'                                             => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-BOOST/LS770ZVB.rdf'                                             => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-BOOST/LS770ZVE.rdf'                                             => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-Chameleon/latest'                                               => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-SPRINT/LS770ZV4.rdf'                                            => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-SPRINT/LS770ZV5.rdf'                                            => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-SPRINT/LS770ZV7.rdf'                                            => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-SPRINT/LS770ZVB.rdf'                                            => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-SPRPRE/LS770ZV3.rdf'                                            => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-SPRPRE/LS770ZV4.rdf'                                            => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-VIRGIN/LS770ZV7.rdf'                                            => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-VIRGIN/LS770ZV9.rdf'                                            => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-VIRGIN/LS770ZVA.rdf'                                            => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS770-VIRGIN/LS770ZVB.rdf'                                            => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/5uyruBAm__1ZuYMa/H631-M10-D1.xml'                                        => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/b7_gceeg_u9fMBZq/H635-M10-D1.xml'                                        => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/b7_gceeg_u9fMBZq/H635-M5-D1.xml'                                         => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/b7_gceeg_u9fMBZq/H635-M6-D1.xml'                                         => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/b7_gceeg_u9fMBZq/H636-M10-D1.xml'                                        => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/b7_gceeg_u9fMBZq/H636-M3-D1.xml'                                         => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/uIJXil7N_tpYFHo7/LGMS631-M10-D1.xml'                                     => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/uIJXil7N_tpYFHo7/LGMS631-M3-D1.xml'                                      => [ 'LG', 'G Stylo', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/m9a8_OJx_S_kt06K/H740-M10-D1.xml'                                        => [ 'LG', 'G Vista 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-G1610.xml'                                                            => [ 'LG', 'G1610', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-BOOST/LS980ZVC.rdf'                                             => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-BOOST/LS980ZVD.rdf'                                             => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-BOOST/LS980ZVG.rdf'                                             => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-BOOST/LS980ZVH.rdf'                                             => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-Chameleon/latest'                                               => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-SPRINT/LS980ZV6.rdf'                                            => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-SPRINT/LS980ZV7.rdf'                                            => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-SPRINT/LS980ZV8.rdf'                                            => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-SPRINT/LS980ZVA.rdf'                                            => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-SPRINT/LS980ZVC.rdf'                                            => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-SPRINT/LS980ZVD.rdf'                                            => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-SPRINT/LS980ZVE.rdf'                                            => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-SPRINT/LS980ZVG.rdf'                                            => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-SPRINT/LS980ZVH.rdf'                                            => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-SPRINT/LS980ZVI.rdf'                                            => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS980-SPRINT/OpTimuS.rdf'                                             => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.comLS980ZV8.rdf'                                                             => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.comLS980ZVG.rdf'                                                             => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/01F-M3-D1-KK.xml'                                                        => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/01F-M3-D1.xml'                                                           => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/01F-M9-D1-KK.xml'                                                        => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/980 4G-M12-D1-KK.xml'                                                    => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D800-M10-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D800-M10-D1.xml'                                                         => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D800-M3-D1-KK.xml'                                                       => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D800-M3-D1.xml'                                                          => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D801-M10-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D801-M10-D1.xml'                                                         => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D801-M3-D1-KK.xml'                                                       => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D801-M3-D1.xml'                                                          => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802-M1-D1-KK.xml'                                                       => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802-M1-D1.xml'                                                          => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802-M10-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802-M10-D1.xml'                                                         => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802-M2-D1-KK.xml'                                                       => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802-M20-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802-M20-D1.xml'                                                         => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802-M3-D1-KK.xml'                                                       => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802-M3-D1.xml'                                                          => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802-M4-D1-KK.xml'                                                       => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802-M5-D1-KK.xml'                                                       => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802-M5-D1.xml'                                                          => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802-M6-D1-KK.xml'                                                       => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802-M6-D1.xml'                                                          => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802-M9-D1-KK.xml'                                                       => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802T-M20-D1-KK.xml'                                                     => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802T-M3-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802T-M3-D1.xml'                                                         => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802T-M5-D1.xml'                                                         => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802TR-M3-D1-KK.xml'                                                     => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802TR-M3-D1.xml'                                                        => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802TR-M5-D1-KK.xml'                                                     => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D802TR-M5-D1.xml'                                                        => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D803-M10-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D803-M10-D1.xml'                                                         => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D803-M3-D1.xml'                                                          => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D803-M6-D1-KK.xml'                                                       => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D803-M6-D1.xml'                                                          => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D805-M10-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D805-M10-D1.xml'                                                         => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D805-M3-D1-KK.xml'                                                       => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D805-M3-D1.xml'                                                          => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D805-M5-D1-KK.xml'                                                       => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D806-M3-D1-KK.xml'                                                       => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D806-M3-D1.xml'                                                          => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F320K-M10-D1.xml'                                                        => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F320K-M3-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F320K-M3-D1.xml'                                                         => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F320K-M9-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F320L-M3-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F320L-M3-D1.xml'                                                         => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F320L-M9-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F320L-M9-D1.xml'                                                         => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F320S-M3-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F320S-M3-D1.xml'                                                         => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F320S-M9-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/G2-M3-D1.xml'                                                            => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/l01f-M3-D1-KK.xml'                                                       => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/L01F-M9-D1.xml'                                                          => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/L22-M3-D1-KK.xml'                                                        => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/L22-M3-D1.xml'                                                           => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LS980-M10-D1-KK.xml'                                                     => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LS980-M3-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LS980-M3-D1.xml'                                                         => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LS980-M9-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/M-PrVgyxvfGD20R_/D802-M3-D1-KK.xml'                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/VS980-M3-D1-KK.xml'                                                      => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://tool.xcdn.gdms.lge.com/html/uap/C957NUJHUE/D802TR-M3-D1.xml'                                  => [ 'LG', 'G2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/618-M3-D1.xml'                                                           => [ 'LG', 'G2 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/8-M3-D1.xml'                                                             => [ 'LG', 'G2 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D610-M3-D1.xml'                                                          => [ 'LG', 'G2 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D610AR-M3-D1.xml'                                                        => [ 'LG', 'G2 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D610TR-M3-D1.xml'                                                        => [ 'LG', 'G2 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D610TR-M5-D1.xml'                                                        => [ 'LG', 'G2 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D618-M3-D1.xml'                                                          => [ 'LG', 'G2 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D618-M4-D1.xml'                                                          => [ 'LG', 'G2 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D620-M10-D1.xml'                                                         => [ 'LG', 'G2 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D620-M3-D1.xml'                                                          => [ 'LG', 'G2 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D620-M6-D1.xml'                                                          => [ 'LG', 'G2 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D620r-M3-D1.xml'                                                         => [ 'LG', 'G2 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D625-M10-D1.xml'                                                         => [ 'LG', 'G2 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D625-M3-D1.xml'                                                          => [ 'LG', 'G2 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D625-M5-D1.xml'                                                          => [ 'LG', 'G2 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-G282.xml'                                                             => [ 'LG', 'G282', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS990-BOOST/LS990ZVC.rdf'                                             => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS990-BOOST/LS990ZVF.rdf'                                             => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS990-Chameleon/latest'                                               => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS990-SPRINT/LS990ZV4.rdf'                                            => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS990-SPRINT/LS990ZV6.rdf'                                            => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS990-SPRINT/LS990ZV8.rdf'                                            => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS990-SPRINT/LS990ZVA.rdf'                                            => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS990-SPRINT/LS990ZVB.rdf'                                            => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS990-SPRINT/LS990ZVC.rdf'                                            => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS990-SPRINT/LS990ZVE.rdf'                                            => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS990-SPRINT/LS990ZVF.rdf'                                            => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS990-SPRINT/LS990ZVG.rdf'                                            => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS990-SPRINT/LS990ZVI.rdf'                                            => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS995-SPRINT/LS990ZVA.rdf'                                            => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/%H:%M:%S/D855-M3-D1.xml'                                                 => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/%s/%s/%s/D855-M3-D1.xml'                                                 => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/985 4G-M3-D1.xml'                                                        => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D850-M10-D1.xml'                                                         => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D850-M3-D1.xml'                                                          => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D851-M10-D1.xml'                                                         => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D851-M3-D1.xml'                                                          => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D852-M10-D1.xml'                                                         => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D852-M3-D1.xml'                                                          => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D852-M6-D1.xml'                                                          => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D852-parrot-M10-D1.xml'                                                  => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D852G-M10-D1.xml'                                                        => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D852G-M3-D1.xml'                                                         => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D855-M1-D1.xml'                                                          => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D855-M10-D1.xml'                                                         => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D855-M20-D1.xml'                                                         => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D855-M3-D1.xml'                                                          => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D855-M4-D1.xml'                                                          => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D855-M5-D1.xml'                                                          => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D855-M6-D1.xml'                                                          => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D855A-M3-D1.xml'                                                         => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D855K-M20-D1.xml'                                                        => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D856-M3-D1.xml'                                                          => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D858-M3-D1.xml'                                                          => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D858HK-M3-D1.xml'                                                        => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F400K-M3-D1.xml'                                                         => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F400L-M3-D1.xml'                                                         => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F400S-M3-D1.xml'                                                         => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/G3-M3-D1.xml'                                                            => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LS990-M10-D1.xml'                                                        => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LS990-M3-D1.xml'                                                         => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/LG/LG_LG-D859_3_20140707.xml'                                            => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://pix.cspire.com/UA/profile/lg/as990/as990.xml'                                                 => [ 'LG', 'G3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D727-M10-D1.xml'                                                         => [ 'LG', 'G3 Beat', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D728-M3-D1.xml'                                                          => [ 'LG', 'G3 Beat', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F470S-M3-D1.xml'                                                         => [ 'LG', 'G3 Beat', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/HD_8T0W9FihEqY5S/D727-M10-D1.xml'                                        => [ 'LG', 'G3 Beat', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/LG/LG_LG-D729_2_20140627.xml'                                            => [ 'LG', 'G3 Beat', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F460K-M10-D1.xml'                                                        => [ 'LG', 'G3 Cat.6', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F460L-M9-D1.xml'                                                         => [ 'LG', 'G3 Cat.6', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F460S-M10-D1.xml'                                                        => [ 'LG', 'G3 Cat.6', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS885-Chameleon/latest'                                               => [ 'LG', 'G3 mini', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS885-SPRINT/LS885ZV4.rdf'                                            => [ 'LG', 'G3 mini', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS885-SPRINT/LS885ZV5.rdf'                                            => [ 'LG', 'G3 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D722-M3-D1.xml'                                                          => [ 'LG', 'G3 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D722-M5-D1.xml'                                                          => [ 'LG', 'G3 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D722-M6-D1.xml'                                                          => [ 'LG', 'G3 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D722v-M3-D1.xml'                                                         => [ 'LG', 'G3 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D723-M3-D1.xml'                                                          => [ 'LG', 'G3 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D723-M5-D1.xml'                                                          => [ 'LG', 'G3 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D724-M3-D1.xml'                                                          => [ 'LG', 'G3 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D725-M10-D1.xml'                                                         => [ 'LG', 'G3 mini', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F460K-M3-D1.xml'                                                         => [ 'LG', 'G3 Prime', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F460L-M3-D1.xml'                                                         => [ 'LG', 'G3 Prime', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F460S-M3-D1.xml'                                                         => [ 'LG', 'G3 Prime', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D722-M10-D1.xml'                                                         => [ 'LG', 'G3 S', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D722AR-M3-D1.xml'                                                        => [ 'LG', 'G3 S', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D690-M3-D1.xml'                                                          => [ 'LG', 'G3 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D690n-M3-D1.xml'                                                         => [ 'LG', 'G3 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D693-M3-D1.xml'                                                          => [ 'LG', 'G3 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D693n-M10-D1.xml'                                                        => [ 'LG', 'G3 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D693n-M3-D1.xml'                                                         => [ 'LG', 'G3 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D693TR-M3-D1.xml'                                                        => [ 'LG', 'G3 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D693TR-M5-D1.xml'                                                        => [ 'LG', 'G3 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/RNTp_ElEPgL_QrBQ/D690-M3-D1.xml'                                         => [ 'LG', 'G3 Stylus', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS885-SPRINT/LS885ZV6.rdf'                                            => [ 'LG', 'G3 Vigor', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D631-M10-D1.xml'                                                         => [ 'LG', 'G3 Vista', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS991-Chameleon/latest'                                               => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/H815-M3-D1.xml'                                                          => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/H818P-M3-D1-KK.xml'                                                      => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/Qf23_I29ZbHl2AuA/H815-M5-D1.xml'                                         => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/Qf23_I29ZbHl2AuA/H815-M6-D1.xml'                                         => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/Qf23_I29ZbHl2AuA/H818-M3-D1.xml'                                         => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H810-M10-D1.xml'                                        => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H810-M3-D1.xml'                                         => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H811-M10-D1.xml'                                        => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H811-M3-D1.xml'                                         => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H812-M10-D1.xml'                                        => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H815-M10-D1.xml'                                        => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H815-M20-D1.xml'                                        => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H815-M3-D1.xml'                                         => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H815-M4-D1.xml'                                         => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H815-M5-D1.xml'                                         => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H815-M6-D1.xml'                                         => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H815K-M20-D1.xml'                                       => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H815P-M3-D1.xml'                                        => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H818-M3-D1.xml'                                         => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H818-M4-D1.xml'                                         => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H818-M5-D1.xml'                                         => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/H819-M3-D1.xml'                                         => [ 'LG', 'G4', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/eNsCGw_apwMhnXPM/H900-M10-D1.xml'                                        => [ 'LG', 'G4 Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/_W4s8Utf_eec5qYV/H900-M10-D1.xml'                                        => [ 'LG', 'G4 Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/-pBWguyi4C2qxxHn/H540-M3-D1.xml'                                         => [ 'LG', 'G4 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/-pBWguyi4C2qxxHn/H540-M4-D1.xml'                                         => [ 'LG', 'G4 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/-pBWguyi4C2qxxHn/H540-M5-D1.xml'                                         => [ 'LG', 'G4 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/-pBWguyi4C2qxxHn/H542-M10-D1.xml'                                        => [ 'LG', 'G4 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/-pBWguyi4C2qxxHn/H542-M3-D1.xml'                                         => [ 'LG', 'G4 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/-pBWguyi4C2qxxHn/H542-M5-D1.xml'                                         => [ 'LG', 'G4 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/b7_gceeg_u9fMBZq/H630-M3-D1.xml'                                         => [ 'LG', 'G4 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/b7_gceeg_u9fMBZq/H630D-M3-D1.xml'                                        => [ 'LG', 'G4 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/b7_gceeg_u9fMBZq/H635-M3-D1.xml'                                         => [ 'LG', 'G4 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/b7_gceeg_u9fMBZq/H635A-M3-D1.xml'                                        => [ 'LG', 'G4 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/H540-M3-D1.xml'                                                          => [ 'LG', 'G4 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/H542-M10-D1.xml'                                                         => [ 'LG', 'G4 Stylus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/MX_LG_G4015.xml'                                                         => [ 'LG', 'G4015', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-G4020.xml'                                                            => [ 'LG', 'G4020', null, DeviceType::MOBILE ],
    'http://fr.lge.com/gsm/LG-G4050.xml'                                                                  => [ 'LG', 'G4050', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/1XolXoCnSn7_dGTS/H525n-M10-D1.xml'                                       => [ 'LG', 'G4c', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/1XolXoCnSn7_dGTS/H525n-M6-D1.xml'                                        => [ 'LG', 'G4c', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/3p7OIw-_p_OSTTKo/H734-M3-D1.xml'                                         => [ 'LG', 'G4s', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/3p7OIw-_p_OSTTKo/H735-M10-D1.xml'                                        => [ 'LG', 'G4s', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/3p7OIw-_p_OSTTKo/H735-M20-D1.xml'                                        => [ 'LG', 'G4s', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/3p7OIw-_p_OSTTKo/H735-M3-D1.xml'                                         => [ 'LG', 'G4s', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/3p7OIw-_p_OSTTKo/H735-M5-D1.xml'                                         => [ 'LG', 'G4s', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/3p7OIw-_p_OSTTKo/H735-M6-D1.xml'                                         => [ 'LG', 'G4s', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/3p7OIw-_p_OSTTKo/H736-M3-D1.xml'                                         => [ 'LG', 'G4s', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/AK1bQ_G8_-S9ccPj/H735-M3-D1.xml'                                         => [ 'LG', 'G4s', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/AK1bQ_G8_-S9ccPj/H736-M3-D1.xml'                                         => [ 'LG', 'G4s', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-G5400.xml'                                                            => [ 'LG', 'G5400', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-G650.xml'                                                             => [ 'LG', 'G650', null, DeviceType::MOBILE ],
    'http://fr.lge.com/gsm/LG-G7050.xml'                                                                  => [ 'LG', 'G7050', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-G7200.xml'                                                            => [ 'LG', 'G7200', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-G912.xml'                                                             => [ 'LG', 'G912', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-UAP-GB270-v0.1.xml'                                                   => [ 'LG', 'GB270', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GD510.xml'                                                            => [ 'LG', 'GD510 Pop', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GD880-3G-M6-D2CL.xml'                                                    => [ 'LG', 'GD880', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GD880-M3-D1.xml'                                                         => [ 'LG', 'GD880', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GD880-M6-D1.xml'                                                         => [ 'LG', 'GD880', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GD880-M6-D2CL.xml'                                                       => [ 'LG', 'GD880', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GM200.xml'                                                            => [ 'LG', 'GM200 Brio', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GM360-NS.xml'                                                         => [ 'LG', 'GM360 Viewty Snap', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GM360.xml'                                                            => [ 'LG', 'GM360 Viewty Snap', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GM630.xml'                                                            => [ 'LG', 'GM630', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GM730.xml'                                                            => [ 'LG', 'GM730', 'Windows Mobile', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GM750Q.xml'                                                           => [ 'LG', 'GM750 Smart', 'Windows Mobile', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GR500.xml'                                                            => [ 'LG', 'GR500 Xenon', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GS290.xml'                                                            => [ 'LG', 'GS290 Cookie Fresh', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GS390.xml'                                                            => [ 'LG', 'GS390 Prime', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GT400-M6-D2CL.xml'                                                       => [ 'LG', 'GT400', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GT500-TMO.xml'                                                        => [ 'LG', 'GT500 Puccini', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GT505-ORG.xml'                                                        => [ 'LG', 'GT505', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GT505.xml'                                                            => [ 'LG', 'GT505', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GW300.xml'                                                            => [ 'LG', 'GW300', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GW550.xml'                                                            => [ 'LG', 'GW550', 'Windows Mobile', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GW620-M6-D1.xml'                                                         => [ 'LG', 'GW620 Eve', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F310L-M3-D1-KK.xml'                                                      => [ 'LG', 'GX', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F310L-M3-D1.xml'                                                         => [ 'LG', 'GX', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F310L-M9-D1-KK.xml'                                                      => [ 'LG', 'GX', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F310LR-M3-D1-KK.xml'                                                     => [ 'LG', 'GX', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F310LR-M9-D1-KK.xml'                                                     => [ 'LG', 'GX', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-GX500.xml'                                                            => [ 'LG', 'GX500', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-HB620T.xml'                                                           => [ 'LG', 'HB620T', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lge/vs950/vs950.xml'                                                         => [ 'LG', 'Intuition', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LGL22C-M12-D1.xml'                                                       => [ 'LG', 'isai', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/L24-M3-D1.xml'                                                           => [ 'LG', 'isai FL', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/YSdHbanpHC5h2R_E/V32-M3-D1.xml'                                          => [ 'LG', 'isai vivid LGV32', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/H220-M5-D1.xml'                                                          => [ 'LG', 'Joy', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/H221AR-M3-D1.xml'                                                        => [ 'LG', 'Joy', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/JMVnyLlmw2NR0pk1/H220-M3-D1.xml'                                         => [ 'LG', 'Joy', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/JMVnyLlmw2NR0pk1/H220-M5-D1.xml'                                         => [ 'LG', 'Joy', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/JMVnyLlmw2NR0pk1/H221-M10-D1.xml'                                        => [ 'LG', 'Joy', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/JMVnyLlmw2NR0pk1/H221AR-M3-D1.xml'                                       => [ 'LG', 'Joy', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/JMVnyLlmw2NR0pk1/H222-M3-D1.xml'                                         => [ 'LG', 'Joy', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KB770-VDF3G.xml'                                                      => [ 'LG', 'KB770', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KC550.xml'                                                            => [ 'LG', 'KC550', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KC780.xml'                                                            => [ 'LG', 'KC780', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KC910-VDF.xml'                                                        => [ 'LG', 'KC910', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KC910-VDF3G.xml'                                                      => [ 'LG', 'KC910 Renoir', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KC910.xml'                                                            => [ 'LG', 'KC910 Renoir', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KC910i.xml'                                                           => [ 'LG', 'KC910i Renoir', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KE260-V08f.xml'                                                       => [ 'LG', 'KE260', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KE500.xml'                                                            => [ 'LG', 'KE500', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KE600E.xml'                                                           => [ 'LG', 'KE600', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KE770.xml'                                                            => [ 'LG', 'KE770 Shine', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KE820.xml'                                                            => [ 'LG', 'KE820', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KE850.xml'                                                            => [ 'LG', 'KE850 Prada', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KE970.xml'                                                            => [ 'LG', 'KE970 Shine', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KE990.xml'                                                            => [ 'LG', 'KE990 Viewty', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KF240.xml'                                                            => [ 'LG', 'KF240', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KF245.xml'                                                            => [ 'LG', 'KF245', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KF300.xml'                                                            => [ 'LG', 'KF300', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KF310-H3G.xml'                                                        => [ 'LG', 'KF310', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KF310-VDF3G.xml'                                                      => [ 'LG', 'KF310', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KF311-DRM-2.xml'                                                      => [ 'LG', 'KF311', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KF390.xml'                                                            => [ 'LG', 'KF390', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KF510.xml'                                                            => [ 'LG', 'KF510', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KF600.xml'                                                            => [ 'LG', 'KF600', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KF700.xml'                                                            => [ 'LG', 'KF700', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KF750-OPEN1.xml'                                                      => [ 'LG', 'KF750 Secret', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KF750-VDF3G.xml'                                                      => [ 'LG', 'KF750 Secret', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KF755.xml'                                                            => [ 'LG', 'KF755', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KF900.xml'                                                            => [ 'LG', 'KF900 Prada II', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KG119.xml'                                                            => [ 'LG', 'KG119', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KG190.xml'                                                            => [ 'LG', 'KG190', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KG200.xml'                                                            => [ 'LG', 'KG200', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KG200j.xml'                                                           => [ 'LG', 'KG200', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KG208.xml'                                                            => [ 'LG', 'KG208', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KG280.xml'                                                            => [ 'LG', 'KG280', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KG290UAE.xml'                                                         => [ 'LG', 'KG290', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KG296.xml'                                                            => [ 'LG', 'KG296', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KG300j.xml'                                                           => [ 'LG', 'KG300', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KG70.xml'                                                             => [ 'LG', 'KG70 Shine', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KG77.xml'                                                             => [ 'LG', 'KG77 Shine', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KG90.xml'                                                             => [ 'LG', 'KG90', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KG920.xml'                                                            => [ 'LG', 'KG920', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KG98.xml'                                                             => [ 'LG', 'KG98', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KM380.xml'                                                            => [ 'LG', 'KM380', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KM500.xml'                                                            => [ 'LG', 'KM500', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KM501.xml'                                                            => [ 'LG', 'KM501', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KM553.xml'                                                            => [ 'LG', 'KM553', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KM900N.xml'                                                           => [ 'LG', 'KM900', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KM900.xml'                                                            => [ 'LG', 'KM900 Arena', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP110.xml'                                                            => [ 'LG', 'KP110', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP130.xml'                                                            => [ 'LG', 'KP130', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP135.xml'                                                            => [ 'LG', 'KP135', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-UAP-KP199-v0.1.xml'                                                   => [ 'LG', 'KP199', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP202.xml'                                                            => [ 'LG', 'KP202', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP210.xml'                                                            => [ 'LG', 'KP210', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP215.xml'                                                            => [ 'LG', 'KP215', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-UAP-KP220-v0.1.xml'                                                   => [ 'LG', 'KP220', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP230.xml'                                                            => [ 'LG', 'KP230', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP233.xml'                                                            => [ 'LG', 'KP233', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP260.xml'                                                            => [ 'LG', 'KP260', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP265.xml'                                                            => [ 'LG', 'KP265', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP270-3G.xml'                                                         => [ 'LG', 'KP270', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP275.xml'                                                            => [ 'LG', 'KP275', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP320.xml'                                                            => [ 'LG', 'KP320', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP500.xml'                                                            => [ 'LG', 'KP500 Cookie', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP501.xml'                                                            => [ 'LG', 'KP500 Cookie', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KP570.xml'                                                            => [ 'LG', 'KP570 Cookie', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/KS10.xml'                                                                => [ 'LG', 'KS10 JOY', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KS20.xml'                                                             => [ 'LG', 'KS360', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KS360-V10d.xml'                                                       => [ 'LG', 'KS360', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KS360.xml'                                                            => [ 'LG', 'KS360', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KS500-VDF3G.xml'                                                      => [ 'LG', 'KS500', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KT520-OPEN1.xml'                                                      => [ 'LG', 'KT520', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KU250.xml'                                                            => [ 'LG', 'KU250', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KU380-v10a.xml'                                                       => [ 'LG', 'KU380', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KU380-v10b.xml'                                                       => [ 'LG', 'KU380', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KU580-CA.xml'                                                         => [ 'LG', 'KU580', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KU970-CA.xml'                                                         => [ 'LG', 'KU970 Shine', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KU970.xml'                                                            => [ 'LG', 'KU970 Shine', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KU990-3G.xml'                                                         => [ 'LG', 'KU990', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KU990-VDF3G.xml'                                                      => [ 'LG', 'KU990 Viewty', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KU990.xml'                                                            => [ 'LG', 'KU990 Viewty', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-KU990i.xml'                                                           => [ 'LG', 'KU990 Viewty', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D331-M6-D1.xml'                                                          => [ 'LG', 'L Bello', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D335-M3-D1.xml'                                                          => [ 'LG', 'L Bello', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D337-M3-D1.xml'                                                          => [ 'LG', 'L Bello', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/RNTp_ElEPgL_QrBQ/D335-M3-D1.xml'                                         => [ 'LG', 'L Bello', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/RNTp_ElEPgL_QrBQ/D335-M5-D1.xml'                                         => [ 'LG', 'L Bello', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/U_EOJw1JxwmQJceD/31-M10-D1.xml'                                          => [ 'LG', 'L Bello', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/U_EOJw1JxwmQJceD/D331-M5-D1.xml'                                         => [ 'LG', 'L Bello', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/U_EOJw1JxwmQJceD/D335-M3-D1.xml'                                         => [ 'LG', 'L Bello', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/U_EOJw1JxwmQJceD/D335E-M3-D1.xml'                                        => [ 'LG', 'L Bello', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D290-M10-D1.xml'                                                         => [ 'LG', 'L Fino', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D290-M3-D1.xml'                                                          => [ 'LG', 'L Fino', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D290-M5-D1.xml'                                                          => [ 'LG', 'L Fino', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D295-M3-D1.xml'                                                          => [ 'LG', 'L Fino', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/U_EOJw1JxwmQJceD/D337-M3-D1.xml'                                         => [ 'LG', 'L Prime', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-L1100.xml'                                                            => [ 'LG', 'L1100', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/MX_LG_L1150.xml'                                                         => [ 'LG', 'L1150', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-L1200.xml'                                                            => [ 'LG', 'L1200', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG_L1400.xml'                                                            => [ 'LG', 'L1400', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D100-M10-D1.xml'                                                         => [ 'LG', 'L20', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D100-M3-D1.xml'                                                          => [ 'LG', 'L20', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D100AR-M3-D1.xml'                                                        => [ 'LG', 'L20', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D105-M3-D1.xml'                                                          => [ 'LG', 'L20', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D107-M3-D1.xml'                                                          => [ 'LG', 'L20', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D120-M10-D1.xml'                                                         => [ 'LG', 'L30', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D120-M3-D1.xml'                                                          => [ 'LG', 'L30', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D123-M3-D1.xml'                                                          => [ 'LG', 'L30', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D125-M3-D1.xml'                                                          => [ 'LG', 'L30', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D125f-M3-D1.xml'                                                         => [ 'LG', 'L30', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D127-M3-D1.xml'                                                          => [ 'LG', 'L30', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D120AR-M3-D1.xml'                                                        => [ 'LG', 'L30 Sporty', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D150-M5-D1.xml'                                                          => [ 'LG', 'L35', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D157f-M3-D1.xml'                                                         => [ 'LG', 'L35', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LGL35G-M6-D1.xml'                                                        => [ 'LG', 'L35G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/34C-M11-D1.xml'                                                          => [ 'LG', 'L40', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D160-M10-D1.xml'                                                         => [ 'LG', 'L40', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D160-M20-D1.xml'                                                         => [ 'LG', 'L40', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D160-M3-D1.xml'                                                          => [ 'LG', 'L40', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D160-M6-D1.xml'                                                          => [ 'LG', 'L40', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D170-M3-D1.xml'                                                          => [ 'LG', 'L40', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D175f-M3-D1.xml'                                                         => [ 'LG', 'L40', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/L34C-M12-D1.xml'                                                         => [ 'LG', 'L40', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/X130g-M10-D1.xml'                                                        => [ 'LG', 'L40', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D227-M3-D1.xml'                                                          => [ 'LG', 'L50', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D213-M10-D1.xml'                                                         => [ 'LG', 'L50 Sporty', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D213-M3-D1.xml'                                                          => [ 'LG', 'L50 Sporty', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-L5100.xml'                                                            => [ 'LG', 'L5100', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/X135-M10-D1.xml'                                                         => [ 'LG', 'L60', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/X140-M10-D1.xml'                                                         => [ 'LG', 'L60', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/X145-M10-D1.xml'                                                         => [ 'LG', 'L60', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/X147-M10-D1.xml'                                                         => [ 'LG', 'L60', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-L600V.xml'                                                            => [ 'LG', 'L600v', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/X137-M10-D1.xml'                                                         => [ 'LG', 'L60i', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D280-M10-D1.xml'                                                         => [ 'LG', 'L65', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D280-M3-D1.xml'                                                          => [ 'LG', 'L65', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D280-M5-D1.xml'                                                          => [ 'LG', 'L65', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D285-M3-D1.xml'                                                          => [ 'LG', 'L65', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/321-M10-D1.xml'                                                          => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D320-M10-D1.xml'                                                         => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D320-M2-D1.xml'                                                          => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D320-M3-D1.xml'                                                          => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D320-M5-D1.xml'                                                          => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D320-M6-D1.xml'                                                          => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D320AR-M3-D1.xml'                                                        => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D320n-M3-D1.xml'                                                         => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D321-M10-D1.xml'                                                         => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D325-M3-D1.xml'                                                          => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D325-M4-D1.xml'                                                          => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D325f-M3-D1.xml'                                                         => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LGAS323-M10-D1.xml'                                                      => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LGL41C-M12-D1.xml'                                                       => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LGMS323-M10-D1.xml'                                                      => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LGMS323-M3-D1.xml'                                                       => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/MS323-M10-D1.xml'                                                        => [ 'LG', 'L70', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D340f8-M3-D1.xml'                                                        => [ 'LG', 'L70 Tri', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D373-M10-D1.xml'                                                         => [ 'LG', 'L80', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D373-M3-D1.xml'                                                          => [ 'LG', 'L80', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D380-M3-D1.xml'                                                          => [ 'LG', 'L80', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D385-M3-D1.xml'                                                          => [ 'LG', 'L80', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D331-M3-D1.xml'                                                          => [ 'LG', 'L80+', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/U_EOJw1JxwmQJceD/D331-M10-D1.xml'                                        => [ 'LG', 'L80+', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/U_EOJw1JxwmQJceD/D331-M3-D1.xml'                                         => [ 'LG', 'L80+', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D400-M10-D1.xml'                                                         => [ 'LG', 'L90', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D400-M3-D1.xml'                                                          => [ 'LG', 'L90', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D405-M10-D1.xml'                                                         => [ 'LG', 'L90', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D405-M3-D1.xml'                                                          => [ 'LG', 'L90', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D405-M5-D1.xml'                                                          => [ 'LG', 'L90', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D405-M6-D1.xml'                                                          => [ 'LG', 'L90', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D410-M3-D1.xml'                                                          => [ 'LG', 'L90', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D415-M10-D1.xml'                                                         => [ 'LG', 'L90', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D415-M3-D1.xml'                                                          => [ 'LG', 'L90', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LGL996L-M10-D1.xml'                                                      => [ 'LG', 'L996L', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/0W_43_22MIQ_HNMe/H340-M10-D1.xml'                                        => [ 'LG', 'Leon', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/0W_43_22MIQ_HNMe/H340-M3-D1.xml'                                         => [ 'LG', 'Leon', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/0W_43_22MIQ_HNMe/H340AR-M3-D1.xml'                                       => [ 'LG', 'Leon', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/0W_43_22MIQ_HNMe/H340n-M10-D1.xml'                                       => [ 'LG', 'Leon', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/0W_43_22MIQ_HNMe/H340n-M3-D1.xml'                                        => [ 'LG', 'Leon', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/0W_43_22MIQ_HNMe/H340n-M5-D1.xml'                                        => [ 'LG', 'Leon', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/0W_43_22MIQ_HNMe/H340n-M6-D1.xml'                                        => [ 'LG', 'Leon', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/0W_43_22MIQ_HNMe/H342-M3-D1.xml'                                         => [ 'LG', 'Leon', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/RNTp_ElEPgL_QrBQ/H320-M10-D1.xml'                                        => [ 'LG', 'Leon', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/RNTp_ElEPgL_QrBQ/H320-M3-D1.xml'                                         => [ 'LG', 'Leon', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/RNTp_ElEPgL_QrBQ/H320-M5-D1.xml'                                         => [ 'LG', 'Leon', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/RNTp_ElEPgL_QrBQ/H326-M3-D1.xml'                                         => [ 'LG', 'Leon', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/yObOcsVFUyAgTj5W/H345-M10-D1.xml'                                        => [ 'LG', 'Leon', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/yObOcsVFUyAgTj5W/LGMS345-M10-D1.xml'                                     => [ 'LG', 'Leon', 'Android', DeviceType::MOBILE ],
    'http://uaprof.bellmobilite.ca/LGE_LG160P.rdf'                                                        => [ 'LG', 'LG160', null, DeviceType::MOBILE ],
    'http://uaprof.bellmobilite.ca/LGE_LG160V.rdf'                                                        => [ 'LG', 'LG160', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/lg/LG200.rdf'                                                        => [ 'LG', 'LG200', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/lg/LG245-0.rdf'                                                      => [ 'LG', 'LG245', null, DeviceType::MOBILE ],
    'http://uaprof.bellmobilite.ca/LGE_LG260.rdf'                                                         => [ 'LG', 'LG260', null, DeviceType::MOBILE ],
    'http://uaprof.bellmobilite.ca/LGE_LG280.rdf'                                                         => [ 'LG', 'LG280', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/lg/LG285-1.rdf'                                                      => [ 'LG', 'LG285', null, DeviceType::MOBILE ],
    'http://uaprof.bellmobilite.ca/LGE_LG385.rdf'                                                         => [ 'LG', 'LG385', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-LG440G.xml'                                                           => [ 'LG', 'LG440G', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/lg/lg4600.rdf'                                                       => [ 'LG', 'LG4600', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/lg/LG490-0.rdf'                                                      => [ 'LG', 'LG490', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-LG530G.xml'                                                           => [ 'LG', 'LG530G', null, DeviceType::MOBILE ],
    'http://uaprof.bellmobilite.ca/BMC_LG_LG5400_LG540V05.rdf'                                            => [ 'LG', 'LG5400', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/lg/lg5450.rdf'                                                       => [ 'LG', 'LG5450', null, DeviceType::MOBILE ],
    'http://uaprof.bellmobilite.ca/BMC_LGE_LG550_CX55BL10.rdf'                                            => [ 'LG', 'LG550', null, DeviceType::MOBILE ],
    'http://uaprof.bellmobilite.ca/LGE_LG570V.rdf'                                                        => [ 'LG', 'LG570', null, DeviceType::MOBILE ],
    'http://uaprof.bellmobilite.ca/LGE_LG600.rdf'                                                         => [ 'LG', 'LG600', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/lg/lg6070.rdf'                                                       => [ 'LG', 'LG6070', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/lg/lg6190.rdf'                                                       => [ 'LG', 'LG6190', null, DeviceType::MOBILE ],
    'http://uaprof.bellmobilite.ca/BMC_LG_LG6200_CX62BE07.rdf'                                            => [ 'LG', 'LG6200', null, DeviceType::MOBILE ],
    'http://uaprof.bellmobilite.ca/LGE_LG830.rdf'                                                         => [ 'LG', 'LG830', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-LG840G.xml'                                                           => [ 'LG', 'LG840G', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/lg/LG8500-0.rdf'                                                     => [ 'LG', 'LG8500 Chocolate', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/lg/LG8600-1.rdf'                                                     => [ 'LG', 'LG8600 Chocolate Flip', null, DeviceType::MOBILE ],
    'http://uaprof.bellmobilite.ca/BMC_LGE_LG8700_CX87BL04.rdf'                                           => [ 'LG', 'LG8700', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/lg/LG8800-0.rdf'                                                     => [ 'LG', 'LG8800 Venus', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/lg/LG9100-0.rdf'                                                     => [ 'LG', 'LG9100 Keybo', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/lg/LG9700-0.rdf'                                                     => [ 'LG', 'LG9700 Dare', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LN280-PLB/LN280ZV3.rdf'                                               => [ 'LG', 'LN280', 'Brew', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LX600/LX600V07.rdf'                                                   => [ 'LG', 'Lotus LX600', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LX600/LX600V08.rdf'                                                   => [ 'LG', 'Lotus LX600', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lge/vs840/vs840.xml'                                                         => [ 'LG', 'Lucid', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/Z9L2LsF6CK0ZCabE/LGL16C-M12-D1.xml'                                      => [ 'LG', 'Lucky', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/LG/LX-140/VMU_lx140_UAProf.xml'                                              => [ 'LG', 'LX140 Aloha', null, DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/LG/lx165/VMU_lx165_UAProf.xml'                                               => [ 'LG', 'LX165 Flare', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LX400/LX400V13.rdf'                                                   => [ 'LG', 'LX400', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/5350/LX5350_11.rdf'                                                   => [ 'LG', 'LX5350', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LX610/LX610V05.rdf'                                                   => [ 'LG', 'LX610', 'Brew', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS860-2011011301/LS860ZV7.rdf'                                        => [ 'LG', 'Mach', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS860-BOOST/LS860ZV8.rdf'                                             => [ 'LG', 'Mach', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS860-Chameleon/latest'                                               => [ 'LG', 'Mach', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS860-SPRINT/LS860ZV7.rdf'                                            => [ 'LG', 'Mach', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS860-SPRINT/LS860ZV8.rdf'                                            => [ 'LG', 'Mach', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/1XolXoCnSn7_dGTS/H520-M10-D1.xml'                                        => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/1XolXoCnSn7_dGTS/H520-M3-D1.xml'                                         => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/1XolXoCnSn7_dGTS/H522-M3-D1.xml'                                         => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/1XolXoCnSn7_dGTS/H525-M3-D1.xml'                                         => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/1XolXoCnSn7_dGTS/H525-M5-D1.xml'                                         => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/1XolXoCnSn7_dGTS/H525n-M3-D1.xml'                                        => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/1XolXoCnSn7_dGTS/H525n-M5-D1.xml'                                        => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/Dsi6X_y8P_In4gbf/H500-M10-D1.xml'                                        => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/Dsi6X_y8P_In4gbf/H500-M3-D1.xml'                                         => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/Dsi6X_y8P_In4gbf/H500-M6-D1.xml'                                         => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/Dsi6X_y8P_In4gbf/H502-M10-D1.xml'                                        => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/Dsi6X_y8P_In4gbf/H502-M3-D1.xml'                                         => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/H500-M3-D1.xml'                                                          => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/H522-M3-D1.xml'                                                          => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/H522F-M3-D1.xml'                                                         => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/RNTp_ElEPgL_QrBQ/H502-M3-D1.xml'                                         => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/RNTp_ElEPgL_QrBQ/H522-M3-D1.xml'                                         => [ 'LG', 'Magna', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LG855ABC/LG855ZV3.rdf'                                                => [ 'LG', 'Marquee', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LG855ABC/LG855ZV4.rdf'                                                => [ 'LG', 'Marquee', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS855/LS855ZV1.rdf'                                                   => [ 'LG', 'Marquee', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS855/LS855ZV9.rdf'                                                   => [ 'LG', 'Marquee', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS855/LS855ZVC.rdf'                                                   => [ 'LG', 'Marquee', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-ME591D.xml'                                                           => [ 'LG', 'ME591', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-ME770.xml'                                                            => [ 'LG', 'ME770 Shine', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-MG101.xml'                                                            => [ 'LG', 'MG101', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-MG150.xml'                                                            => [ 'LG', 'MG150', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-MG170.xml'                                                            => [ 'LG', 'MG170', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-MG200.xml'                                                            => [ 'LG', 'MG200', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-MG220.xml'                                                            => [ 'LG', 'MG220', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-MG225d.xml'                                                           => [ 'LG', 'MG225', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-MG235.xml'                                                            => [ 'LG', 'MG235', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-MG280.xml'                                                            => [ 'LG', 'MG280', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-MG800c.xml'                                                           => [ 'LG', 'MG800 Chocolate', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/MM535/MM535V24.rdf'                                                   => [ 'LG', 'MM-535', null, DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/LG-MS770.xml'                                                      => [ 'LG', 'Motion 4G', 'Android', DeviceType::MOBILE ],
    'https://servicios.iusacell.com.mx/lg/mx200v1.xml'                                                    => [ 'LG', 'MX200', null, DeviceType::MOBILE ],
    'https://servicios.iusacell.com.mx/lg/MX210/MX210v1.xml'                                              => [ 'LG', 'MX210', null, DeviceType::MOBILE ],
    'https://servicios.iusacell.com.mx/lg/MX275/mx275v1.xml'                                              => [ 'LG', 'MX275', null, DeviceType::MOBILE ],
    'https://servicios.iusacell.com.mx/lg/mx500v1.xml'                                                    => [ 'LG', 'MX500', null, DeviceType::MOBILE ],
    'https://servicios.iusacell.com.mx/lg/MX8500/mx8500v1.xml'                                            => [ 'LG', 'MX8500', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P930-M6-D1-ICS.xml'                                                      => [ 'LG', 'Nitro HD', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P930-M6-D1.xml'                                                          => [ 'LG', 'Nitro HD', 'Android', DeviceType::MOBILE ],
    'http://mobileuaprof.xtra.co.nz/NX550.rdf'                                                            => [ 'LG', 'NX550', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GT540_M6_D2_CL.xml'                                                      => [ 'LG', 'Optimus', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-P990h-M10-D1.xml'                                                     => [ 'LG', 'Optimus 2X Speed', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P990-M3-D2.xml'                                                          => [ 'LG', 'Optimus 2X Speed', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P990-M6-D1-ICS.xml'                                                      => [ 'LG', 'Optimus 2X Speed', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P990-M6-D2.xml'                                                          => [ 'LG', 'Optimus 2X Speed', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P990h-M10-D1.xml'                                                        => [ 'LG', 'Optimus 2X Speed', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P990hN-M6-D1-ICS.xml'                                                    => [ 'LG', 'Optimus 2X Speed', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P990hN-M6-D1.xml'                                                        => [ 'LG', 'Optimus 2X Speed', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P920-M3-D2-ICS.xml'                                                      => [ 'LG', 'Optimus 3D', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P920-M3-D2.xml'                                                          => [ 'LG', 'Optimus 3D', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P920-M6-D2.xml'                                                          => [ 'LG', 'Optimus 3D', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P920h-M3-D2.xml'                                                         => [ 'LG', 'Optimus 3D', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P725-M3-D2.xml'                                                          => [ 'LG', 'Optimus 3D Max', 'Android', DeviceType::MOBILE ],
    'http://device.telusmobility.com/lg/LG-CX670-0.rdf'                                                   => [ 'LG', 'Optimus 3G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P880-M10-D1.xml'                                                         => [ 'LG', 'Optimus 4X HD', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P880-M3-D1.xml'                                                          => [ 'LG', 'Optimus 4X HD', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P880-M3-D2.xml'                                                          => [ 'LG', 'Optimus 4X HD', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P880-M6-D2.xml'                                                          => [ 'LG', 'Optimus 4X HD', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P880g-M10-D1.xml'                                                        => [ 'LG', 'Optimus 4X HD', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P880g-M3-D1.xml'                                                         => [ 'LG', 'Optimus 4X HD', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/L85C/LGL85CV1.rdf'                                                    => [ 'LG', 'Optimus Black', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-P970-M3-D2.xml'                                                       => [ 'LG', 'Optimus Black', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-P970-M6-D2.xml'                                                       => [ 'LG', 'Optimus Black', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-P970h-M10-D1.xml'                                                     => [ 'LG', 'Optimus Black', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-P970h-M3-D1.xml'                                                      => [ 'LG', 'Optimus Black', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-P970h-M6-D1.xml'                                                      => [ 'LG', 'Optimus Black', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P970-M10-D2.xml'                                                         => [ 'LG', 'Optimus Black', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P970-M3-D2.xml'                                                          => [ 'LG', 'Optimus Black', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P970-M6-D2.xml'                                                          => [ 'LG', 'Optimus Black', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P970g-M10-D1.xml'                                                        => [ 'LG', 'Optimus Black', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P970h-M3-D2.xml'                                                         => [ 'LG', 'Optimus Black', 'Android', DeviceType::MOBILE ],
    'http://mms.cleartalk.co/sam-r720.xml?source=web'                                                     => [ 'LG', 'Optimus C', 'Android', DeviceType::MOBILE ],
    'http://wapuaprof.wap.mycricket.com/lg/LW690.xml'                                                     => [ 'LG', 'Optimus C', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/C550-M6-D2.xml'                                                          => [ 'LG', 'Optimus Chat', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/C555-M10-D1.xml'                                                         => [ 'LG', 'Optimus Chat', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-E720-M6-D2.xml'                                                       => [ 'LG', 'Optimus Chic', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-E720b-M6-D1.xml'                                                      => [ 'LG', 'Optimus Chic', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P720-M3-D2.xml'                                                          => [ 'LG', 'Optimus Chic', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P720h-M3-D2.xml'                                                         => [ 'LG', 'Optimus Chic', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LGL38C-M12-D1.xml'                                                       => [ 'LG', 'Optimus Dynamic', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/L39C-M12-D1.xml'                                                         => [ 'LG', 'Optimus Dynamic II', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/LG/VM696-VMUB/1.0/UAProf.xml'                                                => [ 'LG', 'Optimus Elite', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/L40g-M6-D1.xml'                                                          => [ 'LG', 'Optimus Extreme', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS720-2011011301/LS720ZV8.rdf'                                        => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS720-2012083001/LS720ZV8.rdf'                                        => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS720-BOOST//LG/LS720-BOOST/LS720ZV8.rdf'                             => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS720-BOOST/LS720ZV6.rdf'                                             => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS720-BOOST/LS720ZV8.rdf'                                             => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS720-Chameleon/latest'                                               => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS720-SPRINT/LS720Z06.rdf'                                            => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS720-SPRINT/LS720ZV7.rdf'                                            => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS720-SPRINT/LS720ZV8.rdf'                                            => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS720-VIRGIN//LG/LS720-VIRGIN/LS720ZV8.rdf'                           => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS720-VIRGIN/LS720ZV5.rdf'                                            => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS720-VIRGIN/LS720ZV6.rdf'                                            => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS720-VIRGIN/LS720ZV7.rdf'                                            => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS720-VIRGIN/LS720ZV8.rdf'                                            => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/MS659-M10-D1.xml'                                                        => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P655H-M3-D1.xml'                                                         => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P659-M10-D1.xml'                                                         => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/LG/LS720-VIRGIN/LS720ZV6.rdf'                                                => [ 'LG', 'Optimus F3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D520-M10-D1.xml'                                                         => [ 'LG', 'Optimus F3Q', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P875-M10-D1.xml'                                                         => [ 'LG', 'Optimus F5', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P875-M3-D1.xml'                                                          => [ 'LG', 'Optimus F5', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P875h-M3-D1.xml'                                                         => [ 'LG', 'Optimus F5', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D500-M10-D1.xml'                                                         => [ 'LG', 'Optimus F6', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D500-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus F6', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D505-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus F6', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D505-M3-D1.xml'                                                          => [ 'LG', 'Optimus F6', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D505-M6-D1-KK.xml'                                                       => [ 'LG', 'Optimus F6', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/MS500-M10-D1-KK.xml'                                                     => [ 'LG', 'Optimus F6', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/MS500-M10-D1.xml'                                                        => [ 'LG', 'Optimus F6', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LG870-BOOST/LG870ZV1.rdf'                                             => [ 'LG', 'Optimus F7', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LG870-BOOST/LG870ZV4.rdf'                                             => [ 'LG', 'Optimus F7', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LG870-BOOST/LG870ZV5.rdf'                                             => [ 'LG', 'Optimus F7', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LG870-Chameleon/latest'                                               => [ 'LG', 'Optimus F7', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LG870-SPRINT/LG870ZV4.rdf'                                            => [ 'LG', 'Optimus F7', 'Android', DeviceType::MOBILE ],
    'http://mms.ntwls.net/uaprofs/AS780.xml'                                                              => [ 'LG', 'Optimus F7', 'Android', DeviceType::MOBILE ],
    'http://pix.cspire.com/UA/profile/lg/as780/as780.xml'                                                 => [ 'LG', 'Optimus F7', 'Android', DeviceType::MOBILE ],
    'http://uaprof.ntelospcs.net/AS780.xml'                                                               => [ 'LG', 'Optimus F7', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS970-2011011301/LS970ZVC.rdf'                                        => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS970-Chameleon/latest'                                               => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS970-SPRINT/LS970ZV7.rdf'                                            => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS970-SPRINT/LS970ZV9.rdf'                                            => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS970-SPRINT/LS970ZVA.rdf'                                            => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS970-SPRINT/LS970ZVB.rdf'                                            => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS970-SPRINT/LS970ZVC.rdf'                                            => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/ Optimus G-M3-D1-KK.xml'                                                 => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E970-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E970-M3-D1.xml'                                                          => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E970-M6-D1.xml'                                                          => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E971-M10-D1.xml'                                                         => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E973-M10-D1.xml'                                                         => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E973-M6-D1.xml'                                                          => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E973-parrot-M10-D1.xml'                                                  => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E975-M10-D1.xml'                                                         => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E975-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E975-M3-D1.xml'                                                          => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E975-M5-D1-KK.xml'                                                       => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E975-M6-D1.xml'                                                          => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E975K-M20-D1.xml'                                                        => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E975K-M3-D1.xml'                                                         => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E975T-M3-D1.xml'                                                         => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E975w-M3-D1.xml'                                                         => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E976-M10-D1.xml'                                                         => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E976-M3-D1.xml'                                                          => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E977-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E977-M3-D1.xml'                                                          => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E987-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E987-M3-D1.xml'                                                          => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F180-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F180K-M10-D1-KK.xml'                                                     => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F180K-M3-D1-KK.xml'                                                      => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F180K-M9-D1-KK.xml'                                                      => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F180L-M3-D1-KK.xml'                                                      => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F180L-M3-D1.xml'                                                         => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F180S-M3-D1-KK.xml'                                                      => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F180S-M3-D1.xml'                                                         => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F180S-M9-D1-KK.xml'                                                      => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LS970-M3-D1.xml'                                                         => [ 'LG', 'Optimus G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/980 4G-M12-D1.xml'                                                       => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/980 4G-M3-D1-KK.xml'                                                     => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/980 4G-M3-D1.xml'                                                        => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E980-M10-D1-KK.xml'                                                      => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E980-M10-D1.xml'                                                         => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E980-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E980-M3-D1.xml'                                                          => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E980-M9-D1-KK.xml'                                                       => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E980h-M10-D1.xml'                                                        => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E980h-M3-D1.xml'                                                         => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E981h-M3-D1-KK.xml'                                                      => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E981h-M3-D1.xml'                                                         => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E985-M3-D1.xml'                                                          => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E985T-M3-D1.xml'                                                         => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E986-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E986-M3-D1.xml'                                                          => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E986-M5-D1-KK.xml'                                                       => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E988-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E988-M3-D1.xml'                                                          => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E988-M5-D1-KK.xml'                                                       => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E988-M9-D1-KK.xml'                                                       => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E989-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E989-M3-D1.xml'                                                          => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F240K-M3-D1-KK.xml'                                                      => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F240L-M10-D1.xml'                                                        => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F240L-M3-D1-KK.xml'                                                      => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F240L-M3-D1.xml'                                                         => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F240L-M9-D1-KK.xml'                                                      => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F240S-M3-D1-KK.xml'                                                      => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/VS980-M10-D1.xml'                                                        => [ 'LG', 'Optimus G Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F220K-M3-D1-KK.xml'                                                      => [ 'LG', 'Optimus GK', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F220K-M9-D1-KK.xml'                                                      => [ 'LG', 'Optimus GK', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GT540.xml'                                                               => [ 'LG', 'Optimus GT540', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GT540f_M3_D1_J.xml'                                                      => [ 'LG', 'Optimus GT540', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GT540f_MR_M3_D1_J.xml'                                                   => [ 'LG', 'Optimus GT540', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GT540_M3_D2_CL.xml'                                                      => [ 'LG', 'Optimus GT540', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GT540_M6_D1_J.xml'                                                       => [ 'LG', 'Optimus GT540', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GT540_M6_D2_CL_J.xml'                                                    => [ 'LG', 'Optimus GT540', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GT540_M6_D2_CL_J_Y.xml'                                                  => [ 'LG', 'Optimus GT540', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GT540_MR_M3_D2_CL.xml'                                                   => [ 'LG', 'Optimus GT540', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GT540_MR_M3_D2_CL_J.xml'                                                 => [ 'LG', 'Optimus GT540', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GT540_MR_M6_D1_J.xml'                                                    => [ 'LG', 'Optimus GT540', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/GT540_MR_M6_D2_CL_J.xml'                                                 => [ 'LG', 'Optimus GT540', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E510-M6-D2.xml'                                                          => [ 'LG', 'Optimus Hub', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E510f-M6-D2.xml'                                                         => [ 'LG', 'Optimus Hub', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E510g-M6-D2.xml'                                                         => [ 'LG', 'Optimus Hub', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E410-M3-D1.xml'                                                          => [ 'LG', 'Optimus L1 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E410B-M6-D1.xml'                                                         => [ 'LG', 'Optimus L1 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E410f-M3-D1.xml'                                                         => [ 'LG', 'Optimus L1 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E410g-M10-D1.xml'                                                        => [ 'LG', 'Optimus L1 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E410g-M3-D1.xml'                                                         => [ 'LG', 'Optimus L1 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E410i-M3-D1.xml'                                                         => [ 'LG', 'Optimus L1 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E411g-M3-D1.xml'                                                         => [ 'LG', 'Optimus L1 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E415f-M3-D1.xml'                                                         => [ 'LG', 'Optimus L1 II Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E420-M3-D1.xml'                                                          => [ 'LG', 'Optimus L1 II Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E475f-M3-D1.xml'                                                         => [ 'LG', 'Optimus L1 II Tri', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E400-M6-D2.xml'                                                          => [ 'LG', 'Optimus L3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E400b-M10-D1.xml'                                                        => [ 'LG', 'Optimus L3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E400R-M6-D1.xml'                                                         => [ 'LG', 'Optimus L3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E405-M6-D2.xml'                                                          => [ 'LG', 'Optimus L3 Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E425-M3-D1.xml'                                                          => [ 'LG', 'Optimus L3 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E425f-M10-D1.xml'                                                        => [ 'LG', 'Optimus L3 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E425f-M20-D1.xml'                                                        => [ 'LG', 'Optimus L3 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E425f-M3-D1.xml'                                                         => [ 'LG', 'Optimus L3 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E425g-M3-D1.xml'                                                         => [ 'LG', 'Optimus L3 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E430-M10-D1.xml'                                                         => [ 'LG', 'Optimus L3 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E430-M3-D1.xml'                                                          => [ 'LG', 'Optimus L3 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E430-M5-D1.xml'                                                          => [ 'LG', 'Optimus L3 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E430-M6-D1.xml'                                                          => [ 'LG', 'Optimus L3 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E431g-M3-D1.xml'                                                         => [ 'LG', 'Optimus L3 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E435-M3-D1.xml'                                                          => [ 'LG', 'Optimus L3 II Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E435f-M3-D1.xml'                                                         => [ 'LG', 'Optimus L3 II Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E435g-M3-D1.xml'                                                         => [ 'LG', 'Optimus L3 II Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E435k-M3-D1.xml'                                                         => [ 'LG', 'Optimus L3 II Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E440-M3-D1.xml'                                                          => [ 'LG', 'Optimus L4 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E440g-M10-D1.xml'                                                        => [ 'LG', 'Optimus L4 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E465f-M3-D1.xml'                                                         => [ 'LG', 'Optimus L4 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E465g-M3-D1.xml'                                                         => [ 'LG', 'Optimus L4 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E445-M3-D1.xml'                                                          => [ 'LG', 'Optimus L4 II Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E467f-M3-D1.xml'                                                         => [ 'LG', 'Optimus L4 II Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E470f-M3-D1.xml'                                                         => [ 'LG', 'Optimus L4 II Triple', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E610-M10-D1.xml'                                                         => [ 'LG', 'Optimus L5', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E610-M3-D1.xml'                                                          => [ 'LG', 'Optimus L5', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E610-M5-D1.xml'                                                          => [ 'LG', 'Optimus L5', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E610v-M3-D1.xml'                                                         => [ 'LG', 'Optimus L5', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E612f-M10-D1.xml'                                                        => [ 'LG', 'Optimus L5', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E612f-M3-D1.xml'                                                         => [ 'LG', 'Optimus L5', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E612g-M3-D1.xml'                                                         => [ 'LG', 'Optimus L5', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E617G-M6-D1.xml'                                                         => [ 'LG', 'Optimus L5', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E615-M3-D1.xml'                                                          => [ 'LG', 'Optimus L5 Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E615f-M3-D1.xml'                                                         => [ 'LG', 'Optimus L5 Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E450-M3-D1.xml'                                                          => [ 'LG', 'Optimus L5 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E450B-M6-D1.xml'                                                         => [ 'LG', 'Optimus L5 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E450f-M10-D1.xml'                                                        => [ 'LG', 'Optimus L5 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E450f-M3-D1.xml'                                                         => [ 'LG', 'Optimus L5 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E460-M10-D1.xml'                                                         => [ 'LG', 'Optimus L5 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E460-M3-D1.xml'                                                          => [ 'LG', 'Optimus L5 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E460-M5-D1.xml'                                                          => [ 'LG', 'Optimus L5 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E460-M6-D1.xml'                                                          => [ 'LG', 'Optimus L5 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E460f-M3-D1.xml'                                                         => [ 'LG', 'Optimus L5 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E455-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus L5 II Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E455-M3-D1.xml'                                                          => [ 'LG', 'Optimus L5 II Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E455f-M3-D1.xml'                                                         => [ 'LG', 'Optimus L5 II Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P700-M3-D1.xml'                                                          => [ 'LG', 'Optimus L7', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P700-M6-D2.xml'                                                          => [ 'LG', 'Optimus L7', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P705-M3-D1.xml'                                                          => [ 'LG', 'Optimus L7', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P705-M6-D2.xml'                                                          => [ 'LG', 'Optimus L7', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P705f-M3-D1.xml'                                                         => [ 'LG', 'Optimus L7', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P705g-M10-D1.xml'                                                        => [ 'LG', 'Optimus L7', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P705g-M3-D1.xml'                                                         => [ 'LG', 'Optimus L7', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P705g-M6-D1.xml'                                                         => [ 'LG', 'Optimus L7', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P708g-M10-D1.xml'                                                        => [ 'LG', 'Optimus L7', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P708g-M3-D1.xml'                                                         => [ 'LG', 'Optimus L7', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P710-M10-D1.xml'                                                         => [ 'LG', 'Optimus L7 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P710-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus L7 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P710-M3-D1.xml'                                                          => [ 'LG', 'Optimus L7 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P710-M5-D1.xml'                                                          => [ 'LG', 'Optimus L7 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P710-M6-D1.xml'                                                          => [ 'LG', 'Optimus L7 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P712-M3-D1.xml'                                                          => [ 'LG', 'Optimus L7 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P713-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus L7 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P713-M3-D1.xml'                                                          => [ 'LG', 'Optimus L7 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P713GO-M3-D1.xml'                                                        => [ 'LG', 'Optimus L7 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P713TR-M5-D1-KK.xml'                                                     => [ 'LG', 'Optimus L7 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P714-M10-D1-KK.xml'                                                      => [ 'LG', 'Optimus L7 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P714-M10-D1.xml'                                                         => [ 'LG', 'Optimus L7 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P714-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus L7 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P714-M3-D1.xml'                                                          => [ 'LG', 'Optimus L7 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P715-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus L7 II Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P715-M3-D1.xml'                                                          => [ 'LG', 'Optimus L7 II Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P716-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus L7 II Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P716-M3-D1.xml'                                                          => [ 'LG', 'Optimus L7 II Dual', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D700-M6-D1.xml'                                                          => [ 'LG', 'Optimus L9', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/MS769-M10-D1.xml'                                                        => [ 'LG', 'Optimus L9', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P760-M6-D1.xml'                                                          => [ 'LG', 'Optimus L9', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P765-M6-D1.xml'                                                          => [ 'LG', 'Optimus L9', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P768-M10-D1.xml'                                                         => [ 'LG', 'Optimus L9', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P768-M3-D1.xml'                                                          => [ 'LG', 'Optimus L9', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P768-M6-D1.xml'                                                          => [ 'LG', 'Optimus L9', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P769-M10-D1.xml'                                                         => [ 'LG', 'Optimus L9', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P769-M3-D1.xml'                                                          => [ 'LG', 'Optimus L9', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P778-M3-D1.xml'                                                          => [ 'LG', 'Optimus L9', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D605-M3-D1-KK.xml'                                                       => [ 'LG', 'Optimus L9 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D605-M3-D1.xml'                                                          => [ 'LG', 'Optimus L9 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D605-M5-D1-KK.xml'                                                       => [ 'LG', 'Optimus L9 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D605-M6-D1-KK.xml'                                                       => [ 'LG', 'Optimus L9 II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P935-M10-D1-ICS.xml'                                                     => [ 'LG', 'Optimus LTE', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P935-M10-D1.xml'                                                         => [ 'LG', 'Optimus LTE', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P936-M3-D1.xml'                                                          => [ 'LG', 'Optimus LTE', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F260S-M3-D1-KK.xml'                                                      => [ 'LG', 'Optimus LTE III', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F260S-M9-D1-KK.xml'                                                      => [ 'LG', 'Optimus LTE III', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/a_ygkA6q45TBK1IF/LGMS395-M10-D1.xml'                                     => [ 'LG', 'Optimus M', 'Android', DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/LG-MS690.xml'                                                      => [ 'LG', 'Optimus M', 'Android', DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/LG-MS695.xml'                                                      => [ 'LG', 'Optimus M+', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P350-M6-D1.xml'                                                          => [ 'LG', 'Optimus Me', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P350-M6-D2.xml'                                                          => [ 'LG', 'Optimus Me', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P350f-M6-D1.xml'                                                         => [ 'LG', 'Optimus Me', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P350g-M6-D1.xml'                                                         => [ 'LG', 'Optimus Me', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/L45C/latest'                                                          => [ 'LG', 'Optimus Net', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/L45C/LGL45CT1.rdf'                                                    => [ 'LG', 'Optimus Net', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/L45C/LGL45CT2.rdf'                                                    => [ 'LG', 'Optimus Net', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P690-M6-D2.xml'                                                          => [ 'LG', 'Optimus Net', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P690b-M6-D1.xml'                                                         => [ 'LG', 'Optimus Net', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P690f-M6-D1.xml'                                                         => [ 'LG', 'Optimus Net', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P692-M6-D2.xml'                                                          => [ 'LG', 'Optimus Net', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P698-M6-D2.xml'                                                          => [ 'LG', 'Optimus Net', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P698f-M6-D2.xml'                                                         => [ 'LG', 'Optimus Net', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P500-M6-D1.xml'                                                          => [ 'LG', 'Optimus One', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P500h-M6-D1.xml'                                                         => [ 'LG', 'Optimus One', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P500h_iw-M6-D1.xml'                                                      => [ 'LG', 'Optimus One', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P500_iw-M6-D1.xml'                                                       => [ 'LG', 'Optimus One', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P503-M6-D1.xml'                                                          => [ 'LG', 'Optimus One', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P504-M10-D1.xml'                                                         => [ 'LG', 'Optimus One', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/C660-M6-D1.xml'                                                          => [ 'LG', 'Optimus Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/C660h-M6-D1-TCL.xml'                                                     => [ 'LG', 'Optimus Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/C660h-M6-D1-USC.xml'                                                     => [ 'LG', 'Optimus Pro', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/C660h-M6-D1.xml'                                                         => [ 'LG', 'Optimus Pro', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/L55C/LGL55CV1.rdf'                                                    => [ 'LG', 'Optimus Q', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/L55C/LGL55CV3.rdf'                                                    => [ 'LG', 'Optimus Q', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS670/LS670ZV8.rdf'                                                   => [ 'LG', 'Optimus S', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS670/LS670ZV9.rdf'                                                   => [ 'LG', 'Optimus S', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS670/LS670ZVD.rdf'                                                   => [ 'LG', 'Optimus S', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS670/LS670ZVH.rdf'                                                   => [ 'LG', 'Optimus S', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS670/LS670ZVJ.rdf'                                                   => [ 'LG', 'Optimus S', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/LGE/VM701-VMUB/1.0/UAProf.xml'                                               => [ 'LG', 'Optimus Slider', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E730-M6-D2.xml'                                                          => [ 'LG', 'Optimus Sol', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/E730f-M6-D2.xml'                                                         => [ 'LG', 'Optimus Sol', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P509-M10-D1.xml'                                                         => [ 'LG', 'Optimus T', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/lg/vm670/1.0/VMU_VM670_UAProf.xml'                                           => [ 'LG', 'Optimus V', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P895-M6-D2.xml'                                                          => [ 'LG', 'Optimus Vu', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P895qb-M10-D1.xml'                                                       => [ 'LG', 'Optimus Vu', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P895qb-M6-D2.xml'                                                        => [ 'LG', 'Optimus Vu', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F200L-M3-D1-KK.xml'                                                      => [ 'LG', 'Optimus Vu II', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P505-M6-D1.xml'                                                          => [ 'LG', 'Phoenix', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P505R-M6-D1.xml'                                                         => [ 'LG', 'Phoenix', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/PLS225/WL225V04.rdf'                                                  => [ 'LG', 'PLS225', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/PLS350/LX35VN02.rdf'                                                  => [ 'LG', 'PLS350', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/PM225/PM225V02.rdf'                                                   => [ 'LG', 'PM-225', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/PM325/PM325V16.rdf'                                                   => [ 'LG', 'PM-325', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P940-M6-D2.xml'                                                          => [ 'LG', 'PRADA 3.0', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P940h-M6-D2.xml'                                                         => [ 'LG', 'PRADA 3.0', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/qfss6rfI__J51f2o/LGL61AL-M10-D1.xml'                                     => [ 'LG', 'Premier', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LGLS620-Chameleon/latest'                                             => [ 'LG', 'Realm', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS620-BOOST/LS620ZV3.rdf'                                             => [ 'LG', 'Realm', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS620-BOOST/LS620ZV4.rdf'                                             => [ 'LG', 'Realm', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/xDR2-7TjP_4JVIDb/LGL43AL-M10-D1.xml'                                     => [ 'LG', 'Rebel', 'Android', DeviceType::MOBILE ],
    'http://wapuaprof.wap.mycricket.com/lg/LG-LW770.xml'                                                  => [ 'LG', 'Regard', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LX260/LX260V09.rdf'                                                   => [ 'LG', 'Rumor LX260', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LX260/LX260V0a.rdf'                                                   => [ 'LG', 'Rumor LX260', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LG272/LG272ZV8.rdf'                                                   => [ 'LG', 'Rumor Reflex', 'Brew', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LN272/LN272ZV4.rdf'                                                   => [ 'LG', 'Rumor Reflex', 'Brew', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LN272/LN272ZV7.rdf'                                                   => [ 'LG', 'Rumor Reflex', 'Brew', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LN272/LN272ZV8.rdf'                                                   => [ 'LG', 'Rumor Reflex', 'Brew', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LN272S/LN272SV2.rdf'                                                  => [ 'LG', 'Rumor Reflex S', 'Brew', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LN510/LN510ZVD.rdf'                                                   => [ 'LG', 'Rumor Touch', 'Brew', DeviceType::MOBILE ],
    'http://uaprof.vmobl.com/lg/vm510/1.0/VMU_VM510_UAProf.xml'                                           => [ 'LG', 'Rumor Touch', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-S5300.xml'                                                            => [ 'LG', 'S5300', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lge/vs920/vs920.xml'                                                         => [ 'LG', 'Spectrum', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lge/vs930/vs930.xml'                                                         => [ 'LG', 'Spectrum 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/AK1bQ_G8_-S9ccPj/H440-M3-D1.xml'                                         => [ 'LG', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/AK1bQ_G8_-S9ccPj/H440AR-M3-D1.xml'                                       => [ 'LG', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/AK1bQ_G8_-S9ccPj/H440n-M10-D1.xml'                                       => [ 'LG', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/AK1bQ_G8_-S9ccPj/H440n-M20-D1.xml'                                       => [ 'LG', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/AK1bQ_G8_-S9ccPj/H440n-M3-D1.xml'                                        => [ 'LG', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/AK1bQ_G8_-S9ccPj/H440n-M5-D1.xml'                                        => [ 'LG', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/AK1bQ_G8_-S9ccPj/H440n-M6-D1.xml'                                        => [ 'LG', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/AK1bQ_G8_-S9ccPj/H442-M3-D1.xml'                                         => [ 'LG', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/H440n-M3-D1.xml'                                                         => [ 'LG', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/ojFJqSe94jShCXCN/H443-M10-D1.xml'                                        => [ 'LG', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/ojFJqSe94jShCXCN/H445-M3-D1.xml'                                         => [ 'LG', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/yZxLjC9A3ey4GDAw/H420-M10-D1.xml'                                        => [ 'LG', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/yZxLjC9A3ey4GDAw/H420-M3-D1.xml'                                         => [ 'LG', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/yZxLjC9A3ey4GDAw/H420-M6-D1.xml'                                         => [ 'LG', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/yZxLjC9A3ey4GDAw/H422-M3-D1.xml'                                         => [ 'LG', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/LG-MS870.xml'                                                      => [ 'LG', 'Spirit 4G', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/_2YOMy__ZoqF7__g/LGL81AL-M10-D1.xml'                                     => [ 'LG', 'Stylo 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/L15G-M10-D1.xml'                                                         => [ 'LG', 'Sunrise', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LGL15G-M10-D1.xml'                                                       => [ 'LG', 'Sunrise', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/Q9h6lw8rC-nijrc6/LGL15G-M10-D1.xml'                                      => [ 'LG', 'Sunrise', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/yObOcsVFUyAgTj5W/LGL33L-M10-D1.xml'                                      => [ 'LG', 'Sunset', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T310i-M3-D1-NS.xml'                                                   => [ 'LG', 'T310i', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T325-M3-D1.xml'                                                       => [ 'LG', 'T325', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T370-M3-D1.xml'                                                       => [ 'LG', 'T370', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T375-M3-D1.xml'                                                       => [ 'LG', 'T375', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T375.xml'                                                             => [ 'LG', 'T375', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T385.xml'                                                             => [ 'LG', 'T385', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T385b-M3-D1.xml'                                                      => [ 'LG', 'T385b', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T395.xml'                                                             => [ 'LG', 'T395', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T500-M3-D1.xml'                                                       => [ 'LG', 'T500', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T505-M3-D1.xml'                                                       => [ 'LG', 'T505', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T510-M3-D1.xml'                                                       => [ 'LG', 'T510', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T5100N.xml'                                                           => [ 'LG', 'T5100', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T5100V.xml'                                                           => [ 'LG', 'T5100', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T515-M3-D1.xml'                                                       => [ 'LG', 'T515', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T565-M3-D1.xml'                                                       => [ 'LG', 'T565', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T565b-M3-D1.xml'                                                      => [ 'LG', 'T565b', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T580-M3-D1.xml'                                                       => [ 'LG', 'T580', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T585-M3-D1.xml'                                                       => [ 'LG', 'T585', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-T595-M3-D1.xml'                                                       => [ 'LG', 'T595', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-TB200.xml'                                                            => [ 'LG', 'TB200', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P925-M6-D1-ICS.xml'                                                      => [ 'LG', 'Thrill', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P925-M6-D1.xml'                                                          => [ 'LG', 'Thrill', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P925g-M6-D1-ICS.xml'                                                     => [ 'LG', 'Thrill', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/P925g-M6-D1.xml'                                                         => [ 'LG', 'Thrill', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/D857-M3-D1.xml'                                                          => [ 'LG', 'Titan', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/60XyU11_CW-MsU_c/LGL51AL-M10-D1.xml'                                     => [ 'LG', 'Treasure', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-C333-M3-D1.xml'                                                       => [ 'LG', 'Tri Chip C333', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS660-2012071301/LS660ZV5.rdf'                                        => [ 'LG', 'Tribute', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS660-2012071301/LS660ZV6.rdf'                                        => [ 'LG', 'Tribute', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS660-BOOST/LS660ZV4.rdf'                                             => [ 'LG', 'Tribute', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS660-BOOST/LS660ZV5.rdf'                                             => [ 'LG', 'Tribute', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS660-BOOST/LS660ZV6.rdf'                                             => [ 'LG', 'Tribute', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS660-Chameleon/latest'                                               => [ 'LG', 'Tribute', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS660-SPRPRE/LS660ZV3.rdf'                                            => [ 'LG', 'Tribute', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS660-SPRPRE/LS660ZV4.rdf'                                            => [ 'LG', 'Tribute', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS660-SPRPRE/LS660ZV5.rdf'                                            => [ 'LG', 'Tribute', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS660-VIRGIN/LS660ZV3.rdf'                                            => [ 'LG', 'Tribute', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS660-VIRGIN/LS660ZV4.rdf'                                            => [ 'LG', 'Tribute', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS660-VIRGIN/LS660ZV5.rdf'                                            => [ 'LG', 'Tribute', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS660-VIRGIN/LS660ZV6.rdf'                                            => [ 'LG', 'Tribute', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-TU575.xml'                                                            => [ 'LG', 'TU575', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-TU720.xml'                                                            => [ 'LG', 'TU720 Shine', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-TU915.xml'                                                            => [ 'LG', 'TU915 Vu', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-U300.xml'                                                             => [ 'LG', 'U300', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-U400.xml'                                                             => [ 'LG', 'U400', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-U830.xml'                                                             => [ 'LG', 'U830 Chocolate', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-U900.xml'                                                             => [ 'LG', 'U900', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-U970.xml'                                                             => [ 'LG', 'U970 Shine', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/eNsCGw_apwMhnXPM/H901-M3-D1.xml'                                         => [ 'LG', 'V10', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/eNsCGw_apwMhnXPM/H960-M10-D1.xml'                                        => [ 'LG', 'V10', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/eNsCGw_apwMhnXPM/H960-M3-D1.xml'                                         => [ 'LG', 'V10', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/eNsCGw_apwMhnXPM/H961N-M3-D1.xml'                                        => [ 'LG', 'V10', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/eNsCGw_apwMhnXPM/H968-M3-D1.xml'                                         => [ 'LG', 'V10', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/_W4s8Utf_eec5qYV/H900-M3-D1.xml'                                         => [ 'LG', 'V10', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LG730-6100000231/LG730ZV5.rdf'                                        => [ 'LG', 'Venice', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LG730-BOOST/LG730ZV5.rdf'                                             => [ 'LG', 'Venice', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LG730-BOOST/LG730ZV6.rdf'                                             => [ 'LG', 'Venice', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LG730-BOOST/LG730ZV8.rdf'                                             => [ 'LG', 'Venice', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LG730-Chameleon/latest'                                               => [ 'LG', 'Venice', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/VI125/VI125V10.rdf'                                                   => [ 'LG', 'VI-125', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/VI5225/LX540V08.rdf'                                                  => [ 'LG', 'VI-5225', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS840/LS840ZVC.rdf'                                                   => [ 'LG', 'Viper', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS840/LS840ZVD.rdf'                                                   => [ 'LG', 'Viper', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS840/LS840ZVI.rdf'                                                   => [ 'LG', 'Viper', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS840/LS840ZVK.rdf'                                                   => [ 'LG', 'Viper', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS740-2012071301/LS740ZV6.rdf'                                        => [ 'LG', 'Volt', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS740-SPRPRE/LS740ZV4.rdf'                                            => [ 'LG', 'Volt', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/LG/LS751-Chameleon/latest'                                               => [ 'LG', 'Volt 2', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/F300L-M3-D1.xml'                                                         => [ 'LG', 'Vu 3', 'Android', DeviceType::MOBILE ],
    'http://mms.cellcom.com/uaprofs/lg-vx5000.xml'                                                        => [ 'LG', 'VX5000', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lg/vx8350/vx8350.xml'                                                        => [ 'LG', 'VX8350', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lg/vx8550/vx8550.xml'                                                        => [ 'LG', 'VX8550 Chocolate', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lg/vx8600/vx8600.xml'                                                        => [ 'LG', 'VX8600', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lg/vx8610/vx8610.xml'                                                        => [ 'LG', 'VX8610 Decoy', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lg/vx8700/vx8700.xml'                                                        => [ 'LG', 'VX8700', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lg/vx8800/vx8800.xml'                                                        => [ 'LG', 'VX8800 Venus', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lg/vx9100/vx9100.xml'                                                        => [ 'LG', 'VX9100 enV2', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lg/vx9400/vx9400.xml'                                                        => [ 'LG', 'VX9400', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lg/vx9700/vx9700.xml'                                                        => [ 'LG', 'VX9700 Dare', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/lg/vx9900/vx9900.xml'                                                        => [ 'LG', 'VX9900 enV', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/sMGZI_CVcpnY_oHi/H410-M10-D1.xml'                                        => [ 'LG', 'Wine Smart', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/sMGZI_CVcpnY_oHi/H410-M3-D1.xml'                                         => [ 'LG', 'Wine Smart', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/sMGZI_CVcpnY_oHi/H410-M6-D1.xml'                                         => [ 'LG', 'Wine Smart', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/_aYtYmwT_LRbNYO_/LGL53BL-M10-D1.xml'                                     => [ 'LG', 'X Style', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/31L-M10-D1.xml'                                                          => [ 'LG', 'X3', 'Android', DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-UAP-X330-v0.1.xml'                                                    => [ 'LG', 'X330T', null, DeviceType::MOBILE ],
    'http://gsm.lge.com/html/gsm/LG-X350.xml'                                                             => [ 'LG', 'X350', 'MTK', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4TEL_SS990GPRS.xml'                                    => [ 'M4Tel', 'E-Motion', 'Android', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4TEL_SS550GPRS.xml'                                    => [ 'M4Tel', 'Genius', 'Android', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4_SS1060GPRS.xml'                                      => [ 'M4Tel', 'M4Live', 'Android', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4_SS1080GPRS.xml'                                      => [ 'M4Tel', 'Max One', 'Android', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4_SS1090GPRS.xml'                                      => [ 'M4Tel', 'Max Ultra', 'Android', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4TEL_SS880GPRS.xml'                                    => [ 'M4Tel', 'Mirage', 'Android', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4_SS1070GPRS.xml'                                      => [ 'M4Tel', 'Sense', 'Android', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4_SS1050GPRS.xml'                                      => [ 'M4Tel', 'SS1050', 'Android', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4_SS4040GPRS.xml'                                      => [ 'M4Tel', 'SS4040', 'Android', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4_SS4041GPRS.xml'                                      => [ 'M4Tel', 'SS4041', 'Android', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4_SS4045GPRS.xml'                                      => [ 'M4Tel', 'SS4045', 'Android', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4_SS4350GPRS.xml'                                      => [ 'M4Tel', 'SS4350', 'Android', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4_SS4450GPRS.xml'                                      => [ 'M4Tel', 'SS4450', 'Android', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4_SS4451GPRS.xml'                                      => [ 'M4Tel', 'SS4451', 'Android', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4_SS4452GPRS.xml'                                      => [ 'M4Tel', 'SS4452', 'Android', DeviceType::MOBILE ],
    'http://www.m4tel.com/product/profiles/uaprof/M4_SS4456GPRS.xml'                                      => [ 'M4Tel', 'SS4456', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/ZTE-SKATE.xml, http://www.zte.com.cn/mobile/uaprof/ZTE-SKATE.xml'=> [ 'Medion', 'Life P4310', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/MT7A.xml'                                                        => [ 'MegaFon', 'Login', 'Android', DeviceType::TABLET ],
    'http://www.zte.com.cn/mobile/uaprof/MegaFon_V9+.xml'                                                 => [ 'MegaFon', 'V9+', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/smart_a17.xml'                                                      => [ 'MEO', 'Smart A17', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/MEO Smart A40.xml'                                               => [ 'MEO', 'Smart A40', 'Android', DeviceType::MOBILE ],
    'http://mobileupdate.sdt.pt/meo/WBW5518-UAProfile.xml'                                                => [ 'MEO', 'Smart A66', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/Micromax/Micromax_A104.xml'                                           => [ 'Micromax', 'A104 Canvas Fire', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOA110Q.xml'                                                  => [ 'Micromax', 'A110 Canvas 2', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/Micromax/Micromax_A177.xml'                                           => [ 'Micromax', 'A177 Canvas Juice', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/Micromax/Micromax_A190.xml'                                           => [ 'Micromax', 'A190 Canvas HD Plus', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/Micromax/Micromax_A315.xml'                                           => [ 'Micromax', 'A315 Canvas 4 Plus', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/Micromax/Micromax_A316.xml'                                           => [ 'Micromax', 'A316 Canvas Hue 2', 'Android', DeviceType::MOBILE ],
    'http://ibu.joy3g.org/ibu/MCX_A54_20121119_ua.xml'                                                    => [ 'Micromax', 'A54 Ninja', 'Android', DeviceType::MOBILE ],
    'http://ibu.joy3g.org/ibu/MCX_A56_20120522_ua.xml'                                                    => [ 'Micromax', 'A56 Ninja 2', 'Android', DeviceType::MOBILE ],
    'http://ibu.joy3g.org/ibu/MCX_A57_20120725_ua.xml'                                                    => [ 'Micromax', 'A57 Ninja 3', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/Micromax/Micromax_A064.xml'                                           => [ 'Micromax', 'A64 Bolt', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/Micromax/Micromax_A065.xml'                                           => [ 'Micromax', 'A65 Smarty', 'Android', DeviceType::MOBILE ],
    'http://ibu.joy3g.org/ibu/MCX_A87_20120725_ua.xml'                                                    => [ 'Micromax', 'A87 Ninja 4', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/Micromax/Micromax_A093.xml'                                           => [ 'Micromax', 'A93 Canvas Elanza', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/Micromax/Micromax_AQ5001.xml'                                         => [ 'Micromax', 'AQ5001 Canvas Juice 2', 'Android', DeviceType::MOBILE ],
    'http://202.58.121.191/MTK_Phone_KK_UAprofile.xml'                                                    => [ 'Micromax', 'Canvas Tab P470', 'Android', DeviceType::TABLET ],
    'http://www.1066.cn/uaprof/prof/Micromax/Micromax_Q380.xml'                                           => [ 'Micromax', 'Q380 Canvas Spark', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/Micromax/Micromax Q391.xml'                                           => [ 'Micromax', 'Q391 Canvas Doodle 4', 'Android', DeviceType::MOBILE ],
    'http://www.1066.cn/uaprof/prof/Micromax/Micromax_Q394.xml'                                           => [ 'Micromax', 'Q394 Canvas Juice 3+', 'Android', DeviceType::MOBILE ],
    'http://www.uniscope.com.cn/Micromax_Q415_UAprofile.xml'                                              => [ 'Micromax', 'Q415 Spark Vdeo', 'Android', DeviceType::MOBILE ],
    'Micromax X450'                                                                                       => [ 'Micromax', 'X450', null, DeviceType::MOBILE ],
    'http://go.microsoft.com/fwlink/?LinkId=164226'                                                       => [ 'Microsoft', 'Kin ONE', 'Kin OS', DeviceType::MOBILE ],
    'http://zune.net/uaprof/ZuneHD.xml'                                                                   => [ 'Microsoft', 'Zune HD', null,  ],
    'http://www.mio-tech.com.tw/download/smartphone/Mio8390r101.xml'                                      => [ 'Mio', '8390', null, DeviceType::MOBILE ],
    'http://www.mio-tech.com.tw/download/smartphone/MioA700.xml'                                          => [ 'Mio', 'A700', null, DeviceType::MOBILE ],
    'http://www.mio-tech.com.tw/download/smartphone/MioA701.xml'                                          => [ 'Mio', 'A701', null, DeviceType::MOBILE ],
    'http://www.mitsubishi-telecom.com/profiles/eclipse.ua'                                               => [ 'Mitsubishi', 'Trium Eclipse', null, DeviceType::MOBILE ],
    'http://www.mitsubishi-telecom.com/profiles/eclipse_mserv.ua'                                         => [ 'Mitsubishi', 'Trium Eclipse', null, DeviceType::MOBILE ],
    'http://www.mitsubishi-telecom.com/profiles/mt560.ua'                                                 => [ 'Mitsubishi', 'Trium M 320', null, DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/M9000.xml'                                                       => [ 'MobiFone', 'M9000', 'Android', DeviceType::MOBILE ],
    'http://imatemms.imate.com/gen/UAProf_JAMA_v1.xml'                                                    => [ 'MobileXP', 'JAMA', null, DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/MOCHE SMART A16.xml'                                             => [ 'Moche', 'Smart A16', 'Android', DeviceType::MOBILE ],
    'http://asmobile.ehosting.com.tw/uaprof/Virgin_1.xml'                                                 => [ 'Modelabs', 'Virgin', null, DeviceType::MOBILE ],
    'http://www.modumobile.com/ua/modu-t_1_browser.xml'                                                   => [ 'Modu', 'T', null, DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/moii_E598.xml'                                                   => [ 'moii', 'E598', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Momodesign_MD_Droid.xml'                                         => [ 'Momodesign', 'MD Droid', 'Android', DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/a1000/Profile/a1000.rdf'                                    => [ 'Motorola', 'A1000', 'UIQ', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/MOT/MOT_A3300c_4_20091029.xml'                                           => [ 'Motorola', 'A3300', 'Windows Mobile', DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/a780/Profile/a780.rdf'                                      => [ 'Motorola', 'A780', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/a840/a840v1.xml'                                                         => [ 'Motorola', 'A840', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/MOT603KIT/551Q117PAX33.rdf'                                     => [ 'Motorola', 'ADMIRAL', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/MOT603KIT/551Q117PAX63.rdf'                                     => [ 'Motorola', 'ADMIRAL', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/MOT603KIT/551Q117PAX69.rdf'                                     => [ 'Motorola', 'ADMIRAL', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/MOT603KIT/551Q117PAX79.rdf'                                     => [ 'Motorola', 'ADMIRAL', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomb860/Profile/motomb860.rdf'                              => [ 'Motorola', 'ATRIX', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomb860/Profile/motomb860emara.rdf'                         => [ 'Motorola', 'ATRIX', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomb861/Profile/motomb861.rdf'                              => [ 'Motorola', 'ATRIX', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoME860/profile/MotoME860.rdf'                              => [ 'Motorola', 'ATRIX', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomb865/Profile/motomb865.rdf'                              => [ 'Motorola', 'ATRIX 2', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt687/Profile/xt687.rdf'                                      => [ 'Motorola', 'ATRIX TV', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoMB300/profile/MotoMB300.rdf'                              => [ 'Motorola', 'BACKFLIP', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomb300/Profile/MotoMB300Eclair.rdf'                        => [ 'Motorola', 'BACKFLIP', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomb300/Profile/motomb300la.rdf'                            => [ 'Motorola', 'BACKFLIP', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomb520/Profile/MotoMB520.rdf'                              => [ 'Motorola', 'BRAVO', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomb520/Profile/MotoMB520FroYo.rdf'                         => [ 'Motorola', 'BRAVO', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/ex118/Profile/EX118.rdf'                                      => [ 'Motorola', 'Brea EX119', 'MTK', DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/C168/Profile/c168.rdf'                                      => [ 'Motorola', 'C168', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/C168i/Profile/C168i-cingular.rdf'                           => [ 'Motorola', 'C168i', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/C290/2440.rdf'                                                  => [ 'Motorola', 'C290', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/c357/Profile/c357.rdf'                                        => [ 'Motorola', 'C357', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomb502/Profile/MotoMB502.rdf'                              => [ 'Motorola', 'CHARM', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoMB200/profile/MotoMB200.rdf'                              => [ 'Motorola', 'CLIQ', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoMB501/profile/MotoMB501.rdf'                              => [ 'Motorola', 'CLIQ XT', 'Android', DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/cn620/profile/cn620.rdf'                                    => [ 'Motorola', 'CN620', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoMB525+/profile/MotoMB525+.rdf'                            => [ 'Motorola', 'DEFY', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoMB525/profile/MotoMB525.rdf'                              => [ 'Motorola', 'DEFY', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoMB525/profile/MotoMB525Telstra.rdf'                       => [ 'Motorola', 'DEFY', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt535/Profile/XT535.rdf'                                      => [ 'Motorola', 'DEFY', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt535/Profile/xt535I.rdf'                                     => [ 'Motorola', 'DEFY', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt535/Profile/xt535_TNZ.rdf'                                  => [ 'Motorola', 'DEFY', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt536/Profile/xt536.rdf'                                      => [ 'Motorola', 'DEFY Diana', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt536/Profile/xt536I.rdf'                                     => [ 'Motorola', 'DEFY Diana', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt320/Profile/xt320.rdf'                                      => [ 'Motorola', 'DEFY Mini', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt321/Profile/xt321.rdf'                                      => [ 'Motorola', 'DEFY Mini', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt560/Profile/xt560.rdf'                                      => [ 'Motorola', 'DEFY Pro', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt555c/Profile/xt555c.rdf'                                    => [ 'Motorola', 'DEFY XT', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt556/Profile/xt556.rdf'                                      => [ 'Motorola', 'DEFY XT', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt557/Profile/xt557.rdf'                                      => [ 'Motorola', 'DEFY XT', 'Android', DeviceType::MOBILE ],
    'http://uaprof.ntelospcs.net/xt556.xml'                                                               => [ 'Motorola', 'DEFY XT', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoMB525/profile/MotoMB526.rdf'                              => [ 'Motorola', 'DEFY+', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomb526/Profile/motomb526.rdf'                              => [ 'Motorola', 'DEFY+', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomb886/Profile/motomb886.rdf'                              => [ 'Motorola', 'DINARA', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/a955/a955.xml'                                                           => [ 'Motorola', 'Droid 2', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/a956/a956.xml'                                                           => [ 'Motorola', 'Droid 2', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt682/Profile/xt682.rdf'                                      => [ 'Motorola', 'Droid 3', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/xt862/xt862.xml'                                                         => [ 'Motorola', 'Droid 3', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/XT897-2011011301/771Q6SPR125ASA14.rdf'                          => [ 'Motorola', 'Droid 4', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/xt894/xt894.xml'                                                         => [ 'Motorola', 'Droid 4', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/xt875/xt875.xml'                                                         => [ 'Motorola', 'Droid Bionic', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motoxt610/Profile/motoxt610.rdf'                              => [ 'Motorola', 'Droid Pro', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/xt610/xt610.xml'                                                         => [ 'Motorola', 'Droid Pro', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motoxt912/Profile/motoxt912.rdf'                              => [ 'Motorola', 'Droid RAZR', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/xt912/xt912.xml'                                                         => [ 'Motorola', 'Droid RAZR', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motoxt925/Profile/motoxt925.rdf'                              => [ 'Motorola', 'Droid RAZR HD', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/xt926/xt926.xml'                                                         => [ 'Motorola', 'Droid RAZR HD', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/xt907/xt907.xml'                                                         => [ 'Motorola', 'Droid RAZR M', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/mb810/mb810.xml'                                                         => [ 'Motorola', 'Droid X', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/mb870/mb870.xml'                                                         => [ 'Motorola', 'Droid X2', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/mz617/mz617.xml'                                                         => [ 'Motorola', 'Droid XYBOARD 10.1', 'Android', DeviceType::TABLET ],
    'http://uaprof.vtext.com/mot/mz609/mz609.xml'                                                         => [ 'Motorola', 'Droid XYBOARD 8.2', 'Android', DeviceType::TABLET ],
    'http://motorola.handango.com/phoneconfig/e365/Profile/e365.rdf'                                      => [ 'Motorola', 'E365', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/e680i/Profile/e680i.rdf'                                    => [ 'Motorola', 'E680i', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/E770v/Profile/E770v.rdf'                                    => [ 'Motorola', 'E770v', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/e790/Profile/e790.rdf'                                      => [ 'Motorola', 'E790', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/e815/Profile/e815.rdf'                                      => [ 'Motorola', 'E815', null, DeviceType::MOBILE ],
    'http://uaprof.bellmobilite.ca/BMC_Motorola_E815_BMX171P.rdf'                                         => [ 'Motorola', 'E815', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomb853/Profile/motomb853.rdf'                              => [ 'Motorola', 'Electrify', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/em25/Profile/em25.rdf'                                        => [ 'Motorola', 'EM25', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/em30/Profile/em30.rdf'                                        => [ 'Motorola', 'EM30', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/em325/Profile/em325.rdf'                                      => [ 'Motorola', 'EM325', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/es405b/Profile/es405b.rdf'                                    => [ 'Motorola', 'ES405B', 'Windows Mobile', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/ex116/Profile/ex116.rdf'                                      => [ 'Motorola', 'EX116', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/ex128/Profile/EX128_27390a3c7426da5686f20302b82926e1.rdf'     => [ 'Motorola', 'EX128', null, DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/MOT/MOT_EX200_3_20100728.xml'                                            => [ 'Motorola', 'EX200', 'Brew', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/ex226/Profile/ex226.rdf'                                      => [ 'Motorola', 'EX226', 'MTK', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt311/Profile/xt311.rdf'                                      => [ 'Motorola', 'FIRE', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt530/Profile/xt530.rdf'                                      => [ 'Motorola', 'FIRE XT', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/XT531/Profile/XT531.rdf'                                      => [ 'Motorola', 'FIRE XT', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoMB511/profile/MotoMB511.rdf'                              => [ 'Motorola', 'FLIPOUT', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomb508/Profile/MotoMB508FroYo.rdf'                         => [ 'Motorola', 'FLIPSIDE', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/wx308/Profile/wx308.rdf'                                      => [ 'Motorola', 'GLEAM+ WX308', 'MTK', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/ic402/1280.rdf'                                                 => [ 'Motorola', 'ic402 Blend', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/ic502/1292.rdf'                                                 => [ 'Motorola', 'ic502 Buzz', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/ic602/1500.rdf'                                                 => [ 'Motorola', 'ic602 Buzz+', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/ic902/2610.rdf'                                                 => [ 'Motorola', 'ic902 Deluxe', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motoxt627/Profile/Motoxt627.rdf'                              => [ 'Motorola', 'Kairos XT627', 'Android', DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/k1/Profile/k1.rdf'                                          => [ 'Motorola', 'KRZR K1', null, DeviceType::MOBILE ],
    'http://www.alltel.net/uaprof/moto/k1c/k1c.xml'                                                       => [ 'Motorola', 'KRZR K1c', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/K3/Profile/K3.rdf'                                          => [ 'Motorola', 'KRZR K3', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/l6/Profile/l6.rdf'                                          => [ 'Motorola', 'L6', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/l6i/Profile/l6i.rdf'                                        => [ 'Motorola', 'L6i', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/MOTOXT603/'                                                     => [ 'Motorola', 'Master XT605', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoXT605/profile/MotoXT605.rdf'                              => [ 'Motorola', 'Master XT605', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/mc65/Profile/mc65.rdf'                                        => [ 'Motorola', 'MC65 Wireless Rugged Mobile Computer', 'Windows Mobile', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/milestonext720/Profile/milestonext720.rdf'                    => [ 'Motorola', 'Milestone', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoA953/profile/MotoA953.rdf'                                => [ 'Motorola', 'Milestone 2', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoA953/profile/MotoA953GB.rdf'                              => [ 'Motorola', 'Milestone 2', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motoxt860/Profile/motoxt860.rdf'                              => [ 'Motorola', 'Milestone 3', 'Android', DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/A1200e/profile/A1200e.rdf'                                  => [ 'Motorola', 'Ming A1200e', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/A1200i/profile/A1200i.rdf'                                  => [ 'Motorola', 'Ming A1200i', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/em330/Profile/em330.rdf'                                      => [ 'Motorola', 'MOTO EM330', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motome525+/Profile/motome525+.rdf'                            => [ 'Motorola', 'MOTO ME525', 'Android', DeviceType::MOBILE ],
    'http://uaprofile.motorola.com/uaprof/MOT_MT620-1.0.xml'                                              => [ 'Motorola', 'MOTO MT620', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoMt870/profile/MotoMt870.rdf'                              => [ 'Motorola', 'MOTO MT870', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/SLV-L7c/0350.rdf'                                               => [ 'Motorola', 'MOTO SLVR L7c', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motoxt316/Profile/motoxt316.rdf'                              => [ 'Motorola', 'MOTO XT316', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt316/Profile/xt316.rdf'                                      => [ 'Motorola', 'MOTO XT316', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt615/Profile/motoxt615.rdf'                                  => [ 'Motorola', 'MOTO XT615', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt615/Profile/xt615.rdf'                                      => [ 'Motorola', 'MOTO XT615', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motoxt626/Profile/Motoxt626.rdf'                              => [ 'Motorola', 'MOTO XT626', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/MOT/MOT_XT681_1_20110930.XML'                                            => [ 'Motorola', 'MOTO XT681', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/MOT/MOT_XT681_1_20111012.XML'                                            => [ 'Motorola', 'MOTO XT681', 'Android', DeviceType::MOBILE ],
    'http://uaprof.qma.com.tw/Motorola-XT681.xml'                                                         => [ 'Motorola', 'MOTO XT681', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt685/Profile/xt685.rdf'                                      => [ 'Motorola', 'MOTO XT685', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomb860/Profile/motoxt882.rdf'                              => [ 'Motorola', 'MOTO XT882', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/w450/profile/w450.rdf'                                        => [ 'Motorola', 'MOTOACTV W450', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/ex430/Profile/ex430.rdf'                                      => [ 'Motorola', 'MotoGO EX430', 'MTK', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/ex108/Profile/ex108.rdf'                                      => [ 'Motorola', 'MOTOKEY Mini EX108', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/ex225/Profile/ex225.rdf'                                      => [ 'Motorola', 'MOTOKEY Social EX225', 'MTK', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/mt680/Profile/mt680.rdf'                                      => [ 'Motorola', 'MOTOLUXE MT680', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt611/Profile/xt611.rdf'                                      => [ 'Motorola', 'MOTOSMART Flip', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/MOT/MOT_XT553_1_20120309.XML'                                            => [ 'Motorola', 'MOTOSMART MIX', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt550/Profile/xt550.rdf'                                      => [ 'Motorola', 'MOTOSMART MIX', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt303/Profile/xt303.rdf'                                      => [ 'Motorola', 'MOTOSMART XT303', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt305/Profile/xt305.rdf'                                      => [ 'Motorola', 'MOTOSMART XT305', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt389/Profile/xt389.rdf'                                      => [ 'Motorola', 'MOTOSMART XT389', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt389/Profile/xt389_we.rdf'                                   => [ 'Motorola', 'MOTOSMART XT389', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt390/Profile/xt390.rdf'                                      => [ 'Motorola', 'MOTOSMART XT390', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/q-gsm/Profile/mot-a3100.rdf'                                  => [ 'Motorola', 'MOTOSURF A3100', 'Windows', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/zn5/Profile/zn5.rdf'                                          => [ 'Motorola', 'MOTOZINE ZN5', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/mpx/Profile/mpx.rdf'                                        => [ 'Motorola', 'MPx', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/mpx200/Profile/mpx200.rdf'                                  => [ 'Motorola', 'MPx200', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/mpx220/Profile/mpx220.rdf'                                  => [ 'Motorola', 'MPx220', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomt917/profile/motomt917.rdf'                              => [ 'Motorola', 'MT917', 'Android', DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/u6/Profile/u6.rdf'                                          => [ 'Motorola', 'PEBL U6', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoMB200/profile/MotoMB200.rdf451A1.rdf'                     => [ 'Motorola', 'PHOTON', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/MOTOMB855/'                                                     => [ 'Motorola', 'PHOTON 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/MOTOMB855/451A1.rdf'                                            => [ 'Motorola', 'PHOTON 4G', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motomb855/Profile/motomb855.rdf'                              => [ 'Motorola', 'PHOTON 4G', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/XT897-SPRINT/771Q6SPR125ASA10.rdf'                              => [ 'Motorola', 'PHOTON Q', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/XT897-SPRINT/771Q6SPR125ASA14.rdf'                              => [ 'Motorola', 'PHOTON Q', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/XT897-SPRINT/771Q6SPR89ASA36.rdf'                               => [ 'Motorola', 'PHOTON Q', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/XT897/latest'                                                   => [ 'Motorola', 'PHOTON Q', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoXT621/profile/MotoXT621.rdf'                              => [ 'Motorola', 'Primus XT621', 'Android', DeviceType::MOBILE ],
    'http://uaporf.motorola.com/phoneconfig/MotoME632/profile/MotoME632.rdf'                              => [ 'Motorola', 'PRO+', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoMB632/profile/MotoMB632.rdf'                              => [ 'Motorola', 'PRO+', 'Android', DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/q-umts/Profile/mot-q-umts.rdf'                              => [ 'Motorola', 'Q', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/q-gsm/Profile/mot-q-gsm.rdf'                                  => [ 'Motorola', 'Q', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/q-umts/Profile/mot-q-umts.rdf'                                => [ 'Motorola', 'Q', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/q-umts/Profile/mot-q9h.rdf'                                   => [ 'Motorola', 'Q9h', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motoxt910/Profile/motoxt910.rdf'                              => [ 'Motorola', 'RAZR', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motoxt910k/Profile/motoxt910k.rdf'                            => [ 'Motorola', 'RAZR', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motoxt890/Profile/motoxt890.rdf'                              => [ 'Motorola', 'RAZR i', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motoxt890/Profile/motoxt890_jb.rdf'                           => [ 'Motorola', 'RAZR i', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/mt781/Profile/mt781.rdf'                                      => [ 'Motorola', 'RAZR i', 'Android', DeviceType::MOBILE ],
    'http://uaprof.ntelospcs.net/motoxt908.xml'                                                           => [ 'Motorola', 'RAZR MAXX', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/MOT/MOT_XT889_1_20120217.XML'                                            => [ 'Motorola', 'RAZR V', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/mt887/Profile/mt887.rdf'                                      => [ 'Motorola', 'RAZR V', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt885/Profile/xt885.rdf'                                      => [ 'Motorola', 'RAZR V', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt885/Profile/xt885_ca.rdf'                                   => [ 'Motorola', 'RAZR V', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt885/Profile/xt885_ird.rdf'                                  => [ 'Motorola', 'RAZR V', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt886/Profile/xt886.rdf'                                      => [ 'Motorola', 'RAZR V', 'Android', DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/razrv3x/Profile/razrv3x.rdf'                                => [ 'Motorola', 'RAZR V3', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/razrv3xx/Profile/RAZRV3xx.rdf'                              => [ 'Motorola', 'RAZR V3', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/v3/Profile/v3.rdf'                                          => [ 'Motorola', 'RAZR V3', null, DeviceType::MOBILE ],
    'http://uaprof.bellmobilite.ca/BMC_Motorola_V3c_070301P.rdf'                                          => [ 'Motorola', 'RAZR V3c', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/v3i/Profile/v3i.rdf'                                        => [ 'Motorola', 'RAZR V3i', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/v3r/Profile/v3r.rdf'                                        => [ 'Motorola', 'RAZR V3r', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/razrv6/Profile/RAZRv6.rdf'                                  => [ 'Motorola', 'RAZR V6', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MOTORAZRv9x/profile/MOTORAZRv9x.rdf'                          => [ 'Motorola', 'RAZR V9', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/v9/profile/v9.rdf'                                            => [ 'Motorola', 'RAZR V9', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/VE20/0570.rdf'                                                  => [ 'Motorola', 'RAZR VE20', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/motorazrV8/Profile/motorazrv8.rdf'                          => [ 'Motorola', 'RAZR2 V8', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/V9m/2680.rdf'                                                   => [ 'Motorola', 'RAZR2 V9m', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/motorola/V9m-1.rdf'                                                  => [ 'Motorola', 'RAZR2 V9m', null, DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/V950/0591.rdf'                                                  => [ 'Motorola', 'Renegade V950', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motorizrz10/Profile/motorizrz10.xml'                          => [ 'Motorola', 'RIZR Z10', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motorizrz8/profile/motorizrz8.rdf'                            => [ 'Motorola', 'RIZR Z8', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/e1/Profile/e1.rdf'                                          => [ 'Motorola', 'ROKR E1', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/motorokre6/Profile/motorokre6.rdf'                          => [ 'Motorola', 'ROKR E6', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motorokre6/Profile/motorokre6.rdf'                            => [ 'Motorola', 'ROKR E6', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/e8/Profile/e8.rdf'                                            => [ 'Motorola', 'ROKR E8', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/W5/Profile/W5.rdf'                                            => [ 'Motorola', 'ROKR W5', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/w6/Profile/w6.rdf'                                            => [ 'Motorola', 'ROKR W6', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/motorokrz6/Profile/motorokrz6.rdf'                          => [ 'Motorola', 'ROKR Z6', null, DeviceType::MOBILE ],
    'http://www.alltel.net/uaprof/moto/z6m/z6m.xml'                                                       => [ 'Motorola', 'ROKR Z6m', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/motoxt300/Profile/motoxt300.rdf'                              => [ 'Motorola', 'SPICE', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/VA76r/Profile/VA76r.rdf'                                      => [ 'Motorola', 'Tundra VA76r', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/u9/Profile/u9.rdf'                                            => [ 'Motorola', 'U9', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/v175/Profile/v175.rdf'                                      => [ 'Motorola', 'V175', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/v177/profile/v177.rdf'                                      => [ 'Motorola', 'V177', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/v190/Profile/v190.rdf'                                      => [ 'Motorola', 'V190', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/v191/Profile/v191.rdf'                                      => [ 'Motorola', 'V191', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/v197/Profile/v197.rdf'                                      => [ 'Motorola', 'V197', null, DeviceType::MOBILE ],
    'http://uaprof.metropcs.net/UAProf/Motorola-V323i.xml'                                                => [ 'Motorola', 'V323i', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/v325/v325v1.xml'                                                         => [ 'Motorola', 'V325', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/v360i/Profile/v360i.rdf'                                    => [ 'Motorola', 'V360', null, DeviceType::MOBILE ],
    'http://device.telusmobility.com/motorola/v710.rdf'                                                   => [ 'Motorola', 'V710', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/v860/v860.xml'                                                           => [ 'Motorola', 'V860', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/ve/vev1.xml'                                                             => [ 'Motorola', 'Ve', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/ve538/Profile/ve538.rdf'                                      => [ 'Motorola', 'VE538', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/W213/Profile/W213.rdf'                                        => [ 'Motorola', 'W213', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/w230/Profile/w230.rdf'                                        => [ 'Motorola', 'W230', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/W270/Profile/W270.rdf'                                        => [ 'Motorola', 'W270', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/w360/Profile/w360.rdf'                                        => [ 'Motorola', 'W360', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/w370/Profile/w370.rdf'                                      => [ 'Motorola', 'W370', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/W375/Profile/W375.rdf'                                      => [ 'Motorola', 'W375', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/w385m/Profile/w385m.rdf'                                      => [ 'Motorola', 'W385', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/W396/Profile/W396.rdf'                                        => [ 'Motorola', 'W396', null, DeviceType::MOBILE ],
    'http://motorola.handango.com/phoneconfig/w510/Profile/w510.rdf'                                      => [ 'Motorola', 'W510', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/mot/w755/w755v1.xml'                                                         => [ 'Motorola', 'W755', null, DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/MotoMZ616/Profile/MotoMZ616.rdf'                              => [ 'Motorola', 'XOOM 2', 'Android', DeviceType::TABLET ],
    'http://uaprof.motorola.com/phoneconfig/Xoom2/Profile/xoom2.rdf'                                      => [ 'Motorola', 'XOOM 2', 'Android', DeviceType::TABLET ],
    'http://uaprof.motorola.com/phoneconfig/Xoom2me/Profile/xoom2me.rdf'                                  => [ 'Motorola', 'XOOM 2', 'Android', DeviceType::TABLET ],
    'http://uaprof.motorola.com/phoneconfig/motomz601/Profile/motomz601.rdf'                              => [ 'Motorola', 'XOOM 3G', 'Android', DeviceType::TABLET ],
    'http://device.sprintpcs.com/Motorola/MOTB612ABB/BST20.rdf'                                           => [ 'Motorola', 'XPRT', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/MOTOMB612/451110KNS17.rdf'                                      => [ 'Motorola', 'XPRT', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/MOTOMB612/451110KNS46.rdf'                                      => [ 'Motorola', 'XPRT', 'Android', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/Motorola/MOTOMB612/KRNSX41110.rdf'                                       => [ 'Motorola', 'XPRT', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/xt788/Profile/xt788.rdf'                                      => [ 'Motorola', 'XT788', 'Android', DeviceType::MOBILE ],
    'http://nmsc.ctvap.cn/uaprof/MOT/MOT_XT928_1_20110914.XML'                                            => [ 'Motorola', 'XT928', 'Android', DeviceType::MOBILE ],
    'http://uaprof.motorola.com/phoneconfig/ZN200/Profile/ZN200.rdf'                                      => [ 'Motorola', 'ZN200', null, DeviceType::MOBILE ],
    'http://wap.nexustelco.com/uaprofile/MovistarD5.xml'                                                  => [ 'Movistar', 'Dual D5', 'Android', DeviceType::MOBILE ],
    'http://wap.nexustelco.com/uaprofile/GO1001.xml'                                                      => [ 'Movistar', 'Go Mobile 1001', 'Android', DeviceType::MOBILE ],
    'wap.nexustelco.com/uaprofile/GO984.xml'                                                              => [ 'Movistar', 'Go Mobile 504', 'Android', DeviceType::MOBILE ],
    'http://wap.nexustelco.com/uaprofile/GO775.xml'                                                       => [ 'Movistar', 'Go Mobile 775', 'Android', DeviceType::MOBILE ],
    'http://wap.nexustelco.com/uaprofile/GO778.xml'                                                       => [ 'Movistar', 'Go Mobile 778', 'Android', DeviceType::MOBILE ],
    'http://wap.nexustelco.com/uaprofile/GO950.xml'                                                       => [ 'Movistar', 'Go Mobile 950', 'Android', DeviceType::MOBILE ],
    'http://wap.nexustelco.com/wap/uaprofile/GO963.xml'                                                   => [ 'Movistar', 'Go Mobile 963', 'Android', DeviceType::MOBILE ],
    'http://wap.nexustelco.com/uaprofile/GO980.xml'                                                       => [ 'Movistar', 'Go Mobile 980', 'Android', DeviceType::MOBILE ],
    'http://wap.nexustelco.com/uaprofile/GO984.xml'                                                       => [ 'Movistar', 'Go Mobile 984', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Movistar-Link.xml'                                               => [ 'Movistar', 'Link', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Movistar-Motion.xml'                                             => [ 'Movistar', 'Motion', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Movistar-One.xml'                                                => [ 'Movistar', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/MTC_1055.xml'                                                    => [ 'MTC', '1055', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/MTC_1078.xml'                                                       => [ 'MTC', '1078', 'Android', DeviceType::TABLET ],
    'http://wap1.huawei.com/uaprof/MTC_752.xml'                                                           => [ 'MTC', '752', null, DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/MTC_916.xml'                                                     => [ 'MTC', '916', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650GPRS-MTS.xml'                                               => [ 'MTC', '955', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8650WCDMA-MTS.xml'                                              => [ 'MTC', '955', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/MTC_960.xml'                                                        => [ 'MTC', '960', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/MTC-962.xml'                                                        => [ 'MTC', '962', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/MTC-962_3G.xml'                                                     => [ 'MTC', '962', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/MTC_968.xml'                                                        => [ 'MTC', '968', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/MTC_970.xml'                                                        => [ 'MTC', '970', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/MTC_970H.xml'                                                       => [ 'MTC', '970H', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/MTC_972.xml'                                                        => [ 'MTC', '972', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/MTC_975.xml'                                                        => [ 'MTC', '975', 'Android', DeviceType::MOBILE ],
    'http://tpsolution.ru/uaprof/MTC980.xml'                                                              => [ 'MTC', '980', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/MTC_982T.xml'                                                       => [ 'MTC', '982', 'Android', DeviceType::MOBILE ],
    'http://tpsolution.ru/uaprof/MTC982O.xml'                                                             => [ 'MTC', '982O', 'Android', DeviceType::MOBILE ],
    'http://tpsolution.ru/uaprof/mtc982o442.xml'                                                          => [ 'MTC', '982O', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/MTC_SMART_Run_4G.xml'                                            => [ 'MTC', 'Smart Run', 'Android', DeviceType::MOBILE ],
    'http://tpsolution.ru/uaprof/SS.xml'                                                                  => [ 'MTC', 'Smart Sprint', 'Android', DeviceType::MOBILE ],
    'http://www.jeekomi.com/hw/MTC_SMART_Sprint_4G.xml'                                                   => [ 'MTC', 'Smart Sprint', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/SMART_Start.xml'                                                 => [ 'MTC', 'Smart Start', 'Android', DeviceType::MOBILE ],
    'http://staticfiles.technoserv.com/uap/MTS_Smart_Surf2_4G.xml'                                        => [ 'MTC', 'Smart Surf 2', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiU8160GPRS-MTS.xml'                                               => [ 'MTS', 'Mini', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/NATCOM_N8302GPRS-NORMAL.xml'                                           => [ 'NATCOM', 'N8302', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/NATCOM_N8302WCDMA-NORMAL.xml'                                          => [ 'Natcom', 'N8302', 'Android', DeviceType::MOBILE ],
    'http://www.nechdm.com/profiles/232/a232.rdf'                                                         => [ 'NEC', 'A232', null, DeviceType::MOBILE ],
    'http://www.nechdm.com/profiles/525/a525.rdf'                                                         => [ 'NEC', 'A525', null, DeviceType::MOBILE ],
    'http://nec-uap.com/prof/e121V01.xml'                                                                 => [ 'NEC', 'e121', null, DeviceType::MOBILE ],
    'http://nec-uap.com/prof/232V01.xml'                                                                  => [ 'NEC', 'e232', null, DeviceType::MOBILE ],
    'http://nec-uap.com/prof/e238V01.xml'                                                                 => [ 'NEC', 'e238', null, DeviceType::MOBILE ],
    'http://nec-uap.com/prof/e242V01.xml'                                                                 => [ 'NEC', 'e242', null, DeviceType::MOBILE ],
    'http://nec-uap.com/prof/e353V01.xml'                                                                 => [ 'NEC', 'e353', null, DeviceType::MOBILE ],
    'http://nec-uap.com/prof/530V01.xml'                                                                  => [ 'NEC', 'e530', null, DeviceType::MOBILE ],
    'http://nec-uap.com/prof/UAPMargay.xml'                                                               => [ 'NEC', 'N110', null, DeviceType::MOBILE ],
    'http://nechdm.com/profiles/535/a535.xml'                                                             => [ 'NEC', 'N535', null, DeviceType::MOBILE ],
    'http://nec-uap.com/prof/N6206V01.xml'                                                                => [ 'NEC', 'N6206', null, DeviceType::MOBILE ],
    'http://nec-uap.com/prof/N700V01.xml'                                                                 => [ 'NEC', 'N700', null, DeviceType::MOBILE ],
    'http://nec-uap.com/prof/N710V01.xml'                                                                 => [ 'NEC', 'N710', null, DeviceType::MOBILE ],
    'http://nec-uap.com/prof/N820V01.xml'                                                                 => [ 'NEC', 'N820', null, DeviceType::MOBILE ],
    'http://nec-uap.com/prof/N840HKV01.xml'                                                               => [ 'NEC', 'N840', null, DeviceType::MOBILE ],
    'http://nec-uap.com/prof/N900V01.xml'                                                                 => [ 'NEC', 'N900', null, DeviceType::MOBILE ],
    'http://nec-uap.com/prof/N908V01.xml'                                                                 => [ 'NEC', 'N908', null, DeviceType::MOBILE ],
    'http://www.ehaier.com/download/mobile/HaierN80Wv100WCDMA.xml'                                        => [ 'NEC', 'RPSPG3501', 'Android', DeviceType::MOBILE ],
    'http://www.n-keitai.com/uap/NE-201A1A_UAProf_v1.2.xml'                                               => [ 'NEC', 'Terrain', 'Android', DeviceType::MOBILE ],
    'http://vfwap.jn.neic.ne.jp/profile/V802N.xml'                                                        => [ 'NEC', 'V802N', null, DeviceType::MOBILE ],
    'http://www.nexian-apps.com/UAProf/NX-G869/G869UAProf.xml'                                            => [ 'Nexian', 'NX-G869 Cappuccino', 'MTK', DeviceType::MOBILE ],
    'http://www.nexian-apps.com/UAProf/NX-G965/G965UAProf.xml'                                            => [ 'Nexian', 'NX-G965 Champion', 'MTK', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmatlantis.xml'                                         => [ 'NGM', 'Atlantis', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmfun.xml'                                              => [ 'NGM', 'Dynamic Fun', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmjump.xml'                                             => [ 'NGM', 'Dynamic Jump', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmracing3.xml'                                          => [ 'NGM', 'Dynamic Jump', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmmilo.xml'                                             => [ 'NGM', 'Dynamic Milo', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmstar.xml'                                             => [ 'NGM', 'Dynamic Star', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmstylo.xml'                                            => [ 'NGM', 'Dynamic Stylo', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngm5_5.xml'                                              => [ 'NGM', 'Forward 5.5', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmendurance.xml'                                        => [ 'NGM', 'Forward Endurance', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmprime.xml'                                            => [ 'NGM', 'Forward Prime', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmruby.xml'                                             => [ 'NGM', 'Forward Ruby', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmproductname.xml'                                      => [ 'NGM', 'Forward Young', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmyoung.xml'                                            => [ 'NGM', 'Forward Young', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmlegend2.xml'                                          => [ 'NGM', 'Legend 2', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmmiracle.xml'                                          => [ 'NGM', 'Miracle', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmpolaris.xml'                                          => [ 'NGM', 'Polaris', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmjumpl.xml'                                            => [ 'NGM', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmspirit.xml'                                           => [ 'NGM', 'Spirit', 'Android', DeviceType::MOBILE ],
    'http://www.ngm-mobile.com/UserAgentProfiles/ngmwilco.xml'                                            => [ 'NGM', 'WeMove Wilco', 'Android', DeviceType::MOBILE ],
    'http://www.ddmbrands.com/uaprof/niu/tek4D2.xml'                                                      => [ 'NIU', 'Tek 4D2', 'Android', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia109r100.xml'                                                   => [ 'Nokia', '109', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia110r100.xml'                                                   => [ 'Nokia', '110', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia1100r100.xml'                                                  => [ 'Nokia', '1100', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N1101r100.xml'                                                           => [ 'Nokia', '1101', null, DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia111.1r100.xml'                                                 => [ 'Nokia', '111', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia111r100.xml'                                                   => [ 'Nokia', '111', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia112r100.xml'                                                   => [ 'Nokia', '112', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia1120r100.xml'                                                  => [ 'Nokia', '1120', null, DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia113r100.xml'                                                   => [ 'Nokia', '113', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia114r100.xml'                                                   => [ 'Nokia', '114', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N1680c-2r100.xml'                                                   => [ 'Nokia', '1680 classic', null, DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia2030r100.xml'                                                  => [ 'Nokia', '2030', null, DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia2052r100.xml'                                                  => [ 'Nokia', '2052', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia2055r100.xml'                                                  => [ 'Nokia', '2055', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia2060r100.xml'                                                  => [ 'Nokia', '2060', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia208.1r100.xml'                                                 => [ 'Nokia', '208', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia208.2r100.xml'                                                 => [ 'Nokia', '208', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia208.3r100.xml'                                                 => [ 'Nokia', '208', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia208.4r100.xml'                                                 => [ 'Nokia', '208', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia208r100.xml'                                                   => [ 'Nokia', '208', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia210.2r100.xml'                                                 => [ 'Nokia', '210', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia220r100.xml'                                                   => [ 'Nokia', '220', 'Series30', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia225r100.xml'                                                   => [ 'Nokia', '225', 'Series30', DeviceType::MOBILE ],
    'http://useragentprofile.microsoft.com/uaprof/Nokia230r100.xml'                                       => [ 'Nokia', '230', null, DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2322cr100.xml'                                                     => [ 'Nokia', '2322 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2600c-2r100.xml'                                                   => [ 'Nokia', '2600 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2600cr100.xml'                                                     => [ 'Nokia', '2600 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N2610r100.xml'                                                           => [ 'Nokia', '2610', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2610r100.xml'                                                      => [ 'Nokia', '2610', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N2626r100.xml'                                                           => [ 'Nokia', '2626', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2626r100.xml'                                                      => [ 'Nokia', '2626', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N2630r100.xml'                                                           => [ 'Nokia', '2630', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2630r100.xml'                                                      => [ 'Nokia', '2630', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N2650r100.xml'                                                           => [ 'Nokia', '2650', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N2650r200.xml'                                                           => [ 'Nokia', '2650', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N2650r300.xml'                                                           => [ 'Nokia', '2650', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N2660r100.xml'                                                           => [ 'Nokia', '2660', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2680s-2r100.xml'                                                   => [ 'Nokia', '2680 slide', null, DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2690r100.xml'                                                      => [ 'Nokia', '2690', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2692r100.xml'                                                      => [ 'Nokia', '2692', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2700c-2r100.xml'                                                   => [ 'Nokia', '2700 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2700cr100.xml'                                                     => [ 'Nokia', '2700 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2710c-2r100.xml'                                                   => [ 'Nokia', '2710', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2720ar100.xml'                                                     => [ 'Nokia', '2720 fold', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2730c-1br100.xml'                                                  => [ 'Nokia', '2730 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2730c-1r100.xml'                                                   => [ 'Nokia', '2730 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N2730cr100.xml'                                                     => [ 'Nokia', '2730 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N2760r100.xml'                                                           => [ 'Nokia', '2760', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/3000r100.xml'                                                       => [ 'Nokia', '3000', null, DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia301.1r100.xml'                                                 => [ 'Nokia', '301', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia301r100.xml'                                                   => [ 'Nokia', '301', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia3020r100.xml'                                                  => [ 'Nokia', '3020', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia3030r100.xml'                                                  => [ 'Nokia', '3030', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia3050r200.xml'                                                  => [ 'Nokia', '3050', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia307r100.xml'                                                   => [ 'Nokia', '307', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia3090r100.xml'                                                  => [ 'Nokia', '3090', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3100br100.xml'                                                          => [ 'Nokia', '3100', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3100r100.xml'                                                           => [ 'Nokia', '3100', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3105tlsr100.xml'                                                        => [ 'Nokia', '3105', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3108r100.xml'                                                           => [ 'Nokia', '3108', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3109cr100.xml'                                                          => [ 'Nokia', '3109 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N3109cr100.xml'                                                     => [ 'Nokia', '3109 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3110cr100.xml'                                                          => [ 'Nokia', '3110 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N3110cr100.xml'                                                     => [ 'Nokia', '3110 Evolve', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3120br100.xml'                                                          => [ 'Nokia', '3120', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3120r100.xml'                                                           => [ 'Nokia', '3120', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N3120cr100.xml'                                                     => [ 'Nokia', '3120 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3128r100.xml'                                                           => [ 'Nokia', '3128', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3129r100.xml'                                                           => [ 'Nokia', '3129', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3155x5Ar002.xml'                                                        => [ 'Nokia', '3155', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3155x5Cr002.xml'                                                        => [ 'Nokia', '3155', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3155x7Ar004.xml'                                                        => [ 'Nokia', '3155', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3155x7Cr004.xml'                                                        => [ 'Nokia', '3155', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3200r100.xml'                                                           => [ 'Nokia', '3200', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3200r200.xml'                                                           => [ 'Nokia', '3200', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3205tlsr100.xml'                                                        => [ 'Nokia', '3205', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N3208cr100.xml'                                                     => [ 'Nokia', '3208 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3220r100.xml'                                                           => [ 'Nokia', '3220', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3220r200.xml'                                                           => [ 'Nokia', '3220', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N3220r100.xml'                                                      => [ 'Nokia', '3220', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N3220r200.xml'                                                      => [ 'Nokia', '3220', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3230r100.xml'                                                           => [ 'Nokia', '3230', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N3230r100.xml'                                                      => [ 'Nokia', '3230', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3250r100.xml'                                                           => [ 'Nokia', '3250', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3250r200.xml'                                                           => [ 'Nokia', '3250', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N3250r100.xml'                                                      => [ 'Nokia', '3250', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3300r100.xml'                                                           => [ 'Nokia', '3300', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3300r200.xml'                                                           => [ 'Nokia', '3300', 'Series40', DeviceType::MOBILE ],
    'http://useragentprofile.hmdglobal.com/uaprof/Nokia3310r100.xml'                                      => [ 'Nokia', '3310 (2017)', null, DeviceType::MOBILE ],
    'http://useragentprofile.hmdglobal.com/uaprof/Nokia33103Gr100.xml'                                    => [ 'Nokia', '3310 3G', 'KaiOS', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3330r100.xml'                                                           => [ 'Nokia', '3330', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3350r100.xml'                                                           => [ 'Nokia', '3350', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3360r100.xml'                                                           => [ 'Nokia', '3360', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3410r100.xml'                                                           => [ 'Nokia', '3410', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3500cr100.xml'                                                          => [ 'Nokia', '3500 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N3500cr100.xml'                                                     => [ 'Nokia', '3500 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3510ir100.xml'                                                          => [ 'Nokia', '3510i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3510r100.xml'                                                           => [ 'Nokia', '3510i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3520r100.xml'                                                           => [ 'Nokia', '3520', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3520_N3560r100.xml'                                                     => [ 'Nokia', '3520', null, DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N3555cr100_3G.xml'                                                  => [ 'Nokia', '3555', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3555cr100.xml'                                                          => [ 'Nokia', '3555 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3555cr100_3G.xml'                                                       => [ 'Nokia', '3555 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3560r100.xml'                                                           => [ 'Nokia', '3560', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3590r100.xml'                                                           => [ 'Nokia', '3590', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3595r100.xml'                                                           => [ 'Nokia', '3595', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3600r100.xml'                                                           => [ 'Nokia', '3600', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N3600slider100.xml'                                                 => [ 'Nokia', '3600 slide', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3610r100.xml'                                                           => [ 'Nokia', '3610', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N3610ar100.xml'                                                     => [ 'Nokia', '3610 fold', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3620r100.xml'                                                           => [ 'Nokia', '3620', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3620r200.xml'                                                           => [ 'Nokia', '3620', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3650r100.xml'                                                           => [ 'Nokia', '3650', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3650r200.xml'                                                           => [ 'Nokia', '3650', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N3660r100.xml'                                                           => [ 'Nokia', '3660', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N3710foldr100.xml'                                                  => [ 'Nokia', '3710 fold', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N3720cr100.xml'                                                     => [ 'Nokia', '3720 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N500r100-VF2G.xml'                                                  => [ 'Nokia', '500', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N500r100-VF3G.xml'                                                  => [ 'Nokia', '500', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N500r100.xml'                                                       => [ 'Nokia', '500', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N500r200.xml'                                                       => [ 'Nokia', '500', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N500r210.xml'                                                       => [ 'Nokia', '500', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5000d-2r100.xml'                                                   => [ 'Nokia', '5000', null, DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5000r100.xml'                                                      => [ 'Nokia', '5000', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5070nmr100.xml'                                                         => [ 'Nokia', '5070', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5070r100.xml'                                                           => [ 'Nokia', '5070', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5070r100.xml'                                                      => [ 'Nokia', '5070b', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5100r100.xml'                                                           => [ 'Nokia', '5100', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5100r200.xml'                                                           => [ 'Nokia', '5100', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5130c-2r100.xml'                                                   => [ 'Nokia', '5130 XpressMusic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5130r100.xml'                                                      => [ 'Nokia', '5130 XpressMusic', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5140r100.xml'                                                           => [ 'Nokia', '5140', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5140ir100.xml'                                                          => [ 'Nokia', '5140i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5140ir200.xml'                                                          => [ 'Nokia', '5140i', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia515.2r100.xml'                                                 => [ 'Nokia', '515', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia515r100.xml'                                                   => [ 'Nokia', '515', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5200r100.xml'                                                           => [ 'Nokia', '5200', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5200ir200.xml'                                                     => [ 'Nokia', '5200', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5200r100.xml'                                                      => [ 'Nokia', '5200', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5210r100.xml'                                                           => [ 'Nokia', '5210', null, DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5220XpressMusicr100.xml'                                           => [ 'Nokia', '5220 XpressMusic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5228r100-2G.xml'                                              => [ 'Nokia', '5228', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5228r100-3G.xml'                                              => [ 'Nokia', '5228', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5233r100-2G.xml'                                              => [ 'Nokia', '5228', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5233r100-3G.xml'                                               => [ 'Nokia', '5228', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/n-5230-vf3g.xml'                                                    => [ 'Nokia', '5230', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5230-1br100-3G.xml'                                            => [ 'Nokia', '5230', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5230-1cr100-2G.xml'                                           => [ 'Nokia', '5230', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5230-1cr100-3G.xml'                                            => [ 'Nokia', '5230', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5230-1dr100-3G.xml'                                           => [ 'Nokia', '5230', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5230-cr100-2G.xml'                                            => [ 'Nokia', '5230', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5230-cr100-3G.xml'                                             => [ 'Nokia', '5230', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5230r100-2G.xml'                                              => [ 'Nokia', '5230', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5230r100-3G.xml'                                               => [ 'Nokia', '5230', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5230r100-VF2G.xml'                                             => [ 'Nokia', '5230', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5230r100-VF3G.xml'                                             => [ 'Nokia', '5230', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5235-1br100-3G.xml'                                           => [ 'Nokia', '5235 Ovi Music Unlimited', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5235-1dr100-3G.xml'                                           => [ 'Nokia', '5235 Ovi Music Unlimited', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5235r100-2G.xml'                                              => [ 'Nokia', '5235 Ovi Music Unlimited', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5235r100-3G.xml'                                              => [ 'Nokia', '5235 Ovi Music Unlimited', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5236r100-2G.xml'                                              => [ 'Nokia', '5236', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5238r100-3G.xml'                                              => [ 'Nokia', '5238', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5250r100.xml'                                                  => [ 'Nokia', '5250', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5300r100.xml'                                                           => [ 'Nokia', '5300 XpressMusic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5300r100.xml'                                                      => [ 'Nokia', '5300 XpressMusic', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5310r100.xml'                                                           => [ 'Nokia', '5310 XpressMusic', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5310XpressMusicr100.xml'                                                => [ 'Nokia', '5310 XpressMusic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5310r100.xml'                                                      => [ 'Nokia', '5310 XpressMusic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5310XpressMusicr100.xml'                                           => [ 'Nokia', '5310 XpressMusic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5310XpressMusicVFr100.xml'                                         => [ 'Nokia', '5310 XpressMusic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5320c-1r100-3G.xml'                                                => [ 'Nokia', '5320 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5320d-1br100.xml'                                                  => [ 'Nokia', '5320 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5320d-1r100-2G.xml'                                                => [ 'Nokia', '5320 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5320d-1r100-3G.xml'                                                => [ 'Nokia', '5320 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5320r100-2G.xml'                                                   => [ 'Nokia', '5320 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5330-1dr100.xml'                                                   => [ 'Nokia', '5330 Mobile TV Edition', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5500dr100.xml'                                                          => [ 'Nokia', '5500 Sport', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5510r100.xml'                                                           => [ 'Nokia', '5510', null, DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5530c-2r100-2G.xml'                                            => [ 'Nokia', '5530 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5530r100.xml'                                                  => [ 'Nokia', '5530 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5610r100.xml'                                                      => [ 'Nokia', '5610 XpressMusic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5630d-1r100-2G.xml'                                            => [ 'Nokia', '5630 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5630d-1r100-3G.xml'                                            => [ 'Nokia', '5630 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5700r100-2G.xml'                                                        => [ 'Nokia', '5700 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5700r100-3G.xml'                                                        => [ 'Nokia', '5700 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N5700r100.xml'                                                           => [ 'Nokia', '5700 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5700r100-2G.xml'                                                   => [ 'Nokia', '5700 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5700r100-3G.xml'                                                   => [ 'Nokia', '5700 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5700r100.xml'                                                      => [ 'Nokia', '5700 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5730s-1r100.xml'                                                   => [ 'Nokia', '5730 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N5800XpressMusicr100-2G.xml'                                        => [ 'Nokia', '5800 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5800d-1r100-2G.xml'                                           => [ 'Nokia', '5800 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5800d-1r100-3G.xml'                                            => [ 'Nokia', '5800 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5800d-1r100.xml'                                               => [ 'Nokia', '5800 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5800i-1r100-2G.xml'                                           => [ 'Nokia', '5800 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5800i-1r100-3G.xml'                                            => [ 'Nokia', '5800 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5800r100-2G.xml'                                              => [ 'Nokia', '5800 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5800w-1r100-2G.xml'                                            => [ 'Nokia', '5800 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia5800w-1r100-3G.xml'                                            => [ 'Nokia', '5800 XpressMusic', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6020r100.xml'                                                           => [ 'Nokia', '6020', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6020r200.xml'                                                           => [ 'Nokia', '6020', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6020r200.xml'                                                      => [ 'Nokia', '6020', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6021r100.xml'                                                           => [ 'Nokia', '6021', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N603r100.xml'                                                       => [ 'Nokia', '603', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N603r200-3G.xml'                                                    => [ 'Nokia', '603', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N603r200.xml'                                                       => [ 'Nokia', '603', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N603r300.xml'                                                       => [ 'Nokia', '603', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6030r100.xml'                                                           => [ 'Nokia', '6030', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6030br100.xml'                                                     => [ 'Nokia', '6030', null, DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6030r100.xml'                                                      => [ 'Nokia', '6030', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6030br100.xml'                                                          => [ 'Nokia', '6030b', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6060r100.xml'                                                           => [ 'Nokia', '6060', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6060vr100.xml'                                                          => [ 'Nokia', '6060v', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6061r100.xml'                                                           => [ 'Nokia', '6061', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6070r100.xml'                                                           => [ 'Nokia', '6070', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6070r100.xml'                                                      => [ 'Nokia', '6070', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6080r100.xml'                                                           => [ 'Nokia', '6080', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6085r100.xml'                                                           => [ 'Nokia', '6085', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6085r100.xml'                                                      => [ 'Nokia', '6085', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6086r100.xml'                                                           => [ 'Nokia', '6086', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6086r100.xml'                                                      => [ 'Nokia', '6086', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6100r100.xml'                                                           => [ 'Nokia', '6100', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6101r100.xml'                                                           => [ 'Nokia', '6101', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6101r100.xml'                                                      => [ 'Nokia', '6101', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6102r100.xml'                                                           => [ 'Nokia', '6102', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6102ir100.xml'                                                          => [ 'Nokia', '6102i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6103r100.xml'                                                           => [ 'Nokia', '6103', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6108r100.xml'                                                           => [ 'Nokia', '6108', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6110r100.xml'                                                           => [ 'Nokia', '6110', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6110cr100.xml'                                                          => [ 'Nokia', '6110 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6110Navigatorr100-2G.xml'                                               => [ 'Nokia', '6110 Navigator', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6110Navigatorr100-3G.xml'                                               => [ 'Nokia', '6110 Navigator', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6110Navigatorr100.xml'                                                  => [ 'Nokia', '6110 Navigator', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6110Navigatorr100-2G.xml'                                          => [ 'Nokia', '6110 Navigator', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6110Navigatorr100-3G.xml'                                          => [ 'Nokia', '6110 Navigator', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6111r100.xml'                                                           => [ 'Nokia', '6111', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6111r200.xml'                                                           => [ 'Nokia', '6111', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6111r201.xml'                                                           => [ 'Nokia', '6111', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6111r300.xml'                                                           => [ 'Nokia', '6111', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6111r301.xml'                                                           => [ 'Nokia', '6111', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6111r200.xml'                                                      => [ 'Nokia', '6111', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6120c-1r100-2G.xml'                                                     => [ 'Nokia', '6120 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6120c-1r100-3G.xml'                                                     => [ 'Nokia', '6120 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6120c-1r100-CV2G.xml'                                                   => [ 'Nokia', '6120 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6120c-1r100-CV3G.xml'                                                   => [ 'Nokia', '6120 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6120cr100.xml'                                                          => [ 'Nokia', '6120 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6120c-1r100-2G.xml'                                                => [ 'Nokia', '6120 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6120c-1r100-3G.xml'                                                => [ 'Nokia', '6120 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6120c-1r100-CV2G.xml'                                              => [ 'Nokia', '6120 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6120cr100.xml'                                                     => [ 'Nokia', '6120 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6122cr100.xml'                                                     => [ 'Nokia', '6122 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6124cr100-2G.xml'                                                  => [ 'Nokia', '6124 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6124cr100-3G.xml'                                                  => [ 'Nokia', '6124 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6125r100.xml'                                                           => [ 'Nokia', '6125', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6126r100.xml'                                                           => [ 'Nokia', '6126', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6126r101.xml'                                                           => [ 'Nokia', '6126', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6131r100.xml'                                                           => [ 'Nokia', '6131', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6131r101.xml'                                                           => [ 'Nokia', '6131', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6131r100.xml'                                                      => [ 'Nokia', '6131', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6133r100.xml'                                                           => [ 'Nokia', '6133', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6133r101.xml'                                                           => [ 'Nokia', '6133', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6136r100.xml'                                                           => [ 'Nokia', '6136', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r100.xml'                                                           => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r100_3G.xml'                                                        => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r101.xml'                                                           => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r101_3G.xml'                                                        => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r200.xml'                                                           => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r200_3G.xml'                                                        => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r201.xml'                                                           => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r201_3G.xml'                                                        => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r300.xml'                                                           => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r300_3G.xml'                                                        => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r301.xml'                                                           => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r301_3G.xml'                                                        => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r400.xml'                                                           => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r400_3G.xml'                                                        => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r401.xml'                                                           => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6151r401_3G.xml'                                                        => [ 'Nokia', '6151', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6170r100.xml'                                                           => [ 'Nokia', '6170', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6200r100.xml'                                                           => [ 'Nokia', '6200', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6210r100.xml'                                                           => [ 'Nokia', '6210 Navigator', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6210s-1r100-2G.xml'                                                => [ 'Nokia', '6210 Navigator', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6210s-1r100-3G.xml'                                                => [ 'Nokia', '6210 Navigator', 'Series60', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/nokia/nokia6215i/nokia6215i.xml'                                             => [ 'Nokia', '6215i', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6220r100.xml'                                                           => [ 'Nokia', '6220 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6220r200.xml'                                                           => [ 'Nokia', '6220 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6220r300.xml'                                                           => [ 'Nokia', '6220 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6220c-1r100-2G.xml'                                                => [ 'Nokia', '6220 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6220c-1r100-3G.xml'                                                => [ 'Nokia', '6220 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6225tlsr100.xml'                                                        => [ 'Nokia', '6225', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6230r100.xml'                                                           => [ 'Nokia', '6230', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6230r200.xml'                                                           => [ 'Nokia', '6230', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6230r300.xml'                                                           => [ 'Nokia', '6230', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6230r400.xml'                                                           => [ 'Nokia', '6230', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6230ir100.xml'                                                          => [ 'Nokia', '6230i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6230ir200.xml'                                                          => [ 'Nokia', '6230i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6230ir201.xml'                                                          => [ 'Nokia', '6230i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6230ir300.xml'                                                          => [ 'Nokia', '6230i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6230ir301.xml'                                                          => [ 'Nokia', '6230i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6230ir400.xml'                                                          => [ 'Nokia', '6230i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6230ir401.xml'                                                          => [ 'Nokia', '6230i', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6230ir401.xml'                                                     => [ 'Nokia', '6230i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r100.xml'                                                           => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r100_3G.xml'                                                        => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r101.xml'                                                           => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r101_3G.xml'                                                        => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r200.xml'                                                           => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r200_3G.xml'                                                        => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r201.xml'                                                           => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r201_3G.xml'                                                        => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r300.xml'                                                           => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r300_3G.xml'                                                        => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r301.xml'                                                           => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r301_3G.xml'                                                        => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r400.xml'                                                           => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r400_3G.xml'                                                        => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r401.xml'                                                           => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r401_3G.xml'                                                        => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r500.xml'                                                           => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r500_3G.xml'                                                        => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r501.xml'                                                           => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6233r501_3G.xml'                                                        => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6233r200.xml'                                                      => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6233r400.xml'                                                      => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6233r500.xml'                                                      => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6233r500_3G.xml'                                                   => [ 'Nokia', '6233', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r100.xml'                                                           => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r100_3G.xml'                                                        => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r101.xml'                                                           => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r101_3G.xml'                                                        => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r200.xml'                                                           => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r200_3G.xml'                                                        => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r201.xml'                                                           => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r201_3G.xml'                                                        => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r300.xml'                                                           => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r300_3G.xml'                                                        => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r301.xml'                                                           => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r301_3G.xml'                                                        => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r400.xml'                                                           => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r400_3G.xml'                                                        => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r401.xml'                                                           => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r401_3G.xml'                                                        => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r500.xml'                                                           => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r500_3G.xml'                                                        => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r501.xml'                                                           => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6234r501_3G.xml'                                                        => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6234r500.xml'                                                      => [ 'Nokia', '6234', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6235x4Ar001.xml'                                                        => [ 'Nokia', '6235i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6250r100.xml'                                                           => [ 'Nokia', '6250', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6255x3Ar001.xml'                                                        => [ 'Nokia', '6255i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6260r100.xml'                                                           => [ 'Nokia', '6260', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6260s-1r100.xml'                                                   => [ 'Nokia', '6260 slide', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6263r100.xml'                                                           => [ 'Nokia', '6263', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6263r100_3G.xml'                                                        => [ 'Nokia', '6263', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6263r101.xml'                                                           => [ 'Nokia', '6263', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6263r101_3G.xml'                                                        => [ 'Nokia', '6263', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6267r100.xml'                                                           => [ 'Nokia', '6267', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6267r100_3G.xml'                                                        => [ 'Nokia', '6267', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6267r101.xml'                                                           => [ 'Nokia', '6267', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6267r101_3G.xml'                                                        => [ 'Nokia', '6267', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6270r100.xml'                                                           => [ 'Nokia', '6270', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r100.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r1000.xml'                                                          => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r1000_3G.xml'                                                       => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r1001.xml'                                                          => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r1001_3G.xml'                                                       => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r1100.xml'                                                          => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r1100_3G.xml'                                                       => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r1101.xml'                                                          => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r1101_3G.xml'                                                       => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r200.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r201.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r300.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r301.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r400.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r400_3G.xml'                                                        => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r401.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r401_3G.xml'                                                        => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r500.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r500_3G.xml'                                                        => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r501.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r501_3G.xml'                                                        => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r600.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r600_3G.xml'                                                        => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r601.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r601_3G.xml'                                                        => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r700.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r700_3G.xml'                                                        => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r701.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r701_3G.xml'                                                        => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r800.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r800_3G.xml'                                                        => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r801.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r801_3G.xml'                                                        => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r900.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r900_3G.xml'                                                        => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r901.xml'                                                           => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6280r901_3G.xml'                                                        => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6280r1100.xml'                                                     => [ 'Nokia', '6280', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6282r100.xml'                                                           => [ 'Nokia', '6282', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6282r100_3G.xml'                                                        => [ 'Nokia', '6282', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6282r200.xml'                                                           => [ 'Nokia', '6282', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6282r200_3G.xml'                                                        => [ 'Nokia', '6282', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6282r300.xml'                                                           => [ 'Nokia', '6282', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6282r300_3G.xml'                                                        => [ 'Nokia', '6282', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6288r100.xml'                                                           => [ 'Nokia', '6288', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6288r100_3G.xml'                                                        => [ 'Nokia', '6288', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6288r101.xml'                                                           => [ 'Nokia', '6288', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6288r101_3G.xml'                                                        => [ 'Nokia', '6288', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6288r200.xml'                                                           => [ 'Nokia', '6288', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6288r200_3G.xml'                                                        => [ 'Nokia', '6288', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6288r201.xml'                                                           => [ 'Nokia', '6288', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6288r201_3G.xml'                                                        => [ 'Nokia', '6288', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6288r300.xml'                                                           => [ 'Nokia', '6288', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6288r300_3G.xml'                                                        => [ 'Nokia', '6288', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6288r301.xml'                                                           => [ 'Nokia', '6288', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6288r301_3G.xml'                                                        => [ 'Nokia', '6288', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6288r300.xml'                                                      => [ 'Nokia', '6288', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6290r100-2G.xml'                                                        => [ 'Nokia', '6290', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6290r100-3G.xml'                                                        => [ 'Nokia', '6290', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6290r100.xml'                                                           => [ 'Nokia', '6290', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NokiaMMS13r100.xml'                                                      => [ 'Nokia', '6290', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6300r100.xml'                                                           => [ 'Nokia', '6300', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6300r100.xml'                                                      => [ 'Nokia', '6300', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6300ir100.xml'                                                     => [ 'Nokia', '6300i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6301r100.xml'                                                           => [ 'Nokia', '6301', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6301r100.xml'                                                      => [ 'Nokia', '6301', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6303classicr100.xml'                                               => [ 'Nokia', '6303 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6303cr100.xml'                                                     => [ 'Nokia', '6303 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6303cir100.xml'                                                    => [ 'Nokia', '6303i classic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6303iclassicr100.xml'                                              => [ 'Nokia', '6303i classic', 'Series40', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/nokia/6305/6305v1.xml'                                                       => [ 'Nokia', '6305i', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6310r100.xml'                                                           => [ 'Nokia', '6310', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/nokia/nokia6315i/nokia6315i.xml'                                             => [ 'Nokia', '6315i', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6340r100.xml'                                                           => [ 'Nokia', '6340', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6500cr100.xml'                                                          => [ 'Nokia', '6500 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6500cr101.xml'                                                          => [ 'Nokia', '6500 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6500cVFr100.xml'                                                        => [ 'Nokia', '6500 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6500cVFr100_3G.xml'                                                     => [ 'Nokia', '6500 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6500sr100.xml'                                                          => [ 'Nokia', '6500 slide', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6500sr101.xml'                                                          => [ 'Nokia', '6500 slide', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6500sVFr100.xml'                                                        => [ 'Nokia', '6500 slide', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6500sVFr100_3G.xml'                                                     => [ 'Nokia', '6500 slide', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6500s2Gr100.xml'                                                   => [ 'Nokia', '6500 slide', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6500sr100.xml'                                                     => [ 'Nokia', '6500 slide', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6500cr100.xml'                                                     => [ 'Nokia', '6500c', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6510R100.xml'                                                           => [ 'Nokia', '6510', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6555r100.xml'                                                           => [ 'Nokia', '6555', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6555r100_3G.xml'                                                        => [ 'Nokia', '6555', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6555r100_3G.xml'                                                   => [ 'Nokia', '6555', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6555br100.xml'                                                          => [ 'Nokia', '6555b', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6555br100_3G.xml'                                                       => [ 'Nokia', '6555b', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6555cr100.xml'                                                          => [ 'Nokia', '6555c', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6555cr100_3G.xml'                                                       => [ 'Nokia', '6555c', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6560R100.xml'                                                           => [ 'Nokia', '6560', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6590R100.xml'                                                           => [ 'Nokia', '6590', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6590r200.xml'                                                           => [ 'Nokia', '6590', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6600r100.xml'                                                           => [ 'Nokia', '6600', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6600r100.xml'                                                      => [ 'Nokia', '6600', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6600fr100.xml'                                                     => [ 'Nokia', '6600 fold', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6600sr100.xml'                                                     => [ 'Nokia', '6600 slide', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6600ir100.xml'                                                     => [ 'Nokia', '6600i slide', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6610r100.xml'                                                           => [ 'Nokia', '6610', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6610r200.xml'                                                           => [ 'Nokia', '6610', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6610ir100.xml'                                                          => [ 'Nokia', '6610i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6620r100.xml'                                                           => [ 'Nokia', '6620', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6620r200.xml'                                                           => [ 'Nokia', '6620', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6620r200.xml'                                                      => [ 'Nokia', '6620', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6630r100-VF2G.xml'                                                      => [ 'Nokia', '6630', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6630r100-VF3G.xml'                                                      => [ 'Nokia', '6630', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6630r100-VFKK2G.xml'                                                    => [ 'Nokia', '6630', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6630r100-VFKK3G.xml'                                                    => [ 'Nokia', '6630', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6630r100.xml'                                                           => [ 'Nokia', '6630', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6650r100.xml'                                                           => [ 'Nokia', '6650', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6650r200.xml'                                                           => [ 'Nokia', '6650', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6650r300.xml'                                                           => [ 'Nokia', '6650', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6651r100.xml'                                                           => [ 'Nokia', '6651', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6670r100.xml'                                                           => [ 'Nokia', '6670', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6680r100-VF2G.xml'                                                      => [ 'Nokia', '6680', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6680r100-VF3G.xml'                                                      => [ 'Nokia', '6680', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6680r100-VFKK2G.xml'                                                    => [ 'Nokia', '6680', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6680r100-VFKK3G.xml'                                                    => [ 'Nokia', '6680', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6680r100.xml'                                                           => [ 'Nokia', '6680', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6681r100.xml'                                                           => [ 'Nokia', '6681', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6681r100.xml'                                                      => [ 'Nokia', '6681', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6682r100.xml'                                                           => [ 'Nokia', '6682', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6682r200.xml'                                                           => [ 'Nokia', '6682', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6700c-1r100.xml'                                                   => [ 'Nokia', '6700 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6700cr100.xml'                                                     => [ 'Nokia', '6700 classic', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6700s-1cr100.xml'                                                  => [ 'Nokia', '6700 slide', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6700sr100-VF3G.xml'                                                => [ 'Nokia', '6700 slide', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6700sr100.xml'                                                     => [ 'Nokia', '6700 slide', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6708r100.xml'                                                           => [ 'Nokia', '6708', 'UIQ', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia6710sr100-2G.xml'                                              => [ 'Nokia', '6710 Navigator', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia6710sr100-3G.xml'                                              => [ 'Nokia', '6710 Navigator', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia6720c-1br100.xml'                                              => [ 'Nokia', '6720 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia6720cr100.xml'                                                 => [ 'Nokia', '6720 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6730cr100.xml'                                                     => [ 'Nokia', '6730 classic', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6760s-1r100-2G.xml'                                                => [ 'Nokia', '6760 slide', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N6760s-1r100-3G.xml'                                                => [ 'Nokia', '6760 slide', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6800r100.xml'                                                           => [ 'Nokia', '6800', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6800r200.xml'                                                           => [ 'Nokia', '6800', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6810r100.xml'                                                           => [ 'Nokia', '6810', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6820r100.xml'                                                           => [ 'Nokia', '6820', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N6822r100.xml'                                                           => [ 'Nokia', '6822', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N700r100-VF2G.xml'                                                  => [ 'Nokia', '700', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N700r100-VF3G.xml'                                                  => [ 'Nokia', '700', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N700r100.xml'                                                       => [ 'Nokia', '700', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N700r200.xml'                                                       => [ 'Nokia', '700', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N700r300.xml'                                                       => [ 'Nokia', '700', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N701r100.xml'                                                       => [ 'Nokia', '701', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N701r200.xml'                                                       => [ 'Nokia', '701', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N701r300.xml'                                                       => [ 'Nokia', '701', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N701r310-3G.xml'                                                    => [ 'Nokia', '701', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N7020r100.xml'                                                      => [ 'Nokia', '7020', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N702Tr100.xml'                                                      => [ 'Nokia', '702T', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N7070d-2r100.xml'                                                   => [ 'Nokia', '7070 Prism', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7110r100.xml'                                                           => [ 'Nokia', '7110', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7160r100.xml'                                                           => [ 'Nokia', '7160', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7190r100.xml'                                                           => [ 'Nokia', '7190', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7200r100.xml'                                                           => [ 'Nokia', '7200', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7210r100.xml'                                                           => [ 'Nokia', '7210 Supernova', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7210r200.xml'                                                           => [ 'Nokia', '7210 Supernova', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N7210Supernovar100.xml'                                             => [ 'Nokia', '7210 Supernova', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N7230-1cr100.xml'                                                   => [ 'Nokia', '7230', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N7230r100.xml'                                                      => [ 'Nokia', '7230', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7250r100.xml'                                                           => [ 'Nokia', '7250', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7250ir100.xml'                                                          => [ 'Nokia', '7250i', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7260r100.xml'                                                           => [ 'Nokia', '7260', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7260r200.xml'                                                           => [ 'Nokia', '7260', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7262r100.xml'                                                           => [ 'Nokia', '7262', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7270r100.xml'                                                           => [ 'Nokia', '7270', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7270r300.xml'                                                           => [ 'Nokia', '7270', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7280r100.xml'                                                           => [ 'Nokia', '7280', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7280r200.xml'                                                           => [ 'Nokia', '7280', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7280r300.xml'                                                           => [ 'Nokia', '7280', null, DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N7310r100.xml'                                                      => [ 'Nokia', '7310', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N7310cr100.xml'                                                     => [ 'Nokia', '7310 Supernova', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7360r100.xml'                                                           => [ 'Nokia', '7360', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7370r100.xml'                                                           => [ 'Nokia', '7370', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7373r100.xml'                                                           => [ 'Nokia', '7373', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7380r100.xml'                                                           => [ 'Nokia', '7380', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7380r101.xml'                                                           => [ 'Nokia', '7380', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7390r100.xml'                                                           => [ 'Nokia', '7390', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7390r100_3G.xml'                                                        => [ 'Nokia', '7390', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7390r101.xml'                                                           => [ 'Nokia', '7390', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7390r101_3G.xml'                                                        => [ 'Nokia', '7390', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7390r200.xml'                                                           => [ 'Nokia', '7390', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7390r200_3G.xml'                                                        => [ 'Nokia', '7390', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7390r201.xml'                                                           => [ 'Nokia', '7390', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7390r201_3G.xml'                                                        => [ 'Nokia', '7390', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7390r300.xml'                                                           => [ 'Nokia', '7390', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7390r300_3G.xml'                                                        => [ 'Nokia', '7390', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7390r301.xml'                                                           => [ 'Nokia', '7390', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7390r301_3G.xml'                                                        => [ 'Nokia', '7390', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7500r100.xml'                                                           => [ 'Nokia', '7500 Prism', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N7500r100.xml'                                                      => [ 'Nokia', '7500 Prism', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N7510ar100.xml'                                                     => [ 'Nokia', '7510', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N7510Supernovar100.xml'                                             => [ 'Nokia', '7510 Supernova', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7600r100.xml'                                                           => [ 'Nokia', '7600', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7600r200.xml'                                                           => [ 'Nokia', '7600', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N7610r100.xml'                                                      => [ 'Nokia', '7610', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7610r100.xml'                                                           => [ 'Nokia', '7610 Supernova', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N7610Supernovar100.xml'                                             => [ 'Nokia', '7610 Supernova', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7650r100.xml'                                                           => [ 'Nokia', '7650', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7650r200.xml'                                                           => [ 'Nokia', '7650', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N7710r100.xml'                                                           => [ 'Nokia', '7710', 'Series90', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N7900r100.xml'                                                      => [ 'Nokia', '7900 Prism', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N801Tr100.xml'                                                      => [ 'Nokia', '801T', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N808PureViewr100.xml'                                               => [ 'Nokia', '808 PureView', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N808PureViewr200.xml'                                               => [ 'Nokia', '808 PureView', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N808r100.xml'                                                       => [ 'Nokia', '808 PureView', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N808r200.xml'                                                       => [ 'Nokia', '808 PureView', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8310r100.xml'                                                           => [ 'Nokia', '8310', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8600dr100.xml'                                                          => [ 'Nokia', '8600 Luna', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8800r100.xml'                                                           => [ 'Nokia', '8800', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8800r101.xml'                                                           => [ 'Nokia', '8800', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8800r200.xml'                                                           => [ 'Nokia', '8800', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8800r201.xml'                                                           => [ 'Nokia', '8800', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8800r300.xml'                                                           => [ 'Nokia', '8800', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8800r301.xml'                                                           => [ 'Nokia', '8800', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8800SIr100.xml'                                                         => [ 'Nokia', '8800 Sirocco', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8800SIr101.xml'                                                         => [ 'Nokia', '8800 Sirocco', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8800SIr200.xml'                                                         => [ 'Nokia', '8800 Sirocco', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8800SIr201.xml'                                                         => [ 'Nokia', '8800 Sirocco', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8801r100.xml'                                                           => [ 'Nokia', '8801', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8801r101.xml'                                                           => [ 'Nokia', '8801', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8801r200.xml'                                                           => [ 'Nokia', '8801', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8801r201.xml'                                                           => [ 'Nokia', '8801', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8801r300.xml'                                                           => [ 'Nokia', '8801', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8801r301.xml'                                                           => [ 'Nokia', '8801', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8801r400.xml'                                                           => [ 'Nokia', '8801', 'Series40', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8801r401.xml'                                                           => [ 'Nokia', '8801', 'Series40', DeviceType::MOBILE ],
    'http://useragentprofile.hmdglobal.com/uaprof/Nokia88104Gr100.xml'                                    => [ 'Nokia', '8810 4G', 'KaiOS', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8910r100.xml'                                                           => [ 'Nokia', '8910', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N8910ir100.xml'                                                          => [ 'Nokia', '8910i', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N9110r100.xml'                                                           => [ 'Nokia', '9110 Communicator', 'GOES', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N9210r100.xml'                                                           => [ 'Nokia', '9210 Communicator', 'Series80', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N9300r100.xml'                                                           => [ 'Nokia', '9300', 'Series80', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N9300r100.xml'                                                      => [ 'Nokia', '9300', 'Series80', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N9300ir100.xml'                                                          => [ 'Nokia', '9300i', 'Series80', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N93kir100.xml'                                                           => [ 'Nokia', '9300i', 'Series80', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N9300ir100.xml'                                                     => [ 'Nokia', '9300i', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/N9500r100.xml'                                                           => [ 'Nokia', '9500 Communicator', 'Series90', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia200r100.xml'                                                   => [ 'Nokia', 'Asha 200', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia201r100.xml'                                                   => [ 'Nokia', 'Asha 201', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/202r100.xml'                                                        => [ 'Nokia', 'Asha 202', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/203r100.xml'                                                        => [ 'Nokia', 'Asha 203', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia205.1r100.xml'                                                 => [ 'Nokia', 'Asha 205', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia205.3r100.xml'                                                 => [ 'Nokia', 'Asha 205', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia205r100.xml'                                                   => [ 'Nokia', 'Asha 205', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia206.1r100.xml'                                                 => [ 'Nokia', 'Asha 206', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia206r100.xml'                                                   => [ 'Nokia', 'Asha 206', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia210.3r100.xml'                                                 => [ 'Nokia', 'Asha 210', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia210.4r100.xml'                                                 => [ 'Nokia', 'Asha 210', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia210.5r100.xml'                                                 => [ 'Nokia', 'Asha 210', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia210r100.xml'                                                   => [ 'Nokia', 'Asha 210', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaAsha230DSr100.xml'                                             => [ 'Nokia', 'Asha 230', 'Nokia Asha Platform', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaAsha230SSr100.xml'                                             => [ 'Nokia', 'Asha 230', 'Nokia Asha Platform', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/300r100.xml'                                                        => [ 'Nokia', 'Asha 300', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia302r100.xml'                                                   => [ 'Nokia', 'Asha 302', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia303r100.xml'                                                   => [ 'Nokia', 'Asha 303', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/305r100.xml'                                                        => [ 'Nokia', 'Asha 305', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/305r200.xml'                                                        => [ 'Nokia', 'Asha 305', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/306r100.xml'                                                        => [ 'Nokia', 'Asha 306', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/308r100.xml'                                                        => [ 'Nokia', 'Asha 308', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/309r100.xml'                                                        => [ 'Nokia', 'Asha 309', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia310r100.xml'                                                   => [ 'Nokia', 'Asha 310', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/311r100.xml'                                                        => [ 'Nokia', 'Asha 311', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaAsha500DSr100.xml'                                             => [ 'Nokia', 'Asha 500', 'Nokia Asha Platform', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia501.1r100.xml'                                                 => [ 'Nokia', 'Asha 501', 'Nokia Asha Platform', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia501.2r100.xml'                                                 => [ 'Nokia', 'Asha 501', 'Nokia Asha Platform', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia501r100.xml'                                                   => [ 'Nokia', 'Asha 501', 'Nokia Asha Platform', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia501sr100.xml'                                                  => [ 'Nokia', 'Asha 501', 'Nokia Asha Platform', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia502r100.xml'                                                   => [ 'Nokia', 'Asha 502', 'Nokia Asha Platform', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia503r100.xml'                                                   => [ 'Nokia', 'Asha 503', 'Nokia Asha Platform', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/Nokia503sr100.xml'                                                  => [ 'Nokia', 'Asha 503', 'Nokia Asha Platform', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC1-01.1r100.xml'                                               => [ 'Nokia', 'C1-01', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC1-01r100.xml'                                                 => [ 'Nokia', 'C1-01', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC1-02ir100.xml'                                                => [ 'Nokia', 'C1-02', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC1-02r100.xml'                                                 => [ 'Nokia', 'C1-02', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC1-03r100.xml'                                                 => [ 'Nokia', 'C1-03', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC2-00r100.xml'                                                 => [ 'Nokia', 'C2-00', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC2-01r100.xml'                                                     => [ 'Nokia', 'C2-01', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC2-02.1r100.xml'                                               => [ 'Nokia', 'C2-02', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC2-02r100.xml'                                                 => [ 'Nokia', 'C2-02', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC2-03r100.xml'                                                 => [ 'Nokia', 'C2-03', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC2-05.1r100.xml'                                               => [ 'Nokia', 'C2-05', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC2-05r100.xml'                                                 => [ 'Nokia', 'C2-05', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC2-06r100.xml'                                                 => [ 'Nokia', 'C2-06', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC3-00.1r100.xml'                                               => [ 'Nokia', 'C3-00', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC3-00r100.xml'                                                 => [ 'Nokia', 'C3-00', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC3-01.5r100.xml'                                                   => [ 'Nokia', 'C3-01', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC3-01r100.xml'                                                     => [ 'Nokia', 'C3-01', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC5-00.2r100.xml'                                                   => [ 'Nokia', 'C5-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC5-00r100.xml'                                                     => [ 'Nokia', 'C5-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC5-03r100-3G.xml'                                             => [ 'Nokia', 'C5-03', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC5-03r100-VF2G.xml'                                            => [ 'Nokia', 'C5-03', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC5-03r100-VF3G.xml'                                            => [ 'Nokia', 'C5-03', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC5-03r200-3G.xml'                                              => [ 'Nokia', 'C5-03', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC5-05r100-2G.xml'                                             => [ 'Nokia', 'C5-05', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC5-06r100-2G.xml'                                             => [ 'Nokia', 'C5-06', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC6-00.1r100.xml'                                               => [ 'Nokia', 'C6-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC6-00r100-VF2G.xml'                                            => [ 'Nokia', 'C6-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC6-00r100-VF3G.xml'                                            => [ 'Nokia', 'C6-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaC6-00r100.xml'                                                 => [ 'Nokia', 'C6-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC6-01.3r100.xml'                                                   => [ 'Nokia', 'C6-01', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC6-01.3r200.xml'                                                   => [ 'Nokia', 'C6-01', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC6-01.3r300.xml'                                                   => [ 'Nokia', 'C6-01', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC6-01r100.xml'                                                     => [ 'Nokia', 'C6-01', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC6-01r200.xml'                                                     => [ 'Nokia', 'C6-01', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC6-01r300.xml'                                                     => [ 'Nokia', 'C6-01', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC6-01r310.xml'                                                     => [ 'Nokia', 'C6-01', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC7-00.1r100.xml'                                                   => [ 'Nokia', 'C7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC7-00r100-VF2G.xml'                                                => [ 'Nokia', 'C7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC7-00r100-VF3G.xml'                                                => [ 'Nokia', 'C7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC7-00r100.xml'                                                     => [ 'Nokia', 'C7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC7-00r200.xml'                                                     => [ 'Nokia', 'C7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC7-00r300-3G.xml'                                                  => [ 'Nokia', 'C7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC7-00r300.xml'                                                     => [ 'Nokia', 'C7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC7-00r310.xml'                                                     => [ 'Nokia', 'C7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC7-00sr100.xml'                                                    => [ 'Nokia', 'C7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NC7-00sr210.xml'                                                    => [ 'Nokia', 'C7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE5-00.2r100.xml'                                                   => [ 'Nokia', 'E5-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE5-00r100-VF2G.xml'                                                => [ 'Nokia', 'E5-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE5-00r100-VF3G.xml'                                                => [ 'Nokia', 'E5-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE5-00r100.xml'                                                     => [ 'Nokia', 'E5-00', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE50-1r100.xml'                                                          => [ 'Nokia', 'E50', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE50-2r100-VF2G.xml'                                                     => [ 'Nokia', 'E50', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE50-2r100.xml'                                                          => [ 'Nokia', 'E50', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE51-1r100-VF3G.xml'                                                => [ 'Nokia', 'E51', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE51-1r100.xml'                                                     => [ 'Nokia', 'E51', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE51-2r100.xml'                                                     => [ 'Nokia', 'E51', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE52-1r100-vf3g.xml'                                                => [ 'Nokia', 'E52', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE52-1r100.xml'                                                     => [ 'Nokia', 'E52', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE55-1r100.xml'                                                     => [ 'Nokia', 'E55', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE6-00r100-VF2G.xml'                                                => [ 'Nokia', 'E6-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE6-00r100-VF3G.xml'                                                => [ 'Nokia', 'E6-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE6-00r100.xml'                                                     => [ 'Nokia', 'E6-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE6-00r210.xml'                                                     => [ 'Nokia', 'E6-00', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE60-1r100-VF2G.xml'                                                     => [ 'Nokia', 'E60', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE60-1r100-VF3G.xml'                                                     => [ 'Nokia', 'E60', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE60-1r100-VFKK2G.xml'                                                   => [ 'Nokia', 'E60', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE60-1r100-VFKK3G.xml'                                                   => [ 'Nokia', 'E60', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE60-1r100.xml'                                                          => [ 'Nokia', 'E60', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE61-1r100-VF2G.xml'                                                     => [ 'Nokia', 'E61', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE61-1r100-VF3G.xml'                                                     => [ 'Nokia', 'E61', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE61-1r100-VFKK2G.xml'                                                   => [ 'Nokia', 'E61', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE61-1r100-VFKK3G.xml'                                                   => [ 'Nokia', 'E61', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE61-1r100.xml'                                                          => [ 'Nokia', 'E61', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE61i-1r100-VF2G.xml'                                                    => [ 'Nokia', 'E61i', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE61i-1r100-VF2Gdrm10.xml'                                               => [ 'Nokia', 'E61i', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE61i-1r100-VF3G.xml'                                                    => [ 'Nokia', 'E61i', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE61i-1r100-VF3Gdrm10.xml'                                               => [ 'Nokia', 'E61i', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE61i-1r100.xml'                                                         => [ 'Nokia', 'E61i', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE61i-1r101.xml'                                                         => [ 'Nokia', 'E61i', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE61i-2r100.xml'                                                         => [ 'Nokia', 'E61i', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE61i-1r100.xml'                                                    => [ 'Nokia', 'E61i', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE62-1r100.xml'                                                          => [ 'Nokia', 'E62', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE63-1r100.xml'                                                     => [ 'Nokia', 'E63', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE63-2r100.xml'                                                     => [ 'Nokia', 'E63', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE63-3r100.xml'                                                     => [ 'Nokia', 'E63', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE63r100.xml'                                                       => [ 'Nokia', 'E63', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE65-1r100-VF2G.xml'                                                     => [ 'Nokia', 'E65', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE65-1r100-VF2Gdrm10.xml'                                                => [ 'Nokia', 'E65', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE65-1r100-VF3G.xml'                                                     => [ 'Nokia', 'E65', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE65-1r100-VF3Gdrm10.xml'                                                => [ 'Nokia', 'E65', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE65-1r100.xml'                                                          => [ 'Nokia', 'E65', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE65-1r101.xml'                                                          => [ 'Nokia', 'E65', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE65-2r100.xml'                                                          => [ 'Nokia', 'E65', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE66-1r100-vf3g.xml'                                                => [ 'Nokia', 'E66', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE66-1r100.xml'                                                     => [ 'Nokia', 'E66', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE66-2r100.xml'                                                     => [ 'Nokia', 'E66', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE66r100.xml'                                                       => [ 'Nokia', 'E66', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE7-00r100-VF2G.xml'                                                => [ 'Nokia', 'E7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE7-00r100-VF3G.xml'                                                => [ 'Nokia', 'E7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE7-00r100.xml'                                                     => [ 'Nokia', 'E7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE7-00r200.xml'                                                     => [ 'Nokia', 'E7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE7-00r300.xml'                                                     => [ 'Nokia', 'E7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE7-00r310.xml'                                                     => [ 'Nokia', 'E7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE70-1r100-VF2G.xml'                                                     => [ 'Nokia', 'E70', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE70-1r100-VF3G.xml'                                                     => [ 'Nokia', 'E70', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE70-1r100-VFKK2G.xml'                                                   => [ 'Nokia', 'E70', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE70-1r100-VFKK3G.xml'                                                   => [ 'Nokia', 'E70', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE70-1r100.xml'                                                          => [ 'Nokia', 'E70', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE70-2r100.xml'                                                          => [ 'Nokia', 'E70', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/ne71-1r100-vf2g.xml'                                                => [ 'Nokia', 'E71', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/ne71-1r100-vf3g.xml'                                                => [ 'Nokia', 'E71', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE71-1r100.xml'                                                     => [ 'Nokia', 'E71', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE71-2r100.xml'                                                     => [ 'Nokia', 'E71', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE71-3r100.xml'                                                     => [ 'Nokia', 'E71', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE71r100.xml'                                                       => [ 'Nokia', 'E71', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE71xr100-2G.xml'                                                   => [ 'Nokia', 'E71x', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE71xr100-3G.xml'                                                   => [ 'Nokia', 'E71x', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE72-1r100-vf2g.xml'                                                => [ 'Nokia', 'E72', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE72-1r100-vf3g.xml'                                                => [ 'Nokia', 'E72', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE72-1r100.xml'                                                     => [ 'Nokia', 'E72', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE72-2r100.xml'                                                     => [ 'Nokia', 'E72', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE72r100.xml'                                                       => [ 'Nokia', 'E72', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE73r100.xml'                                                       => [ 'Nokia', 'E73 Mode', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE75-1r100.xml'                                                     => [ 'Nokia', 'E75', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE90-1r100-VF2G.xml'                                                     => [ 'Nokia', 'E90', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE90-1r100-VF3G.xml'                                                     => [ 'Nokia', 'E90', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NE90-1r100.xml'                                                          => [ 'Nokia', 'E90', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NE90-1r100.xml'                                                     => [ 'Nokia', 'E90 Communicator', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NNGager100.xml'                                                          => [ 'Nokia', 'N-Gage', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NNGageQDr100.xml'                                                        => [ 'Nokia', 'N-Gage QD', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NNGageQDr200.xml'                                                        => [ 'Nokia', 'N-Gage QD', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NNGQDr100.xml'                                                           => [ 'Nokia', 'N-Gage QD', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NNGQDr200.xml'                                                           => [ 'Nokia', 'N-Gage QD', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN70-1r100-VF2G.xml'                                                     => [ 'Nokia', 'N70', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN70-1r100-VF2GMIP.xml'                                                  => [ 'Nokia', 'N70', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN70-1r100-VF3G.xml'                                                     => [ 'Nokia', 'N70', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN70-1r100-VF3GMIP.xml'                                                  => [ 'Nokia', 'N70', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN70-1r100-VFKK2G.xml'                                                   => [ 'Nokia', 'N70', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN70-1r100-VFKK3G.xml'                                                   => [ 'Nokia', 'N70', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN70-1r100.xml'                                                          => [ 'Nokia', 'N70', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN70-5r100.xml'                                                          => [ 'Nokia', 'N70', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN70-1r100.xml'                                                     => [ 'Nokia', 'N70', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN71-1r100-VFKK2G.xml'                                                   => [ 'Nokia', 'N71', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN71-1r100-VFKK3G.xml'                                                   => [ 'Nokia', 'N71', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN71-1r100.xml'                                                          => [ 'Nokia', 'N71', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN71-1r101.xml'                                                          => [ 'Nokia', 'N71', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN72r100.xml'                                                            => [ 'Nokia', 'N72', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN72r100.xml'                                                       => [ 'Nokia', 'N72', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN73-1r100-SB2G.xml'                                                     => [ 'Nokia', 'N73', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN73-1r100-SB3G.xml'                                                     => [ 'Nokia', 'N73', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN73-1r100-VF2G.xml'                                                     => [ 'Nokia', 'N73', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN73-1r100-VF2GMIP.xml'                                                  => [ 'Nokia', 'N73', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN73-1r100-VF3G.xml'                                                     => [ 'Nokia', 'N73', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN73-1r100-VF3GMIP.xml'                                                  => [ 'Nokia', 'N73', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN73-1r100.xml'                                                          => [ 'Nokia', 'N73', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN73-2r100.xml'                                                          => [ 'Nokia', 'N73', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN73-5r100.xml'                                                          => [ 'Nokia', 'N73', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN73-6r100.xml'                                                          => [ 'Nokia', 'N73', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN73r100.xml'                                                            => [ 'Nokia', 'N73', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN75-3r100.xml'                                                          => [ 'Nokia', 'N75', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN75-3r200.xml'                                                          => [ 'Nokia', 'N75', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN75-3r300.xml'                                                          => [ 'Nokia', 'N75', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN76-1r100.xml'                                                          => [ 'Nokia', 'N76', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN76-1r100.xml'                                                     => [ 'Nokia', 'N76', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN77-1r100.xml'                                                          => [ 'Nokia', 'N77', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN77r100.xml'                                                            => [ 'Nokia', 'N77', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN78-1r100-VF2G.xml'                                                => [ 'Nokia', 'N78', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN78-1r100-VF3G.xml'                                                => [ 'Nokia', 'N78', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN78-1r100.xml'                                                     => [ 'Nokia', 'N78', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN79-1r100.xml'                                                     => [ 'Nokia', 'N79', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N8r200.xml'                                                         => [ 'Nokia', 'N8', null, DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NC7-00r100.xml'                                                          => [ 'Nokia', 'N8-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN8-00.1r100-3G.xml'                                                => [ 'Nokia', 'N8-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN8-00.1r200-3G.xml'                                                => [ 'Nokia', 'N8-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN8-00.1r300-3G.xml'                                                => [ 'Nokia', 'N8-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN8-00r100-3G.xml'                                                  => [ 'Nokia', 'N8-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN8-00r100-VF2G.xml'                                                => [ 'Nokia', 'N8-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN8-00r100-VF3G.xml'                                                => [ 'Nokia', 'N8-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN8-00r200-3G.xml'                                                  => [ 'Nokia', 'N8-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN8-00r300-3G.xml'                                                  => [ 'Nokia', 'N8-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN8-00r310-3G.xml'                                                  => [ 'Nokia', 'N8-00', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN80-1r100-VF2G.xml'                                                     => [ 'Nokia', 'N80', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN80-1r100-VF3G.xml'                                                     => [ 'Nokia', 'N80', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN80-1r100.xml'                                                          => [ 'Nokia', 'N80', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN80-3r100.xml'                                                          => [ 'Nokia', 'N80', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN81-1r100.xml'                                                          => [ 'Nokia', 'N81', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/N81r100.xml'                                                        => [ 'Nokia', 'N81', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN81-1r100-VF2G.xml'                                                => [ 'Nokia', 'N81', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN81-1r100.xml'                                                     => [ 'Nokia', 'N81', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN81-3r100.xml'                                                     => [ 'Nokia', 'N81', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN82-1r100.xml'                                                     => [ 'Nokia', 'N82', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN85-1r100-VF2G.xml'                                                => [ 'Nokia', 'N85', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN85-1r100-VF3G.xml'                                                => [ 'Nokia', 'N85', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN85-1r100.xml'                                                     => [ 'Nokia', 'N85', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN85-3r100.xml'                                                     => [ 'Nokia', 'N85', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN85r100.xml'                                                       => [ 'Nokia', 'N85', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN86-1r100.xml'                                                     => [ 'Nokia', 'N86 8MP', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN86-3r100.xml'                                                     => [ 'Nokia', 'N86 8MP', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN90-1r100-VF2G.xml'                                                     => [ 'Nokia', 'N90', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN90-1r100-VF3G.xml'                                                     => [ 'Nokia', 'N90', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN90-1r100-VFKK2G.xml'                                                   => [ 'Nokia', 'N90', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN90-1r100-VFKK3G.xml'                                                   => [ 'Nokia', 'N90', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN90-1r100.xml'                                                          => [ 'Nokia', 'N90', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN91-1r100-VF2G.xml'                                                     => [ 'Nokia', 'N91', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN91-1r100-VF3G.xml'                                                     => [ 'Nokia', 'N91', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN91-1r100.xml'                                                          => [ 'Nokia', 'N91', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN91-2r100.xml'                                                          => [ 'Nokia', 'N91', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN91-5r100.xml'                                                          => [ 'Nokia', 'N91', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN91-6r100.xml'                                                          => [ 'Nokia', 'N91', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN91r100.xml'                                                            => [ 'Nokia', 'N91', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN92-1r100.xml'                                                          => [ 'Nokia', 'N92', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN92-2r100.xml'                                                          => [ 'Nokia', 'N92', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN93-1r100-VF2G.xml'                                                     => [ 'Nokia', 'N93', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN93-1r100-VF3G.xml'                                                     => [ 'Nokia', 'N93', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN93-1r100.xml'                                                          => [ 'Nokia', 'N93', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN93r100.xml'                                                            => [ 'Nokia', 'N93', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN93i-1r100-VF2G.xml'                                                    => [ 'Nokia', 'N93i', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN93i-1r100-VF3G.xml'                                                    => [ 'Nokia', 'N93i', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN93i-1r100.xml'                                                         => [ 'Nokia', 'N93i', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN93ir100.xml'                                                           => [ 'Nokia', 'N93i', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN95-1r100-VF2G.xml'                                                     => [ 'Nokia', 'N95', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN95-1r100-VF2GMIP.xml'                                                  => [ 'Nokia', 'N95', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN95-1r100-VF3G.xml'                                                     => [ 'Nokia', 'N95', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN95-1r100-VF3GMIP.xml'                                                  => [ 'Nokia', 'N95', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN95-1r100.xml'                                                          => [ 'Nokia', 'N95', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN95-3r100.xml'                                                          => [ 'Nokia', 'N95', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN95-5r100.xml'                                                          => [ 'Nokia', 'N95', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NN95_8GB-1r100.xml'                                                      => [ 'Nokia', 'N95', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN95-1r100-VF2G.xml'                                                => [ 'Nokia', 'N95', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN95-1r100.xml'                                                     => [ 'Nokia', 'N95', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN95_8GB-1r100-VF3G.xml'                                            => [ 'Nokia', 'N95 8GB', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN95_8GB-1r100.xml'                                                 => [ 'Nokia', 'N95 8GB', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN95_8GB-3r100.xml'                                                 => [ 'Nokia', 'N95 8GB', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN95-3r100.xml'                                                     => [ 'Nokia', 'N95-3 NAM', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN96-1r100.xml'                                                     => [ 'Nokia', 'N96', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN96-3r100.xml'                                                     => [ 'Nokia', 'N96', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN96r100.xml'                                                       => [ 'Nokia', 'N96', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN97-1r100-2G.xml'                                                  => [ 'Nokia', 'N97', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN97-1r100-3G.xml'                                                  => [ 'Nokia', 'N97', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN97-3r100-2G.xml'                                                  => [ 'Nokia', 'N97', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN97-3r100-3G.xml'                                                  => [ 'Nokia', 'N97', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN97ir100-2G.xml'                                                   => [ 'Nokia', 'N97', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN97r100-2G.xml'                                                    => [ 'Nokia', 'N97', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaN97-1r100-3G.xml'                                             => [ 'Nokia', 'N97', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaN97-4r100-3G.xml'                                             => [ 'Nokia', 'N97', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN9-00r100-R.xml'                                                   => [ 'Nokia', 'N97 Mini', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN97-4r100-2G.xml'                                                  => [ 'Nokia', 'N97 Mini', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN97-4r100-3G-VF2G.xml'                                             => [ 'Nokia', 'N97 Mini', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN97-4r100-3G-VF3G.xml'                                             => [ 'Nokia', 'N97 Mini', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN97-4r100-3G.xml'                                                  => [ 'Nokia', 'N97 Mini', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN97-5r100-2G.xml'                                                  => [ 'Nokia', 'N97 Mini', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN97-5r100-3G.xml'                                                  => [ 'Nokia', 'N97 Mini', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN97minir100-2G.xml'                                                => [ 'Nokia', 'N97 Mini', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NN97minir100-3G.xml'                                                => [ 'Nokia', 'N97 Mini', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NSU7r100.xml'                                                            => [ 'Nokia', 'SU-7', null, DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NT7-00r100.xml'                                                     => [ 'Nokia', 'T7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds.nokia.com/uaprof/NTHR880ir100.xml'                                                        => [ 'Nokia', 'THR880i', null, DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NX2-00r100.xml'                                                     => [ 'Nokia', 'X2-00', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaX2-01.1r100.xml'                                               => [ 'Nokia', 'X2-01', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaX2-01r100.xml'                                                 => [ 'Nokia', 'X2-01', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaX2-02r100.xml'                                                 => [ 'Nokia', 'X2-02', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaX2-03r100.xml'                                                 => [ 'Nokia', 'X2-03', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaX2-05r100.xml'                                                 => [ 'Nokia', 'X2-05', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NX3-00r100.xml'                                                     => [ 'Nokia', 'X3-00', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NX3-02.5r100.xml'                                                   => [ 'Nokia', 'X3-02', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NX3-02r100.xml'                                                     => [ 'Nokia', 'X3-02', 'Series40', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NX5-00r100.xml'                                                     => [ 'Nokia', 'X5-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NX5-01r100.xml'                                                     => [ 'Nokia', 'X5-01', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaX6-00.1r100-3G.xml'                                           => [ 'Nokia', 'X6-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaX6-00mr100-2G.xml'                                             => [ 'Nokia', 'X6-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaX6-00r100-2G.xml'                                             => [ 'Nokia', 'X6-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaX6-00r100-3G.xml'                                              => [ 'Nokia', 'X6-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NokiaX6-00r100-VF2G.xml'                                            => [ 'Nokia', 'X6-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NX7-00.1r100-3G.xml'                                                => [ 'Nokia', 'X7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NX7-00r100-3G.xml'                                                  => [ 'Nokia', 'X7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NX7-00r100-VF3G.xml'                                                => [ 'Nokia', 'X7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NX7-00r200-3G.xml'                                                  => [ 'Nokia', 'X7-00', 'Series60', DeviceType::MOBILE ],
    'http://nds1.nds.nokia.com/uaprof/NX7-00r210-3G.xml'                                                  => [ 'Nokia', 'X7-00', 'Series60', DeviceType::MOBILE ],
    'http://www.ztemt.com/mobile/uaprof/nubia_NX501_Z54.xml'                                              => [ 'Nubia', 'Z5', 'Android', DeviceType::MOBILE ],
    'http://nyxmobile.com/UAProfile/fly/NYX_FLY.xml'                                                      => [ 'Nyx', 'Fly', 'Android', DeviceType::MOBILE ],
    'http://www.nyxmobile.com/UAProfile/flyii/NYX_FLY_II.xml'                                             => [ 'NYX Mobile', 'Fly II', 'Android', DeviceType::MOBILE ],
    'http://www.nyxmobile.com/UAProfile/join/NYX_JOIN.xml'                                                => [ 'NYX Mobile', 'Join', 'Android', DeviceType::MOBILE ],
    'http://www.nyxmobile.com/UAProfile/nobaii/NYX_NOBA_II.xml'                                           => [ 'NYX Mobile', 'Noba II', 'Android', DeviceType::MOBILE ],
    'http://www.nyxmobile.com/UAProfile/orbis/NYX_ORBIS_LL.xml'                                           => [ 'NYX Mobile', 'Orbis', 'Android', DeviceType::MOBILE ],
    'http://www.seeo2.com/uaprofile/uaprof-atomlife.xml'                                                  => [ 'O2', 'Comet', null, DeviceType::MOBILE ],
    'http://www.seeo2.com/uaprofile/uaprof-atomexec.xml'                                                  => [ 'O2', 'Xda Exec', null, DeviceType::MOBILE ],
    'http://www.seeo2.com/uaprofile/uaprof-stealth.xml'                                                   => [ 'O2', 'XDA Stealth', null, DeviceType::MOBILE ],
    'http://www.obimobiles.com/UAP/S500.xml'                                                              => [ 'Obi', 'Yeti S500', 'Android', DeviceType::MOBILE ],
    'http://www.okwap.com.cn/uaprof/d88/d88profile.xml'                                                   => [ 'Okwap', 'D88', null, DeviceType::MOBILE ],
    'http://www.okwap.com.cn/uaprof/km63/km63profile.xml'                                                 => [ 'Okwap', 'KM63', null, DeviceType::MOBILE ],
    'http://www.okwap.com.cn/uaprof/km65/km65profile.xml'                                                 => [ 'Okwap', 'KM65', null, DeviceType::MOBILE ],
    'http://www.ondacommunication.com/ua/N1010.xml'                                                       => [ 'Onda', 'N1010', null, DeviceType::MOBILE ],
    'http://www.ondacommunication.com/ua/N5010.xml'                                                       => [ 'Onda', 'N5010', null, DeviceType::MOBILE ],
    'http://www.ondacommunication.com/ua/TT101.xml'                                                       => [ 'Onda', 'TT101', 'Android', DeviceType::TABLET ],
    'http://www.ondacommunication.com/ua/TT102.xml'                                                       => [ 'Onda', 'TT102', 'Android', DeviceType::MOBILE ],
    'http://ua.prof.oppo.com/resource/ua-PROF/OPPOA0001.xml'                                              => [ 'OnePlus', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/ONEPLUSA0001.xml'                                               => [ 'OnePlus', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOA0001.xml'                                                  => [ 'OnePlus', 'One', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/ZTE-ONIDA F970.xml'                                              => [ 'Onida', 'F970', null, DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPO1100.xml'                                                   => [ 'Oppo', '1100', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPO1105.xml'                                                   => [ 'Oppo', '1105', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPO1107.xml'                                                   => [ 'Oppo', '1107', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPO3005.xml'                                                   => [ 'Oppo', '3005', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO A30.xml'                                               => [ 'Oppo', 'A30', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOA31.xml'                                                    => [ 'Oppo', 'A31', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOA31c.xml'                                                   => [ 'Oppo', 'A31c', 'Android', DeviceType::MOBILE ],
    'http://ua.prof.oppo.com/resource/ua-PROF/OPPOA31t.xml'                                               => [ 'Oppo', 'A31t', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO A31t.xml'                                              => [ 'Oppo', 'A31t', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOA31u.xml'                                                   => [ 'Oppo', 'A31u', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO A33.xml'                                               => [ 'Oppo', 'A33', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO A33m.xml'                                              => [ 'Oppo', 'A33m', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO A37m.xml'                                              => [ 'Oppo', 'A37m', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO A53.xml'                                               => [ 'Oppo', 'A53', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO A53m.xml'                                              => [ 'Oppo', 'A53m', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO A57.xml'                                               => [ 'Oppo', 'A57', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO A57t.xml'                                              => [ 'Oppo', 'A57t', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO A59m.xml'                                              => [ 'Oppo', 'A59m', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO A59s.xml'                                              => [ 'Oppo', 'A59s', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO A59st.xml'                                             => [ 'Oppo', 'A59st', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO A77.xml'                                               => [ 'Oppo', 'A77', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO A77t.xml'                                              => [ 'Oppo', 'A77t', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR827.xml'                                                   => [ 'Oppo', 'Find 5 mini R827', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR2001.xml'                                                  => [ 'Oppo', 'Find 5 mini R827T', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR827T.xml'                                                  => [ 'Oppo', 'Find 5 mini R827T', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOX909T.xml'                                                  => [ 'Oppo', 'Find 5 X909', 'Android', DeviceType::MOBILE ],
    'http://ua.prof.oppo.com/resource/ua-PROF/OPPOR6006.xml'                                              => [ 'Oppo', 'Find 7 mini R6006', 'Android', DeviceType::MOBILE ],
    'http://ua.prof.oppo.com/resource/ua-PROF/OPPOFIND7.xml'                                              => [ 'Oppo', 'Find 7 X9070', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOX9070.xml'                                                  => [ 'Oppo', 'Find 7 X9070', 'Android', DeviceType::MOBILE ],
    'http://ua.prof.oppo.com/resource/ua-PROF/OPPOX9076.xml'                                              => [ 'Oppo', 'Find 7 X9076', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOX9077.xml'                                                  => [ 'Oppo', 'Find 7 X9077', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOX9000.xml'                                                  => [ 'Oppo', 'Find 7a X9000', 'Android', DeviceType::MOBILE ],
    'http://ua.prof.oppo.com/resource/ua-PROF/OPPOX9006.xml'                                              => [ 'Oppo', 'Find 7a X9006', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOX9007.xml'                                                  => [ 'Oppo', 'Find 7a X9007', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR815.xml'                                                   => [ 'Oppo', 'Find Clover R815', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR815T.xml'                                                  => [ 'Oppo', 'Find Clover R815', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR821T.xml'                                                  => [ 'Oppo', 'Find Muse R821T', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOU707.xml'                                                   => [ 'Oppo', 'Find Way S U707', 'Android', DeviceType::MOBILE ],
    'http://ua.prof.oppo.com/resource/ua-PROF/OPPON1.xml'                                                 => [ 'Oppo', 'N1', 'Android', DeviceType::MOBILE ],
    'http://ua.prof.oppo.com/resource/ua-PROF/OPPON5111.xml'                                              => [ 'Oppo', 'N1 mini', 'Android', DeviceType::MOBILE ],
    'http://ua.prof.oppo.com/resource/ua-PROF/OPPON5116.xml'                                              => [ 'Oppo', 'N1 mini', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPON5110.xml'                                                  => [ 'Oppo', 'N1 mini', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPON5117.xml'                                                  => [ 'Oppo', 'N1 mini', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPON5207.xml'                                                  => [ 'Oppo', 'N3', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPON5209.xml'                                                  => [ 'Oppo', 'N3', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPON828.xml'                                                   => [ 'Oppo', 'N828', 'Android', DeviceType::MOBILE ],
    'http://ua.prof.oppo.com/resource/ua-PROF/OPPOR831L.xml'                                              => [ 'Oppo', 'Neo 5 R831L', 'Android', DeviceType::MOBILE ],
    'http://ua.prof.oppo.com/resource/ua-PROF/OPPOR831.xml'                                               => [ 'Oppo', 'Neo R831', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR829.xml'                                                   => [ 'Oppo', 'R1 R829', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR829T.xml'                                                  => [ 'Oppo', 'R1 R829T', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R11.xml'                                               => [ 'Oppo', 'R11', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R11 Plus.xml'                                          => [ 'Oppo', 'R11 Plus', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R11 Plusk.xml'                                         => [ 'Oppo', 'R11 Plus', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R11 Pluskt.xml'                                        => [ 'Oppo', 'R11 Plus', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R11t.xml'                                              => [ 'Oppo', 'R11t', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR8200.xml'                                                  => [ 'Oppo', 'R1c R8200', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR8207.xml'                                                  => [ 'Oppo', 'R1c R8207', 'Android', DeviceType::MOBILE ],
    'http://ua.prof.oppo.com/resource/ua-PROF/OPPOR8006.xml'                                              => [ 'Oppo', 'R1L R8006', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR8000.xml'                                                  => [ 'Oppo', 'R1S R8000', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR8007.xml'                                                  => [ 'Oppo', 'R1S R8007', 'Android', DeviceType::MOBILE ],
    'http://ua.prof.oppo.com/resource/ua-PROF/OPPOR8201.xml'                                              => [ 'Oppo', 'R1x R8201', 'Android', DeviceType::MOBILE ],
    'http://ua.prof.oppo.com/resource/ua-PROF/OPPOR8206.xml'                                              => [ 'Oppo', 'R1x R8206', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR2010.xml'                                                  => [ 'Oppo', 'R2010', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR2017.xml'                                                  => [ 'Oppo', 'R2017', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR7007.xml'                                                  => [ 'Oppo', 'R3 R7007', 'Android', DeviceType::MOBILE ],
    'http://ua.prof.oppo.com/resource/ua-PROF/OPPOR8106.xml'                                              => [ 'Oppo', 'R5 R8106', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR8107.xml'                                                  => [ 'Oppo', 'R5 R8107', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR6007.xml'                                                  => [ 'Oppo', 'R6007', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R7.xml'                                                => [ 'Oppo', 'R7', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR7.xml'                                                     => [ 'Oppo', 'R7', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR7Plus.xml'                                                 => [ 'Oppo', 'R7 Plus', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR7Plusm.xml'                                                => [ 'Oppo', 'R7 Plus', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR7005.xml'                                                  => [ 'Oppo', 'R7005', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR7c.xml'                                                    => [ 'Oppo', 'R7c', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R7s.xml'                                               => [ 'Oppo', 'R7s', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR7s.xml'                                                    => [ 'Oppo', 'R7s', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R7sPlus.xml'                                           => [ 'Oppo', 'R7s Plus', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R7sm.xml'                                              => [ 'Oppo', 'R7sm', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR7st.xml'                                                   => [ 'Oppo', 'R7st', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R7t.xml'                                               => [ 'Oppo', 'R7t', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR7t.xml'                                                    => [ 'Oppo', 'R7t', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR809T.xml'                                                  => [ 'Oppo', 'R809', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR813T.xml'                                                  => [ 'Oppo', 'R813', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR819.xml'                                                   => [ 'Oppo', 'R819', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR8205.xml'                                                  => [ 'Oppo', 'R8205', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR823T.xml'                                                  => [ 'Oppo', 'R823', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR831S.xml'                                                  => [ 'Oppo', 'R831S', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR833T.xml'                                                  => [ 'Oppo', 'R833T', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR850.xml'                                                   => [ 'Oppo', 'R850', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R9 Plusm A.xml'                                        => [ 'Oppo', 'R9 Plus', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R9 Plustm A.xml'                                       => [ 'Oppo', 'R9 Plus', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R9km.xml'                                              => [ 'Oppo', 'R9km', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R9m.xml'                                               => [ 'Oppo', 'R9m', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R9s.xml'                                               => [ 'Oppo', 'R9s', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R9s Plus.xml'                                          => [ 'Oppo', 'R9s Plus', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R9sk.xml'                                              => [ 'Oppo', 'R9sk', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R9st.xml'                                              => [ 'Oppo', 'R9st', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R9t.xml'                                               => [ 'Oppo', 'R9t', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOOPPO R9tm.xml'                                              => [ 'Oppo', 'R9tm', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR811.xml'                                                   => [ 'Oppo', 'Real R811', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR817T.xml'                                                  => [ 'Oppo', 'Real R817', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOR819T.xml'                                                  => [ 'Oppo', 'Real R819T', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOU707T.xml'                                                  => [ 'Oppo', 'U2S U707T', 'Android', DeviceType::MOBILE ],
    'http://www.oppo.com/resource/UA-PROF/OPPOU705T.xml'                                                  => [ 'Oppo', 'U705T', 'Android', DeviceType::MOBILE ],
    'http://www.gigabytecm.com/ua/Boston4G.xml'                                                           => [ 'Optimus', 'Boston 4G', 'Android', DeviceType::MOBILE ],
    'http://www.qisda.com/UserFiles/uaprof_boston_4g.xml'                                                 => [ 'Optimus', 'Boston 4G', 'Android', DeviceType::MOBILE ],
    'https://s3-eu-west-1.amazonaws.com/fotabucket/uaprof/uaprof_qisda_boston.xml'                        => [ 'Optimus', 'Boston 4G', 'Android', DeviceType::MOBILE ],
    'http://www.opto.co.jp/win_ht/uaprof/H-21-1.0.xml'                                                    => [ 'Opto', 'H-21', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.amobile.com.cn/ua/Amoi-Berlin.xml'                                                        => [ 'Orange', 'Berlin', null, DeviceType::MOBILE ],
    'http://eip2.gigabytecm.com/BOSTON-OPO.xml'                                                           => [ 'Orange', 'Boston', 'Android', DeviceType::MOBILE ],
    'http://eip2.gigabytecm.com/BOSTON-P2.xml'                                                            => [ 'Orange', 'Boston', 'Android', DeviceType::MOBILE ],
    'http://eip2.gigabytecm.com/Orange-BOSTON.xml'                                                        => [ 'Orange', 'Boston', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Orange Covo.xml'                                                    => [ 'Orange', 'Covo', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG510-0200GPRS-Orange.xml'                                        => [ 'Orange', 'Daytona', 'Android', DeviceType::MOBILE ],
    'http://config.51coolpad.com/UAProfile/Orange/Orange-Fova.xml'                                        => [ 'Orange', 'Fova', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG535-L11LTE-OrangeGova.xml'                                      => [ 'Orange', 'Gova', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Orange_Hi_4G.xml'                                                => [ 'Orange', 'Hi', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Orange_Hiro.xml'                                                    => [ 'Orange', 'Hiro', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Orange_infinity_996.xml'                                            => [ 'Orange', 'Infinity 996', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Infinity_X.xml'                                                     => [ 'Orange', 'Infinity X', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Orange_KLIF.xml'                                                    => [ 'Orange', 'Kilf', 'Firefox OS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Orange_KLIFD.xml'                                                   => [ 'Orange', 'Kilf', 'Firefox OS', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Orange-Kivo.xml'                                                    => [ 'Orange', 'Kivo', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiY330-U01-OrangeLuno.xml'                                         => [ 'Orange', 'Luno', 'Android', DeviceType::MOBILE ],
    'http://www.amobile.com.cn/ua/Amoi-NewYork.xml'                                                       => [ 'Orange', 'New York', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Orange_Niva.xml'                                                    => [ 'Orange', 'Nivo', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Orange_Nura.xml'                                                    => [ 'Orange', 'Nura', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Nura 2.xml'                                                         => [ 'Orange', 'Nura 2', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Orange_Reyo.xml'                                                 => [ 'Orange', 'Reyo', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Orange_Rono.xml'                                                 => [ 'Orange', 'Rono', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Orange_Roya.xml'                                                    => [ 'Orange', 'Roya', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Orange-San-Francisco.xml'                                        => [ 'Orange', 'San Francisco', 'Android', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/Excal-1.0.xml'                                                          => [ 'Orange', 'SPV E600', null, DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/ph10cd-1.0.xml'                                                         => [ 'Orange', 'SPV M1500', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.htcmms.com.tw/gen/st21-1.0.xml'                                                           => [ 'Orange', 'SPV V550', 'Windows Mobile', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Orange_Tado.xml'                                                 => [ 'Orange', 'Tado', 'Android', DeviceType::MOBILE ],
    'http://www.modelabs.com/uaprofs/Orange-Tokyo.xml'                                                    => [ 'Orange', 'Tokyo', null, DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiG740-L00LTE-OrangeYumo.xml'                                      => [ 'Orange', 'Yumo', 'Android', DeviceType::MOBILE ],
    'http://www.zte.com.cn/mobile/uaprof/Orange-Zali.xml'                                                 => [ 'Orange', 'Zali', 'Android', DeviceType::MOBILE ],
    'http://www.huaqin.com/mobile/uaprof/Zilo.xml'                                                        => [ 'Orange', 'Zilo', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Bucare_Y330-U05_UAProfile.xml'                                         => [ 'Orinoquia', 'Bucare Y330', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/Kavak_Y625_U03_UAProfile.xml'                                          => [ 'Orinoquia', 'Kavak Y625', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/5054A.xml'                                                          => [ 'Own', 'S4035 4G', 'Android', DeviceType::MOBILE ],
    'http://www.oysters.ru/UAProfile/Arctic450_UAProfile.xml'                                             => [ 'Oysters', 'Arctic 450', 'Android', DeviceType::MOBILE ],
    'http://support.acer.com/UAprofile/Acer_G100W_Profile.xml'                                            => [ 'Packard Bell', 'Liberty Tab G100W', 'Android', DeviceType::MOBILE ],
    'http://www.palm.com/permalinks/mmsuaprofs/ASUS_Crown_1.xml'                                          => [ 'Palm', 'Treo 500', 'Palm OS', DeviceType::MOBILE ],
    'http://www.handspring.com/profilespecs/Blazer300_OR.rdf'                                             => [ 'Palm', 'Treo 600', 'Palm OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/PALMONE/POTR650HK/Blazer400103.rdf'                                      => [ 'Palm', 'Treo 650', 'Palm OS', DeviceType::MOBILE ],
    'http://downloads.palmone.com/profiles/Blazer400.rdf'                                                 => [ 'Palm', 'Treo 650', 'Palm OS', DeviceType::MOBILE ],
    'http://downloads.palm.com/profiles/Blazer453-ROW.rdf'                                                => [ 'Palm', 'Treo 680', 'Palm OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/PALM/PTR700PHK/Blazer450108.rdf'                                         => [ 'Palm', 'Treo 700', 'Palm OS', DeviceType::MOBILE ],
    'http://downloads.palm.com/profiles/Blazer450.rdf'                                                    => [ 'Palm', 'Treo 700p', 'Palm OS', DeviceType::MOBILE ],
    'http://downloads.palm.com/profiles/Treo750R1.rdf'                                                    => [ 'Palm', 'Treo 750', 'Palm OS', DeviceType::MOBILE ],
    'http://downloads.palm.com/profiles/Treo750R2.rdf'                                                    => [ 'Palm', 'Treo 750', 'Palm OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/PALM/PTR755PHK/Blazer450104.rdf'                                         => [ 'Palm', 'Treo 755', 'Palm OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/PALM/PTR800HK/IEM101.rdf'                                                => [ 'Palm', 'Treo 800', 'Palm OS', DeviceType::MOBILE ],
    'http://downloads.palm.com/profiles/Blazer400.rdf'                                                    => [ 'Palm', 'TX', 'Palm OS', DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/A200/R1.xml'                                           => [ 'Panasonic', 'A200', null, DeviceType::MOBILE ],
    'http://dlcache.mobile.pfota.com/Panasonic/UAProf/DL1R1.xml'                                          => [ 'Panasonic', 'Eluga dL1', 'Android', DeviceType::MOBILE ],
    'http://vodafone.51coolpad.com/UAProfile/vodafone/Q475.xml'                                           => [ 'Panasonic', 'Eluga L', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Panasonic_ELUGA_Switch.xml'                                         => [ 'Panasonic', 'Eluga Switch', 'Android', DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/G50/R1.xml'                                            => [ 'Panasonic', 'G50', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/G60/R1.xml'                                            => [ 'Panasonic', 'G60', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/G70/R1.xml'                                            => [ 'Panasonic', 'G70', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/GD67/04.xml'                                           => [ 'Panasonic', 'GD67', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/GD67/R1.xml'                                           => [ 'Panasonic', 'GD67', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/GD67/R2.xml'                                           => [ 'Panasonic', 'GD67', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/GD86A/R1.xml'                                          => [ 'Panasonic', 'GD86', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/GD87/01.xml'                                           => [ 'Panasonic', 'GD87', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/GD87/R1.xml'                                           => [ 'Panasonic', 'GD87', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/GD88/R1.xml'                                           => [ 'Panasonic', 'GD88', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/GD88D/R1.xml'                                          => [ 'Panasonic', 'GD88', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/GU87/R1.xml'                                           => [ 'Panasonic', 'GU87', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/PANASONIC_P31.xml'                                                  => [ 'Panasonic', 'P31', 'Android', DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Panasonic P51.xml'                                                  => [ 'Panasonic', 'P51', 'Android', DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/SA7/RP1.xml'                                           => [ 'Panasonic', 'SA7', null, DeviceType::MOBILE ],
    'http://www-ccpp.tcl-ta.com/files/Panasonic_T31.xml'                                                  => [ 'Panasonic', 'T31', 'Android', DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/vs2/RP1.xml'                                           => [ 'Panasonic', 'VS2', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/VS7/RP1.xml'                                           => [ 'Panasonic', 'VS7', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/VS7aI/RJ1_3G.xml'                                      => [ 'Panasonic', 'VS7', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/VS7aII/RJ1_3G.xml'                                     => [ 'Panasonic', 'VS7', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/VS7x/RJ1_3G.xml'                                       => [ 'Panasonic', 'VS7', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/VS70/RJ1_3G.xml'                                       => [ 'Panasonic', 'VS70', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/VS8x/RJ1_3G.xml'                                       => [ 'Panasonic', 'VS8', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/X200/R1.xml'                                           => [ 'Panasonic', 'X200', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/X200/RP1.xml'                                          => [ 'Panasonic', 'X200', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/X300/R1.xml'                                           => [ 'Panasonic', 'X300', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/X400/RP1.xml'                                          => [ 'Panasonic', 'X400', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/X410/R1.xml'                                           => [ 'Panasonic', 'X410', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/X500/R1.xml'                                           => [ 'Panasonic', 'X500', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/X60/R1-D2.xml'                                         => [ 'Panasonic', 'X60', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/X60/R1.xml'                                            => [ 'Panasonic', 'X60', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/X60/R1new.xml'                                         => [ 'Panasonic', 'X60', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/X66/R1.xml'                                            => [ 'Panasonic', 'X66', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/x68/R1.xml'                                            => [ 'Panasonic', 'X68', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/X70/R1.xml'                                            => [ 'Panasonic', 'X70', null, DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/X700/X700R1.xml'                                       => [ 'Panasonic', 'X700', 'Series60', DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/X701/X701R1.xml'                                       => [ 'Panasonic', 'X700', 'Series60', DeviceType::MOBILE ],
    'http://mobileinternet.panasonicbox.com/UAprof/X800/X800R1.xml'                                       => [ 'Panasonic', 'X800', 'Series60', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/pcd/adr8995/adr8995.xml'                                                     => [ 'Pantech', 'Breakout', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/pcd/STARQ/adr8995.xml'                                                       => [ 'Pantech', 'Breakout', 'Android', DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/Gsm/C520.xml'                                                          => [ 'Pantech', 'Breeze', null, DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/umts/PU-P9070.xml'                                                     => [ 'Pantech', 'Burst', 'Android', DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/umts/PU-P9070R01.xml'                                                  => [ 'Pantech', 'Burst', 'Android', DeviceType::MOBILE ],
    'http://www.pantech.com/UAPROF/GSM/PG-C150.XML'                                                       => [ 'Pantech', 'C150', null, DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/Gsm/PG-C300J.xml'                                                      => [ 'Pantech', 'C300', null, DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/umts/PU-C630.xml'                                                      => [ 'Pantech', 'C630', null, DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/umts/PU-P8000.xml'                                                     => [ 'Pantech', 'Crossover', 'Android', DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/umts/PU-P8000R01.xml'                                                  => [ 'Pantech', 'Crossover', 'Android', DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/umts/PU-C810.xml'                                                      => [ 'Pantech', 'Duo', null, DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/umts/PU-P4100.xml'                                                     => [ 'Pantech', 'Element', 'Android', DeviceType::TABLET ],
    'http://www.pantech.com/Uaprof/umts/PU-P4100R01.xml'                                                  => [ 'Pantech', 'Element', 'Android', DeviceType::TABLET ],
    'http://www.pantech.com/Uaprof/umts/PU-P8010.xml'                                                     => [ 'Pantech', 'Flex', 'Android', DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/umts/PU-P8010R01.xml'                                                  => [ 'Pantech', 'Flex', 'Android', DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/umts/PU-P9090.xml'                                                     => [ 'Pantech', 'Magnus', 'Android', DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/umts/PU-P9090R01.xml'                                                  => [ 'Pantech', 'Magnus', 'Android', DeviceType::MOBILE ],
    'http://uaprof.vtext.com/pcd/adr910l/adr910l.xml'                                                     => [ 'Pantech', 'Marauder', 'Android', DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/umts/PU-C740.xml'                                                      => [ 'Pantech', 'Matrix', null, DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/umts/PU-P6020.xml'                                                     => [ 'Pantech', 'P6020', 'Brew', DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/umts/PU-P6030.xml'                                                     => [ 'Pantech', 'P6030', null, DeviceType::MOBILE ],
    'http://uaprof.vtext.com/pcd/adr930l/adr930l.xml'                                                     => [ 'Pantech', 'Perception', 'Android', DeviceType::MOBILE ],
    'http://device.telusmobility.com/pantech/PN3200-0.rdf'                                                => [ 'Pantech', 'PN-3200', null, DeviceType::MOBILE ],
    'http://www.pantech.com/Uaprof/umts/PU-P9060.xml'                                                     => [ 'Pantech', 'Pocket', 'Android', DeviceType::MOBILE ],
    'http://www.pantech.co.kr/Uaprof/Gsm/S100J.xml'                                                       => [ 'Pantech', 'S100', null, DeviceType::MOBILE ],
    'http://mobileuaprof.xtra.co.nz/h_tx215c.rdf'                                                         => [ 'Pantech', 'TX215', null, DeviceType::MOBILE ],
    'http://uaprof.qma.com.tw/vega-ptl21.xml'                                                             => [ 'Pantech', 'Vega Nº6', 'Android', DeviceType::MOBILE ],
    'http://ota.phicomm.com.cn/MobileProfile/C630LwRU-UA-Profile.xml'                                     => [ 'Phicomm', 'Clue L', 'Android', DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uap289.xml'                                                      => [ 'Philips', '289', null, DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uap330.xml'                                                      => [ 'Philips', '330', null, DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uap350.xml'                                                      => [ 'Philips', '350', null, DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uap530.xml'                                                      => [ 'Philips', '530', null, DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uap568.xml'                                                      => [ 'Philips', '568', null, DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uap650.xml'                                                      => [ 'Philips', '650', null, DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uap755.xml'                                                      => [ 'Philips', '755', null, DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uap766.xml'                                                      => [ 'Philips', '766', null, DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uap960.xml'                                                      => [ 'Philips', '960', null, DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uapCT9A9G.xml'                                                   => [ 'Philips', '9A9G', null, DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uapPHILIPS9A9W.xml'                                              => [ 'Philips', '9A9W', null, DeviceType::MOBILE ],
    'www-ccpp.tcl-ta.com/files/PI3210G.xml'                                                               => [ 'Philips', 'Amio 7', 'Android', DeviceType::TABLET ],
    'http://www.consumer.philips.com/wbu/uapP199.xml'                                                     => [ 'Philips', 'P100', null, DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uapP598.xml'                                                     => [ 'Philips', 'P598', null, DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uapW3550.xml'                                                    => [ 'Philips', 'S309', 'Android', DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uapS890.XML'                                                     => [ 'Philips', 'S890', null, DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uapW3568.xml'                                                    => [ 'Philips', 'W3568', 'Android', DeviceType::MOBILE ],
    'http://www.consumer.philips.com/wbu/uapX525.xml'                                                     => [ 'Philips', 'X331', 'MTK', DeviceType::MOBILE ],
    'http://uriver.co.kr/UAprof/UAprof_M801.xml'                                                          => [ 'PhoneOne', 'M801', null, DeviceType::MOBILE ],
    'http://www.coobery.com/mobile/Suning_S90w_UAProfile.xml'                                             => [ 'Pioneer', 'S90w', 'Android', DeviceType::MOBILE ],
    'http://wap1.huawei.com/uaprof/HuaweiMediaPad7951WDWIFIOnly.xml'                                      => [ 'PLDT', 'Telpad Dual S', 'Android', DeviceType::TABLET ],
    'http://www.diamond-electronics.com/xmlfiles/PSPC550.XML'                                             => [ 'Polaroid', 'Cosmo 550', 'Android', DeviceType::MOBILE ],
    'http://www.diamond-electronics.com/xmlfiles/P5526A.xml'                                              => [ 'Polaroid', 'Cosmo K Plus', 'Android', DeviceType::TABLET ],
    'http://www.diamond-electronics.com/xmlfiles/P5046A.xml'                                              => [ 'Polaroid', 'Cosmo P5s Dorado', 'Android', DeviceType::MOBILE ],
    'http://www.diamond-electronics.com/xmlfiles/P5525A.xml'                                              => [ 'Polaroid', 'Cosmo Q5s Gris', 'Android', DeviceType::MOBILE ],
    'http://www.diamond-electronics.com/xmlfiles/P4005A.xml'                                              => [ 'Polaroid', 'P4005A', 'Android', DeviceType::MOBILE ],
    'http://www.gfivemobile.com/en/xml/PMID703GK.xml'                                                     => [ 'Polaroid', 'PMID 703gk', 'Android', DeviceType::MOBILE ],
    'http://www.diamond-electronics.com/xmlfiles/PMID704GK.XML'                                           => [ 'Polaroid', 'PMID 704gk', 'Android', DeviceType::TABLET ],
    'http://www.diamond-electronics.com/xmlfiles/P4006A.XML'                                              => [ 'Polaroid', 'Polaroid P4006A', 'Android', DeviceType::MOBILE ],
    'http://www.diamond-electronics.com/xmlfiles/PMID7102DC.xml'                                          => [ 'Polaroid', 'Polaroid PMID7102DC', 'Android', DeviceType::MOBILE ],
    'http://www.diamond-electronics.com/xmlfiles/PSPC505.XML'                                             => [ 'Polaroid', 'PSPC505', 'Android', DeviceType::MOBILE ],
    'http://www.diamond-electronics.com/xmlfiles/PSPT350_UAProfile.xml'                                   => [ 'Polaroid', 'PSPT350', 'Android', DeviceType::MOBILE ],
    'http://www.diamond-electronics.com/xmlfiles/PSPT401.xml'                                             => [ 'Polaroid', 'Turbo 401', 'Android', DeviceType::MOBILE ],
    'http://www.diamond-electronics.com/xmlfiles/P4525A.XML'                                              => [ 'Polaroid', 'Turbo C4 Plus', 'Android', DeviceType::MOBILE ],
    'http://www.diamond-electronics.com/xmlfiles/P5005A.XML'                                              => [ 'Polaroid', 'Turbo C5', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PGPS7795_V1.xml'                                       => [ 'Prestigio', 'Geovision Tour', 'Android',  ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP7557_V1.xml'                                    => [ 'Prestigio', 'Grace 7557', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP5670C_DUO_V1.xml'                                   => [ 'Prestigio', 'Multipad 2 Pro Duo 7.0', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP7380D3G_QUAD_V1.xml'                                => [ 'Prestigio', 'Multipad 2 Pro Quad 8.0 3G', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP7280C3G_DUO_PL_V1.xml'                              => [ 'Prestigio', 'Multipad 2 Ultra Duo 8.0 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP7280C3G_QUAD_V1.xml'                                => [ 'Prestigio', 'Multipad 2 Ultra Duo 8.0 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP7110D3G_V1.xml'                                     => [ 'Prestigio', 'Multipad 4 Diamond 10.1 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT7177_3G_V1.xml'                                     => [ 'Prestigio', 'Multipad 4 Diamond 10.1 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP7079D_QUAD_V1.xml'                                  => [ 'Prestigio', 'Multipad 4 Diamond 7.85', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP7079D3G_QUAD_V1.xml'                                => [ 'Prestigio', 'Multipad 4 Diamond 7.85 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP7079E3G_QUAD_V1.xml'                                => [ 'Prestigio', 'Multipad 4 Diamond 7.85 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT7077_3G_V1.xml'                                     => [ 'Prestigio', 'Multipad 4 Diamond 7.85 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP5101C3G_QUAD_V1.xml'                                => [ 'Prestigio', 'Multipad 4 Quantum 10.1 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP5101D3G_QUAD_V1.xml'                                => [ 'Prestigio', 'Multipad 4 Quantum 10.1 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP5785C3G_QUAD_V1.xml'                                => [ 'Prestigio', 'Multipad 4 Quantum 7.85 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT7287_3G_V1.xml'                                     => [ 'Prestigio', 'Multipad 4 Ultra Quad 8.0 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP7100D3G_QUAD_V1.xml'                                => [ 'Prestigio', 'Multipad 7100', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP7280D3G_QUAD_V1.xml'                                => [ 'Prestigio', 'Multipad 7280', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP7480D3G_QUAD_V1.xml'                                => [ 'Prestigio', 'Multipad 7480', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT5777_3G_V1.xml'                                     => [ 'Prestigio', 'Multipad Color 7.0 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT5887_3G_V1.xml'                                     => [ 'Prestigio', 'Multipad Color 8.0 3G', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT5001_3G_V1.xml'                                     => [ 'Prestigio', 'Multipad Muze 5001 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT5008_3G_V1.xml'                                     => [ 'Prestigio', 'Multipad Muze 5008 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT5487_3G_V1.xml'                                     => [ 'Prestigio', 'Multipad Quantum 8.0 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT3277_3G_V1.xml'                                     => [ 'Prestigio', 'Multipad Ranger 7.0 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT3287_3G_V1.xml'                                     => [ 'Prestigio', 'Multipad Ranger 8.0 3G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT5287_4G_V1.xml'                                     => [ 'Prestigio', 'Multipad Ranger 8.0 4G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT7077_4G_V1.xml'                                     => [ 'Prestigio', 'Multipad Ranger 8.0 4G', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP3007C_V1.xml'                                       => [ 'Prestigio', 'Multipad Rider 7.0', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMP3007C3G_V1.xml'                                     => [ 'Prestigio', 'Multipad Rider 7.0 3G', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT7787_3G_V1.xml'                                     => [ 'Prestigio', 'Multipad Thunder 8.0i', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT3057_3G_V1.xml'                                     => [ 'Prestigio', 'Multipad Wize 3057', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT3067_3G_V1.xml'                                     => [ 'Prestigio', 'Multipad Wize 3067', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/tablets/PMT5002_Wi_V1.xml'                                     => [ 'Prestigio', 'Multipad Wize 5002', 'Android', DeviceType::TABLET ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP3350DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 3350 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP3400DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 3400 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP3404DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 3404 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP3405DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 3405 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP3450DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 3450 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP3502DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 3502 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP3540DUO_Polcomtel_V1.xml'                       => [ 'Prestigio', 'Multiphone 3540 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP3540DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 3540 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP4044DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 4044 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP4055DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 4055 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP4322DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 4322 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP4500TDUO_V1.XML'                                => [ 'Prestigio', 'Multiphone 4500 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP5000DUO_V1.XML'                                 => [ 'Prestigio', 'Multiphone 5000 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP5000TDUO_V1.XML'                                => [ 'Prestigio', 'Multiphone 5000 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP5044DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 5044 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP5430_V1.xml'                                    => [ 'Prestigio', 'Multiphone 5430', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP5450DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 5450 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP5451DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 5451 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP5453DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 5453 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP5454DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 5454 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP5455_DUO_V1.xml'                                => [ 'Prestigio', 'Multiphone 5455 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP5500DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 5500 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP5501_V1.xml'                                    => [ 'Prestigio', 'Multiphone 5501', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP5504DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 5504 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP5505DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 5505 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP5507DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 5507 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP5508DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 5508 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP5517DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 5517 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP5550DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 5550 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP7500_V1.xml'                                    => [ 'Prestigio', 'Multiphone 7500', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PAP7600DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone 7600 Duo', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP3455DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone Grace X3', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP5470DUO_V1.xml'                                 => [ 'Prestigio', 'Multiphone Grace X5', 'Android', DeviceType::MOBILE ],
    'http://wap.dl.prestigio.com/uaprofile/smartphones/PSP3452DUO_V1.xml'                                 => [ 'Prestigio', 'Muze A3', 'Android', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/Unknown_80211g/7.1.0.rdf'                        => [ 'RIM', 'BlackBerry', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/Unknown_evdo/7.1.0.rdf'                          => [ 'RIM', 'BlackBerry', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/5810/3.2.1.rdf'                                  => [ 'RIM', 'BlackBerry 5810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/5810/3.3.0.rdf'                                  => [ 'RIM', 'BlackBerry 5810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/5810/3.3.1.rdf'                                  => [ 'RIM', 'BlackBerry 5810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/5810/3.6.0.rdf'                                  => [ 'RIM', 'BlackBerry 5810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/5810/3.6.1.rdf'                                  => [ 'RIM', 'BlackBerry 5810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/5810/3.7.0.rdf'                                  => [ 'RIM', 'BlackBerry 5810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/5810/3.7.1.rdf'                                  => [ 'RIM', 'BlackBerry 5810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/5810/3.7.2.rdf'                                  => [ 'RIM', 'BlackBerry 5810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/5810/3.7.3.rdf'                                  => [ 'RIM', 'BlackBerry 5810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6210/3.2.1.rdf'                                  => [ 'RIM', 'BlackBerry 6210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6210/3.3.0.rdf'                                  => [ 'RIM', 'BlackBerry 6210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6210/3.3.1.rdf'                                  => [ 'RIM', 'BlackBerry 6210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6210/3.6.0.rdf'                                  => [ 'RIM', 'BlackBerry 6210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6210/3.6.1.rdf'                                  => [ 'RIM', 'BlackBerry 6210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6210/3.7.0.rdf'                                  => [ 'RIM', 'BlackBerry 6210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6210/3.7.1.rdf'                                  => [ 'RIM', 'BlackBerry 6210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6210/3.7.2.rdf'                                  => [ 'RIM', 'BlackBerry 6210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6210/3.7.3.rdf'                                  => [ 'RIM', 'BlackBerry 6210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6230/3.2.1.rdf'                                  => [ 'RIM', 'BlackBerry 6230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6230/3.3.0.rdf'                                  => [ 'RIM', 'BlackBerry 6230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6230/3.3.1.rdf'                                  => [ 'RIM', 'BlackBerry 6230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6230/3.6.0.rdf'                                  => [ 'RIM', 'BlackBerry 6230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6230/3.6.1.rdf'                                  => [ 'RIM', 'BlackBerry 6230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6230/3.7.0.rdf'                                  => [ 'RIM', 'BlackBerry 6230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6230/3.7.1.rdf'                                  => [ 'RIM', 'BlackBerry 6230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6230/3.7.2.rdf'                                  => [ 'RIM', 'BlackBerry 6230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6230/3.7.3.rdf'                                  => [ 'RIM', 'BlackBerry 6230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6280/3.2.1.rdf'                                  => [ 'RIM', 'BlackBerry 6280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6280/3.3.0.rdf'                                  => [ 'RIM', 'BlackBerry 6280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6280/3.3.1.rdf'                                  => [ 'RIM', 'BlackBerry 6280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6280/3.6.0.rdf'                                  => [ 'RIM', 'BlackBerry 6280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6280/3.6.1.rdf'                                  => [ 'RIM', 'BlackBerry 6280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6280/3.7.0.rdf'                                  => [ 'RIM', 'BlackBerry 6280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6280/3.7.1.rdf'                                  => [ 'RIM', 'BlackBerry 6280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6280/3.7.2.rdf'                                  => [ 'RIM', 'BlackBerry 6280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6280/3.7.3.rdf'                                  => [ 'RIM', 'BlackBerry 6280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6510/3.2.1.rdf'                                  => [ 'RIM', 'BlackBerry 6510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6510/3.3.0.rdf'                                  => [ 'RIM', 'BlackBerry 6510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6510/3.3.1.rdf'                                  => [ 'RIM', 'BlackBerry 6510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6510/3.6.0.rdf'                                  => [ 'RIM', 'BlackBerry 6510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6510/3.6.1.rdf'                                  => [ 'RIM', 'BlackBerry 6510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6510/3.7.0.rdf'                                  => [ 'RIM', 'BlackBerry 6510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6510/3.7.1.rdf'                                  => [ 'RIM', 'BlackBerry 6510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6510/3.7.2.rdf'                                  => [ 'RIM', 'BlackBerry 6510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6510/3.7.3.rdf'                                  => [ 'RIM', 'BlackBerry 6510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6710/3.2.1.rdf'                                  => [ 'RIM', 'BlackBerry 6710', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6710/3.3.0.rdf'                                  => [ 'RIM', 'BlackBerry 6710', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6710/3.3.1.rdf'                                  => [ 'RIM', 'BlackBerry 6710', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6710/3.6.0.rdf'                                  => [ 'RIM', 'BlackBerry 6710', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6710/3.6.1.rdf'                                  => [ 'RIM', 'BlackBerry 6710', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6710/3.7.0.rdf'                                  => [ 'RIM', 'BlackBerry 6710', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6710/3.7.1.rdf'                                  => [ 'RIM', 'BlackBerry 6710', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6710/3.7.2.rdf'                                  => [ 'RIM', 'BlackBerry 6710', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6710/3.7.3.rdf'                                  => [ 'RIM', 'BlackBerry 6710', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6750/3.2.1.rdf'                                  => [ 'RIM', 'BlackBerry 6750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6750/3.3.0.rdf'                                  => [ 'RIM', 'BlackBerry 6750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6750/3.3.1.rdf'                                  => [ 'RIM', 'BlackBerry 6750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6750/3.6.0.rdf'                                  => [ 'RIM', 'BlackBerry 6750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6750/3.6.1.rdf'                                  => [ 'RIM', 'BlackBerry 6750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6750/3.7.0.rdf'                                  => [ 'RIM', 'BlackBerry 6750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6750/3.7.1.rdf'                                  => [ 'RIM', 'BlackBerry 6750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6750/3.7.2.rdf'                                  => [ 'RIM', 'BlackBerry 6750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/6750/3.7.3.rdf'                                  => [ 'RIM', 'BlackBerry 6750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7210/3.2.1.rdf'                                  => [ 'RIM', 'BlackBerry 7210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7210/3.3.0.rdf'                                  => [ 'RIM', 'BlackBerry 7210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7210/3.3.1.rdf'                                  => [ 'RIM', 'BlackBerry 7210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7210/3.6.0.rdf'                                  => [ 'RIM', 'BlackBerry 7210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7210/3.6.1.rdf'                                  => [ 'RIM', 'BlackBerry 7210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7210/3.7.0.rdf'                                  => [ 'RIM', 'BlackBerry 7210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7210/3.7.1.rdf'                                  => [ 'RIM', 'BlackBerry 7210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7210/3.7.2.rdf'                                  => [ 'RIM', 'BlackBerry 7210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7210/3.7.3.rdf'                                  => [ 'RIM', 'BlackBerry 7210', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7230/3.2.1.rdf'                                  => [ 'RIM', 'BlackBerry 7230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7230/3.3.0.rdf'                                  => [ 'RIM', 'BlackBerry 7230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7230/3.3.1.rdf'                                  => [ 'RIM', 'BlackBerry 7230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7230/3.6.0.rdf'                                  => [ 'RIM', 'BlackBerry 7230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7230/3.6.1.rdf'                                  => [ 'RIM', 'BlackBerry 7230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7230/3.7.0.rdf'                                  => [ 'RIM', 'BlackBerry 7230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7230/3.7.1.rdf'                                  => [ 'RIM', 'BlackBerry 7230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7230/3.7.2.rdf'                                  => [ 'RIM', 'BlackBerry 7230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7230/3.7.3.rdf'                                  => [ 'RIM', 'BlackBerry 7230', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7280/3.2.1.rdf'                                  => [ 'RIM', 'BlackBerry 7280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7280/3.3.0.rdf'                                  => [ 'RIM', 'BlackBerry 7280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7280/3.3.1.rdf'                                  => [ 'RIM', 'BlackBerry 7280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7280/3.6.0.rdf'                                  => [ 'RIM', 'BlackBerry 7280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7280/3.6.1.rdf'                                  => [ 'RIM', 'BlackBerry 7280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7280/3.7.0.rdf'                                  => [ 'RIM', 'BlackBerry 7280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7280/3.7.1.rdf'                                  => [ 'RIM', 'BlackBerry 7280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7280/3.7.2.rdf'                                  => [ 'RIM', 'BlackBerry 7280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7280/3.7.3.rdf'                                  => [ 'RIM', 'BlackBerry 7280', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7510/3.2.1.rdf'                                  => [ 'RIM', 'BlackBerry 7510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7510/3.3.0.rdf'                                  => [ 'RIM', 'BlackBerry 7510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7510/3.3.1.rdf'                                  => [ 'RIM', 'BlackBerry 7510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7510/3.6.0.rdf'                                  => [ 'RIM', 'BlackBerry 7510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7510/3.6.1.rdf'                                  => [ 'RIM', 'BlackBerry 7510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7510/3.7.0.rdf'                                  => [ 'RIM', 'BlackBerry 7510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7510/3.7.1.rdf'                                  => [ 'RIM', 'BlackBerry 7510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7510/3.7.2.rdf'                                  => [ 'RIM', 'BlackBerry 7510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7510/3.7.3.rdf'                                  => [ 'RIM', 'BlackBerry 7510', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7730/3.2.1.rdf'                                  => [ 'RIM', 'BlackBerry 7730', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7730/3.3.0.rdf'                                  => [ 'RIM', 'BlackBerry 7730', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7730/3.3.1.rdf'                                  => [ 'RIM', 'BlackBerry 7730', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7730/3.6.0.rdf'                                  => [ 'RIM', 'BlackBerry 7730', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7730/3.6.1.rdf'                                  => [ 'RIM', 'BlackBerry 7730', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7730/3.7.0.rdf'                                  => [ 'RIM', 'BlackBerry 7730', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7730/3.7.1.rdf'                                  => [ 'RIM', 'BlackBerry 7730', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7730/3.7.2.rdf'                                  => [ 'RIM', 'BlackBerry 7730', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7730/3.7.3.rdf'                                  => [ 'RIM', 'BlackBerry 7730', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7750/3.2.1.rdf'                                  => [ 'RIM', 'BlackBerry 7750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7750/3.3.0.rdf'                                  => [ 'RIM', 'BlackBerry 7750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7750/3.3.1.rdf'                                  => [ 'RIM', 'BlackBerry 7750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7750/3.6.0.rdf'                                  => [ 'RIM', 'BlackBerry 7750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7750/3.6.1.rdf'                                  => [ 'RIM', 'BlackBerry 7750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7750/3.7.0.rdf'                                  => [ 'RIM', 'BlackBerry 7750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7750/3.7.1.rdf'                                  => [ 'RIM', 'BlackBerry 7750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7750/3.7.2.rdf'                                  => [ 'RIM', 'BlackBerry 7750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/7750/3.7.3.rdf'                                  => [ 'RIM', 'BlackBerry 7750', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8500_edge/4.6.1.rdf'                             => [ 'RIM', 'BlackBerry 8500', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8707/4.2.2.rdf'                                  => [ 'RIM', 'BlackBerry 8707', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8800/4.2.1.rdf'                                  => [ 'RIM', 'BlackBerry 8800', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8820/4.2.2.rdf'                                  => [ 'RIM', 'BlackBerry 8820', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8820/4.5.0.rdf'                                  => [ 'RIM', 'BlackBerry 8820', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8830/4.2.2.rdf'                                  => [ 'RIM', 'BlackBerry 8830', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9315_edge/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry 9315', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9570_80211g/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry 9570', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9620_80211g/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry 9620', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9620_edge/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry 9620', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9620_umts/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry 9620', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9720/7.1.0.rdf'                                  => [ 'RIM', 'BlackBerry 9720', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9720_80211g/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry 9720', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9720_edge/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry 9720', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9720_gprs/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry 9720', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9720_umts/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry 9720', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9000/4.6.0.rdf'                                  => [ 'RIM', 'BlackBerry Bold 9000', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9000/5.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Bold 9000', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9000_80211a/5.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9000', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9000_80211b/5.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9000', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9000_80211g/4.6.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9000', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9000_80211g/5.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9000', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9000_edge/4.6.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9000', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9000_edge/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9000', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9000_umts/4.6.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9000', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9000_umts/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9000', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/RIM/BlackBerry9650/6.0.0.706.rdf'                                        => [ 'RIM', 'BlackBerry Bold 9650', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/RIM/BlackBerry9650/6.0.0.723.rdf'                                        => [ 'RIM', 'BlackBerry Bold 9650', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9650/6.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Bold 9650', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9650_1x/6.0.0.rdf'                               => [ 'RIM', 'BlackBerry Bold 9650', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9650_80211g/5.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9650', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9650_80211g/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9650', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9650_edge/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9650', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9650_edge/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9650', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9650_evdo/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9650', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9650_evdo/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9650', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9650_umts/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9650', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9650_umts/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9650', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9700/5.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Bold 9700', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9700/6.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Bold 9700', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9700_80211b/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9700', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9700_80211g/5.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9700', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9700_80211g/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9700', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9700_edge/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9700', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9700_edge/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9700', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9700_gprs/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9700', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9700_gprs/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9700', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9700_umts/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9700', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9700_umts/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9700', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9780/6.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Bold 9780', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9780_80211b/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9780', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9780_80211g/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9780', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9780_edge/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9780', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9780_gprs/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9780', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9780_umts/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9780', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9780_usb/6.0.0.rdf'                              => [ 'RIM', 'BlackBerry Bold 9780', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9788_80211g/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9788', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9788_edge/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9788', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9790/7.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Bold 9790', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9790/7.1.0.rdf'                                  => [ 'RIM', 'BlackBerry Bold 9790', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9790_80211a/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9790', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9790_80211g/7.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9790', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9790_80211g/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9790', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9790_edge/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9790', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9790_edge/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9790', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9790_gprs/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9790', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9790_gprs/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9790', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9790_umts/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9790', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9790_umts/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9790', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9790_usb/7.0.0.rdf'                              => [ 'RIM', 'BlackBerry Bold 9790', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9900/7.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Bold 9900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9900/7.1.0.rdf'                                  => [ 'RIM', 'BlackBerry Bold 9900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9900_80211a/7.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9900_80211a/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9900_80211g/7.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9900_80211g/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9900_edge/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9900_edge/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9900_gprs/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9900_gprs/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9900_umts/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9900_umts/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9900_usb/7.1.0.rdf'                              => [ 'RIM', 'BlackBerry Bold 9900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/RIM/BlackBerry9930/7.1.0.1066.rdf'                                       => [ 'RIM', 'BlackBerry Bold 9930', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9930_1x/7.0.0.rdf'                               => [ 'RIM', 'BlackBerry Bold 9930', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9930_1x/7.1.0.rdf'                               => [ 'RIM', 'BlackBerry Bold 9930', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9930_80211a/7.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9930', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9930_80211a/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9930', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9930_80211g/7.0.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9930', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9930_80211g/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Bold 9930', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9930_edge/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9930', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9930_edge/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9930', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9930_evdo/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9930', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9930_evdo/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9930', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9930_gprs/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9930', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9930_umts/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9930', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9930_umts/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Bold 9930', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8300/4.5.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 8300', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8310/4.2.2.rdf'                                  => [ 'RIM', 'BlackBerry Curve 8310', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8330/4.3.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 8330', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8350i_80211g/5.0.0.rdf'                          => [ 'RIM', 'BlackBerry Curve 8350', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8520/5.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 8520', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8520_80211b/5.0.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 8520', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8520_80211g/4.6.1.rdf'                           => [ 'RIM', 'BlackBerry Curve 8520', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8520_80211g/5.0.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 8520', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8520_edge/4.6.1.rdf'                             => [ 'RIM', 'BlackBerry Curve 8520', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8520_edge/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 8520', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8520_gprs/4.6.1.rdf'                             => [ 'RIM', 'BlackBerry Curve 8520', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8520_gprs/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 8520', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8520_usb/5.0.0.rdf'                              => [ 'RIM', 'BlackBerry Curve 8520', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/RIM/BlackBerry8530/5.0.0.1000.rdf'                                       => [ 'RIM', 'BlackBerry Curve 8530', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/RIM/BlackBerry8530/5.0.0.1030.rdf'                                       => [ 'RIM', 'BlackBerry Curve 8530', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/RIM/BlackBerry8530/5.0.0.654.rdf'                                        => [ 'RIM', 'BlackBerry Curve 8530', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/RIM/BlackBerry8530/5.0.0.973.rdf'                                        => [ 'RIM', 'BlackBerry Curve 8530', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8530/5.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 8530', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8530_1x/5.0.0.rdf'                               => [ 'RIM', 'BlackBerry Curve 8530', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8530_80211g/5.0.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 8530', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8530_evdo/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 8530', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8900/5.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 8900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8900_80211g/4.6.1.rdf'                           => [ 'RIM', 'BlackBerry Curve 8900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8900_80211g/5.0.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 8900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8900_edge/4.6.1.rdf'                             => [ 'RIM', 'BlackBerry Curve 8900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8900_edge/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 8900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8900_gprs/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 8900', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9220/7.1.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 9220', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9220_80211g/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9220', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9220_edge/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9220', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9220_gprs/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9220', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9300/5.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 9300', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9300/6.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 9300', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9300_80211b/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9300', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9300_80211g/5.0.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9300', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9300_80211g/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9300', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9300_edge/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9300', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9300_edge/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9300', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9300_gprs/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9300', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9300_umts/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9300', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9300_umts/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9300', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9310/7.1.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 9310', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9310_80211g/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9310', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9310_evdo/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9310', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9315_80211g/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9315', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9315_umts/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9315', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9320/7.1.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 9320', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9320_80211g/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9320', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9320_edge/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9320', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9320_gprs/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9320', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9320_umts/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9320', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9320_usb/7.1.0.rdf'                              => [ 'RIM', 'BlackBerry Curve 9320', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/RIM/BlackBerry9330/6.0.0.707.rdf'                                        => [ 'RIM', 'BlackBerry Curve 9330', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9330/5.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 9330', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9330/6.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 9330', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9330_1x/6.0.0.rdf'                               => [ 'RIM', 'BlackBerry Curve 9330', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9330_80211g/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9330', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9330_evdo/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9330', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9330_evdo/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9330', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/RIM/BlackBerry9350/7.1.0.580.rdf'                                        => [ 'RIM', 'BlackBerry Curve 9350', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/RIM/BlackBerry9350/7.1.0.714.rdf'                                        => [ 'RIM', 'BlackBerry Curve 9350', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/RIM/BlackBerry9350/7.1.0.861.rdf'                                        => [ 'RIM', 'BlackBerry Curve 9350', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9350_1x/7.1.0.rdf'                               => [ 'RIM', 'BlackBerry Curve 9350', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9350_80211g/7.0.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9350', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9350_80211g/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9350', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9350_evdo/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9350', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9350_evdo/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9350', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9360/7.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 9360', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9360/7.1.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 9360', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9360_80211g/7.0.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9360', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9360_80211g/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9360', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9360_edge/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9360', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9360_edge/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9360', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9360_gprs/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9360', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9360_gprs/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9360', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9360_umts/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9360', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9360_umts/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9360', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9360_usb/7.1.0.rdf'                              => [ 'RIM', 'BlackBerry Curve 9360', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9370_1x/7.1.0.rdf'                               => [ 'RIM', 'BlackBerry Curve 9370', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9370_80211g/7.0.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9370', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9370_80211g/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9370', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9370_edge/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9370', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9370_evdo/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9370', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9370_evdo/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9370', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9380/7.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 9380', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9380/7.1.0.rdf'                                  => [ 'RIM', 'BlackBerry Curve 9380', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9380_80211g/7.0.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9380', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9380_80211g/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Curve 9380', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9380_edge/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9380', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9380_edge/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9380', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9380_gprs/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9380', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9380_gprs/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9380', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9380_umts/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9380', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9380_umts/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Curve 9380', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8100/4.2.1.rdf'                                  => [ 'RIM', 'BlackBerry Pearl 8100', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8120/4.3.0.rdf'                                  => [ 'RIM', 'BlackBerry Pearl 8120', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8220_80211g/4.6.0.rdf'                           => [ 'RIM', 'BlackBerry Pearl 8220', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9100/4.6.0.rdf'                                  => [ 'RIM', 'BlackBerry Pearl 9100', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9100_80211g/5.0.0.rdf'                           => [ 'RIM', 'BlackBerry Pearl 9100', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9100_80211g/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry Pearl 9100', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9100_edge/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Pearl 9100', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9100_umts/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Pearl 9100', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9105/5.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Pearl 9105', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9105/6.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Pearl 9105', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9105_80211g/5.0.0.rdf'                           => [ 'RIM', 'BlackBerry Pearl 9105', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9105_80211g/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry Pearl 9105', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9105_edge/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Pearl 9105', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9105_edge/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Pearl 9105', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9105_umts/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Pearl 9105', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9105_umts/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Pearl 9105', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/8220_edge/4.6.0.rdf'                             => [ 'RIM', 'BlackBerry Pearl Flip 8220', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9981_80211g/7.0.0.rdf'                           => [ 'RIM', 'BlackBerry Porsche P 9981', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9981_80211g/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Porsche P 9981', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9981_edge/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Porsche P 9981', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9981_edge/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Porsche P 9981', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9981_gprs/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Porsche P 9981', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9981_umts/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Porsche P 9981', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9981_umts/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Porsche P 9981', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9500/5.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Storm 9500', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9500_edge/4.7.0.rdf'                             => [ 'RIM', 'BlackBerry Storm 9500', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9500_edge/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Storm 9500', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9500_umts/4.7.0.rdf'                             => [ 'RIM', 'BlackBerry Storm 9500', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9500_umts/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Storm 9500', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9530_edge/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Storm 9530', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9530_evdo/4.6.0.rdf'                             => [ 'RIM', 'BlackBerry Storm 9530', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9530_evdo/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Storm 9530', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9530_gprs/4.7.0.rdf'                             => [ 'RIM', 'BlackBerry Storm 9530', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9530_umts/4.7.0.rdf'                             => [ 'RIM', 'BlackBerry Storm 9530', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9530_umts/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Storm 9530', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9550/5.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Storm 9550', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9550_80211g/5.0.0.rdf'                           => [ 'RIM', 'BlackBerry Storm 9550', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9550_edge/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Storm 9550', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9550_evdo/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Storm 9550', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9550_umts/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Storm 9550', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9520/5.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Storm2 9520', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9520_80211g/5.0.0.rdf'                           => [ 'RIM', 'BlackBerry Storm2 9520', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9520_edge/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Storm2 9520', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9520_gprs/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Storm2 9520', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9520_umts/5.0.0.rdf'                             => [ 'RIM', 'BlackBerry Storm2 9520', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/RIM/BlackBerry9670/6.0.0.706.rdf'                                        => [ 'RIM', 'BlackBerry Style 9670', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/RIM/BlackBerry9670/6.0.0.707.rdf'                                        => [ 'RIM', 'BlackBerry Style 9670', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9670/6.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Style 9670', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9670_1x/6.0.0.rdf'                               => [ 'RIM', 'BlackBerry Style 9670', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9670_80211b/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry Style 9670', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9670_80211g/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry Style 9670', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9670_evdo/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Style 9670', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9800/6.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Torch 9800', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9800_80211b/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry Torch 9800', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9800_80211g/6.0.0.rdf'                           => [ 'RIM', 'BlackBerry Torch 9800', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9800_edge/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Torch 9800', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9800_gprs/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Torch 9800', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9800_umts/6.0.0.rdf'                             => [ 'RIM', 'BlackBerry Torch 9800', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9800_usb/6.0.0.rdf'                              => [ 'RIM', 'BlackBerry Torch 9800', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9810/7.0.0.rdf'                                  => [ 'RIM', 'BlackBerry Torch 9810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9810/7.1.0.rdf'                                  => [ 'RIM', 'BlackBerry Torch 9810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9810_80211g/6.1.0.rdf'                           => [ 'RIM', 'BlackBerry Torch 9810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9810_80211g/7.0.0.rdf'                           => [ 'RIM', 'BlackBerry Torch 9810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9810_80211g/7.1.0.rdf'                           => [ 'RIM', 'BlackBerry Torch 9810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9810_edge/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Torch 9810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9810_edge/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Torch 9810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9810_gprs/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Torch 9810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9810_gprs/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Torch 9810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9810_umts/7.0.0.rdf'                             => [ 'RIM', 'BlackBerry Torch 9810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9810_umts/7.1.0.rdf'                             => [ 'RIM', 'BlackBerry Torch 9810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9810_usb/7.1.0.rdf'                              => [ 'RIM', 'BlackBerry Torch 9810', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://device.sprintpcs.com/RIM/BlackBerry9850/7.1.0.580.rdf'                                        => [ 'RIM', 'BlackBerry Torch 9850', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9850_1x/7.1.0.rdf'                               => [ 'RIM', 'BlackBerry Torch 9850', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9850_80211g/7.0.0.rdf'                           => [ 'RIM', 'BlackBerry Torch 9850', 'BlackBerry OS', DeviceType::MOBILE ],
    'http://www.blackberry.net/go/mobile/profiles/uaprof/9850