#!/usr/bin/env php
<?php
declare(strict_types=1);
$root = dirname(__DIR__);
require_once $root . '/core.php';

$options = getopt('', ['csv:']);
$csvPath = $options['csv'] ?? null;
if (!$csvPath || !file_exists($csvPath)) {
  fwrite(STDERR, "Uso: php cli/import_cities_br.php --csv=/caminho/cities.csv\n");
  exit(1);
}

$pdo = $connect;
$pdo->exec("CREATE TABLE IF NOT EXISTS `cities_br` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `name` VARCHAR(128) NOT NULL,
  `uf`   CHAR(2)      NOT NULL,
  `lat`  DECIMAL(9,6) NOT NULL,
  `lng`  DECIMAL(9,6) NOT NULL,
  UNIQUE KEY `uniq_name_uf` (`name`,`uf`),
  KEY `idx_uf` (`uf`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

$st = $pdo->prepare("INSERT INTO cities_br (name, uf, lat, lng)
                     VALUES (:name, :uf, :lat, :lng)
                     ON DUPLICATE KEY UPDATE lat=VALUES(lat), lng=VALUES(lng)");

if (($fh = fopen($csvPath, 'r')) === false) { exit("Falha ao abrir $csvPath\n"); }
$header = fgetcsv($fh, 0, ','); // pula cabeçalho
$cnt = 0;
while (($row = fgetcsv($fh, 0, ',')) !== false) {
  if (count($row) < 4) continue;
  $name = trim($row[0]); $uf = strtoupper(trim($row[1]));
  $lat = (float)$row[2];  $lng = (float)$row[3];
  if ($name === '' || $uf === '' || !$lat || !$lng) continue;
  $st->execute([':name'=>$name, ':uf'=>$uf, ':lat'=>$lat, ':lng'=>$lng]);
  $cnt++;
}
fclose($fh);
echo "Importados $cnt registros em cities_br.\n";
