<?php

declare(strict_types=1);
// === ND Helpers Loader (guarded) ===
$___h_candidates = [
    __DIR__ . '/app/Support/helpers.php',
    // if this bootstrap sits in a subfolder:
    dirname(__DIR__) . '/app/Support/helpers.php',
    // fallback if only 'Support/helpers.php' got uploaded to project root
    __DIR__ . '/Support/helpers.php',
];
$___loaded = false;
foreach ($___h_candidates as $___h) {
    if (is_file($___h)) {
        require_once $___h;
        $___loaded = true;
        break;
    }
}
if (!$___loaded) {
    trigger_error('ND Helpers not found (tried: ' . implode(', ', $___h_candidates) . ')', E_USER_WARNING);
}
// === /ND Helpers Loader ===

?>
<?php
/**
 * Runtime compatibility shim for PHP 8.2+ (works on 8.3 and 8.4)
 * - Centralizes error reporting and deprecation handling
 * - Silences known noisy 8.2 dynamic property deprecations coming from third-party libs
 * - Normalizes encoding
 * - Ensures Intl IDN functions fallback cleanly if extension is missing
 */

// Encoding & locale
if (function_exists('mb_internal_encoding')) {
    @mb_internal_encoding('UTF-8');
}
if (function_exists('mb_http_output')) {
    @mb_http_output('UTF-8');
}

// Only change error reporting if not already configured by the host
if (!defined('GADGETZA_ERROR_CONFIGURED')) {
    // Show all but deprecations/notices in production-like mode.
    // You can override this by defining GADGETZA_ERROR_CONFIGURED earlier.
    @ini_set('display_errors', '0');
    @ini_set('log_errors', '1');
    @ini_set('error_log', __DIR__ . '/../storage/logs/php-error.log');
    error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
}

// Convert specific 8.2 deprecations to logs (avoid breaking flow)
set_error_handler(function ($errno, $errstr, $errfile = '', $errline = 0) {
    if ($errno === E_DEPRECATED) {
        // Dynamic properties (PHP 8.2)
        if (stripos($errstr ?? '', 'Creation of dynamic property') !== false) {
            // swallow but keep a trace in error log
            error_log("[DEPRECATED suppressed] {$errstr} in {$errfile}:{$errline}");
            return true;
        }
        // Other vendor deprecations that are safe to ignore at runtime
        if (stripos($errstr ?? '', 'Passing null to parameter') !== false) {
            error_log("[DEPRECATED suppressed] {$errstr} in {$errfile}:{$errline}");
            return true;
        }
    }
    return false; // default handling
}, E_DEPRECATED);

// Provide safe fallbacks if ext/intl IDN functions are missing (some hosts)
if (!function_exists('idn_to_ascii')) {
    function idn_to_ascii($domain, $flags = 0, $variant = INTL_IDNA_VARIANT_UTS46, &$info = []) {
        // naive fallback: return as-is; upstream libs handle validation
        return $domain;
    }
}
if (!function_exists('idn_to_utf8')) {
    function idn_to_utf8($domain, $flags = 0, $variant = INTL_IDNA_VARIANT_UTS46, &$info = []) {
        return $domain;
    }
}

// Ensure session cookies are secure by default
if (PHP_SAPI !== 'cli') {
    @ini_set('session.cookie_httponly', '1');
    @ini_set('session.use_strict_mode', '1');
    @ini_set('session.cookie_samesite', 'Lax');
}
