<?php
declare(strict_types=1);

/**
 * ND Helpers Loader (guarded)
 */
$___h_candidates = [
    __DIR__ . '/app/Support/helpers.php',
    dirname(__DIR__) . '/app/Support/helpers.php', // se este bootstrap estiver em subpasta
    __DIR__ . '/Support/helpers.php',              // fallback se fizer upload de Support/ na raiz
];
$___loaded = false;
foreach ($___h_candidates as $___h) {
    if (is_file($___h)) {
        require_once $___h;
        $___loaded = true;
        break;
    }
}
if (!$___loaded) {
    trigger_error('ND Helpers not found (tried: ' . implode(', ', $___h_candidates) . ')', E_USER_WARNING);
}

/**
 * ND env load
 */
if (file_exists(__DIR__ . '/vendor/autoload.php')) {
    require_once __DIR__ . '/vendor/autoload.php';
}
if (class_exists('Dotenv\\Dotenv')) {
    $dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
    $dotenv->load();
}
if (function_exists('nd_security_headers')) { nd_security_headers(); }
if (function_exists('ini_set')) { @ini_set('display_errors', '0'); }

/**
 * Helper para definir constantes sem redefinir
 */
if (!function_exists('nd_define')) {
    function nd_define(string $name, $value): void {
        if (!defined($name)) {
            define($name, $value);
        }
    }
}

/**
 * URL / Idioma
 */
nd_define('APP_LANG', 'pt-br');
nd_define('SITE_URL', 'https://conecta.ndmidia.com.br');

/**
 * WHATSAPP BUSINESS API (opcional)
 *
 * Configure estas constantes para habilitar notificações automáticas
 * para comerciantes quando novos cupons forem criados.
 *
 * Recomenda-se definir valores reais via variáveis de ambiente ou
 * ajustar diretamente aqui conforme seu ambiente.
 */
nd_define('WHATSAPP_API_ENABLED', false);
nd_define('WHATSAPP_API_VERSION', 'v20.0');
nd_define('WHATSAPP_PHONE_NUMBER_ID', '');
nd_define('WHATSAPP_ACCESS_TOKEN', '');
nd_define('WHATSAPP_DEFAULT_COUNTRY_CODE', '55');
nd_define('WHATSAPP_DEBUG_LOG', true);


/**
 * 2FA CONFIG
 * Gere uma chave aleatria de 32 bytes em base64:
 *   base64_encode(random_bytes(32))
 */
nd_define('APP_2FA_ENCRYPTION_KEY_B64', '2/tVCvG3JE2Xiun5X7vmGCIB8KLEhtBZFOd/LXtDFcs=');
nd_define('APP_2FA_HMAC_KEY_B64',       'jc9R4ShYMNoc8r41m+b0BK/4cBYb79TFKCHvUk0I9wQ=');
nd_define('APP_2FA_COOKIE_NAME',        'nd2fa');
nd_define('APP_2FA_COOKIE_TTL_DAYS',    30);

/**
 * Compensa0400o de deriva de relgio para TOTP (em segundos)
 * Servidor ADIANTADO ~2s  => use -2
 */
nd_define('APP_TOTP_DRIFT_SEC', -2);

/**
 * Nome do aplicativo para o TOTP (aparece como issuer no QR)
 */
nd_define('APP_NAME_FOR_TOTP', 'Conecta ND Midia');

/**
 * DATABASE CONFIG
 * (mantido como variveis  ok repetir)
 */
$database = [
    'host' => 'localhost',
    'db'   => 'ndmidia_conecta',
    'user' => 'ndmidia_conecta',
    'pass' => '^)E[Z!Z][V=RCcEY',
];

/**
 * SITE CONFIG
 */
$site_config = [
    'default_radius_km' => 30,
    'featured_items'    => 10,
    'exclusive_items'   => 10,
    'featured_stores'   => 10,
    'featured_locations'=> 10,
    'latest_items'      => 10,
    'reviews_page'      => 3,
    'search_default_per_page' => 9,
    'page_limit'        => 1000000,
];