<?php
// ND v13b — controllers/add-review.php
// Envia avaliação: exige usuário logado, grava como PENDENTE (verified=0).
// Trata ausência da coluna 'ip' com fallback automático.
// Saída JSON sempre.

declare(strict_types=1);
if (session_status() === PHP_SESSION_NONE) { session_start(); }
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

require_once __DIR__ . '/_nd_boot.php'; // precisa expor $pdo (PDO válido)
if (!isset($pdo) || !($pdo instanceof PDO)) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'message'=>'Configuração de banco ausente.']);
  exit;
}
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);

// Helpers
function s($v){ return trim((string)$v); }
function getParam($name){ return isset($_POST[$name]) ? s($_POST[$name]) : (isset($_GET[$name]) ? s($_GET[$name]) : ''); }

// Entrada
$item    = getParam('item');
$rating  = (int) (getParam('rating') !== '' ? getParam('rating') : 0);
$comment = getParam('comment');
if ($item === '' || $rating < 1 || $rating > 5) {
  http_response_code(422);
  echo json_encode(['ok'=>false,'message'=>'Dados inválidos.']);
  exit;
}

// Resolve user_id de múltiplas formas
$userId = 0;
$paths = [
  ['_SESSION','user_id'],
  ['_SESSION','uid'],
  ['_SESSION','user','user_id'],
  ['_SESSION','user','id'],
  ['_SESSION','auth','id'],
];
foreach ($paths as $path) {
  $ref = null;
  foreach ($path as $i=>$k) {
    if ($i===0){ $ref = ($k==='_SESSION') ? $_SESSION : (($k==='_COOKIE') ? $_COOKIE : null); continue; }
    if (!is_array($ref) || !array_key_exists($k,$ref)) { $ref = null; break; }
    $ref = $ref[$k];
  }
  if (is_numeric($ref) && (int)$ref > 0) { $userId = (int)$ref; break; }
}
if ($userId === 0) {
  $email = '';
  if (!empty($_SESSION['user_email'])) $email = $_SESSION['user_email'];
  elseif (!empty($_SESSION['user']['email'])) $email = $_SESSION['user']['email'];
  elseif (!empty($_COOKIE['user_email'])) $email = $_COOKIE['user_email'];
  elseif (!empty($_COOKIE['nd_user'])) {
    $d = json_decode($_COOKIE['nd_user'], true);
    if (is_array($d) && !empty($d['email'])) $email = $d['email'];
  }
  if ($email) {
    $stm = $pdo->prepare('SELECT user_id FROM users WHERE user_email = ? LIMIT 1');
    $stm->execute([$email]);
    $uid = (int)$stm->fetchColumn();
    if ($uid > 0) $userId = $uid;
  }
}
if ($userId === 0 && !empty($_COOKIE['user_id']) && ctype_digit($_COOKIE['user_id'])) {
  $userId = (int)$_COOKIE['user_id'];
}
if ($userId === 0) {
  http_response_code(401);
  echo json_encode(['ok'=>false,'message'=>'Faça login para enviar sua avaliação.']);
  exit;
}

// Evita duplicado (mesmo usuário no mesmo item)
try {
  $chk = $pdo->prepare('SELECT id FROM reviews WHERE item = ? AND `user` = ? LIMIT 1');
  $chk->execute([$item, $userId]);
  if ($chk->fetchColumn()) {
    echo json_encode(['ok'=>false,'message'=>'Você já avaliou esta oferta.']);
    exit;
  }
} catch (Throwable $e) {
  // Se a tabela/colunas diferirem, não derruba — apenas segue
}

// Inserção (verified=0 — pendente)
$ip = $_SERVER['HTTP_CF_CONNECTING_IP'] ?? $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'] ?? '';
try {
  $ins = $pdo->prepare('INSERT INTO reviews (item, `user`, ip, comment, rating, verified, status, created) VALUES (?, ?, ?, ?, ?, 0, 1, NOW())');
  $ins->execute([$item, $userId, $ip, $comment, (string)$rating]);
} catch (Throwable $e) {
  // Fallback sem coluna ip
  try {
    $ins = $pdo->prepare('INSERT INTO reviews (item, `user`, comment, rating, verified, status, created) VALUES (?, ?, ?, ?, 0, 1, NOW())');
    $ins->execute([$item, $userId, $comment, (string)$rating]);
  } catch (Throwable $e2) {
    http_response_code(500);
    if (function_exists('error_log')) @error_log('[add-review] '.$e->getMessage().' | '.$e2->getMessage());
    echo json_encode(['ok'=>false,'message'=>'Erro interno ao enviar avaliação.']);
    exit;
  }
}

echo json_encode(['ok'=>true,'message'=>'Avaliação enviada! Pendente de aprovação.']);
