<?php
// ND v14 — controllers/get-reviews.php
// Lista avaliações públicas com JOIN em users.
// Regras:
//   - Usa somente aprovadas (status=1) e **verificadas**;
//   - 'verificado' aceita formatos: 1, '1', 'true', 't', 'on', 'yes';
//   - Se a coluna 'verified' não existir, faz fallback para apenas status=1.

declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

require_once __DIR__ . '/_nd_boot.php';
if (!($pdo instanceof PDO)) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'message'=>'DB indisponível']);
  exit;
}
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);

$item = isset($_GET['item']) ? trim((string)$_GET['item']) : '';
if ($item === '') {
  echo json_encode(['stats'=>['avg'=>0,'count'=>0],'items'=>[]], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
  exit;
}

// helper: tenta query, senão cai para fallback
function qtry(PDO $pdo, string $sql, array $args){
  try{
    $st = $pdo->prepare($sql);
    $st->execute($args);
    return $st;
  }catch(Throwable $e){
    return null;
  }
}

$stats = ['avg'=>0,'count'=>0];
$items = [];

// 1) Stats com verified
$sqlStats = "SELECT COALESCE(AVG(rating),0) AS avg, COUNT(*) AS cnt
             FROM reviews WHERE item=? AND status=1
               AND (verified=1 OR verified='1' OR verified='true' OR verified='t' OR verified='on' OR verified='yes')";
$st = qtry($pdo, $sqlStats, [$item]);
if ($st === null){
  // Fallback: sem coluna verified
  $st = $pdo->prepare("SELECT COALESCE(AVG(rating),0) AS avg, COUNT(*) AS cnt
                       FROM reviews WHERE item=? AND status=1");
  $st->execute([$item]);
}
$row = $st->fetch() ?: ['avg'=>0,'cnt'=>0];
$stats = ['avg'=>(float)$row['avg'], 'count'=>(int)$row['cnt']];

// 2) Items com verified + JOIN users
$sqlItems = "SELECT r.id, r.item, r.`user`, r.rating, r.comment, r.created, u.*
             FROM reviews r
             LEFT JOIN users u ON u.user_id = r.`user`
             WHERE r.item=? AND r.status=1
               AND (r.verified=1 OR r.verified='1' OR r.verified='true' OR r.verified='t' OR r.verified='on' OR r.verified='yes')
             ORDER BY r.id DESC LIMIT 100";
$st2 = qtry($pdo, $sqlItems, [$item]);
if ($st2 === null){
  $st2 = $pdo->prepare("SELECT r.id, r.item, r.`user`, r.rating, r.comment, r.created, u.*
                        FROM reviews r
                        LEFT JOIN users u ON u.user_id = r.`user`
                        WHERE r.item=? AND r.status=1
                        ORDER BY r.id DESC LIMIT 100");
  $st2->execute([$item]);
}
while($r = $st2->fetch()){
  // map nome/email/avatar
  $uname=''; foreach(['full_name','name','username','user_name','first_name','display_name'] as $k){ if(!empty($r[$k])){ $uname=(string)$r[$k]; break; } }
  $uemail=''; foreach(['user_email','email'] as $k){ if(!empty($r[$k])){ $uemail=(string)$r[$k]; break; } }
  $uavatar=''; foreach(['avatar','photo','profile_image','image','picture','avatar_url'] as $k){ if(!empty($r[$k])){ $uavatar=(string)$r[$k]; break; } }

  $items[] = [
    'id'=>(int)$r['id'],
    'item'=>$r['item'],
    'user'=> isset($r['user']) ? (int)$r['user'] : null,
    'rating'=>(int)$r['rating'],
    'comment'=>(string)$r['comment'],
    'created'=>(string)$r['created'],
    'user_name'=>$uname,
    'user_email'=>$uemail,
    'user_avatar'=>$uavatar
  ];
}

echo json_encode(['stats'=>$stats,'items'=>$items], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
