<?php

declare(strict_types=1);

// ND - Endpoint leve para registrar "resgate" ao copiar cupom
// e notificar o comerciante via WhatsApp (opcional).
//
// Este arquivo foi pensado para ser nÃ£o-invasivo:
// - Se WhatsApp nÃ£o estiver configurado, o envio Ã© ignorado.
// - Se ocorrer erro de BD ou escrita de log, o endpoint ainda responde.

require_once __DIR__ . '/../core.php';

header('Content-Type: application/json; charset=UTF-8');

$payload = [];

// 1) Tenta ler JSON
$raw = file_get_contents('php://input');
if ($raw) {
    $json = json_decode($raw, true);
    if (is_array($json)) {
        $payload = $json;
    }
}

// 2) Fallback: POST normal
if (empty($payload) && !empty($_POST)) {
    $payload = $_POST;
}

$dealId = (int)($payload['deal_id'] ?? 0);
$couponCode = trim((string)($payload['coupon_code'] ?? ''));
$couponTitle = isset($payload['coupon_title']) ? trim((string)$payload['coupon_title']) : null;

$response = [
    'ok' => false,
    'notified' => false,
    'skipped' => false,
    'reason' => null,
];

if ($dealId <= 0 || $couponCode === '') {
    $response['skipped'] = true;
    $response['reason'] = 'invalid_payload';
    echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

// Log simples em arquivo (sem depender de schema do banco)
try {
    $logDir = __DIR__ . '/logs/nd_coupons';
    if (!is_dir($logDir)) {
        @mkdir($logDir, 0775, true);
    }

    $ui = null;
    try {
        if (function_exists('getUserInfo') && isLogged()) {
            $ui = getUserInfo();
        }
    } catch (Throwable $e) {}

    $logData = [
        'time' => date('c'),
        'deal_id' => $dealId,
        'coupon_code' => $couponCode,
        'coupon_title' => $couponTitle,
        'customer_id' => (int)($ui['user_id'] ?? 0),
        'customer_name' => (string)($ui['user_name'] ?? ''),
        'ip' => (string)($_SERVER['REMOTE_ADDR'] ?? ''),
        'ua' => (string)($_SERVER['HTTP_USER_AGENT'] ?? ''),
    ];

    $logFile = $logDir . '/' . date('Y-m-d') . '.jsonl';
    @file_put_contents($logFile, json_encode($logData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) . "\n", FILE_APPEND);
} catch (Throwable $e) {
    // silencioso
}

// NotificaÃ§Ã£o WhatsApp ao comerciante
try {
    if (function_exists('nd_whatsapp_notify_merchant_coupon_redeemed')) {
        $result = nd_whatsapp_notify_merchant_coupon_redeemed($connect, $dealId, $couponCode, $couponTitle);
        if (!empty($result['ok'])) {
            $response['ok'] = true;
            $response['notified'] = true;
        } else {
            $response['ok'] = false;
            $response['notified'] = false;
            $response['skipped'] = (bool)($result['skipped'] ?? false);
            $response['reason'] = $result['reason'] ?? null;
        }
    } else {
        $response['skipped'] = true;
        $response['reason'] = 'whatsapp_helper_missing';
    }
} catch (Throwable $e) {
    $response['skipped'] = true;
    $response['reason'] = 'exception';
}

echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
