<?php
declare(strict_types=1);
if (session_status() === PHP_SESSION_NONE) { @session_start(); }
header('Content-Type: application/json; charset=utf-8');

// Conexão direta
$helper = __DIR__ . '/helpers/db.php';
if (!is_file($helper)) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>'controllers/helpers/db.php não encontrado']);
  exit;
}
require_once $helper;

if (!isset($pdo) || !($pdo instanceof PDO)) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>'PDO não inicializado']);
  exit;
}

// Entrada
$raw = file_get_contents('php://input');
$payload = json_decode($raw, true);
if (!is_array($payload)) $payload = [];
$input = array_merge($_POST, $payload);

$item    = isset($input['item'])    ? trim((string)$input['item']) : '';
$rating  = isset($input['rating'])  ? (int)$input['rating'] : 0;
$comment = isset($input['comment']) ? trim((string)$input['comment']) : '';

if ($item === '' || $rating < 1 || $rating > 5) {
  echo json_encode(['ok'=>false,'error'=>'Dados inválidos (item/rating)']);
  exit;
}

// Se exigir login para avaliar, mantenha este bloco
$userId = $_SESSION['user_id'] ?? 0;
if (!$userId) {
  echo json_encode(['ok'=>false,'error'=>'Faça login para avaliar']);
  exit;
}

// IP (Cloudflare ou comum)
$ip = $_SERVER['HTTP_CF_CONNECTING_IP'] ?? $_SERVER['REMOTE_ADDR'] ?? null;
$ip = $ip ? substr($ip, 0, 45) : null;

// Regra: 1 review por usuário por item
$chk = $pdo->prepare("SELECT id FROM reviews WHERE item = :item AND `user` = :uid LIMIT 1");
$chk->execute([':item'=>$item, ':uid'=>$userId]);
if ($chk->fetch()) {
  echo json_encode(['ok'=>false,'error'=>'Você já avaliou esta oferta.']);
  exit;
}

// Reforço por IP (para prevenir spam adicional do mesmo IP)
if ($ip) {
  $chk2 = $pdo->prepare("SELECT id FROM reviews WHERE item = :item AND ip = :ip LIMIT 1");
  $chk2->execute([':item'=>$item, ':ip'=>$ip]);
  if ($chk2->fetch()) {
    echo json_encode(['ok'=>false,'error'=>'Este IP já registrou uma avaliação para esta oferta.']);
    exit;
  }
}

// Insere (verified=0, status=1 = aprovado automático; mude se quiser moderação)
$ins = $pdo->prepare("INSERT INTO reviews (item, `user`, ip, comment, rating, verified, status, created)
                      VALUES (:item, :user, :ip, :comment, :rating, 0, 1, NOW())");
$ins->execute([
  ':item'    => $item,
  ':user'    => $userId,
  ':ip'      => $ip,
  ':comment' => $comment,
  ':rating'  => $rating
]);

echo json_encode(['ok'=>true]);
