<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../core.php';
date_default_timezone_set(defined('TIMEZONE') ? TIMEZONE : 'America/Sao_Paulo');

// Collect input (POST preferred)
$reason  = isset($_POST['reason'])  ? trim((string)$_POST['reason'])  : '';
$details = isset($_POST['details']) ? trim((string)$_POST['details']) : '';
$dealId  = isset($_POST['deal_id']) ? (int)$_POST['deal_id'] : 0;
$pageUrl = isset($_POST['page_url'])? trim((string)$_POST['page_url']): (isset($_SERVER['HTTP_REFERER']) ? (string)$_SERVER['HTTP_REFERER'] : '');
$ua      = $_SERVER['HTTP_USER_AGENT'] ?? '';
$ip      = $_SERVER['REMOTE_ADDR']     ?? '';

if ($dealId === 0) {
  // fallback: try from query string ?deal_id=
  $dealId = isset($_GET['deal_id']) ? (int)$_GET['deal_id'] : 0;
}

if ($reason === '' || $dealId === 0) {
  http_response_code(400);
  echo json_encode(['ok'=>false,'error'=>'missing_fields']);
  exit;
}

try {
  // Build record
  $payload = [
    'deal_id'   => $dealId,
    'reason'    => $reason,
    'details'   => $details,
    'page_url'  => $pageUrl,
    'ip'        => $ip,
    'ua'        => $ua,
    'created_at'=> date('c'),
  ];

  // Storage folder
  $storeDir = __DIR__ . '/../storage/reports';
  if (!is_dir($storeDir)) { @mkdir($storeDir, 0775, true); }

  // Append JSON line
  $jsonl = $storeDir . '/reports.jsonl';
  file_put_contents($jsonl, json_encode($payload, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES) . PHP_EOL, FILE_APPEND);

  // Optional: try to send email if CONTACT_EMAIL or ADMIN_EMAIL is defined
  $to = defined('CONTACT_EMAIL') ? CONTACT_EMAIL : (defined('ADMIN_EMAIL') ? ADMIN_EMAIL : '');
  if ($to) {
    $subject = 'Novo reporte de oferta #' . $dealId;
    $body  = "Oferta: #{$dealId}\n";
    $body .= "Motivo: {$reason}\n";
    $body .= "Detalhes: {$details}\n";
    $body .= "URL: {$pageUrl}\n";
    $body .= "IP: {$ip}\nUA: {$ua}\n";
    @mail($to, $subject, $body, "Content-Type: text/plain; charset=UTF-8");
  }

  echo json_encode(['ok'=>true]);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>'server_error','detail'=>$e->getMessage()]);
}
