<?php
declare(strict_types=1);

require_once __DIR__ . '/lib/db_bootstrap.php';

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['ok'=>false,'error'=>'Method not allowed']);
    exit;
}

try {
    $pdo = nd_db();
} catch (Throwable $e) {
    nd_log('ERRO conexão: ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>'Sem conexão com o banco']);
    exit;
}

// Normaliza inputs
$reason       = trim((string)($_POST['reason'] ?? $_POST['motivo'] ?? ''));
$reason_label = trim((string)($_POST['reason_label'] ?? $_POST['motivo_label'] ?? ''));
$details      = trim((string)($_POST['details'] ?? $_POST['detalhes'] ?? ''));
$deal_id      = (int)($_POST['deal_id'] ?? $_POST['id_oferta'] ?? 0);
$page_url     = trim((string)($_POST['page_url'] ?? $_POST['url'] ?? ''));
$ip           = $_SERVER['REMOTE_ADDR'] ?? '';
$ua           = $_SERVER['HTTP_USER_AGENT'] ?? '';
$ref          = $_SERVER['HTTP_REFERER'] ?? '';
$status       = 'open'; // padrão

if ($reason === '') {
    http_response_code(400);
    echo json_encode(['ok'=>false,'error'=>'reason obrigatório']);
    exit;
}

// Monta dados com possíveis colunas
$all = [
    'deal_id'      => $deal_id ?: null,
    'reason'       => $reason,
    'reason_label' => $reason_label,
    'details'      => $details,
    'status'       => $status,
    'ip'           => $ip,
    'user_agent'   => $ua,
    'referer'      => $ref,
    'page_url'     => $page_url,
    'created_at'   => date('Y-m-d H:i:s'),
];

// Descobre colunas existentes da tabela
$table = 'deal_reports';
try {
    $colsStmt = $pdo->query("SHOW COLUMNS FROM `$table`");
    $existingCols = array_map(fn($r) => $r['Field'], $colsStmt->fetchAll());
} catch (Throwable $e) {
    nd_log('SHOW COLUMNS falhou: ' . $e->getMessage());
    $existingCols = array_keys($all); // tenta inserir tudo mesmo assim
}

// Filtra para colunas que existem
$data = [];
foreach ($all as $k => $v) {
    if (in_array($k, $existingCols, true)) $data[$k] = $v;
}

if (empty($data)) {
    nd_log('Nenhuma coluna válida para inserir');
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>'Tabela incompatível']);
    exit;
}

// Monta e executa INSERT
$cols = array_keys($data);
$place = array_map(fn($c) => ':' . $c, $cols);
$sql = "INSERT INTO `$table` (" . implode(',', $cols) . ") VALUES (" . implode(',', $place) . ")";
try {
    $stmt = $pdo->prepare($sql);
    foreach ($data as $k => $v) $stmt->bindValue(':' . $k, $v);
    $stmt->execute();
    $id = (int)$pdo->lastInsertId();
    nd_log("INSERT OK id={$id} reason={$reason} deal_id={$deal_id} ip={$ip}");
    echo json_encode(['ok'=>true,'id'=>$id]);
} catch (Throwable $e) {
    nd_log('INSERT falhou: ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>'Falha ao salvar']);
}
