<?php
declare(strict_types=1);
require_once __DIR__.'/includes/location_prefilter.php';
// === ND Helpers Loader (guarded) ===
$___h_candidates = [
    __DIR__ . '/app/Support/helpers.php',
    // if this bootstrap sits in a subfolder:
    dirname(__DIR__) . '/app/Support/helpers.php',
    // fallback if only 'Support/helpers.php' got uploaded to project root
    __DIR__ . '/Support/helpers.php',
];
$___loaded = false;
foreach ($___h_candidates as $___h) {
    if (is_file($___h)) {
        require_once $___h;
        $___loaded = true;
        break;
    }
}
if (!$___loaded) {
    trigger_error('ND Helpers not found (tried: ' . implode(', ', $___h_candidates) . ')', E_USER_WARNING);
}
// === /ND Helpers Loader ===

?>
<?php
// *** NUNCA remova estas 3 linhas ***
if (function_exists('ob_get_level') && ob_get_level() === 0) { ob_start(); }

// Sessão: iniciar somente se possível (evita WARNING quando headers já foram enviados)
if (session_status() !== PHP_SESSION_ACTIVE) {
    if (!headers_sent()) {
        @session_start([
            'cookie_httponly' => true,
            'cookie_secure'   => !empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off',
            'use_strict_mode' => 1,
        ]);
    } else {
        // Cabeçalhos já enviados — não tente iniciar a sessão para evitar Warning.
        // Opcional: marcar flag para debugging
        if (!defined('ND_SESSION_DEFERRED')) define('ND_SESSION_DEFERRED', true);
    }
}


// ============================
// CORE BOOTSTRAP + I18N FIXED
// ============================
if (session_status() === PHP_SESSION_NONE && !headers_sent()) { @session_start(); }

// DEBUG TEMPORÁRIO: mostrar e logar todos os erros (admin quebrando)
// Se quiser desativar depois que tudo estiver ok, pode voltar para o modo de produção.
if (!defined('GADGETZA_ERROR_CONFIGURED')) {
    define('GADGETZA_ERROR_CONFIGURED', true);
}
error_reporting(E_ALL);
ini_set('display_errors', '1');
ini_set('log_errors', '1');
ini_set('error_log', __DIR__ . '/nd_error.log');

if (!isset($langStrings) || !is_array($langStrings)) { $langStrings = array(); }
if (!isset($langStrings[0]) || !is_array($langStrings[0])) { $langStrings[0] = array(); }
if (!isset($translation) || !is_array($translation)) { $translation = array(); }

require_once __DIR__ . '/compat/bootstrap.php';
require __DIR__ . '/config.php';
require __DIR__ . '/functions.php';
require_once __DIR__ . '/includes/nd-events.php';
require __DIR__ . '/routes.php';

// /*LANG_AUTOLOADER*/
$forcedLang = getenv('APP_LANG') ?: (defined('APP_LANG') ? APP_LANG : null);
$acceptLang = isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? strtolower($_SERVER['HTTP_ACCEPT_LANGUAGE']) : '';
$langFile   = __DIR__ . '/translation.php';

if ($forcedLang === 'pt-br' || strpos($acceptLang, 'pt-br') !== false) {
    $try = __DIR__ . '/translation-pt-br.php';
    if (file_exists($try)) { $langFile = $try; }
} elseif ($forcedLang === 'ar') {
    $try = __DIR__ . '/translation-ar.php';
    if (file_exists($try)) { $langFile = $try; }
}

// --- PRIORIDADE FINAL: escolha do usuário (sessão) ---
if (isset($_SESSION['lang'])) {
    $langKey = strtolower($_SESSION['lang']); // 'pt-br' | 'en' | 'es'
    $map = [
        'en'    => '/translation.php',
        'pt-br' => '/translation-pt-br.php',
        'es'    => '/translation-es.php',
    ];
    if (isset($map[$langKey])) {
        $try = __DIR__ . $map[$langKey];
        if (file_exists($try)) { $langFile = $try; }
    }
}
unset($forcedLang, $acceptLang, $try);

require($langFile);
// ==== Fallback para chaves tr_* faltantes (evita Undefined array key) ====
if (!isset($translation) || !is_array($translation)) { $translation = array(); }
if (!isset($langStrings) || !is_array($langStrings)) { $langStrings = array(); }

// Quantidade segura (ajuste se necessário)
$__MAX_TR = 300;

// 1) Gera mapa base de inglês se existir (boa prática)
$__baseEn = array();
$__enFile = __DIR__ . '/translation.php';
if (file_exists($__enFile)) {
    // Clona estado atual, inclui EN e captura chaves
    $__bak = $translation;
    include $__enFile;
    if (isset($translation) && is_array($translation)) $__baseEn = $translation;
    $translation = $__bak; // restaura
    unset($__bak);
}

// 2) Preenche tr_1..tr_N com base EN se houver, senão string vazia
for ($__i = 1; $__i <= $__MAX_TR; $__i++) {
    $__k = 'tr_' . $__i;
    if (!array_key_exists($__k, $translation)) {
        if (isset($__baseEn[$__k])) {
            $translation[$__k] = $__baseEn[$__k];
        } else {
            $translation[$__k] = '';
        }
    }
}
unset($__MAX_TR, $__i, $__k, $__baseEn, $__enFile);


// SYNC entre estruturas i18n
if (isset($translation) && is_array($translation)) {
    $langStrings = $translation;
} elseif (isset($langStrings) && is_array($langStrings)) {
    $translation = $langStrings;
} else {
    $translation = array();
    $langStrings = array();
}

require_once __DIR__ . '/i18n-shim.php';
include __DIR__ . '/partials/i18n-aftercore-fix.php';


$connect = connect();
if (!$connect) { exit(); }

$settings = getSettings($connect);
$theme    = getTheme($connect);

$translation = is_array($langStrings) && isset($translation) && is_array($translation)
    ? $translation
    : (is_array($langStrings) ? $langStrings : array());

$langDir = $settings['st_langdir'];

$headerAd  = getHeaderAd($connect);
$footerAd  = getFooterAd($connect);
$sidebarAd = getSidebarAd($connect);

$socialMedia = getSocialMedia($connect);

if (isLogged()){
    $userInfo = getUserInfo();
}

$defaultSearchPage     = getDefaultPage($connect, $settings['st_defaultsearchpage']);
$defaultPrivacyPage    = getDefaultPage($connect, $settings['st_defaultprivacypage']);
$defaultTermsPage      = getDefaultPage($connect, $settings['st_defaulttermspage']);
$defaultContactPage    = getDefaultPage($connect, $settings['st_defaultcontactpage']);
$defaultCategoriesPage = getDefaultPage($connect, $settings['st_defaultcategoriespage']);
$defaultStoresPage     = getDefaultPage($connect, $settings['st_defaultstorespage']);
$defaultLocationsPage  = getDefaultPage($connect, $settings['st_defaultlocationspage']);
$defaultPricingPage    = getDefaultPage($connect, $settings['st_defaultpricingpage']);

if (!defined('SEARCH_PAGE')) define('SEARCH_PAGE',      $defaultSearchPage['page_slug']);
if (!defined('PRIVACY_PAGE')) define('PRIVACY_PAGE',     $defaultPrivacyPage['page_slug']);
if (!defined('TERMS_PAGE')) define('TERMS_PAGE',       $defaultTermsPage['page_slug']);
if (!defined('CONTACT_PAGE')) define('CONTACT_PAGE',     $defaultContactPage['page_slug']);
if (!defined('CATEGORIES_PAGE')) define('CATEGORIES_PAGE',  $defaultCategoriesPage['page_slug']);
if (!defined('STORES_PAGE')) define('STORES_PAGE',      $defaultStoresPage['page_slug']);
if (!defined('LOCATIONS_PAGE')) define('LOCATIONS_PAGE',   $defaultLocationsPage['page_slug']);
if (!defined('PRICING_PAGE')) define('PRICING_PAGE',     $defaultPricingPage['page_slug']);

$maintenanceMode = $settings['st_maintenance'];
$urlPath = new Routes();

if (isLogged()) {
    if ($maintenanceMode == 1 && !isAdmin() && basename($_SERVER['PHP_SELF']) != 'offline.php') {
        header('Location: '. $urlPath->offline());
    }
} elseif ($maintenanceMode == 1 && basename($_SERVER['PHP_SELF']) != 'offline.php') {
    header('Location: '. $urlPath->offline());
}
