<?php
declare(strict_types=1);
/*--------------------*/
// Dashboard Add-ons (seller)
/*--------------------*/

if (session_status() !== PHP_SESSION_ACTIVE) { @session_start(); }

require_once __DIR__ . '/../core.php';
require_once __DIR__ . '/functions.php';
if (is_file(__DIR__ . '/../init_lang.php')) { require_once __DIR__ . '/../init_lang.php'; }

/* Conexão PDO segura */
$connect = $connect ?? null;
try {
  if (!isset($connect) || !$connect) {
    if (function_exists('connect')) {
      if (isset($database)) { $connect = @connect($database); }
      if (!$connect)        { $connect = @connect(); }
    }
  }
} catch (Throwable $e) {}

/* Guards */
if (!function_exists('nd_is_logged')) {
  function nd_is_logged($conn = null): bool {
    if (function_exists('isLogged')) {
      try { return isset($conn) ? (bool)isLogged($conn) : (bool)isLogged(); }
      catch (Throwable $e) { return false; }
    }
    return !empty($_SESSION['user_id']) || !empty($_SESSION['user']);
  }
}
if (!function_exists('nd_is_seller')) {
  function nd_is_seller(): bool {
    if (function_exists('isSeller')) {
      try { return (bool)isSeller(); } catch (Throwable $e) { return false; }
    }
    return false;
  }
}

/* Gate */
if (!nd_is_logged($connect)) {
  if (!headers_sent()) { header('Location: ./login.php'); }
  exit;
}
if (!nd_is_seller()) {
  if (!headers_sent()) { header('Location: ./denied.php'); }
  exit;
}

/* User */
$userProfile = [];
try { if (function_exists('getUserInfo')) $userProfile = (array)getUserInfo(); } catch (Throwable $e) {}
$userId = (int)($userProfile['user_id'] ?? ($_SESSION['user_id'] ?? 0));
if ($userId <= 0) {
  if (!headers_sent()) { header('Location: ./login.php'); }
  exit;
}

// garante tabelas (fail-open)
try { if (function_exists('nd_addons_ensure_tables')) nd_addons_ensure_tables($connect); } catch (Throwable $e) {}

/* Busca add-ons do anunciante */
$orders = [];
try {
  if ($connect) {
    $st = $connect->prepare(
      "SELECT ao.*, s.store_title\n".
      "FROM nd_addon_orders ao\n".
      "LEFT JOIN stores s ON s.store_id = ao.store_id\n".
      "WHERE ao.user_id = :uid\n".
      "ORDER BY ao.created_at DESC"
    );
    $st->execute([':uid' => $userId]);
    $orders = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];
  }
} catch (Throwable $e) { $orders = []; }

/* Counters */
$counts = [
  'pending_payment' => 0,
  'pending_activation' => 0,
  'active' => 0,
  'expired' => 0,
  'canceled' => 0,
];
foreach ($orders as $o) {
  $s = strtolower(trim((string)($o['status'] ?? '')));
  if (isset($counts[$s])) $counts[$s]++;
}

require __DIR__ . '/views/addons.view.php';
