<?php
// Saída de avatar do associado a partir de storage/associates, contornando o .htaccess de deny.

declare(strict_types=1);

@session_start();

$assocId = 0;
if (isset($_GET['id'])) {
    $assocId = (int)$_GET['id'];
} elseif (isset($_SESSION['associate_id'])) {
    $assocId = (int)$_SESSION['associate_id'];
}

if ($assocId <= 0) {
    http_response_code(404);
    exit;
}

// Caminho físico do projeto (raiz conecta.ndmidia.com.br)
$baseDir = realpath(dirname(__DIR__));
if ($baseDir === false) {
    http_response_code(500);
    exit;
}

$storageDir = $baseDir . '/storage/associates';
$path = null;
$contentType = 'image/png';

foreach (['png','jpg','jpeg'] as $ext) {
    $candidate = $storageDir . '/avatar_' . $assocId . '.' . $ext;
    if (is_file($candidate)) {
        $path = $candidate;
        if ($ext === 'jpg' || $ext === 'jpeg') {
            $contentType = 'image/jpeg';
        } else {
            $contentType = 'image/png';
        }
        break;
    }
}

// Se não encontrar avatar, tenta usar um avatar padrão do tema
if ($path === null) {
    // Tenta usar avatar padrão do dashboard
    $default = $baseDir . '/dashboard/assets/images/avatar.png';
    if (is_file($default)) {
        $path = $default;
        $contentType = 'image/png';
    } else {
        http_response_code(404);
        exit;
    }
}

header('Content-Type: ' . $contentType);
header('Cache-Control: private, max-age=86400');
header('Content-Length: ' . filesize($path));

$fp = fopen($path, 'rb');
if ($fp !== false) {
    fpassthru($fp);
    fclose($fp);
} else {
    http_response_code(500);
}
