<?php
declare(strict_types=1);

/**
 * Exporta CSV de cliques do associado logado.
 */

if (session_status() !== PHP_SESSION_ACTIVE) {
    @session_start();
}

require_once __DIR__ . '/../core.php';

// DEBUG: loga sessão e ID do associado na exportação CSV
try {
    $debugDir = __DIR__ . '/../storage/logs';
    if (!is_dir($debugDir)) {
        @mkdir($debugDir, 0775, true);
    }
    $debugFile = $debugDir . '/associate_export_csv_debug.log';
    $dbg = date('Y-m-d H:i:s') . " associate_export_csv.php\n";
    $dbg .= "SESSION: " . print_r($_SESSION, true) . "\n";
    @file_put_contents($debugFile, $dbg . "\n----------------------\n", FILE_APPEND);
} catch (Throwable $e) {
    // ignora falha de log
}

$associateId = isset($_SESSION['associate_id']) ? (int)$_SESSION['associate_id'] : 0;
if (empty($_SESSION['associate_signedin']) || $associateId <= 0) {
    http_response_code(403);
    echo 'Acesso negado.';
    exit;
}

$connect = $connect ?? null;
try {
    if (!$connect && function_exists('connect')) {
        $connect = connect();
    }
} catch (Throwable $e) {
    $connect = null;
}

// DEBUG: loga estado da conexão
try {
    $debugDir = __DIR__ . '/../storage/logs';
    if (!is_dir($debugDir)) {
        @mkdir($debugDir, 0775, true);
    }
    $debugFile = $debugDir . '/associate_export_csv_debug.log';
    $dbg = date('Y-m-d H:i:s') . " AFTER_CONNECT associate_export_csv.php\n";
    $dbg .= "connect instanceof PDO? " . (($connect instanceof PDO) ? 'yes' : 'no') . "\n";
    @file_put_contents($debugFile, $dbg . "\n----------------------\n", FILE_APPEND);
} catch (Throwable $e) {
    // ignora
}

if (!($connect instanceof PDO)) {
    http_response_code(500);
    echo 'Falha na conexão com o banco de dados.';
    exit;
}

// Busca cliques do associado
try {
    // Buscamos todos os campos da tabela para evitar erro se alguma coluna não existir
    $stmt = $connect->prepare('
        SELECT *
          FROM associate_clicks
         WHERE associate_id = :id
         ORDER BY 1 ASC
    ');
    $stmt->execute([':id' => $associateId]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // DEBUG: loga quantidade de linhas retornadas
    try {
        $debugDir = __DIR__ . '/../storage/logs';
        if (!is_dir($debugDir)) {
            @mkdir($debugDir, 0775, true);
        }
        $debugFile = $debugDir . '/associate_export_csv_debug.log';
        $dbg = date('Y-m-d H:i:s') . " AFTER_QUERY associate_export_csv.php\n";
        $dbg .= "associateId: " . $associateId . "\n";
        $dbg .= "rows count: " . (is_array($rows) ? count($rows) : -1) . "\n";
        @file_put_contents($debugFile, $dbg . "\n----------------------\n", FILE_APPEND);
    } catch (Throwable $e) {
        // ignora
    }
} catch (Throwable $e) {
    // Loga mensagem de erro para debug
    try {
        $debugDir = __DIR__ . '/../storage/logs';
        if (!is_dir($debugDir)) {
            @mkdir($debugDir, 0775, true);
        }
        $debugFile = $debugDir . '/associate_export_csv_debug.log';
        $dbg = date('Y-m-d H:i:s') . " ERROR_QUERY associate_export_csv.php\n";
        $dbg .= "exception: " . $e->getMessage() . "\n";
        @file_put_contents($debugFile, $dbg . "\n----------------------\n", FILE_APPEND);
    } catch (Throwable $e2) {
        // ignora
    }

    http_response_code(500);
    echo 'Erro ao carregar cliques.';
    exit;
}

$filename = 'cliques_associado_' . $associateId . '_' . date('Ymd_His') . '.csv';

header('Content-Type: text/csv; charset=UTF-8');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Pragma: no-cache');
header('Expires: 0');

$out = fopen('php://output', 'w');
// BOM para Excel em UTF-8
fwrite($out, chr(0xEF) . chr(0xBB) . chr(0xBF));

// Cabeçalho
if (is_array($rows) && !empty($rows)) {
    // Usa as chaves da primeira linha como cabeçalho genérico
    fputcsv($out, array_keys($rows[0]), ';');
    foreach ($rows as $r) {
        fputcsv($out, array_values($r), ';');
    }
} else {
    // Sem linhas: ainda assim gera um CSV mínimo
    fputcsv($out, ['mensagem'], ';');
    fputcsv($out, ['Nenhum clique encontrado para este associado.'], ';');
}

fclose($out);
exit;
