<?php
declare(strict_types=1);

/**
 * Login de associados
 * - Autentica pelo código único do associado (associate_code)
 * - Cria sessão própria e redireciona para o dashboard do associado
 */

require_once __DIR__ . '/../core.php';

// Garante sessão
if (session_status() !== PHP_SESSION_ACTIVE) {
    @session_start();
}

// Conexão segura com o banco
$connect = $connect ?? null;
try {
    if (!($connect instanceof PDO) && function_exists('connect')) {
        if (isset($database)) {
            $connect = @connect($database);
        }
        if (!$connect) {
            $connect = @connect();
        }
    }
} catch (Throwable $e) {
    // segue com $connect nulo; erros serão tratados mais abaixo
}

// Se já estiver logado como associado, vai direto para o painel
if (!empty($_SESSION['associate_signedin']) && !empty($_SESSION['associate_id'])) {
    if (!headers_sent()) {
        header('Location: associate_home.php');
    }
    exit;
}

$errors = [];
$fullHeight = true;

// Processa login
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'POST') {
    $codeRaw = $_POST['associate_code'] ?? '';
    $code    = trim((string)$codeRaw);

    if ($code === '') {
        $errors[] = 'Informe o código do associado.';
    } else {
        try {
            if (!($connect instanceof PDO) && function_exists('connect')) {
                if (isset($database)) {
                    $connect = @connect($database);
                }
                if (!$connect) {
                    $connect = @connect();
                }
            }

            if ($connect instanceof PDO) {
                $stmt = $connect->prepare(
                    'SELECT associate_id, associate_name, associate_status 
                     FROM associates 
                     WHERE associate_code = :code 
                     LIMIT 1'
                );
                $stmt->execute([':code' => $code]);
                $row = $stmt->fetch(PDO::FETCH_ASSOC);

                if ($row && (int)($row['associate_status'] ?? 0) === 1) {
                    $_SESSION['associate_signedin'] = true;
                    $_SESSION['associate_id']       = (int)$row['associate_id'];
                    $_SESSION['associate_name']     = (string)($row['associate_name'] ?? '');

                    if (!headers_sent()) {
                        header('Location: associate_home.php');
                    }
                    exit;
                } else {
                    $errors[] = 'Código de associado não encontrado ou inativo.';
                }
            } else {
                $errors[] = 'Falha na conexão com o banco de dados.';
            }
        } catch (Throwable $e) {
            $errors[] = 'Ocorreu um erro ao validar o código do associado.';
        }
    }
}

/* reCAPTCHA siteKey (se a view usar) */
$siteKey = $siteKey ?? ($settings['recaptcha_site_key'] ?? '');

/* Render */
require __DIR__ . '/header.php';
require __DIR__ . '/views/associate-login.view.php';
require __DIR__ . '/footer.php';
