<?php
declare(strict_types=1);

// Bootstrap mínimo
require_once __DIR__ . '/../core.php';

// Headers de JSON SEM ecoar notices/HTML
@ini_set('display_errors', '0');
header('Content-Type: application/json; charset=UTF-8');

// Helper seguro p/ finalizar
function json_ok($data) {
  echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
  exit;
}
function json_err($msg = 'error') {
  http_response_code(200); // DataTables fica feliz com 200 + payload vazio
  echo json_encode([], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
  exit;
}

try {
  // Conexão
  if (!isset($connect) || !$connect) {
    if (function_exists('connect')) {
      $connect = connect($database ?? null);
    }
  }
} catch (Throwable $e) {
  json_err();
}

// Autenticação
try {
  if (!function_exists('isLogged') || !isLogged($connect ?? null)) {
    json_ok([]); // responde vazio em vez de 302/HTML
  }
} catch (Throwable $e) {
  json_ok([]);
}

// Usuário logado
try {
  $userProfile = function_exists('getUserInfo') ? getUserInfo() : null;
  $userId = (int)($userProfile['user_id'] ?? 0);
  if ($userId <= 0) json_ok([]);
} catch (Throwable $e) {
  json_ok([]);
}

// Tipo solicitado
$type = $_GET['type'] ?? '';

/**
 * O DataTables do seu front consome um ARRAY simples de linhas (dataSrc padrão “”
 * nos seus exemplos antigos). Então retornamos um array simples.
 */
try {

  if ($type === 'last10submissions') {
    // Últimos 10 itens do usuário logado
    $stmt = $connect->prepare("
      SELECT d.deal_id, d.deal_title, d.deal_clicks, d.deal_price, d.deal_status, d.deal_image
      FROM deals d
      WHERE d.deal_author = :uid
      ORDER BY d.deal_id DESC
      LIMIT 10
    ");
    $stmt->execute([':uid' => $userId]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC) ?: [];
    json_ok($rows);
  }

  if ($type === 'submissions') {
    // Todos envios do usuário (paginado no front)
    $stmt = $connect->prepare("
      SELECT d.deal_id, d.deal_title, d.deal_clicks, d.deal_price, d.deal_status, d.deal_image
      FROM deals d
      WHERE d.deal_author = :uid
      ORDER BY d.deal_id DESC
    ");
    $stmt->execute([':uid' => $userId]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC) ?: [];
    json_ok($rows);
  }

  // default: vazio
  json_ok([]);

} catch (Throwable $e) {
  // Em JSON não podemos vazar HTML/erros
  json_ok([]);
}
