<?php 


declare(strict_types=1);
/*--------------------*/
// Descrição: ND Cupons 
// Autor: ND Tecnologia 
// Autor URI: https://www.ndmidia.com.br 
/*--------------------*/

require '../core.php';
require_once __DIR__ . '/functions.php';

$connect = connect($database);

if (!getItemId()) {

    header('Location: ./home.php');
    exit();
}

if (isLogged($connect)){

$userProfile = getUserInfo();
$userDetails = getUserInfoById($userProfile['user_id']);

if(!isSeller()){
    header('Location: ./denied.php');
}

$itemId = clearGetData(getItemId());

$itemDetails = getItemById($userProfile['user_id'], $itemId);

// checking if you are the author of the item

if($itemDetails['deal_author'] !== $userProfile['user_id']){
    header('Location: ./error.php');
    exit();
}

// checking if the item was rejected

if($itemDetails['deal_status'] == 4){
    header('Location: ./error.php');
    exit();
}

// checking the expiration date of the user's subscription

if(isExpiredSubscription()){
    header('Location: ./error.php');
    exit();
}


// ND: enforce plan_limit when enabling an item
try {
    $remaining = nd_user_remaining_deals($connect, (int)$userProfile['user_id']);
    if ($remaining <= 0) {
        header('Location: ./error.php');
        exit();
    }
} catch (Throwable $e) {
    // fail-open
}
$statement = $connect->prepare("UPDATE deals SET deal_status = 1 WHERE deal_id = :deal_id AND deal_author = :deal_author");
$statement->execute(array(
    'deal_id' => $itemId,
    'deal_author' => $userProfile['user_id']
));

header('Location: ' . $_SERVER['HTTP_REFERER']);

}else{
    
    header('Location: ./login.php');
}

?>