<?php
declare(strict_types=1);

/* =========================
   ND Helpers Loader (guarded)
   ========================= */
$___h_candidates = [
    __DIR__ . '/app/Support/helpers.php',
    dirname(__DIR__) . '/app/Support/helpers.php',
    __DIR__ . '/Support/helpers.php',
];
$___loaded = false;
foreach ($___h_candidates as $___h) {
    if (is_file($___h)) { require_once $___h; $___loaded = true; break; }
}
if (!$___loaded) {
    trigger_error('ND Helpers not found (tried: ' . implode(', ', $___h_candidates) . ')', E_USER_WARNING);
}

/* Núcleo (PDO, $database, $urlPath etc.) */
require_once __DIR__ . '/../core.php';

/* =========================
   Upload settings / helpers
   ========================= */
function allowedFileExt(): array {
    return ['jpg','jpeg','png','gif'];
}
function allowedFileSize(): int {
    // 1Mb
    return 1048576;
}

/* =========================
   ND SECURITY HELPERS
   ========================= */
if (!function_exists('nd_safe_html')) {
  function nd_safe_html(string $html): string {
    // Remove tags perigosas
    $html = preg_replace('#<(script|style|iframe|object|embed|meta|link)\b[^>]*>.*?</\1>#is', '', $html);
    // Remove on* attrs
    $html = preg_replace('#\son\w+\s*=\s*([\'"]).*?\1#i', '', $html);
    // Neutraliza javascript:/data:
    $html = preg_replace('#(href|src)\s*=\s*([\'"])\s*(javascript:|data:)#i', '$1=$2#', $html);
    // Whitelist
    $allowed = '<p><br><strong><em><ul><ol><li><blockquote><code><pre><h1><h2><h3><h4><h5><h6><a><img><hr><span><div>';
    $html = strip_tags($html, $allowed);
    // Links seguros
    $html = preg_replace('#<a\b([^>]*)>#i', '<a$1 rel="nofollow noopener" target="_blank">', $html);
    return $html;
  }
}

if (!function_exists('nd_security_headers')) {
  function nd_security_headers(): void {
    @header('X-Frame-Options: SAMEORIGIN');
    @header('X-Content-Type-Options: nosniff');
    @header('Referrer-Policy: strict-origin-when-cross-origin');
    @header("Permissions-Policy: geolocation=(), microphone=(), camera=()");
    // Ajuste o CSP conforme seu projeto (bibliotecas inline, etc.)
    @header("Content-Security-Policy: default-src 'self' https: data:; img-src 'self' https: data:; script-src 'self' https: 'unsafe-inline' 'unsafe-eval'; style-src 'self' https: 'unsafe-inline'");
  }
}

/* =========================
   Sessão / Usuário (polyfills)
   ========================= */
if (!function_exists('nd_is_logged')) {
  function nd_is_logged($conn = null): bool {
    try {
      if (function_exists('isLogged')) {
        return isset($conn) ? (bool)isLogged($conn) : (bool)isLogged();
      }
      return !empty($_SESSION['user_id']) || !empty($_SESSION['user_email']);
    } catch (Throwable $e) {
      return false;
    }
  }
}

if (!function_exists('nd_user_info')) {
  function nd_user_info(): array {
    try {
      if (function_exists('getUserInfo'))     return (array)getUserInfo();
      if (function_exists('getUserInfoById')) {
        $uid = (int)($_SESSION['user_id'] ?? 0);
        if ($uid > 0) return (array)getUserInfoById($uid);
      }
    } catch (Throwable $e) {}
    return [];
  }
}

/* =========================
   isSeller() robusto
   - aceita user_pro = 1 OU
   - existir seller ativo para o user_id
   ========================= */
if (!function_exists('isSeller')) {
  function isSeller($conn = null): bool {
    try {
      // 1) precisa estar logado
      if (!nd_is_logged($conn)) return false;

      // 2) obter user_id
      $u = nd_user_info();
      $uid = (int)($u['user_id'] ?? 0);
      if ($uid <= 0) return false;

      // 3) atalho: user_pro (muitos temas usam como “vendedor/pro”)
      if (isset($u['user_pro']) && (int)$u['user_pro'] === 1) return true;

      // 4) sellers.seller_user ativo
      if (!($conn instanceof PDO)) {
        if (function_exists('connect') && isset($GLOBALS['database'])) {
          $conn = @connect($GLOBALS['database']);
        }
      }
      if ($conn instanceof PDO) {
        $st = $conn->prepare("SELECT 1 FROM sellers WHERE seller_user = :uid AND seller_status = 1 LIMIT 1");
        $st->execute([':uid' => $uid]);
        if ($st->fetchColumn()) return true;
      }
    } catch (Throwable $e) {}
    return false;
  }
}

/* =========================
   nd_is_seller(): helper fino para checar se o usuário é anunciante
   ========================= */
if (!function_exists('nd_is_seller')) {
  function nd_is_seller($conn = null): bool {
    try {
      if (function_exists('isSeller')) {
        return (bool) isSeller($conn);
      }
    } catch (Throwable $e) {
      return false;
    }
    return false;
  }
}

/* =========================
   (Opcional) helper: assinatura ativa
   ========================= */
if (!function_exists('nd_has_active_plan')) {
  function nd_has_active_plan($conn = null): bool {
    try {
      $u = nd_user_info();
      $exp = $u['user_plan_expiration_date'] ?? null;
      if ($exp && strtotime((string)$exp) > time()) return true;
      // se quiser checar pagamentos, faça aqui via $conn
    } catch (Throwable $e) {}
    return false;
  }
}

