<?php
declare(strict_types=1);

/*--------------------*/
// Dashboard Home (seller area)
// Corrige "undefined function isSeller()" com requires e guards
/*--------------------*/

if (session_status() !== PHP_SESSION_ACTIVE) { @session_start(); }

require_once __DIR__ . '/../core.php';
require_once __DIR__ . '/functions.php';
if (is_file(__DIR__ . '/../init_lang.php')) { require_once __DIR__ . '/../init_lang.php'; }

/* Conexão PDO segura */
$connect = $connect ?? null;
try {
  if (!isset($connect) || !$connect) {
    if (function_exists('connect')) {
      if (isset($database)) { $connect = @connect($database); }
      if (!$connect)        { $connect = @connect(); }
    }
  }
} catch (Throwable $e) { /* tolera sem derrubar */ }

/* Guards para funções que podem não existir */
if (!function_exists('nd_is_logged')) {
  function nd_is_logged($conn = null): bool {
    if (function_exists('isLogged')) {
      try { return isset($conn) ? (bool)isLogged($conn) : (bool)isLogged(); }
      catch (Throwable $e) { return false; }
    }
    return !empty($_SESSION['user_id']) || !empty($_SESSION['user']);
  }
}
if (!function_exists('nd_is_seller')) {
  function nd_is_seller(): bool {
    if (function_exists('isSeller')) {
      try { return (bool)isSeller(); } catch (Throwable $e) { return false; }
    }
    return false;
  }
}

/* Gate de autenticação */
if (!nd_is_logged($connect)) {
  if (!headers_sent()) { header('Location: ./login.php'); }
  exit;
}

/* Opcional: só sellers acessam esse home (se esse for o comportamento) */
if (!nd_is_seller()) {
  if (!headers_sent()) { header('Location: ./denied.php'); }
  exit;
}

/* Carrega dados usados pela view, com tolerância */
$userProfile      = [];
$userDetails      = [];
$userPlanSettings = [];
$latestItems      = [];
$mtd = ['views' => 0, 'clicks' => 0, 'copies' => 0];

try { if (function_exists('getUserInfo')) $userProfile = (array)getUserInfo(); } catch (Throwable $e) {}
try {
  if (function_exists('getUserInfoById') && !empty($userProfile['user_id'])) {
    $userDetails = (array)getUserInfoById((int)$userProfile['user_id']);
  }
} catch (Throwable $e) {}
try {
  if (!empty($userDetails['user_plan']) && function_exists('getPlanById') && $connect) {
    $userPlanSettings = (array)getPlanById($connect, (int)$userDetails['user_plan']);
  }
} catch (Throwable $e) {}
try {
  if (function_exists('get_all_deals_by_user') && !empty($userProfile['user_id'])) {
    $latestItems = (array)get_all_deals_by_user((int)$userProfile['user_id'], 10);
  }
} catch (Throwable $e) {}

// Month-to-date headline for seller (sellable)
try {
  if ($connect && !empty($userProfile['user_id'])) {
    // Ensure nd_events exists
    $q = $connect->query("SHOW TABLES LIKE 'nd_events'");
    $has = (bool)($q && $q->fetch(PDO::FETCH_NUM));
    if ($has) {
      $uid = (int)$userProfile['user_id'];
      $stores = [];
      $st = $connect->prepare("SELECT store_id FROM stores WHERE store_user_id = :uid AND store_status = 1");
      $st->execute([':uid' => $uid]);
      $stores = $st->fetchAll(PDO::FETCH_COLUMN, 0) ?: [];
      $stores = array_values(array_filter(array_map('intval', $stores), fn($v) => $v > 0));
      if (!empty($stores)) {
        $tz = new DateTimeZone('America/Sao_Paulo');
        $today = new DateTime('now', $tz);
        $monthStart = new DateTime('first day of this month 00:00:00', $tz);
        $in = implode(',', array_fill(0, count($stores), '?'));
        $sql = "SELECT\n".
               "  SUM(event_name = 'view_deal') AS views,\n".
               "  SUM(event_name = 'click_deal_link') AS clicks,\n".
               "  SUM(event_name = 'copy_coupon') AS copies\n".
               "FROM nd_events\n".
               "WHERE store_id IN ($in) AND created_at BETWEEN ? AND ?";
        $st2 = $connect->prepare($sql);
        $i = 1;
        foreach ($stores as $sid) { $st2->bindValue($i++, (int)$sid, PDO::PARAM_INT); }
        $st2->bindValue($i++, $monthStart->format('Y-m-d H:i:s'), PDO::PARAM_STR);
        $st2->bindValue($i++, $today->format('Y-m-d H:i:s'), PDO::PARAM_STR);
        $st2->execute();
        $row = $st2->fetch(PDO::FETCH_ASSOC) ?: [];
        $mtd = [
          'views'  => (int)($row['views'] ?? 0),
          'clicks' => (int)($row['clicks'] ?? 0),
          'copies' => (int)($row['copies'] ?? 0),
        ];
      }
    }
  }
} catch (Throwable $e) { /* ignore */ }

/* Render */
require __DIR__ . '/header.php';
require __DIR__ . '/views/home.view.php';
require __DIR__ . '/footer.php';
