<?php
declare(strict_types=1);

/**
 * i18n bootstrap para o Dashboard (PT-BR por padrão)
 * - Usa ?lang= (pt-br|en|es) -> sessão + cookie (1 ano)
 * - Carrega /languages/{lang}.php e mescla com pt-br.php como fallback
 * - Expõe $translation (array) e $currentLang
 */

if (session_status() !== PHP_SESSION_ACTIVE) { @session_start(); }

// >>> aqui trocamos 'pt' por 'pt-br'
$__allowed = ['pt-br','en','es'];

$__get = isset($_GET['lang']) ? strtolower((string)$_GET['lang']) : null;
if ($__get && in_array($__get, $__allowed, true)) {
  $_SESSION['lang'] = $__get;
  setcookie('lang', $__get, time()+31536000, '/');
}
$currentLang =
  $_SESSION['lang'] ??
  (isset($_COOKIE['lang']) && in_array($_COOKIE['lang'], $__allowed, true) ? $_COOKIE['lang'] : 'pt-br');

# Locale/Timezone BR
@date_default_timezone_set('America/Sao_Paulo');
@setlocale(LC_ALL, 'pt_BR.UTF-8', 'pt_BR', 'pt_BR.utf8');

# Carrega idioma base PT-BR + idioma atual
$translation = $translation ?? [];
$__baseFile = dirname(__DIR__) . '/languages/pt-br.php';              // <<< base agora é pt-br.php
$__currFile = dirname(__DIR__) . "/languages/{$currentLang}.php";

$__base = (is_file($__baseFile) ? (include $__baseFile) : []);
$__curr = (is_file($__currFile) ? (include $__currFile) : []);

if (!is_array($__base)) $__base = [];
if (!is_array($__curr)) $__curr = [];

/* prioridade: variáveis já existentes > idioma atual > base pt-br */
$translation = $translation + ($__curr + $__base);

/* Helper seguro (se ainda não existir) */
if (!function_exists('tr')) {
  function tr(string $k, string $default=''): string {
    $t = $GLOBALS['translation'] ?? [];
    $v = isset($t[$k]) && $t[$k] !== '' ? (string)$t[$k] : $default;
    return htmlspecialchars($v, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
  }
}
