<?php
declare(strict_types=1);

/* -------------------- ND Helpers Loader (guarded) -------------------- */
$___h_candidates = [
    __DIR__ . '/app/Support/helpers.php',
    dirname(__DIR__) . '/app/Support/helpers.php',
    __DIR__ . '/Support/helpers.php',
];
foreach ($___h_candidates as $___h) {
    if (is_file($___h)) { require_once $___h; break; }
}
/* -------------------------------------------------------------------- */

if (!headers_sent()) { @ob_start(); }
if (session_status() !== PHP_SESSION_ACTIVE) { @session_start(); }

/* Core do projeto (carrega config, router, funções globais, etc.) */
require_once __DIR__ . '/../core.php';

/* Conexão: funciona com connect() sem args ou connect($database) */
$__db = null;
try {
    if (function_exists('connect')) {
        if (isset($database)) {
            $__db = @connect($database);
            if (!$__db) { $__db = @connect(); }
        } else {
            $__db = @connect();
        }
    }
} catch (\Throwable $e) {
    // segue sem derrubar a página – vamos usar apenas checagens de sessão
}

/* ---------- Polyfills e helpers de segurança ---------- */

/** Normaliza checagem de sessão/logado (aceita assinaturas diferentes) */
if (!function_exists('nd_is_logged')) {
    function nd_is_logged($conn = null): bool {
        if (function_exists('isLogged')) {
            try {
                // alguns projetos usam isLogged($conn), outros isLogged()
                return isset($conn) ? (bool)isLogged($conn) : (bool)isLogged();
            } catch (\Throwable $e) { return false; }
        }
        // fallback simples por sessão
        return !empty($_SESSION['user_id']) || !empty($_SESSION['user']);
    }
}

/** Normaliza a checagem de “é anunciante?” (cobre isSeller/isSellerr/isActiveSellerr) */
if (!function_exists('nd_is_seller')) {
    function nd_is_seller(): bool {
        if (function_exists('isSeller'))        return (bool) isSeller();
        if (function_exists('isSellerr'))       return (bool) isSellerr();
        if (function_exists('isActiveSellerr')) return (bool) isActiveSellerr();
        // fallbacks por sessão/role – ajuste o ID do papel se souber
        if (isset($_SESSION['is_seller'])) return (bool) $_SESSION['is_seller'];
        if (isset($_SESSION['user_role'])) {
            // supondo 3 como papel “vendedor”; mude se necessário
            return ((int)$_SESSION['user_role'] === 3);
        }
        return false;
    }
}

/** Resgata info do usuário sem estourar caso assinatura mude */
if (!function_exists('nd_user_info')) {
    function nd_user_info() {
        try {
            if (function_exists('getUserInfo'))      return getUserInfo();
            if (function_exists('getUserInfoById'))  return getUserInfoById($_SESSION['user_id'] ?? 0);
        } catch (\Throwable $e) {}
        return [];
    }
}

/* ---------- Fluxo de roteamento seguro ---------- */

if (!nd_is_logged($__db)) {
    // Não logado → login do dashboard
    header('Location: ./login.php', true, 302);
    exit;
}

// Opcional: carrega detalhes (se o restante do dashboard usa essas variáveis)
$userProfile = nd_user_info();
$userDetails = [];
try {
    if (function_exists('getUserInfoById') && !empty($userProfile['user_id'])) {
        $userDetails = getUserInfoById((int)$userProfile['user_id']);
    }
} catch (\Throwable $e) { /* segue sem fatal */ }

// Gate: somente “seller” acessa home do dashboard; demais → denied
if (nd_is_seller()) {
    header('Location: ./home.php', true, 302);
    exit;
}

header('Location: ./denied.php', true, 302);
exit;
