<?php 


declare(strict_types=1);
/*--------------------*/
// Descrição: ND Cupons 
// Autor: ND Tecnologia 
// Autor URI: https://www.ndmidia.com.br 
/*--------------------*/

require '../core.php';
require_once __DIR__ . '/functions.php';

$connect = connect($database);

if (isLogged($connect)){

$userProfile = getUserInfo();
$userDetails = getUserInfoById($userProfile['user_id']);

if(!isSeller()){
    header('Location: ./denied.php');
}

$itemId = clearGetData(getItemId());

$itemDetails = gePaymentById($itemId);

if (!$itemDetails){
    header('Location: ./home.php');
    exit();
}

$userBilling = json_decode($userDetails['user_billing']);
$taxes = getTaxesById($itemDetails['payment_taxes']);

require './views/header.view.php';
require './views/invoice.view.php';
require './views/footer.view.php';

}else{
    
    header('Location: ./login.php');
}

?>