<?php
// dashboard/locations-geo-autofill.php
// Liga locations -> cities_br por nome e UF e preenche lat/lng onde estiver nulo

require_once __DIR__ . '/../core.php';

$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 500;

$sql = "SELECT location_id, location_title
        FROM locations
        WHERE (location_lat IS NULL OR location_lng IS NULL)
        ORDER BY location_id ASC
        LIMIT :lim";
$st = $connect->prepare($sql);
$st->bindValue(':lim', $limit, PDO::PARAM_INT);
$st->execute();
$rows = $st->fetchAll(PDO::FETCH_ASSOC);

$upd = $connect->prepare("UPDATE locations SET location_lat=:lat, location_lng=:lng WHERE location_id=:id");
$hit = 0; $miss = 0;

foreach ($rows as $r) {
  $id = (int)$r['location_id'];
  $title = trim($r['location_title']);
  $name = $title; $uf = '';

  if (preg_match('/(.+?)[\s\-\/,]*([A-Z]{2})$/u', $title, $m)) {
    $name = trim($m[1]);
    $uf = strtoupper(trim($m[2]));
  }

  if ($uf !== '') {
    $q = $connect->prepare("SELECT lat,lng FROM cities_br WHERE name=:n AND uf=:u LIMIT 1");
    $q->execute([':n'=>$name, ':u'=>$uf]);
  } else {
    $q = $connect->prepare("SELECT lat,lng FROM cities_br WHERE name=:n LIMIT 1");
    $q->execute([':n'=>$name]);
  }
  $c = $q->fetch(PDO::FETCH_ASSOC);
  if ($c) {
    $upd->execute([':lat'=>$c['lat'], ':lng'=>$c['lng'], ':id'=>$id]);
    $hit++;
  } else {
    $miss++;
  }
}

echo "Autofill concluído. Sucesso: $hit, Sem correspondência: $miss. <a href=\"locations-geo.php\">Voltar</a>";
