<?php
// dashboard/locations-geo-import.php
require_once __DIR__ . '/../core.php';

if (!isset($_FILES['csv']) || $_FILES['csv']['error'] !== UPLOAD_ERR_OK) {
  exit('Arquivo CSV inválido');
}
$fn = $_FILES['csv']['tmp_name'];
$fh = fopen($fn, 'r');
if (!$fh) exit('Falha ao abrir CSV');

$st = $connect->prepare("INSERT INTO cities_br (name, uf, lat, lng) VALUES (:name, :uf, :lat, :lng)
                         ON DUPLICATE KEY UPDATE lat=VALUES(lat), lng=VALUES(lng)");

$cnt = 0;
while (($row = fgetcsv($fh, 0, ',')) !== false) {
  if (count($row) < 4) continue;
  $name = trim($row[0]); $uf = trim($row[1]); $lat = floatval($row[2]); $lng = floatval($row[3]);
  if ($name === '' || $uf === '') continue;
  $st->execute([':name'=>$name, ':uf'=>$uf, ':lat'=>$lat, ':lng'=>$lng]);
  $cnt++;
}
fclose($fh);
echo "Importados: $cnt registros. <a href=\"locations-geo.php\">Voltar</a>";
