<?php
// dashboard/locations-geo.php
// Tela admin para buscar/editar coordenadas de locations
require_once __DIR__ . '/../core.php';

// Access control básico (ajuste conforme seu auth)
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
  // Tente detectar seu sistema de auth e adaptar
  // Por ora, deixamos um gate simplista:
  // header('HTTP/1.1 403 Forbidden'); exit('Acesso negado');
}

$action = $_POST['action'] ?? '';
if ($action === 'save') {
  $id = intval($_POST['location_id'] ?? 0);
  $lat = isset($_POST['location_lat']) ? floatval($_POST['location_lat']) : null;
  $lng = isset($_POST['location_lng']) ? floatval($_POST['location_lng']) : null;
  if ($id > 0 && $lat && $lng) {
    $st = $connect->prepare("UPDATE locations SET location_lat=:lat, location_lng=:lng WHERE location_id=:id");
    $st->execute([':lat'=>$lat, ':lng'=>$lng, ':id'=>$id]);
  }
  header("Location: locations-geo.php?saved=1"); exit;
}

// Busca locations
$kw = trim($_GET['q'] ?? '');
$sql = "SELECT location_id, location_title, location_slug, location_lat, location_lng, location_status
        FROM locations";
$where = [];
$params = [];
if ($kw !== '') {
  $where[] = "(location_title LIKE :kw OR location_slug LIKE :kw)";
  $params[':kw'] = "%$kw%";
}
if ($where) $sql .= " WHERE ".implode(" AND ", $where);
$sql .= " ORDER BY location_title ASC LIMIT 200";
$st = $connect->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>ND Cupons – Geolocalização (Locations)</title>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" crossorigin=""/>
<style>
  body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,Cantarell,sans-serif;margin:20px;}
  .grid{display:grid;grid-template-columns: 1fr 480px; gap: 16px;}
  table{width:100%; border-collapse:collapse;}
  th,td{border-bottom:1px solid #eee; padding:8px; text-align:left;}
  .map{height:400px; border:1px solid #ddd; border-radius:8px;}
  .row{display:flex; gap:8px; align-items:center;}
  input[type=text]{padding:8px; width:100%;}
  .muted{color:#666; font-size:12px;}
  .pill{display:inline-block; padding:2px 8px; border-radius:16px; background:#f1f5f9; font-size:12px;}
  .btn{background:#111; color:#fff; padding:8px 12px; border-radius:8px; text-decoration:none; border:0; cursor:pointer;}
  .btn:disabled{opacity:.5; cursor:not-allowed;}
</style>
  <script src="/assets/js/nd-geolocation.js"></script>
</head>
<body>
<h1>ND Cupons – Geolocalização de Locations</h1>
<p class="muted">Pesquise, selecione um location e defina as coordenadas pelo mapa ou pelo campo de busca (Nominatim / OpenStreetMap).</p>

<form method="get" class="row" style="margin-bottom:12px;">
  <input type="text" name="q" placeholder="Buscar por título ou slug..." value="<?=htmlspecialchars($kw)?>">
  <button class="btn" type="submit">Buscar</button>
  <a class="btn" href="locations-geo.php">Limpar</a>
</form>

<div class="grid">
  <div>
    <table>
      <thead>
        <tr><th>ID</th><th>Título</th><th>Slug</th><th>Lat</th><th>Lng</th><th>Status</th><th>Ação</th></tr>
      </thead>
      <tbody id="tbl">
        <?php foreach($rows as $r): ?>
        <tr data-id="<?=$r['location_id']?>" data-title="<?=htmlspecialchars($r['location_title'])?>">
          <td><?=$r['location_id']?></td>
          <td><?=$r['location_title']?></td>
          <td><span class="pill"><?=$r['location_slug']?></span></td>
          <td><?=$r['location_lat']?></td>
          <td><?=$r['location_lng']?></td>
          <td><?=$r['location_status'] ? 'Ativo' : 'Inativo'?></td>
          <td><button class="btn select" data-id="<?=$r['location_id']?>">Editar</button></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
  <div>
    <div id="map" class="map"></div>
    <div class="row" style="margin-top:8px;">
      <input type="text" id="geoSearch" placeholder="Buscar no mapa (ex.: Florianópolis, SC)" />
      <button class="btn" id="btnSearch">Buscar</button>
    </div>
    <form method="post" style="margin-top:8px;">
      <input type="hidden" name="action" value="save">
      <input type="hidden" name="location_id" id="form_id">
      <div class="row">
        <input type="text" name="location_lat" id="form_lat" placeholder="Latitude">
        <input type="text" name="location_lng" id="form_lng" placeholder="Longitude">
      </div>
      <div class="row" style="margin-top:8px;">
        <button class="btn" type="submit" id="btnSave" disabled>Salvar coordenadas</button>
      </div>
      <p class="muted" id="lblSel">Selecione um location na tabela.</p>
    </form>
    <hr>
    <h3>Importar cidades do Brasil</h3>
    <p class="muted">Você pode importar um CSV (nome, uf, lat, lng) para a tabela <code>cities_br</code> e depois ligar cada <em>location</em> a uma cidade.</p>
    <form method="post" action="locations-geo-import.php" enctype="multipart/form-data">
      <input type="file" name="csv" accept=".csv" required>
      <button class="btn" type="submit">Importar CSV</button>
    </form>
  </div>
</div>

<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" crossorigin=""></script>
<script>
let map = L.map('map').setView([-14.2350, -51.9253], 4); // Brasil
L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
  maxZoom: 19, attribution: '&copy; OpenStreetMap'
}).addTo(map);
let marker = null;

function setMarker(lat, lng){
  if (marker) { map.removeLayer(marker); }
  marker = L.marker([lat, lng]).addTo(map);
  map.setView([lat, lng], 12);
  document.getElementById('form_lat').value = lat.toFixed(6);
  document.getElementById('form_lng').value = lng.toFixed(6);
  document.getElementById('btnSave').disabled = !document.getElementById('form_id').value;
}

document.getElementById('btnSearch').addEventListener('click', function(){
  let q = document.getElementById('geoSearch').value.trim();
  if (!q) return;
  fetch('https://nominatim.openstreetmap.org/search?format=json&q='+encodeURIComponent(q)+'&countrycodes=br')
    .then(r => r.json())
    .then(arr => { if (arr && arr.length){ setMarker(parseFloat(arr[0].lat), parseFloat(arr[0].lon)); } });
});

document.querySelectorAll('.select').forEach(btn => {
  btn.addEventListener('click', function(){
    let id = this.dataset.id;
    let tr = document.querySelector('tr[data-id="'+id+'"]');
    let title = tr ? tr.dataset.title : '';
    document.getElementById('form_id').value = id;
    document.getElementById('lblSel').textContent = 'Editando: '+title+' (ID '+id+')';
    document.getElementById('btnSave').disabled = !document.getElementById('form_lat').value;
  });
});

map.on('click', function(e){ setMarker(e.latlng.lat, e.latlng.lng); });
</script>
</body>
</html>
