<?php
declare(strict_types=1);

// Núcleo do app (rotas, $settings, helpers, etc.)
require '../core.php';

// Garante sessão
if (session_status() !== PHP_SESSION_ACTIVE) {
  @session_start();
}

// Garante $connect (se o core não tiver criado)
try {
  if (!isset($connect) || !$connect) {
    if (function_exists('connect')) {
      if (isset($database)) { $connect = @connect($database); }
      if (!$connect)         { $connect = @connect(); }
    }
  }
} catch (Throwable $e) {
  // o fluxo abaixo lida com ausência de conexão
}

/* ----------------- i18n guards ----------------- */
$translation = (isset($translation) && is_array($translation)) ? $translation : [];
$translation += [
  'tr_signinpage' => 'Entrar',
  'tr_1'          => 'Cupons',
  'tr_3'          => 'Descrição',
  'tr_158'        => 'E-mail é obrigatório.',
  'tr_160'        => 'Senha é obrigatória.',
  'tr_163'        => 'E-mail inválido.',
  'tr_168'        => 'Erro ao conectar ao banco de dados.',
  'tr_172'        => 'Usuário não encontrado.',
  'tr_174'        => 'E-mail ou senha incorretos.',
  'tr_352'        => 'Conta não verificada.',
];

if (!function_exists('tr')) {
  function tr(string $k, string $default = ''): string {
    $t = $GLOBALS['translation'] ?? [];
    return htmlspecialchars((string)($t[$k] ?? $default), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
  }
}

/* ----------------- SEO ----------------- */
$titleSeoHeader       = getSeoTitle(tr('tr_1','Cupons'), tr('tr_signinpage','Entrar'));
$descriptionSeoHeader = getSeoDescription(tr('tr_3',''));

/* ----------------- Fluxo login ----------------- */
$errors = [];
$validateEmail = false;
$validatePassword = false;
$fullHeight = true;

// Se já está logado, leva pro painel
if (function_exists('isLogged') && isLogged()) {
  if (!headers_sent()) {
    header('Location: home.php'); // relativo a /dashboard/
  }
  exit;
}

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'POST') {
  $user_email_raw    = $_POST['user_email']    ?? '';
  $user_password_raw = $_POST['user_password'] ?? '';

  $user_email    = filter_var(strtolower($user_email_raw), FILTER_SANITIZE_EMAIL);
  $user_password = (string)$user_password_raw;
  $encrtypted_password = hash('sha512', $user_password);

  if ($user_email === '') {
    $errors[] = tr('tr_158');
  } elseif (!filter_var($user_email, FILTER_VALIDATE_EMAIL)) {
    $errors[] = tr('tr_163');
  } else {
    $validateEmail = true;
  }

  if ($user_password === '') {
    $errors[] = tr('tr_160');
  } else {
    $validatePassword = true;
  }

  if ($validateEmail && $validatePassword) {
    try {
      if (!isset($connect) || !$connect) {
        throw new PDOException('Sem conexão PDO');
      }
    } catch (PDOException $e) {
      $errors[] = tr('tr_168');
    }

    if (empty($errors)) {
      $stmt = $connect->prepare("SELECT * FROM users WHERE user_email = :user_email AND user_status = 1");
      $stmt->execute([':user_email' => $user_email]);
      $result = $stmt->fetch();

      if ($result == false) {
        $errors[] = tr('tr_172');
      }

      if (($settings['st_login_verified_users_only'] ?? 0) == 1) {
        $stmt = $connect->prepare("SELECT * FROM users WHERE user_email = :user_email AND user_verified = 1");
        $stmt->execute([':user_email' => $user_email]);
        $result = $stmt->fetch();
        if ($result == false) {
          $errors[] = tr('tr_352');
        }
      }
    }

    if (empty($errors)) {
      $stmt = $connect->prepare(
        "SELECT * FROM users 
         WHERE user_email = :user_email 
           AND user_password = :user_password 
           AND user_status = 1"
      );
      $stmt->execute([
        ':user_email'    => $user_email,
        ':user_password' => $encrtypted_password
      ]);
      $result_login = $stmt->fetch();

      if ($result_login !== false) {
        $_SESSION['signedin']   = true;
        $_SESSION['user_email'] = $user_email;
        $_SESSION['user_name']  = $result_login['user_name'] ?? '';
        if (!headers_sent()) {
          header('Location: home.php');
        }
        exit;
      } else {
        $errors[] = tr('tr_174');
      }
    }
  }
}

/* reCAPTCHA siteKey (se a view usar) */
$siteKey = $siteKey ?? ($settings['recaptcha_site_key'] ?? '');

/* Render */
require './header.php';
require './views/login.view.php';
require './footer.php';
