<?php
declare(strict_types=1);

/*--------------------*/
// Dashboard — Membership/Assinatura
/*--------------------*/

if (session_status() !== PHP_SESSION_ACTIVE) { @session_start(); }

require_once __DIR__ . '/../core.php';
require_once __DIR__ . '/functions.php';
if (is_file(__DIR__ . '/../init_lang.php')) { require_once __DIR__ . '/../init_lang.php'; }

/* ========= Conexão PDO segura ========= */
$connect = $connect ?? null;
try {
  if (!isset($connect) || !$connect) {
    if (function_exists('connect')) {
      if (isset($database)) { $connect = @connect($database); }
      if (!$connect)        { $connect = @connect(); }
    }
  }
} catch (Throwable $e) {
  // tolera sem derrubar; as funções abaixo lidam com $connect nulo
}

/* ========= Guards / Polyfills ========= */
if (!function_exists('nd_is_logged')) {
  function nd_is_logged($conn = null): bool {
    if (function_exists('isLogged')) {
      try { return isset($conn) ? (bool)isLogged($conn) : (bool)isLogged(); }
      catch (Throwable $e) { return false; }
    }
    return !empty($_SESSION['user_id']) || !empty($_SESSION['user']);
  }
}

/* NOTA: membership pode (ou não) exigir seller.
   Para evitar fatal, só chamamos isSeller() se existir. */
$requireSeller = false; // troque para true se quiser restringir a sellers
$nd_is_seller = function(): bool {
  if (function_exists('isSeller')) {
    try { return (bool)isSeller(); } catch (Throwable $e) { return false; }
  }
  return false; // se não existir, trate como não-seller
};

/* getTotalItemsByUser pode existir como getTotalItemsByUserr em alguns forks */
if (!function_exists('getTotalItemsByUser')) {
  if (function_exists('getTotalItemsByUserr')) {
    function getTotalItemsByUser($user_id) { return getTotalItemsByUserr($user_id); }
  } else {
    function getTotalItemsByUser($user_id) { return 0; }
  }
}

/* ========= Gates ========= */
if (!nd_is_logged($connect)) {
  if (!headers_sent()) { header('Location: ./login.php'); }
  exit;
}

/* Restringir apenas a sellers? */
if ($requireSeller && !$nd_is_seller()) {
  if (!headers_sent()) { header('Location: ./denied.php'); }
  exit;
}

/* ========= Carrega dados do usuário ========= */
$userProfile = [];
$userDetails = [];
$userPlanSettings = [];
$userPlan = [];

// Perfil básico
try { if (function_exists('getUserInfo')) $userProfile = (array)getUserInfo(); } catch (Throwable $e) {}

// Detalhes por ID
try {
  if (function_exists('getUserInfoById') && !empty($userProfile['user_id'])) {
    $userDetails = (array)getUserInfoById((int)$userProfile['user_id']);
  }
} catch (Throwable $e) {}

// Plano do usuário (se disponível)
try {
  if (!empty($userDetails['user_plan']) && function_exists('getPlanById') && $connect) {
    $userPlanSettings = (array)getPlanById($connect, (int)$userDetails['user_plan']);
  }
} catch (Throwable $e) {}


// Plano atual (pagamento mais recente ou, se não houver, dados diretos do usuário)
try {
  if (function_exists('getUserCurrentPlan')) {
    $planRow = getUserCurrentPlan();
    if ($planRow) { $userPlan = (array)$planRow; }
  }
} catch (Throwable $e) {}

// Fallback: se não houver pagamento, mas o usuário tem um plano definido e data de expiração,
// montamos um array mínimo para a view não exibir "sem plano".
if (empty($userPlan) && !empty($userDetails['user_plan'])) {
  $userPlan = [
    'plan_title' => $userPlanSettings['plan_title'] ?? '',
    'user_plan_expiration_date' => $userDetails['user_plan_expiration_date'] ?? null,
    'payment_total_amount' => $userDetails['user_payment_total_amount'] ?? 0,
    'payment_currency' => $userDetails['user_payment_currency'] ?? 'BRL',
    'payment_frequency' => $userDetails['user_payment_frequency'] ?? 'manual',
    'user_payment_subscription_id' => $userDetails['user_payment_subscription_id'] ?? '',
    'user_plan_canceled_date' => $userDetails['user_plan_canceled_date'] ?? null,
  ];
}
if (empty($userPlan) && empty($userDetails['user_plan']) && !empty($userDetails['user_plan_expiration_date'])) {
  $userPlan = [
    'plan_title' => $translation['tr_450'] ?? 'Plano manual ativo',
    'user_plan_expiration_date' => $userDetails['user_plan_expiration_date'],
    'payment_total_amount' => $userDetails['user_payment_total_amount'] ?? 0,
    'payment_currency' => $userDetails['user_payment_currency'] ?? 'BRL',
    'payment_frequency' => $userDetails['user_payment_frequency'] ?? 'manual',
    'user_payment_subscription_id' => $userDetails['user_payment_subscription_id'] ?? '',
    'user_plan_canceled_date' => $userDetails['user_plan_canceled_date'] ?? null,
  ];
}
/* ========= Traduções (fallbacks) ========= */
$translation = (isset($translation) && is_array($translation)) ? $translation : [];
$translation += [
  'tr_240' => 'Minhas Submissões',
  'tr_241' => 'Minhas Lojas',
  'tr_242' => 'Assinatura',
  'tr_244' => 'Perfil',
];

/* ========= Render ========= */
require __DIR__ . '/header.php';
require __DIR__ . '/views/membership.view.php';
require __DIR__ . '/footer.php';