<?php
declare(strict_types=1);

/* Bootstrap mínimo do Dashboard Menu */
if (!headers_sent()) { @ob_start(); }
if (session_status() !== PHP_SESSION_ACTIVE) { @session_start(); }

require_once __DIR__ . '/../core.php';
require_once __DIR__ . '/functions.php';
if (is_file(__DIR__ . '/../init_lang.php')) { require_once __DIR__ . '/../init_lang.php'; }

/* Conexão segura ($connect pode ser usado por getPlanById) */
$connect = $connect ?? null;
try {
  if (function_exists('connect')) {
    if (!isset($connect) || !$connect) {
      if (isset($database)) { $connect = @connect($database); }
      if (!$connect)        { $connect = @connect(); }
    }
  }
} catch (\Throwable $e) {
  // segue sem derrubar; funções abaixo devem tolerar $connect nulo
}

/* Polyfill: getTotalItemsByUser → getTotalItemsByUserr (ou 0) */
if (!function_exists('getTotalItemsByUser')) {
  if (function_exists('getTotalItemsByUserr')) {
    function getTotalItemsByUser($user_id) { return getTotalItemsByUserr($user_id); }
  } else {
    function getTotalItemsByUser($user_id) { return 0; }
  }
}

/* Helper: is logged (aceita assinaturas diferentes) */
if (!function_exists('nd_is_logged')) {
  function nd_is_logged($conn = null): bool {
    if (function_exists('isLogged')) {
      try { return isset($conn) ? (bool)isLogged($conn) : (bool)isLogged(); }
      catch (\Throwable $e) { return false; }
    }
    return !empty($_SESSION['user_id']) || !empty($_SESSION['user']);
  }
}

/* Helper: user info seguro */
if (!function_exists('nd_user_info')) {
  function nd_user_info(): array {
    try {
      if (function_exists('getUserInfo'))     return (array)getUserInfo();
      if (function_exists('getUserInfoById')) return (array)getUserInfoById((int)($_SESSION['user_id'] ?? 0));
    } catch (\Throwable $e) {}
    return [];
  }
}

/* Carrega dados do usuário (se logado) */
$userProfile = [];
$userDetails = [];
$userPlanSettings = [];
$userTotalOUploaded = 0;

if ((!defined('ND_ASSOCIATE_DASHBOARD') || ND_ASSOCIATE_DASHBOARD !== true) && nd_is_logged($connect)) {
  $userProfile = nd_user_info();
  try {
    if (function_exists('getUserInfoById') && !empty($userProfile['user_id'])) {
      $userDetails = (array)getUserInfoById((int)$userProfile['user_id']);
    }
  } catch (\Throwable $e) { $userDetails = []; }

  // Plano do usuário (se tivermos connect e user_plan)
  try {
    if (!empty($userDetails['user_plan']) && function_exists('getPlanById')) {
      $userPlanSettings = getPlanById($connect, (int)$userDetails['user_plan']);
    }
  } catch (\Throwable $e) { $userPlanSettings = []; }

  // Total de itens enviados pelo usuário (com polyfill)
  try {
    if (!empty($userDetails['user_id'])) {
      $userTotalOUploaded = (int)getTotalItemsByUser((int)$userDetails['user_id']);
    }
  } catch (\Throwable $e) { $userTotalOUploaded = 0; }
}

// Se for dashboard do associado, sobrescreve dados do usuário para exibir info do associado
if (defined('ND_ASSOCIATE_DASHBOARD') && ND_ASSOCIATE_DASHBOARD === true && isset($associate) && is_array($associate)) {
  // Dados básicos do associado
  $userDetails = [
    'user_name'  => (string)($associate['associate_name'] ?? ''),
    'user_email' => (string)($associate['associate_email'] ?? ''),
    'user_plan'  => null,
  ];

  // Define URL do avatar do associado via script, evitando bloqueio de .htaccess em /storage
  try {
    $assocId = isset($associate['associate_id']) ? (int)$associate['associate_id'] : 0;
    if ($assocId > 0) {
      // O script associate_avatar.php faz a leitura segura a partir de storage/associates
      $userDetails['user_avatar'] = '/dashboard/associate_avatar.php?id=' . $assocId;
    }
  } catch (\Throwable $e) {
    // Em caso de erro, mantemos avatar padrão
  }

  $userProfile        = ['user_id' => 0];
  $userTotalOUploaded = 0;
  $userPlanSettings   = [];
}


/* ===== Traduções + fallback seguro ===== */
$T = [];
if (isset($translation)  && is_array($translation))  { $T = $T + $translation; }
if (isset($translations) && is_array($translations)) { $T = $T + $translations; }

/**
 * trf: Translation with fallback.
 * Usa o fallback quando a chave não existir, for null, vazia ou só espaços.
 */
if (!function_exists('trf')) {
  function trf(array $map, string $key, string $fallback): string {
    if (!array_key_exists($key, $map)) return $fallback;
    $v = (string)$map[$key];
    return (trim($v) === '') ? $fallback : $v;
  }
}

/* Monta itens de menu (com fallbacks) */
if (defined('ND_ASSOCIATE_DASHBOARD') && ND_ASSOCIATE_DASHBOARD === true) {
$menuItems = [
  [
    'url'   => 'associate_home.php',
    'icon'  => 'home',
    'title' => trf($T, 'nd_assoc_home', 'Visão geral'),
  ],
  [
    'url'   => 'associate_profile.php',
    'icon'  => 'user',
    'title' => trf($T, 'nd_assoc_profile', 'Perfil do associado'),
  ],
  [
    'url'   => 'associate_export_csv.php',
    'icon'  => 'download',
    'title' => trf($T, 'nd_assoc_export', 'Exportar CSV'),
  ],
];
} else {
$menuItems = [
  [
    'url'   => 'submissions.php',
    'icon'  => 'album',
    'title' => trf($T, 'tr_240', 'Meus Envios'),           // Minhas Submissões
  ],
  [
    'url'   => 'seller.php',
    'icon'  => 'cart',
    'title' => trf($T, 'tr_241', 'Minhas Lojas'),         // Minhas Lojas
  ],
  [
    'url'   => 'membership.php',
    'icon'  => 'bookmark',
    'title' => trf($T, 'tr_242', 'Assinatura'),       // Membership
  ],
  
  [
    'url'   => 'addons.php',
    'icon'  => 'star',
    'title' => 'Add-ons',
  ],
  [
    'url'   => 'coupons.php',
    'icon'  => 'tag',
    'title' => trf($T, 'nd_coupons_menu', 'Meus Cupons'), // Meus Cupons
  ],
  [
    'url'   => 'reports.php',
    'icon'  => 'file-text',
    'title' => 'Relatórios',
  ],
  [
    'url'   => 'profile.php',
    'icon'  => 'user',
    'title' => trf($T, 'tr_244', 'Perfil'),           // Perfil
  ],
];
}

/* Render da view */
require __DIR__ . '/views/menu.view.php';
