<?php
require '../config.php';
require '../functions.php';
require './functions.php';

if (!isLogged()) {
  header('Location: ' . _URL . '/dashboard/login.php');
  exit;
}

$userInfo = get_user_profile();
if (!$userInfo) {
  header('Location: ' . _URL . '/dashboard/login.php');
  exit;
}

$connect = connect();
$errors  = array();
$success = null;

try {
  if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $title  = trim($_POST['store_title'] ?? '');
    $desc   = trim($_POST['store_description'] ?? '');
    $uid    = (int)($userInfo['user_id'] ?? 0);

    // campos adicionais da loja
    $address  = trim($_POST['store_address'] ?? '');
    $hours    = trim($_POST['store_hours'] ?? '');
    $whatsapp = trim($_POST['store_whatsapp'] ?? '');

    // status e destaque
    $status   = isset($_POST['store_status'])   ? (int)$_POST['store_status']   : 1;
    $featured = isset($_POST['store_featured']) ? (int)$_POST['store_featured'] : 0;

    // diretório de upload para logos
    $target_dir = __DIR__ . '/../images/';
    if (!is_dir($target_dir)) {
      $target_dir = dirname(__DIR__) . '/images/';
    }

    if ($action === 'create') {
      if ($title === '') {
        $errors[] = 'O nome da loja é obrigatório.';
      } else {
        // gerar slug único
        $slug = slugify_basic($title);
        $base = $slug; $i = 1;
        $st = $connect->prepare('SELECT store_id FROM stores WHERE store_slug = :slug LIMIT 1');
        while (true) {
          $st->execute([':slug' => $slug]);
          if (!$st->fetch()) break;
          $slug = $base . '-' . $i; $i++;
        }

        // upload opcional de logo
        $logoFile = '';
        if (!empty($_FILES['store_image']['name'])) {
          $file_name = $_FILES['store_image']['name'];
          $file_size = $_FILES['store_image']['size'];
          $file_extension = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
          $file_temp = $_FILES['store_image']['tmp_name'];

          if (!in_array($file_extension, allowedFileExt())) {
            $errors[] = 'Formato de logo inválido.';
          } elseif ($file_size > allowedFileSize()) {
            $errors[] = 'Logo muito grande.';
          } else {
            $image_new_name = md5(time() . rand()) . '.' . $file_extension;
            if (@move_uploaded_file($file_temp, $target_dir . $image_new_name)) {
              $logoFile = $image_new_name;
            }
          }
        }

        if (empty($errors)) {
          // upload de imagem (opcional)
        $image_new_name = '';
        if (!empty($_FILES['store_image']['name'])) {
          $file = $_FILES['store_image'];
          $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
          $allowed = array('jpg','jpeg','png','gif');
          if (in_array($ext, $allowed) && $file['size'] > 0 && $file['error'] == 0) {
            $image_new_name = md5(time().rand()) . '.' . $ext;
            $target_dir = __DIR__ . '/../images/';
            if (!is_dir($target_dir)) { @mkdir($target_dir, 0775, true); }
            @move_uploaded_file($file['tmp_name'], $target_dir . $image_new_name);
          }
        }
        // tenta inserir com store_user_id (multi-loja)
          try {
            $ins = $connect->prepare('INSERT INTO stores (store_title, store_description, store_featured, store_slug, store_image, store_url, store_status, store_user_id) VALUES (:t, :d, :f, :s, :img, :url, :st, :uid)');
            $ins->execute([
              ':t'   => $title,
              ':d'   => $desc,
              ':f'   => $featured,
              ':s'   => $slug,
              ':img' => $logoFile,
              ':url' => '',
              ':st'  => $status,
              ':addr' => $address,
              ':hrs'  => $hours,
              ':wa'   => $whatsapp,
              ':uid' => $uid,
              ':addr' => $address,
              ':hrs'  => $hours,
              ':wa'   => $whatsapp
            ]);
          } catch (Throwable $e) {
            // fallback sem coluna store_user_id
            $ins = $connect->prepare('INSERT INTO stores (store_title, store_description, store_featured, store_slug, store_image, store_url, store_status) VALUES (:t, :d, :f, :s, :img, :url, :st)');
            $ins->execute([
              ':t'   => $title,
              ':d'   => $desc,
              ':f'   => $featured,
              ':s'   => $slug,
              ':img' => $logoFile,
              ':url' => '',
              ':st'  => $status,
              ':addr' => $address,
              ':hrs'  => $hours,
              ':wa'   => $whatsapp
            ]);
          }

          $success = 'Loja criada com sucesso!';
        }
      }
    } elseif ($action === 'update') {
      $store_id = (int)($_POST['store_id'] ?? 0);
      if ($store_id > 0) {
        // garantir propriedade
        $ok = false;
        try {
          $ck = $connect->prepare('SELECT store_id FROM stores WHERE store_id = :id AND store_user_id = :uid LIMIT 1');
          $ck->execute([':id'=>$store_id, ':uid'=>$uid]);
          $ok = (bool)$ck->fetch();
        } catch (Throwable $e) {
          // se coluna não existir, qualquer um que criou via fallback pode editar
          $ok = true;
        }
        if ($ok) {
          // upload opcional de novo logo
          $logoFile = null;
          $target_dir = __DIR__ . '/../images/'; if (!is_dir($target_dir)) { @mkdir($target_dir, 0775, true); }
          if (!empty($_FILES['store_image']['name'])) {
            $file_name = $_FILES['store_image']['name'];
            $file_size = $_FILES['store_image']['size'];
            $file_extension = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
            $file_temp = $_FILES['store_image']['tmp_name'];

            if (!in_array($file_extension, allowedFileExt())) {
              $errors[] = 'Formato de logo inválido.';
            } elseif ($file_size > allowedFileSize()) {
              $errors[] = 'Logo muito grande.';
            } else {
              $image_new_name = md5(time() . rand()) . '.' . $file_extension;
              if (@move_uploaded_file($file_temp, $target_dir . $image_new_name)) {
                $logoFile = $image_new_name;
              }
            }
          }

          if (empty($errors)) {
            $sql = 'UPDATE stores SET store_title = :t, store_description = :d, store_featured = :f, store_status = :st, store_address = :addr, store_hours = :hrs, store_whatsapp = :wa';
            $params = [':t'=>$title, ':d'=>$desc, ':f'=>$featured, ':st'=>$status, ':addr'=>$address, ':hrs'=>$hours, ':wa'=>$whatsapp, ':id'=>$store_id];
            if ($logoFile !== null) {
              $sql .= ', store_image = :img';
              $params[':img'] = $logoFile;
            }
            $sql .= ' WHERE store_id = :id';

            $upd = $connect->prepare($sql);
            $upd->execute($params);
            $success = 'Loja atualizada!';
          }
        }
      }
    } elseif ($action === 'delete') {
      $store_id = (int)($_POST['store_id'] ?? 0);
      if ($store_id > 0) {
        $ok = false;
        try {
          $ck = $connect->prepare('SELECT store_id FROM stores WHERE store_id = :id AND store_user_id = :uid LIMIT 1');
          $ck->execute([':id'=>$store_id, ':uid'=>$uid]);
          $ok = (bool)$ck->fetch();
        } catch (Throwable $e) {
          $ok = true;
        }
        if ($ok) {
          $del = $connect->prepare('DELETE FROM stores WHERE store_id = :id');
          $del->execute([':id'=>$store_id]);
          $success = 'Loja removida.';
        }
      }
    }
  }
} catch (Throwable $e) {
  $errors[] = 'Erro: ' . $e->getMessage();
}

// Listar lojas do usuário (multi-loja se houver coluna)
$myStores = getStoresForUser($connect, (int)($userInfo['user_id'] ?? 0));

require './views/header.view.php';
require './views/my_stores.view.php';
require './views/footer.view.php';
